/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Platform {
    UNDEFINED("undefined"),
    ALL("all"),
    LINUX("linux", "linux"),
    MAC("mac", "macosx"),
    WIN("windows", "win32"),
    UNIX("unix", "aix", "hpux", "linux", "solaris");

    private static Platform[] NO_PLATFORMS;
    private static Map<String, Platform> NAME_MAP;
    private static Map<String, List<Platform>> PLATFORM_MAP;
    private String _name;
    private String[] _platforms;

    static {
        NO_PLATFORMS = new Platform[0];
        NAME_MAP = new HashMap<String, Platform>();
        PLATFORM_MAP = new HashMap<String, List<Platform>>();
        for (Platform type : EnumSet.allOf(Platform.class)) {
            NAME_MAP.put(type.getName(), type);
            String[] oses = type.getPlatforms();
            if (oses == null || oses.length <= 0) continue;
            String[] stringArray = oses;
            int n = oses.length;
            int n2 = 0;
            while (n2 < n) {
                String os = stringArray[n2];
                if (!PLATFORM_MAP.containsKey(os)) {
                    PLATFORM_MAP.put(os, new ArrayList());
                }
                List<Platform> types = PLATFORM_MAP.get(os);
                types.add(type);
                ++n2;
            }
        }
    }

    static Platform[] getCurrentPlatforms() {
        return Platform.getPlatformsForEclipsePlatform(org.eclipse.core.runtime.Platform.getOS());
    }

    public static Platform[] getPlatformsForEclipsePlatform(String eclipsePlatform) {
        Platform[] result = NO_PLATFORMS;
        if (PLATFORM_MAP.containsKey(eclipsePlatform)) {
            List<Platform> platforms = PLATFORM_MAP.get(eclipsePlatform);
            result = platforms.toArray(new Platform[platforms.size()]);
        }
        return result;
    }

    public static final Platform get(String name) {
        return NAME_MAP.containsKey(name) ? NAME_MAP.get(name) : UNDEFINED;
    }

    private Platform(String name) {
        this._name = name;
    }

    private Platform(String name, String ... os) {
        this._name = name;
        this._platforms = os;
    }

    public String getName() {
        return this._name;
    }

    public String[] getPlatforms() {
        return this._platforms;
    }
}

