/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum OutputType {
    UNDEFINED("undefined", true),
    DISCARD("discard", true),
    REPLACE_SELECTION("replace_selection", false),
    REPLACE_SELECTED_LINES("replace_selected_lines", false),
    REPLACE_LINE("replace_line", false),
    REPLACE_WORD("replace_word", false),
    REPLACE_DOCUMENT("replace_document", false),
    INSERT_AS_TEXT("insert_as_text", false),
    INSERT_AS_SNIPPET("insert_as_snippet", false),
    SHOW_AS_HTML("show_as_html", true),
    SHOW_AS_TOOLTIP("show_as_tooltip", false),
    CREATE_NEW_DOCUMENT("create_new_document", false),
    OUTPUT_TO_CONSOLE("output_to_console", true),
    OUTPUT_TO_STREAM("output_to_stream", true),
    OUTPUT_TO_FILE("output_to_file", true),
    COPY_TO_CLIPBOARD("copy_to_clipboard", false);

    private static Map<String, OutputType> NAME_MAP;
    private String _name;
    private boolean _allowAsync;

    static {
        NAME_MAP = new HashMap<String, OutputType>();
        for (OutputType type : EnumSet.allOf(OutputType.class)) {
            NAME_MAP.put(type.getName(), type);
        }
    }

    public static final OutputType get(String name) {
        return NAME_MAP.containsKey(name) ? NAME_MAP.get(name) : UNDEFINED;
    }

    private OutputType(String name, boolean allowAsync) {
        this._name = name;
        this._allowAsync = allowAsync;
    }

    public boolean allowAsync() {
        return this._allowAsync;
    }

    public String getName() {
        return this._name;
    }
}

