/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LibraryCrossReference {
    private static final Map<String, Set<String>> LIBS_BY_PATH;
    private static final Map<String, Set<String>> PATHS_BY_LIB;
    private static final String[] NO_STRINGS;
    private static LibraryCrossReference INSTANCE;

    static {
        NO_STRINGS = new String[0];
        LIBS_BY_PATH = new HashMap<String, Set<String>>();
        PATHS_BY_LIB = new HashMap<String, Set<String>>();
    }

    public static LibraryCrossReference getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryCrossReference();
        }
        return INSTANCE;
    }

    private LibraryCrossReference() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPathsFromLibrary(String libraryPath) {
        String[] result = NO_STRINGS;
        Map<String, Set<String>> map = PATHS_BY_LIB;
        synchronized (map) {
            Set<String> paths = PATHS_BY_LIB.get(libraryPath);
            if (paths != null) {
                result = paths.toArray(new String[paths.size()]);
            }
        }
        return result;
    }

    public boolean hasLibrary(String libraryPath) {
        return PATHS_BY_LIB.containsKey(libraryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLibraryReference(String scriptPath, String ... libraryPaths) {
        int n;
        Map<String, Set<String>> map = PATHS_BY_LIB;
        synchronized (map) {
            String[] stringArray = libraryPaths;
            n = libraryPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String libraryPath = stringArray[n2];
                if (!PATHS_BY_LIB.containsKey(libraryPath)) {
                    PATHS_BY_LIB.put(libraryPath, new HashSet());
                }
                Set<String> paths = PATHS_BY_LIB.get(libraryPath);
                paths.add(scriptPath);
                ++n2;
            }
        }
        map = LIBS_BY_PATH;
        synchronized (map) {
            if (!LIBS_BY_PATH.containsKey(scriptPath)) {
                LIBS_BY_PATH.put(scriptPath, new HashSet());
            }
            Set<String> libs = LIBS_BY_PATH.get(scriptPath);
            String[] stringArray = libraryPaths;
            int n3 = libraryPaths.length;
            n = 0;
            while (n < n3) {
                String libraryPath = stringArray[n];
                libs.add(libraryPath);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPath(String path) {
        Set<String> libs = null;
        Map<String, Set<String>> map = LIBS_BY_PATH;
        synchronized (map) {
            if (LIBS_BY_PATH.containsKey(path)) {
                libs = LIBS_BY_PATH.get(path);
                LIBS_BY_PATH.remove(path);
            }
        }
        if (libs != null) {
            map = PATHS_BY_LIB;
            synchronized (map) {
                for (String lib : libs) {
                    Set<String> paths = PATHS_BY_LIB.get(lib);
                    if (paths != null) {
                        paths.remove(path);
                    }
                    if (paths.size() != 0) continue;
                    PATHS_BY_LIB.remove(lib);
                }
            }
        }
    }
}

