/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.filewatcher.FileWatcher;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.BundlePrecedence;
import com.aptana.scripting.model.LibraryCrossReference;
import com.aptana.scripting.model.Messages;
import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.util.regex.Pattern;
import net.contentobjects.jnotify.JNotifyException;
import net.contentobjects.jnotify.JNotifyListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class BundleMonitor
implements IResourceChangeListener,
IResourceDeltaVisitor,
JNotifyListener {
    private static final Pattern USER_BUNDLE_PATTERN = Pattern.compile(".+?[/\\\\]bundle\\.rb$", 2);
    private static final Pattern USER_LOCALIZATIONS_PATTERN = Pattern.compile(".+?[/\\\\]config/locales/[^/\\\\]+\\.yml$", 2);
    private static final Pattern USER_FILE_PATTERN = Pattern.compile(".+?[/\\\\](?:commands|snippets|templates|samples)/[^/\\\\]+\\.rb$", 2);
    private static final Pattern BUNDLE_PATTERN = Pattern.compile("/.+?/bundle\\.rb$", 2);
    private static final Pattern FILE_PATTERN = Pattern.compile("/.+?/(?:commands|snippets|templates|samples)/[^/]+\\.rb$", 2);
    private static final Pattern BUNDLE_PATTERN_DEPRECATED = Pattern.compile("/.+?/bundles/.+?/bundle\\.rb$", 2);
    private static final Pattern FILE_PATTERN_DEPRECATED = Pattern.compile("/.+?/bundles/.+?/(?:commands|snippets|templates|samples)/[^/]+\\.rb$", 2);
    private static BundleMonitor INSTANCE;
    private boolean _registered;
    private int _watchId = -1;

    public static BundleMonitor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BundleMonitor();
        }
        return INSTANCE;
    }

    private BundleMonitor() {
    }

    public synchronized void beginMonitoring() throws JNotifyException {
        if (!this._registered) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 5);
            String userBundlesPath = this.getBundleManager().getUserBundlesPath();
            File bundleDirectory = new File(userBundlesPath);
            boolean directoryExists = true;
            directoryExists = !bundleDirectory.exists() ? bundleDirectory.mkdirs() : bundleDirectory.isDirectory();
            if (directoryExists) {
                try {
                    this._watchId = FileWatcher.addWatch((String)userBundlesPath, (int)15, (boolean)true, (JNotifyListener)this);
                    if (IdeLog.isTraceEnabled((Plugin)ScriptingActivator.getDefault(), (String)"com.aptana.scripting/debug/show_bundle_monitor_file_events")) {
                        this.showFileEvent("Begin file system monitoring");
                    }
                }
                catch (JNotifyException e) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.BundleMonitor_ERROR_REGISTERING_FILE_WATCHER, (Throwable)e);
                }
            } else {
                String message = MessageFormat.format(Messages.BundleMonitor_INVALID_WATCHER_PATH, userBundlesPath);
                IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)message);
            }
            this._registered = true;
        }
    }

    public synchronized void endMonitoring() throws JNotifyException {
        if (this._registered) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)INSTANCE);
            if (this._watchId != -1) {
                FileWatcher.removeWatch((int)this._watchId);
                this._watchId = -1;
                if (IdeLog.isTraceEnabled((Plugin)ScriptingActivator.getDefault(), (String)"com.aptana.scripting/debug/show_bundle_monitor_file_events")) {
                    this.showFileEvent("End file system monitoring");
                }
            }
            this._registered = false;
        }
    }

    public synchronized void fileCreated(int wd, String rootPath, String name) {
        this.fileCreatedHelper(rootPath, name);
        this.notifyAll();
    }

    private void fileCreatedHelper(String rootPath, String name) {
        if (this.isUserBundleFile(rootPath, name)) {
            if (IdeLog.isTraceEnabled((Plugin)ScriptingActivator.getDefault(), (String)"com.aptana.scripting/debug/show_bundle_monitor_file_events")) {
                this.showFileEvent(MessageFormat.format("File created: {0},{1}", rootPath, name));
            }
            BundleManager manager = this.getBundleManager();
            File file = new File(rootPath, name);
            if (USER_BUNDLE_PATTERN.matcher(name).matches()) {
                manager.loadBundle(file.getParentFile());
            } else {
                manager.loadScript(file);
            }
        } else {
            this.showFileEvent(MessageFormat.format("Skipped file created: {0},{1}", rootPath, name));
        }
    }

    public synchronized void fileDeleted(int wd, String rootPath, String name) {
        this.fileDeletedHelper(rootPath, name);
        this.notifyAll();
    }

    private void fileDeletedHelper(String rootPath, String name) {
        if (this.isUserBundleFile(rootPath, name)) {
            if (IdeLog.isTraceEnabled((Plugin)ScriptingActivator.getDefault(), (String)"com.aptana.scripting/debug/show_bundle_monitor_file_events")) {
                this.showFileEvent(MessageFormat.format("File deleted: {0},{1}", rootPath, name));
            }
            BundleManager manager = this.getBundleManager();
            File file = new File(rootPath, name);
            if (USER_BUNDLE_PATTERN.matcher(name).matches()) {
                manager.unloadBundle(file.getParentFile());
            } else {
                manager.unloadScript(file);
            }
        } else {
            if (IdeLog.isTraceEnabled((Plugin)ScriptingActivator.getDefault(), (String)"com.aptana.scripting/debug/show_bundle_monitor_file_events")) {
                this.showFileEvent(MessageFormat.format("Skipped file deleted: {0},{1}", rootPath, name));
            }
            this.reloadDependentScripts(new File(rootPath, name));
        }
    }

    protected BundleManager getBundleManager() {
        return BundleManager.getInstance();
    }

    public synchronized void fileModified(int wd, String rootPath, String name) {
        if (this.isUserBundleFile(rootPath, name)) {
            if (IdeLog.isTraceEnabled((Plugin)ScriptingActivator.getDefault(), (String)"com.aptana.scripting/debug/show_bundle_monitor_file_events")) {
                this.showFileEvent(MessageFormat.format("File modified: {0},{1}", rootPath, name));
            }
            File file = new File(rootPath, name);
            this.getBundleManager().reloadScript(file);
        } else if (this.isUserLocalizationFile(rootPath, name)) {
            if (IdeLog.isTraceEnabled((Plugin)ScriptingActivator.getDefault(), (String)"com.aptana.scripting/debug/show_bundle_monitor_file_events")) {
                this.showFileEvent(MessageFormat.format("Localization file modified: {0},{1}", rootPath, name));
            }
            File file = new File(rootPath, name);
            BundleManager manager = this.getBundleManager();
            File bundleDirectory = manager.getBundleDirectory(file);
            File[] fileArray = bundleDirectory.listFiles(new CacheFileFilter());
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File localeFile = fileArray[n2];
                localeFile.delete();
                ++n2;
            }
            manager.unloadBundle(bundleDirectory);
            manager.loadBundle(bundleDirectory);
        } else {
            if (IdeLog.isTraceEnabled((Plugin)ScriptingActivator.getDefault(), (String)"com.aptana.scripting/debug/show_bundle_monitor_file_events")) {
                this.showFileEvent(MessageFormat.format("Skipped file modified: {0},{1}", rootPath, name));
            }
            this.reloadDependentScripts(new File(rootPath, name));
        }
        this.notifyAll();
    }

    private boolean isUserLocalizationFile(String rootPath, String name) {
        if (USER_LOCALIZATIONS_PATTERN.matcher(name).matches()) {
            File script = new File(rootPath, name);
            return this.isScriptInExistingBundle(script);
        }
        return false;
    }

    public synchronized void fileRenamed(int wd, String rootPath, String oldName, String newName) {
        this.showFileEvent(MessageFormat.format("File renamed: {0},{1}=>{2}", rootPath, oldName, newName));
        this.fileDeletedHelper(rootPath, oldName);
        this.fileCreatedHelper(rootPath, newName);
        this.notifyAll();
    }

    private boolean isProjectBundleFile(IResourceDelta delta) {
        IPath location;
        IResource resource;
        String fullProjectPath = delta.getFullPath().toString();
        boolean result = false;
        if (BUNDLE_PATTERN_DEPRECATED.matcher(fullProjectPath).matches() || BUNDLE_PATTERN.matcher(fullProjectPath).matches()) {
            result = true;
        } else if ((FILE_PATTERN_DEPRECATED.matcher(fullProjectPath).matches() || FILE_PATTERN.matcher(fullProjectPath).matches()) && (resource = delta.getResource()) != null && (location = resource.getLocation()) != null) {
            File script = delta.getResource().getLocation().toFile();
            result = this.isScriptInExistingBundle(script);
        }
        return result;
    }

    private boolean isProjectBundleFile(IFile file) {
        String fullProjectPath = file.getFullPath().toString();
        if (BUNDLE_PATTERN_DEPRECATED.matcher(fullProjectPath).matches() || BUNDLE_PATTERN.matcher(fullProjectPath).matches()) {
            return true;
        }
        if (FILE_PATTERN_DEPRECATED.matcher(fullProjectPath).matches() || FILE_PATTERN.matcher(fullProjectPath).matches()) {
            return this.isScriptInExistingBundle(file.getLocation().toFile());
        }
        return false;
    }

    private boolean isScriptInExistingBundle(File script) {
        BundleManager manager = this.getBundleManager();
        File bundleDirectory = manager.getBundleDirectory(script);
        return manager.hasBundleAtPath(bundleDirectory);
    }

    private boolean isUserBundleFile(String rootPath, String name) {
        boolean result = false;
        if (USER_BUNDLE_PATTERN.matcher(name = name.replace("\\", "/")).matches()) {
            result = true;
        } else if (USER_FILE_PATTERN.matcher(name).matches()) {
            File script = new File(rootPath, name);
            result = this.isScriptInExistingBundle(script);
        }
        return result;
    }

    private void processFile(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource != null && resource.getLocation() != null) {
            BundleManager manager = this.getBundleManager();
            File file = resource.getLocation().toFile();
            String fullProjectPath = delta.getFullPath().toString();
            BundlePrecedence scope = manager.getBundlePrecedence(file);
            if (scope != BundlePrecedence.USER) {
                switch (delta.getKind()) {
                    case 1: {
                        this.showResourceEvent("Added: " + file);
                        if (BUNDLE_PATTERN_DEPRECATED.matcher(fullProjectPath).matches() || BUNDLE_PATTERN.matcher(fullProjectPath).matches()) {
                            manager.loadBundle(file.getParentFile());
                            break;
                        }
                        manager.loadScript(file);
                        break;
                    }
                    case 2: {
                        this.showResourceEvent("Removed: " + file);
                        if (BUNDLE_PATTERN_DEPRECATED.matcher(fullProjectPath).matches() || BUNDLE_PATTERN.matcher(fullProjectPath).matches()) {
                            manager.unloadBundle(file.getParentFile());
                        }
                        manager.unloadScript(file);
                        break;
                    }
                    case 4: {
                        if ((delta.getFlags() & 0x1000) != 0) {
                            IPath movedFromPath = delta.getMovedFromPath();
                            IFile movedFrom = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(movedFromPath);
                            if (movedFrom == null || !(movedFrom instanceof IFile)) break;
                            this.showResourceEvent(MessageFormat.format("Added: {0}=>{1}", movedFrom.getLocation().toFile(), file));
                            manager.unloadScript(movedFrom.getLocation().toFile());
                            manager.loadScript(file);
                            break;
                        }
                        if ((delta.getFlags() & 0x2000) != 0) {
                            IPath movedToPath = delta.getMovedToPath();
                            IFile movedTo = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(movedToPath);
                            if (movedTo == null || !(movedTo instanceof IFile)) break;
                            this.showResourceEvent(MessageFormat.format("Added: {0}=>{1}", file, movedTo.getLocation().toFile()));
                            manager.unloadScript(file);
                            manager.loadScript(movedTo.getLocation().toFile());
                            break;
                        }
                        if ((delta.getFlags() & 0x40000) != 0) {
                            this.showResourceEvent("Reload: " + file);
                            manager.reloadScript(file);
                            break;
                        }
                        if ((delta.getFlags() & 0x100) == 0) break;
                        this.showResourceEvent("Reload: " + file);
                        manager.reloadScript(file);
                    }
                }
            }
        }
    }

    private void reloadDependentScripts(File file) {
        BundleManager manager = this.getBundleManager();
        String fullPath = file.getAbsolutePath();
        LibraryCrossReference xref = LibraryCrossReference.getInstance();
        if (xref.hasLibrary(fullPath)) {
            String[] stringArray = xref.getPathsFromLibrary(fullPath);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String script = stringArray[n2];
                manager.reloadScript(new File(script));
                ++n2;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4) {
            this.handleProjectDeleteEvent((IResource)((IProject)event.getResource()));
        } else {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)Messages.BundleMonitor_Error_Processing_Resource_Change, (Throwable)e);
            }
        }
    }

    private void handleProjectDeleteEvent(IResource resource) {
        BundleManager manager = this.getBundleManager();
        if (resource instanceof IFile) {
            File localFile;
            BundlePrecedence scope;
            IFile file = (IFile)resource;
            if (this.isProjectBundleFile(file) && (scope = manager.getBundlePrecedence(localFile = file.getLocation().toFile())) != BundlePrecedence.USER) {
                String fullProjectPath = file.getFullPath().toString();
                if (BUNDLE_PATTERN_DEPRECATED.matcher(fullProjectPath).matches() || BUNDLE_PATTERN.matcher(fullProjectPath).matches()) {
                    manager.unloadBundle(localFile.getParentFile());
                }
                manager.unloadScript(localFile);
            }
        } else if (resource instanceof IContainer) {
            try {
                IResource[] children;
                IResource[] iResourceArray = children = ((IContainer)resource).members();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    this.handleProjectDeleteEvent(child);
                    ++n2;
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (Throwable)e);
            }
        }
    }

    protected void showFileEvent(String message) {
        IdeLog.logTrace((Plugin)ScriptingActivator.getDefault(), (String)message, (String)"com.aptana.scripting/debug/show_bundle_monitor_file_events");
    }

    protected void showResourceEvent(String message) {
        IdeLog.logTrace((Plugin)ScriptingActivator.getDefault(), (String)message, (String)"com.aptana.scripting/debug/show_bundle_monitor_resource_events");
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        File file;
        IPath location;
        IResource resource;
        if (this.isProjectBundleFile(delta)) {
            this.processFile(delta);
        } else if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0 && (resource = delta.getResource()) != null && (location = resource.getLocation()) != null && (file = location.toFile()) != null) {
            this.reloadDependentScripts(file);
        }
        return true;
    }

    private final class CacheFileFilter
    implements FilenameFilter {
        private CacheFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("cache") && name.endsWith(".yml");
        }
    }
}

