/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.SourcePrinter;
import com.aptana.core.util.StringUtil;
import com.aptana.scope.ScopeSelector;
import com.aptana.scripting.model.AbstractBundleElement;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BuildPathElement;
import com.aptana.scripting.model.BundleEntry;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.BundlePrecedence;
import com.aptana.scripting.model.BundleUtils;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.ContentAssistElement;
import com.aptana.scripting.model.EnvironmentElement;
import com.aptana.scripting.model.MenuElement;
import com.aptana.scripting.model.ProjectSampleElement;
import com.aptana.scripting.model.ProjectTemplateElement;
import com.aptana.scripting.model.SmartTypingPairsElement;
import com.aptana.scripting.model.SnippetCategoryElement;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.model.TemplateElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.RubyRegexp;

public class BundleElement
extends AbstractElement {
    private String _author;
    private String _copyright;
    private String _description;
    private String _license;
    private String _licenseUrl;
    private String _repository;
    private List<AbstractBundleElement> _children;
    private File _bundleDirectory;
    private BundlePrecedence _bundlePrecedence;
    private boolean _visible;
    private Map<String, String> _fileTypeRegistry;
    private List<String> _fileTypes;
    private Object fileTypeRegistryLock = new Object();
    private Object fileTypesLock = new Object();
    private Map<ScopeSelector, RubyRegexp> _foldingStartMarkers;
    private Map<ScopeSelector, RubyRegexp> _foldingStopMarkers;
    private Object foldingStartMarkersLock = new Object();
    private Object foldingStopMarkersLock = new Object();
    private Map<ScopeSelector, RubyRegexp> _increaseIndentMarkers;
    private Map<ScopeSelector, RubyRegexp> _decreaseIndentMarkers;
    private Object increaseIndentMarkersLock = new Object();
    private Object decreaseIndentMarkersLock = new Object();

    public BundleElement(String path) {
        super(path);
        if (path != null) {
            File parentDirectory;
            File pathFile = new File(path);
            File file = parentDirectory = pathFile.isFile() ? pathFile.getParentFile() : pathFile;
            if (BundleManager.isSpecialDirectory(parentDirectory)) {
                parentDirectory = parentDirectory.getParentFile();
            }
            this._bundleDirectory = parentDirectory.getAbsoluteFile();
        }
        this._children = new ArrayList<AbstractBundleElement>();
        this._bundlePrecedence = BundleManager.getInstance().getBundlePrecedence(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(AbstractBundleElement element) {
        if (element != null) {
            BundleEntry.VisibilityContext context = null;
            List<AbstractBundleElement> list = this._children;
            synchronized (list) {
                this._children.remove(element);
                context = this.getVisibilityContext(element.getClass());
                this._children.add(element);
                if (context != null) {
                    context.updateElementContext();
                }
            }
            element.setOwningBundle(this);
            if (context != null) {
                context.fireElementVisibilityEvents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateFileType(String fileType) {
        Object object = this.fileTypesLock;
        synchronized (object) {
            if (this._fileTypes == null) {
                this._fileTypes = new ArrayList<String>();
            }
            this._fileTypes.add(fileType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateScope(String filePattern, String scope) {
        if (!StringUtil.isEmpty((String)filePattern) && !StringUtil.isEmpty((String)scope)) {
            Object object = this.fileTypeRegistryLock;
            synchronized (object) {
                if (this._fileTypeRegistry == null) {
                    this._fileTypeRegistry = new HashMap<String, String>();
                }
                this._fileTypeRegistry.put(filePattern, scope);
            }
        }
    }

    public void clearMetadata() {
        this._author = null;
        this._copyright = null;
        this._description = null;
        this._license = null;
        this._licenseUrl = null;
    }

    public String getAuthor() {
        return this._author;
    }

    public List<BuildPathElement> getBuildPaths() {
        return this.getChildrenByType(BuildPathElement.class);
    }

    public File getBundleDirectory() {
        return this._bundleDirectory;
    }

    public BundlePrecedence getBundlePrecedence() {
        return this._bundlePrecedence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractBundleElement> getChildren() {
        ArrayList<AbstractBundleElement> result;
        List<AbstractBundleElement> list = this._children;
        synchronized (list) {
            result = new ArrayList<AbstractBundleElement>(this._children);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChildren(List<AbstractBundleElement> children) {
        List<AbstractBundleElement> list = this._children;
        synchronized (list) {
            this._children.clear();
        }
        if (children != null) {
            for (AbstractBundleElement child : children) {
                this.addChild(child);
            }
        }
    }

    public <T extends AbstractBundleElement> List<T> getChildrenByExactType(Class<T> childType) {
        ArrayList<AbstractBundleElement> result = new ArrayList<AbstractBundleElement>();
        for (AbstractBundleElement child : this.getChildren()) {
            if (childType != child.getClass()) continue;
            result.add((AbstractBundleElement)childType.cast(child));
        }
        return result;
    }

    public <T extends AbstractBundleElement> List<T> getChildrenByType(Class<T> childType) {
        ArrayList<AbstractBundleElement> result = new ArrayList<AbstractBundleElement>();
        for (AbstractBundleElement child : this.getChildren()) {
            if (!childType.isAssignableFrom(child.getClass())) continue;
            result.add((AbstractBundleElement)childType.cast(child));
        }
        return result;
    }

    public CommandElement getCommandByName(String name) {
        CommandElement result = null;
        if (!StringUtil.isEmpty((String)name)) {
            for (CommandElement command : this.getCommands()) {
                if (!name.equals(command.getDisplayName())) continue;
                result = command;
                break;
            }
        }
        return result;
    }

    public List<CommandElement> getCommands() {
        return this.getChildrenByType(CommandElement.class);
    }

    public List<ContentAssistElement> getContentAssists() {
        return this.getChildrenByType(ContentAssistElement.class);
    }

    public String getCopyright() {
        return this._copyright;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ScopeSelector, RubyRegexp> getDecreaseIndentMarkers() {
        Map<ScopeSelector, RubyRegexp> result;
        Object object = this.decreaseIndentMarkersLock;
        synchronized (object) {
            result = this._decreaseIndentMarkers == null ? Collections.emptyMap() : new HashMap<ScopeSelector, RubyRegexp>(this._decreaseIndentMarkers);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDecreaseIndentMarkers(Map<ScopeSelector, RubyRegexp> indentMarkers) {
        Object object = this.decreaseIndentMarkersLock;
        synchronized (object) {
            this._decreaseIndentMarkers = indentMarkers;
        }
    }

    protected String getDefaultName() {
        return BundleUtils.getDefaultBundleName(this.getPath());
    }

    public String getDescription() {
        return this._description;
    }

    @Override
    public String getDisplayName() {
        String result = super.getDisplayName();
        if (StringUtil.isEmpty((String)result)) {
            result = this.getDefaultName();
        }
        return result;
    }

    @Override
    protected String getElementName() {
        return "bundle";
    }

    public List<EnvironmentElement> getEnvs() {
        return this.getChildrenByType(EnvironmentElement.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFileTypeRegistry() {
        Map<String, String> result;
        Object object = this.fileTypeRegistryLock;
        synchronized (object) {
            result = this._fileTypeRegistry != null ? new HashMap<String, String>(this._fileTypeRegistry) : Collections.emptyMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileTypeRegistry(Map<String, String> fileTypeRegistry) {
        Object object = this.fileTypeRegistryLock;
        synchronized (object) {
            this._fileTypeRegistry = fileTypeRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFileTypes() {
        List<String> result;
        Object object = this.fileTypesLock;
        synchronized (object) {
            result = this._fileTypes != null ? new ArrayList<String>(this._fileTypes) : Collections.emptyList();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileTypes(List<String> fileTypes) {
        Object object = this.fileTypesLock;
        synchronized (object) {
            this._fileTypes = fileTypes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ScopeSelector, RubyRegexp> getFoldingStartMarkers() {
        Map<ScopeSelector, RubyRegexp> result;
        Object object = this.foldingStartMarkersLock;
        synchronized (object) {
            result = this._foldingStartMarkers != null ? new HashMap<ScopeSelector, RubyRegexp>(this._foldingStartMarkers) : Collections.emptyMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFoldingStartMarkers(Map<ScopeSelector, RubyRegexp> startMarkers) {
        Object object = this.foldingStartMarkersLock;
        synchronized (object) {
            this._foldingStartMarkers = startMarkers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ScopeSelector, RubyRegexp> getFoldingStopMarkers() {
        Map<ScopeSelector, RubyRegexp> result;
        Object object = this.foldingStopMarkersLock;
        synchronized (object) {
            result = this._foldingStopMarkers != null ? new HashMap<ScopeSelector, RubyRegexp>(this._foldingStopMarkers) : Collections.emptyMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFoldingStopMarkers(Map<ScopeSelector, RubyRegexp> stopMarkers) {
        Object object = this.foldingStopMarkersLock;
        synchronized (object) {
            this._foldingStopMarkers = stopMarkers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ScopeSelector, RubyRegexp> getIncreaseIndentMarkers() {
        Map<ScopeSelector, RubyRegexp> result;
        Object object = this.increaseIndentMarkersLock;
        synchronized (object) {
            result = this._increaseIndentMarkers != null ? new HashMap<ScopeSelector, RubyRegexp>(this._increaseIndentMarkers) : Collections.emptyMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIncreaseIndentMarkers(Map<ScopeSelector, RubyRegexp> indentMarkers) {
        Object object = this.increaseIndentMarkersLock;
        synchronized (object) {
            this._increaseIndentMarkers = indentMarkers;
        }
    }

    public String getLicense() {
        return this._license;
    }

    public String getLicenseUrl() {
        return this._licenseUrl;
    }

    public List<String> getLoadPaths() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(BundleUtils.getBundleLibDirectory(this.getBundleDirectory()));
        return result;
    }

    public List<MenuElement> getMenus() {
        return this.getChildrenByType(MenuElement.class);
    }

    public List<SmartTypingPairsElement> getPairs() {
        return this.getChildrenByType(SmartTypingPairsElement.class);
    }

    public List<ProjectTemplateElement> getProjectTemplates() {
        return this.getChildrenByType(ProjectTemplateElement.class);
    }

    public List<ProjectSampleElement> getProjectSamples() {
        return this.getChildrenByType(ProjectSampleElement.class);
    }

    public List<TemplateElement> getFileTemplates() {
        return this.getChildrenByType(TemplateElement.class);
    }

    public List<SnippetElement> getSnippets() {
        return this.getChildrenByType(SnippetElement.class);
    }

    public List<SnippetCategoryElement> getSnippetCategories() {
        return this.getChildrenByType(SnippetCategoryElement.class);
    }

    public String getRepository() {
        return this._repository;
    }

    private BundleEntry.VisibilityContext getVisibilityContext(Class<? extends AbstractBundleElement> elementClass) {
        BundleEntry entry = BundleManager.getInstance().getBundleEntry(this.getDisplayName());
        BundleEntry.VisibilityContext context = null;
        if (entry != null) {
            context = entry.getVisibilityContext(elementClass);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildren() {
        boolean result = false;
        List<AbstractBundleElement> list = this._children;
        synchronized (list) {
            result = this._children.size() > 0;
        }
        return result;
    }

    public boolean hasMetadata() {
        return this._author != null || this._copyright != null || this._description != null || this._license != null || this._licenseUrl != null;
    }

    public boolean isEmpty() {
        return !this.hasMetadata() && !this.hasChildren();
    }

    public boolean isReference() {
        String displayName = super.getDisplayName();
        return !StringUtil.isEmpty((String)displayName) && ObjectUtil.areNotEqual((Object)displayName, (Object)this.getDefaultName());
    }

    public boolean isVisible() {
        return this._visible;
    }

    @Override
    public void printBody(SourcePrinter printer, boolean includeBlocks) {
        printer.printWithIndent("bundle_precedence: ").println(this._bundlePrecedence.toString());
        printer.printWithIndent("path: ").println(this.getPath());
        printer.printWithIndent("author: ").println(this._author);
        printer.printWithIndent("copyright: ").println(this._copyright);
        printer.printWithIndent("description: ").println(this._description);
        printer.printWithIndent("repository: ").println(this._repository);
        for (CommandElement command : this.getCommands()) {
            command.toSource(printer, includeBlocks);
        }
        for (MenuElement menu : this.getMenus()) {
            menu.toSource(printer, includeBlocks);
        }
        for (SmartTypingPairsElement pairs : this.getPairs()) {
            pairs.toSource(printer, includeBlocks);
        }
        for (EnvironmentElement env : this.getEnvs()) {
            env.toSource(printer, includeBlocks);
        }
        for (ProjectTemplateElement projTemplates : this.getProjectTemplates()) {
            projTemplates.toSource(printer, includeBlocks);
        }
        for (ProjectSampleElement projSample : this.getProjectSamples()) {
            projSample.toSource(printer, includeBlocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(AbstractBundleElement element) {
        boolean removed = false;
        BundleEntry.VisibilityContext context = null;
        element.setOwningBundle(null);
        List<AbstractBundleElement> list = this._children;
        synchronized (list) {
            context = this.getVisibilityContext(element.getClass());
            removed = this._children.remove(element) && context != null;
            if (removed) {
                context.updateElementContext();
            }
        }
        if (removed) {
            if (element instanceof MenuElement) {
                ((MenuElement)element).removeChildren();
            }
            AbstractElement.unregisterElement(element);
            if (context != null) {
                context.fireElementVisibilityEvents();
            }
        }
    }

    public void setAuthor(String author) {
        this._author = author;
    }

    public void setCopyright(String copyright) {
        this._copyright = copyright;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFoldingMarkers(String scope, RubyRegexp startRegexp, RubyRegexp endRegexp) {
        if (!(StringUtil.isEmpty((String)scope) || startRegexp == null || startRegexp.isNil() || endRegexp == null || endRegexp.isNil())) {
            Object object = this.foldingStartMarkersLock;
            synchronized (object) {
                if (this._foldingStartMarkers == null) {
                    this._foldingStartMarkers = new HashMap<ScopeSelector, RubyRegexp>();
                }
                this._foldingStartMarkers.put(new ScopeSelector(scope), startRegexp);
            }
            object = this.foldingStopMarkersLock;
            synchronized (object) {
                if (this._foldingStopMarkers == null) {
                    this._foldingStopMarkers = new HashMap<ScopeSelector, RubyRegexp>();
                }
                this._foldingStopMarkers.put(new ScopeSelector(scope), endRegexp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndentMarkers(String scope, RubyRegexp startRegexp, RubyRegexp endRegexp) {
        if (!(StringUtil.isEmpty((String)scope) || startRegexp == null || startRegexp.isNil() || endRegexp == null || endRegexp.isNil())) {
            Object object = this.increaseIndentMarkersLock;
            synchronized (object) {
                if (this._increaseIndentMarkers == null) {
                    this._increaseIndentMarkers = new HashMap<ScopeSelector, RubyRegexp>();
                }
                this._increaseIndentMarkers.put(new ScopeSelector(scope), startRegexp);
            }
            object = this.decreaseIndentMarkersLock;
            synchronized (object) {
                if (this._decreaseIndentMarkers == null) {
                    this._decreaseIndentMarkers = new HashMap<ScopeSelector, RubyRegexp>();
                }
                this._decreaseIndentMarkers.put(new ScopeSelector(scope), endRegexp);
            }
        }
    }

    public void setLicense(String license) {
        this._license = license;
    }

    public void setLicenseUrl(String licenseUrl) {
        this._licenseUrl = licenseUrl;
    }

    public void setRepository(String gitRepo) {
        this._repository = gitRepo;
    }

    public void setVisible(boolean flag) {
        this._visible = flag;
    }
}

