/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.scope.ScopeSelector;
import com.aptana.scripting.ScriptingActivator;
import com.aptana.scripting.ScriptingEngine;
import com.aptana.scripting.model.AbstractBundleElement;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BuildPathElement;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.ContentAssistElement;
import com.aptana.scripting.model.EnvironmentElement;
import com.aptana.scripting.model.LoadCycleListener;
import com.aptana.scripting.model.MenuElement;
import com.aptana.scripting.model.Messages;
import com.aptana.scripting.model.ProjectSampleElement;
import com.aptana.scripting.model.ProjectTemplateElement;
import com.aptana.scripting.model.SmartTypingPairsElement;
import com.aptana.scripting.model.SnippetCategoryElement;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.model.TemplateElement;
import com.aptana.scripting.model.TriggerType;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.util.KCode;
import org.jruby.util.RegexpOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class BundleCacher {
    private static final String CACHE_FILE = "cache.yml";
    private static final String REGEXP_TAG = "!regexp";
    private static final String SCOPE_SELECTOR_TAG = "!scope";
    private static final String ENVIRONMENT_TAG = "!environment";
    private static final String COMMAND_TAG = "!command";
    private static final String CONTENT_ASSIST_TAG = "!content_assist";
    private static final String TEMPLATE_TAG = "!template";
    private LoadCycleListener listener = new BundleCacheInvalidatingLoadCycleListener();

    public BundleCacher() {
        this.getBundleManager().addLoadCycleListener(this.listener);
    }

    protected File getBundleDir(File script) {
        return this.getBundleManager().getBundleDirectory(script);
    }

    public void dispose() {
        if (this.listener != null) {
            this.getBundleManager().removeLoadCycleListener(this.listener);
        }
        this.listener = null;
    }

    public void cache(File bundleDirectory, IProgressMonitor monitor) {
        this.cache(this.getBundleManager().getBundleFromPath(bundleDirectory));
    }

    protected BundleManager getBundleManager() {
        return BundleManager.getInstance();
    }

    /*
     * Loose catch block
     */
    protected boolean cache(BundleElement be) {
        block44: {
            boolean serializationSucceeded;
            InputStreamReader reader;
            File cacheFile;
            block39: {
                block42: {
                    Yaml yaml;
                    block40: {
                        block41: {
                            block38: {
                                if (be == null) {
                                    return false;
                                }
                                OutputStreamWriter writer = null;
                                cacheFile = null;
                                yaml = null;
                                try {
                                    try {
                                        if (be.getBundleDirectory().canWrite()) {
                                            yaml = this.createYAML(be.getBundleDirectory());
                                            Locale locale = Locale.getDefault();
                                            cacheFile = new File(be.getBundleDirectory(), MessageFormat.format("cache.{0}_{1}.yml", locale.getLanguage(), locale.getCountry()));
                                            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(cacheFile), "UTF-8");
                                            yaml.dump((Object)be, (Writer)writer);
                                        }
                                    }
                                    catch (IOException e) {
                                        IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (Throwable)e);
                                        if (writer != null) {
                                            try {
                                                writer.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        break block38;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (writer != null) {
                                        try {
                                            writer.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    throw throwable;
                                }
                                if (writer != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                            reader = null;
                            serializationSucceeded = false;
                            if (!be.getBundleDirectory().canRead()) break block39;
                            if (cacheFile != null) break block40;
                            if (reader == null) break block41;
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (!serializationSucceeded && cacheFile != null) {
                            IdeLog.logWarning((Plugin)ScriptingActivator.getDefault(), (String)StringUtil.format((String)Messages.BundleCacher_SerializationExceptionDeletingCacheFile, (Object)cacheFile));
                            cacheFile.delete();
                        }
                        return false;
                    }
                    reader = new InputStreamReader((InputStream)new FileInputStream(cacheFile), "UTF-8");
                    BundleElement be2 = (BundleElement)yaml.load((Reader)reader);
                    String beString1 = be.toSource(false);
                    String beString2 = be2.toSource(false);
                    serializationSucceeded = beString2.equals(beString1);
                    if (reader == null) break block42;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (!serializationSucceeded && cacheFile != null) {
                    IdeLog.logWarning((Plugin)ScriptingActivator.getDefault(), (String)StringUtil.format((String)Messages.BundleCacher_SerializationExceptionDeletingCacheFile, (Object)cacheFile));
                    cacheFile.delete();
                }
                return true;
                catch (IOException e) {
                    block43: {
                        try {
                            IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (Throwable)e);
                            if (reader == null) break block43;
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (!serializationSucceeded && cacheFile != null) {
                                IdeLog.logWarning((Plugin)ScriptingActivator.getDefault(), (String)StringUtil.format((String)Messages.BundleCacher_SerializationExceptionDeletingCacheFile, cacheFile));
                                cacheFile.delete();
                            }
                            throw throwable;
                        }
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (!serializationSucceeded && cacheFile != null) {
                        IdeLog.logWarning((Plugin)ScriptingActivator.getDefault(), (String)StringUtil.format((String)Messages.BundleCacher_SerializationExceptionDeletingCacheFile, (Object)cacheFile));
                        cacheFile.delete();
                    }
                    break block44;
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (!serializationSucceeded && cacheFile != null) {
                IdeLog.logWarning((Plugin)ScriptingActivator.getDefault(), (String)StringUtil.format((String)Messages.BundleCacher_SerializationExceptionDeletingCacheFile, cacheFile));
                cacheFile.delete();
            }
        }
        return false;
    }

    private File getCacheFile(File bundleDirectory) {
        File file = null;
        Locale current = Locale.getDefault();
        file = new File(bundleDirectory, MessageFormat.format("cache.{0}_{1}.yml", current.getLanguage(), current.getCountry()));
        if (file.isFile()) {
            return file;
        }
        file = new File(bundleDirectory, MessageFormat.format("cache.{0}.yml", current.getLanguage()));
        if (file.isFile()) {
            return file;
        }
        return new File(bundleDirectory, CACHE_FILE);
    }

    public BundleElement load(File bundleDirectory, List<File> bundleFiles, IProgressMonitor monitor) {
        return this.load(bundleDirectory, bundleFiles, monitor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BundleElement load(File bundleDirectory, List<File> bundleFiles, IProgressMonitor monitor, boolean ignoreFileStatus) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)120);
        BundleElement be = null;
        try {
            InputStreamReader reader;
            block23: {
                File cacheFile = this.getCacheFile(bundleDirectory);
                if (!cacheFile.exists()) {
                    return null;
                }
                if (!ignoreFileStatus && this.anyFilesNewer(cacheFile, bundleFiles, (IProgressMonitor)sub.newChild(10))) {
                    return null;
                }
                reader = null;
                Yaml yaml = this.createYAML(bundleDirectory);
                reader = new InputStreamReader((InputStream)new FileInputStream(cacheFile), "UTF-8");
                sub.subTask(MessageFormat.format(Messages.BundleCacher_LoadCacheTaskName, bundleDirectory.getAbsolutePath()));
                BundleCacher bundleCacher = this;
                synchronized (bundleCacher) {
                    be = (BundleElement)yaml.load((Reader)reader);
                }
                sub.worked(80);
                if (ignoreFileStatus || !this.anyFileDeleted(be, (IProgressMonitor)sub.newChild(10))) break block23;
                if (reader == null) return null;
                try {
                    reader.close();
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            try {
                try {
                    this.fireScriptLoadedEvents(be, (IProgressMonitor)sub.newChild(20));
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)MessageFormat.format("Failed to load bundle {0}", bundleDirectory.getAbsolutePath()), (Throwable)e);
                    IdeLog.logInfo((Plugin)ScriptingActivator.getDefault(), (String)MessageFormat.format(Messages.BundleCacher_LoadingYAMLError, bundleDirectory.getAbsolutePath()));
                    if (reader == null) return be;
                    try {
                        reader.close();
                        return be;
                    }
                    catch (IOException iOException) {
                        return be;
                    }
                }
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            if (reader == null) return be;
            try {
                reader.close();
                return be;
            }
            catch (IOException iOException) {
                return be;
            }
        }
        finally {
            sub.done();
        }
    }

    private void fireScriptLoadedEvents(BundleElement be, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Set<File> files = this.getFiles(be, (IProgressMonitor)sub.newChild(30));
        for (File file : files) {
            this.getBundleManager().fireScriptLoadedEvent(file);
            sub.worked(100 / files.size());
        }
        sub.done();
    }

    private Set<File> getFiles(BundleElement be, IProgressMonitor monitor) {
        HashSet<File> files = new HashSet<File>();
        if (be == null) {
            return files;
        }
        String path = be.getPath();
        files.add(new File(path));
        List<AbstractBundleElement> children = be.getChildren();
        if (children == null) {
            return files;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)children.size());
        try {
            for (AbstractBundleElement abe : be.getChildren()) {
                path = abe.getPath();
                files.add(new File(path));
                sub.worked(1);
                if (!(abe instanceof MenuElement)) continue;
                MenuElement menu = (MenuElement)abe;
                files.addAll(this.getFiles(menu));
            }
        }
        finally {
            sub.done();
        }
        return files;
    }

    private Set<File> getFiles(MenuElement parent) {
        if (parent == null || !parent.hasChildren()) {
            return Collections.emptySet();
        }
        HashSet<File> files = new HashSet<File>();
        for (MenuElement child : parent.getChildren()) {
            String path = child.getPath();
            files.add(new File(path));
            files.addAll(this.getFiles(child));
        }
        return files;
    }

    private boolean anyFilesNewer(File cacheFile, List<File> bundleFiles, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)bundleFiles.size());
        try {
            long lastMod = cacheFile.lastModified();
            for (File file : bundleFiles) {
                sub.subTask(MessageFormat.format(Messages.BundleCacher_ComparingTimestampSubTaskName, file.getAbsolutePath()));
                if (file.lastModified() < lastMod) continue;
                IdeLog.logInfo((Plugin)ScriptingActivator.getDefault(), (String)MessageFormat.format(Messages.BundleCacher_OutOfDateCacheMsg, file.getPath()));
                return true;
            }
        }
        finally {
            sub.done();
        }
        return false;
    }

    private boolean anyFileDeleted(BundleElement be, IProgressMonitor monitor) {
        if (be == null) {
            return false;
        }
        List<AbstractBundleElement> children = be.getChildren();
        if (children == null) {
            return false;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)children.size());
        try {
            for (AbstractBundleElement abe : be.getChildren()) {
                String path = abe.getPath();
                if (!new File(path).exists()) {
                    IdeLog.logInfo((Plugin)ScriptingActivator.getDefault(), (String)MessageFormat.format(Messages.BundleCacher_FileReferencedInCacheMissingMsg, path, abe.toString()));
                    return true;
                }
                if (abe instanceof MenuElement) {
                    MenuElement menu = (MenuElement)abe;
                    boolean bl = this.anyFileDeleted(menu);
                    return bl;
                }
                sub.worked(1);
            }
        }
        finally {
            sub.done();
        }
        return false;
    }

    private boolean anyFileDeleted(MenuElement parent) {
        if (parent == null || !parent.hasChildren()) {
            return false;
        }
        Iterator<MenuElement> iterator = parent.getChildren().iterator();
        if (iterator.hasNext()) {
            MenuElement child = iterator.next();
            String path = child.getPath();
            if (!new File(path).exists()) {
                IdeLog.logInfo((Plugin)ScriptingActivator.getDefault(), (String)MessageFormat.format(Messages.BundleCacher_FileReferencedInCacheMissingMsg, path, child.toString()));
                return true;
            }
            return this.anyFileDeleted(child);
        }
        return false;
    }

    private Yaml createYAML(File bundleDirectory) {
        return new Yaml((BaseConstructor)new BundleElementsConstructor(bundleDirectory), (Representer)new MyRepresenter(bundleDirectory));
    }

    private class BundleCacheInvalidatingLoadCycleListener
    implements LoadCycleListener {
        private BundleCacheInvalidatingLoadCycleListener() {
        }

        @Override
        public void scriptUnloaded(File script) {
            if (!script.exists()) {
                File bundleDir = BundleCacher.this.getBundleDir(script);
                BundleCacher.this.cache(bundleDir, (IProgressMonitor)new NullProgressMonitor());
            }
        }

        @Override
        public void scriptReloaded(File script) {
            this.updateCacheIfNecessary(script);
        }

        @Override
        public void scriptLoaded(File script) {
            this.updateCacheIfNecessary(script);
        }

        private void updateCacheIfNecessary(File script) {
            File bundleDir = BundleCacher.this.getBundleDir(script);
            File cacheFile = BundleCacher.this.getCacheFile(bundleDir);
            ArrayList<File> bundleFiles = new ArrayList<File>();
            bundleFiles.add(script);
            if (BundleCacher.this.anyFilesNewer(cacheFile, bundleFiles, (IProgressMonitor)new NullProgressMonitor())) {
                BundleCacher.this.cache(bundleDir, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    class BundleElementsConstructor
    extends Constructor {
        private File bundleDirectory;

        public BundleElementsConstructor(File bundleDirectory) {
            this.bundleDirectory = bundleDirectory;
            this.yamlConstructors.put(new Tag(BundleCacher.SCOPE_SELECTOR_TAG), new ConstructScopeSelector());
            this.yamlConstructors.put(new Tag("!ruby/regexp"), new ConstructRubyRegexp());
            this.yamlConstructors.put(new Tag(BundleCacher.REGEXP_TAG), new ConstructRubyRegexp());
            this.yamlConstructors.put(new Tag(BundleCacher.COMMAND_TAG), new ConstructCommandElement());
            this.yamlConstructors.put(new Tag(BundleCacher.ENVIRONMENT_TAG), new ConstructEnvironmentElement());
            this.yamlConstructors.put(new Tag(BundleCacher.CONTENT_ASSIST_TAG), new ConstructContentAssistElement());
            this.yamlConstructors.put(new Tag(BundleCacher.TEMPLATE_TAG), new ConstructTemplateElement());
            this.yamlConstructors.put(new Tag(BundleElement.class), new ConstructBundleElement());
            this.yamlConstructors.put(new Tag(MenuElement.class), new ConstructMenuElement());
            this.yamlConstructors.put(new Tag(SnippetElement.class), new ConstructSnippetElement());
            this.yamlConstructors.put(new Tag(SnippetCategoryElement.class), new ConstructSnippetCategoryElement());
            this.yamlConstructors.put(new Tag(ContentAssistElement.class), new ConstructContentAssistElement());
            this.yamlConstructors.put(new Tag(CommandElement.class), new ConstructCommandElement());
            this.yamlConstructors.put(new Tag(TemplateElement.class), new ConstructTemplateElement());
            this.yamlConstructors.put(new Tag(SmartTypingPairsElement.class), new ConstructSmartTypingPairsElement());
            this.yamlConstructors.put(new Tag(ProjectTemplateElement.class), new ConstructProjectTemplateElement());
            this.yamlConstructors.put(new Tag(ProjectSampleElement.class), new ConstructProjectSampleElement());
            this.yamlConstructors.put(new Tag(EnvironmentElement.class), new ConstructEnvironmentElement());
            this.yamlConstructors.put(new Tag(BuildPathElement.class), new ConstructBuildPathElement());
            TypeDescription menuDescription = new TypeDescription(MenuElement.class);
            menuDescription.putListPropertyType("children", MenuElement.class);
            this.addTypeDescription(menuDescription);
        }

        private abstract class AbstractBundleElementConstruct
        extends AbstractConstruct {
            private AbstractBundleElementConstruct() {
            }

            protected String getPath(Node node) {
                return this.getPath(node, "path");
            }

            protected String getPath(Node node, String propertyName) {
                IPath pathObj;
                String relativePath = null;
                if (node instanceof MappingNode) {
                    MappingNode map = (MappingNode)node;
                    List nodes = map.getValue();
                    for (NodeTuple tuple : nodes) {
                        Node valueNode;
                        ScalarNode scalar;
                        String valueOfKey;
                        Node keyNode = tuple.getKeyNode();
                        if (!(keyNode instanceof ScalarNode) || !propertyName.equals(valueOfKey = (scalar = (ScalarNode)keyNode).getValue()) || !((valueNode = tuple.getValueNode()) instanceof ScalarNode)) continue;
                        ScalarNode scalarValue = (ScalarNode)valueNode;
                        relativePath = scalarValue.getValue();
                        break;
                    }
                }
                if (relativePath != null && !(pathObj = Path.fromOSString(relativePath)).isAbsolute()) {
                    relativePath = new File(BundleElementsConstructor.this.bundleDirectory, relativePath).getAbsolutePath();
                }
                return relativePath;
            }

            protected void setPrefixTriggers(Node node, CommandElement be) {
                MappingNode mapNode = (MappingNode)node;
                List tuples = mapNode.getValue();
                for (NodeTuple tuple : tuples) {
                    Node customPropertiesValueNode;
                    ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
                    String key = keyNode.getValue();
                    if (!"customProperties".equals(key) || !((customPropertiesValueNode = tuple.getValueNode()) instanceof MappingNode)) continue;
                    MappingNode custompropertiesNode = (MappingNode)customPropertiesValueNode;
                    for (NodeTuple propTuple : custompropertiesNode.getValue()) {
                        ScalarNode propKeyNode = (ScalarNode)propTuple.getKeyNode();
                        if (!"prefix_values".equals(propKeyNode.getValue())) continue;
                        SequenceNode prefixValuesNode = (SequenceNode)propTuple.getValueNode();
                        ArrayList<String> values = new ArrayList<String>();
                        for (Node prefixValue : prefixValuesNode.getValue()) {
                            if (prefixValue instanceof ScalarNode) {
                                ScalarNode blah = (ScalarNode)prefixValue;
                                values.add(blah.getValue());
                                continue;
                            }
                            IdeLog.logWarning((Plugin)ScriptingActivator.getDefault(), (String)"Expected a flattened array for trigger, but got nested arrays.");
                        }
                        be.setTrigger(TriggerType.PREFIX.getName(), values.toArray(new String[values.size()]));
                    }
                }
            }
        }

        private class ConstructBuildPathElement
        extends AbstractBundleElementConstruct {
            private ConstructBuildPathElement() {
            }

            public Object construct(Node node) {
                node.setType(BuildPathElement.class);
                String path = this.getPath(node);
                String buildPath = this.getPath(node, "buildPath");
                BuildPathElement bpe = new BuildPathElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)bpe);
                bpe.setPath(path);
                bpe.setBuildPath(buildPath);
                return bpe;
            }
        }

        private class ConstructBundleElement
        extends AbstractBundleElementConstruct {
            private ConstructBundleElement() {
            }

            public Object construct(Node node) {
                node.setType(BundleElement.class);
                String path = this.getPath(node);
                BundleElement be = new BundleElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)be);
                be.setPath(path);
                return be;
            }
        }

        private class ConstructCommandElement
        extends AbstractBundleElementConstruct {
            private ConstructCommandElement() {
            }

            public Object construct(Node node) {
                node.setType(CommandElement.class);
                String path = this.getPath(node);
                LazyCommandElement be = new LazyCommandElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)be);
                be.setPath(path);
                this.setPrefixTriggers(node, be);
                return be;
            }
        }

        private class ConstructContentAssistElement
        extends AbstractBundleElementConstruct {
            private ConstructContentAssistElement() {
            }

            public Object construct(Node node) {
                node.setType(ContentAssistElement.class);
                String path = this.getPath(node);
                LazyContentAssistElement be = new LazyContentAssistElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)be);
                be.setPath(path);
                this.setPrefixTriggers(node, be);
                return be;
            }
        }

        private class ConstructEnvironmentElement
        extends AbstractBundleElementConstruct {
            private ConstructEnvironmentElement() {
            }

            public Object construct(Node node) {
                node.setType(EnvironmentElement.class);
                String path = this.getPath(node);
                LazyEnvironmentElement be = new LazyEnvironmentElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)be);
                be.setPath(path);
                return be;
            }
        }

        private class ConstructMenuElement
        extends AbstractBundleElementConstruct {
            private ConstructMenuElement() {
            }

            public Object construct(Node node) {
                node.setType(MenuElement.class);
                String path = this.getPath(node);
                MenuElement be = new MenuElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)be);
                be.setPath(path);
                this.forcePathsOfChildren(be.getChildren());
                return be;
            }

            private void forcePathsOfChildren(List<MenuElement> children) {
                if (children != null) {
                    for (MenuElement child : children) {
                        String childPath = child.getPath();
                        IPath pathObj = Path.fromOSString((String)childPath);
                        if (!pathObj.isAbsolute()) {
                            child.setPath(String.valueOf(BundleElementsConstructor.this.bundleDirectory.getAbsolutePath()) + File.separator + childPath);
                        }
                        this.forcePathsOfChildren(child.getChildren());
                    }
                }
            }
        }

        private class ConstructProjectSampleElement
        extends AbstractBundleElementConstruct {
            private ConstructProjectSampleElement() {
            }

            public Object construct(Node node) {
                node.setType(ProjectSampleElement.class);
                String path = this.getPath(node);
                ProjectSampleElement be = new ProjectSampleElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)be);
                be.setPath(path);
                return be;
            }
        }

        private class ConstructProjectTemplateElement
        extends AbstractBundleElementConstruct {
            private ConstructProjectTemplateElement() {
            }

            public Object construct(Node node) {
                node.setType(ProjectTemplateElement.class);
                String path = this.getPath(node);
                ProjectTemplateElement be = new ProjectTemplateElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)be);
                be.setPath(path);
                return be;
            }
        }

        private class ConstructRubyRegexp
        extends AbstractConstruct {
            private ConstructRubyRegexp() {
            }

            public Object construct(Node node) {
                String val = (String)BundleElementsConstructor.this.constructScalar((ScalarNode)node);
                if (val != null && val.length() > 2 && val.charAt(0) == '/') {
                    val = val.substring(1, val.length() - 1);
                }
                return RubyRegexp.newRegexp((Ruby)ScriptingEngine.getInstance().getScriptingContainer().getProvider().getRuntime(), (String)val, (RegexpOptions)RegexpOptions.NULL_OPTIONS);
            }
        }

        private class ConstructScopeSelector
        extends AbstractConstruct {
            private ConstructScopeSelector() {
            }

            public Object construct(Node node) {
                String val = (String)BundleElementsConstructor.this.constructScalar((ScalarNode)node);
                return new ScopeSelector(val);
            }
        }

        private class ConstructSmartTypingPairsElement
        extends AbstractBundleElementConstruct {
            private ConstructSmartTypingPairsElement() {
            }

            public Object construct(Node node) {
                node.setType(SmartTypingPairsElement.class);
                String path = this.getPath(node);
                SmartTypingPairsElement be = new SmartTypingPairsElement(path);
                MappingNode mapNode = (MappingNode)node;
                List tuples = mapNode.getValue();
                for (NodeTuple tuple : tuples) {
                    ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
                    String key = keyNode.getValue();
                    if ("pairs".equals(key)) {
                        SequenceNode pairsValueNode = (SequenceNode)tuple.getValueNode();
                        ArrayList<Character> pairs = new ArrayList<Character>();
                        List pairsValues = pairsValueNode.getValue();
                        for (Node pairValue : pairsValues) {
                            ScalarNode blah = (ScalarNode)pairValue;
                            String pairCharacter = blah.getValue();
                            pairs.add(Character.valueOf(pairCharacter.charAt(0)));
                        }
                        be.setPairs(pairs);
                        continue;
                    }
                    if ("scope".equals(key)) {
                        ScalarNode scopeValueNode = (ScalarNode)tuple.getValueNode();
                        be.setScope(scopeValueNode.getValue());
                        continue;
                    }
                    if (!"displayName".equals(key)) continue;
                    ScalarNode displayNameNode = (ScalarNode)tuple.getValueNode();
                    be.setDisplayName(displayNameNode.getValue());
                }
                return be;
            }
        }

        private class ConstructSnippetCategoryElement
        extends AbstractBundleElementConstruct {
            private ConstructSnippetCategoryElement() {
            }

            public Object construct(Node node) {
                node.setType(SnippetCategoryElement.class);
                String path = this.getPath(node);
                SnippetCategoryElement sce = new SnippetCategoryElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)sce);
                sce.setPath(path);
                return sce;
            }
        }

        private class ConstructSnippetElement
        extends AbstractBundleElementConstruct {
            private ConstructSnippetElement() {
            }

            public Object construct(Node node) {
                node.setType(SnippetElement.class);
                String path = this.getPath(node);
                SnippetElement be = new SnippetElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)be);
                be.setPath(path);
                this.setPrefixTriggers(node, be);
                return be;
            }
        }

        private class ConstructTemplateElement
        extends AbstractBundleElementConstruct {
            private ConstructTemplateElement() {
            }

            public Object construct(Node node) {
                node.setType(TemplateElement.class);
                String path = this.getPath(node);
                LazyTemplateElement be = new LazyTemplateElement(path);
                Construct mappingConstruct = (Construct)BundleElementsConstructor.this.yamlClassConstructors.get(NodeId.mapping);
                mappingConstruct.construct2ndStep(node, (Object)be);
                be.setPath(path);
                this.setPrefixTriggers(node, be);
                return be;
            }
        }
    }

    private class LazyCommandElement
    extends CommandElement {
        private CommandElement real;

        public LazyCommandElement(String path) {
            super(path);
        }

        @Override
        public boolean isExecutable() {
            return true;
        }

        @Override
        public String getInvoke() {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.getInvoke();
        }

        @Override
        public RubyProc getInvokeBlock() {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.getInvokeBlock();
        }

        @Override
        public CommandResult execute(CommandContext context) {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.execute(context);
        }

        @Override
        public Ruby getRuntime() {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.getRuntime();
        }

        @Override
        public CommandContext createCommandContext() {
            this.lazyLoad();
            return new CommandContext(this.real);
        }

        private synchronized void lazyLoad() {
            if (this.real == null) {
                BundleElement owning = this.getOwningBundle();
                if (owning == null) {
                    return;
                }
                List<AbstractElement> elements = BundleElement.getElementsByPath(this.getPath());
                for (AbstractElement element : elements) {
                    if (!(element instanceof AbstractBundleElement)) continue;
                    AbstractBundleElement abe = (AbstractBundleElement)element;
                    owning.removeChild(abe);
                }
                BundleManager.getInstance().loadScript(new File(this.getPath()));
                if (this.getPath().equals(owning.getPath())) {
                    owning = BundleManager.getInstance().getBundleFromPath(new File(this.getPath()).getParent());
                    this.setOwningBundle(owning);
                }
                this.real = owning.getCommandByName(this.getDisplayName());
            }
        }
    }

    private class LazyContentAssistElement
    extends ContentAssistElement {
        private ContentAssistElement real;

        public LazyContentAssistElement(String path) {
            super(path);
        }

        @Override
        public boolean isExecutable() {
            return true;
        }

        @Override
        public String getInvoke() {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.getInvoke();
        }

        @Override
        public RubyProc getInvokeBlock() {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.getInvokeBlock();
        }

        @Override
        public CommandResult execute(CommandContext context) {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.execute(context);
        }

        @Override
        public Ruby getRuntime() {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.getRuntime();
        }

        @Override
        public CommandContext createCommandContext() {
            this.lazyLoad();
            return new CommandContext(this.real);
        }

        private synchronized void lazyLoad() {
            if (this.real == null) {
                BundleElement owning = this.getOwningBundle();
                if (owning == null) {
                    return;
                }
                List<AbstractElement> elements = BundleElement.getElementsByPath(this.getPath());
                for (AbstractElement element : elements) {
                    if (!(element instanceof AbstractBundleElement)) continue;
                    AbstractBundleElement abe = (AbstractBundleElement)element;
                    owning.removeChild(abe);
                }
                BundleManager.getInstance().loadScript(new File(this.getPath()));
                if (this.getPath().equals(owning.getPath())) {
                    owning = BundleManager.getInstance().getBundleFromPath(new File(this.getPath()).getParent());
                    this.setOwningBundle(owning);
                }
                for (ContentAssistElement ca : owning.getContentAssists()) {
                    if (!ca.getDisplayName().equals(this.getDisplayName())) continue;
                    this.real = ca;
                    break;
                }
            }
        }
    }

    private class LazyEnvironmentElement
    extends EnvironmentElement {
        private EnvironmentElement real;

        public LazyEnvironmentElement(String path) {
            super(path);
        }

        @Override
        public RubyProc getInvokeBlock() {
            this.lazyLoad();
            if (this.real != null) {
                return this.real.getInvokeBlock();
            }
            return null;
        }

        private synchronized void lazyLoad() {
            if (this.real == null) {
                BundleElement owning = this.getOwningBundle();
                if (owning == null) {
                    return;
                }
                List<AbstractElement> elements = BundleElement.getElementsByPath(this.getPath());
                for (AbstractElement element : elements) {
                    if (!(element instanceof AbstractBundleElement)) continue;
                    AbstractBundleElement abe = (AbstractBundleElement)element;
                    owning.removeChild(abe);
                }
                BundleManager.getInstance().loadScript(new File(this.getPath()));
                if (this.getPath().equals(owning.getPath())) {
                    owning = BundleManager.getInstance().getBundleFromPath(new File(this.getPath()).getParent());
                    this.setOwningBundle(owning);
                }
                List<EnvironmentElement> envs = owning.getEnvs();
                for (EnvironmentElement env : envs) {
                    if (!env.getPath().equals(this.getPath()) || !env.getScope().equals(this.getScope())) continue;
                    this.real = env;
                    break;
                }
            }
        }
    }

    private class LazyTemplateElement
    extends TemplateElement {
        private TemplateElement real;

        public LazyTemplateElement(String path) {
            super(path);
        }

        @Override
        public String getInvoke() {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.getInvoke();
        }

        @Override
        public RubyProc getInvokeBlock() {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.getInvokeBlock();
        }

        @Override
        public CommandResult execute(CommandContext context) {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.execute(context);
        }

        @Override
        public Ruby getRuntime() {
            this.lazyLoad();
            if (this.real == null) {
                return null;
            }
            return this.real.getRuntime();
        }

        @Override
        public CommandContext createCommandContext() {
            this.lazyLoad();
            return new CommandContext(this.real);
        }

        private synchronized void lazyLoad() {
            if (this.real == null) {
                BundleElement owning = this.getOwningBundle();
                if (owning == null) {
                    return;
                }
                HashSet<LazyTemplateElement> lazyTemplates = new HashSet<LazyTemplateElement>();
                lazyTemplates.add(this);
                List<AbstractElement> elements = BundleElement.getElementsByPath(this.getPath());
                for (AbstractElement element : elements) {
                    if (!(element instanceof AbstractBundleElement)) continue;
                    AbstractBundleElement abe = (AbstractBundleElement)element;
                    owning.removeChild(abe);
                    if (!(element instanceof LazyTemplateElement)) continue;
                    lazyTemplates.add((LazyTemplateElement)abe);
                }
                BundleManager.getInstance().loadScript(new File(this.getPath()));
                if (this.getPath().equals(owning.getPath())) {
                    owning = BundleManager.getInstance().getBundleFromPath(new File(this.getPath()).getParent());
                    this.setOwningBundle(owning);
                }
                block1: for (TemplateElement template : owning.getFileTemplates()) {
                    if (template instanceof LazyTemplateElement) continue;
                    for (LazyTemplateElement lazy : lazyTemplates) {
                        if (!template.getDisplayName().equals(lazy.getDisplayName())) continue;
                        lazy.real = template;
                        continue block1;
                    }
                }
            }
        }
    }

    private class MyRepresenter
    extends Representer {
        private File bundleDirectory;

        public MyRepresenter(File bundleDirectory) {
            this.bundleDirectory = bundleDirectory;
            this.representers.put(RubyRegexp.class, new RepresentRubyRegexp());
            this.representers.put(ScopeSelector.class, new RepresentScopeSelector());
            this.addClassTag(LazyCommandElement.class, new Tag(BundleCacher.COMMAND_TAG));
            this.addClassTag(LazyEnvironmentElement.class, new Tag(BundleCacher.ENVIRONMENT_TAG));
            this.addClassTag(LazyTemplateElement.class, new Tag(BundleCacher.TEMPLATE_TAG));
            this.addClassTag(LazyContentAssistElement.class, new Tag(BundleCacher.CONTENT_ASSIST_TAG));
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            if (javaBean instanceof AbstractElement && ("path".equals(property.getName()) || "buildPath".equals(property.getName()))) {
                String path = (String)propertyValue;
                IPath relative = Path.fromOSString((String)path).makeRelativeTo(Path.fromOSString((String)this.bundleDirectory.getAbsolutePath()));
                propertyValue = relative.toOSString();
            }
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }

        protected Set<Property> getProperties(Class<? extends Object> type) throws IntrospectionException {
            if (type.equals(Ruby.class) || type.equals(KCode.class) || type.equals(RubyProc.class)) {
                return Collections.emptySet();
            }
            Set set = super.getProperties(type);
            if (CommandElement.class.isAssignableFrom(type) || type.equals(EnvironmentElement.class)) {
                HashSet<Property> toRemove = new HashSet<Property>();
                for (Property prop : set) {
                    if (!"invokeBlock".equals(prop.getName()) && !"runtime".equals(prop.getName()) && !"invoke".equals(prop.getName())) continue;
                    toRemove.add(prop);
                }
                set.removeAll(toRemove);
            }
            return set;
        }

        private class RepresentRubyRegexp
        implements Represent {
            private RepresentRubyRegexp() {
            }

            public Node representData(Object data) {
                RubyRegexp dice = (RubyRegexp)data;
                String value = dice.toString();
                return MyRepresenter.this.representScalar(new Tag(BundleCacher.REGEXP_TAG), value);
            }
        }

        private class RepresentScopeSelector
        implements Represent {
            private RepresentScopeSelector() {
            }

            public Node representData(Object data) {
                ScopeSelector dice = (ScopeSelector)data;
                String value = dice.toString();
                return MyRepresenter.this.representScalar(new Tag(BundleCacher.SCOPE_SELECTOR_TAG), value);
            }
        }
    }
}

