/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.scripting.ScriptLogger;
import com.aptana.scripting.ScriptingActivator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ScriptUtils {
    public static final String RUBLE_MODULE = "Ruble";
    public static final IRubyObject[] NO_ARGS = new IRubyObject[0];

    private ScriptUtils() {
    }

    public static IRubyObject instantiateClass(Ruby runtime, String name, IRubyObject ... args) {
        ThreadContext threadContext = runtime.getCurrentContext();
        IRubyObject result = null;
        RubyClass rubyClass = runtime.getClass(name);
        if (rubyClass != null) {
            result = rubyClass.newInstance(threadContext, args, Block.NULL_BLOCK);
        }
        return result;
    }

    public static IRubyObject instantiateClass(Ruby runtime, String module, String name, IRubyObject ... args) {
        RubyClass rubyClass;
        ThreadContext threadContext = runtime.getCurrentContext();
        IRubyObject result = null;
        RubyModule rubyModule = runtime.getModule(module);
        if (rubyModule != null && (rubyClass = rubyModule.getClass(name)) != null) {
            result = rubyClass.newInstance(threadContext, args, Block.NULL_BLOCK);
        }
        return result;
    }

    public static void logErrorWithStackTrace(String message, Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        e.printStackTrace(writer);
        ScriptLogger.logError(String.valueOf(message) + "\n" + stringWriter.toString());
    }

    public static void executeScriptCommnad(final String commandId) {
        if (StringUtil.isEmpty((String)commandId)) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ICommandService commandService;
                    Command command;
                    WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (workbenchWindow != null && (command = (commandService = (ICommandService)workbenchWindow.getService(ICommandService.class)).getCommand(commandId)) != null && command.isEnabled()) {
                        command.executeWithChecks(new ExecutionEvent(command, Collections.EMPTY_MAP, null, null));
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)ScriptingActivator.getDefault(), (String)("executeScriptCommnad(" + commandId + ")"), (Throwable)e);
                }
            }
        });
    }
}

