/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scope;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.scope.BinarySelector;
import com.aptana.scope.DescendantSelector;
import com.aptana.scope.GroupSelector;
import com.aptana.scope.ISelectorNode;
import com.aptana.scope.NameSelector;
import java.util.ArrayList;
import java.util.List;

public class ScopeUtil {
    public static String toTreeString(ISelectorNode node) {
        ArrayList<String> parts = new ArrayList<String>();
        ScopeUtil.toTreeString(parts, node);
        return StringUtil.concat(parts);
    }

    private static void toTreeString(List<String> buffer, ISelectorNode node) {
        if (node instanceof BinarySelector) {
            BinarySelector selector = (BinarySelector)node;
            ISelectorNode left = selector.getLeftChild();
            ISelectorNode right = selector.getRightChild();
            String operator = node instanceof DescendantSelector ? ">" : selector.getOperator().trim();
            CollectionsUtil.addToList(buffer, (Object[])new String[]{"(", operator, " ", ScopeUtil.toTreeString(left), " ", ScopeUtil.toTreeString(right), ")"});
        } else if (node instanceof GroupSelector) {
            GroupSelector selector = (GroupSelector)node;
            CollectionsUtil.addToList(buffer, (Object[])new String[]{"(GROUP ", ScopeUtil.toTreeString(selector.getChild()), ")"});
        } else if (node instanceof NameSelector) {
            NameSelector selector = (NameSelector)node;
            buffer.add(selector.toString());
        }
    }

    private ScopeUtil() {
    }
}

