/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter;

import beaver.Symbol;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.js.formatter.JSFormatterPlugin;
import com.aptana.editor.js.formatter.nodes.FormatterJSBlockNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSCaseBodyNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSCaseNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSDeclarationNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSDefaultLineNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSElseIfNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSElseNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSExpressionWrapperNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSFunctionBodyNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSFunctionInvocationNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSGetElementNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSGetPropertyNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSGroupNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSIdentifierNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSIfNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSImplicitBlockNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSNameValuePairNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSNonBlockedWhileNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSObjectNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSOperatorNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSParenthesesNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSPunctuationNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSRootNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSSwitchNode;
import com.aptana.editor.js.formatter.nodes.FormatterJSTextNode;
import com.aptana.editor.js.parsing.ast.JSArgumentsNode;
import com.aptana.editor.js.parsing.ast.JSArrayNode;
import com.aptana.editor.js.parsing.ast.JSAssignmentNode;
import com.aptana.editor.js.parsing.ast.JSBinaryArithmeticOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBinaryBooleanOperatorNode;
import com.aptana.editor.js.parsing.ast.JSBreakNode;
import com.aptana.editor.js.parsing.ast.JSCaseNode;
import com.aptana.editor.js.parsing.ast.JSCatchNode;
import com.aptana.editor.js.parsing.ast.JSCommaNode;
import com.aptana.editor.js.parsing.ast.JSConditionalNode;
import com.aptana.editor.js.parsing.ast.JSConstructNode;
import com.aptana.editor.js.parsing.ast.JSContinueNode;
import com.aptana.editor.js.parsing.ast.JSDeclarationNode;
import com.aptana.editor.js.parsing.ast.JSDefaultNode;
import com.aptana.editor.js.parsing.ast.JSDoNode;
import com.aptana.editor.js.parsing.ast.JSElementsNode;
import com.aptana.editor.js.parsing.ast.JSEmptyNode;
import com.aptana.editor.js.parsing.ast.JSErrorNode;
import com.aptana.editor.js.parsing.ast.JSFalseNode;
import com.aptana.editor.js.parsing.ast.JSFinallyNode;
import com.aptana.editor.js.parsing.ast.JSForInNode;
import com.aptana.editor.js.parsing.ast.JSForNode;
import com.aptana.editor.js.parsing.ast.JSFunctionNode;
import com.aptana.editor.js.parsing.ast.JSGetElementNode;
import com.aptana.editor.js.parsing.ast.JSGetPropertyNode;
import com.aptana.editor.js.parsing.ast.JSGroupNode;
import com.aptana.editor.js.parsing.ast.JSIdentifierNode;
import com.aptana.editor.js.parsing.ast.JSIfNode;
import com.aptana.editor.js.parsing.ast.JSInvokeNode;
import com.aptana.editor.js.parsing.ast.JSNameValuePairNode;
import com.aptana.editor.js.parsing.ast.JSNode;
import com.aptana.editor.js.parsing.ast.JSNullNode;
import com.aptana.editor.js.parsing.ast.JSNumberNode;
import com.aptana.editor.js.parsing.ast.JSObjectNode;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.editor.js.parsing.ast.JSPostUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSPreUnaryOperatorNode;
import com.aptana.editor.js.parsing.ast.JSRegexNode;
import com.aptana.editor.js.parsing.ast.JSReturnNode;
import com.aptana.editor.js.parsing.ast.JSStatementsNode;
import com.aptana.editor.js.parsing.ast.JSStringNode;
import com.aptana.editor.js.parsing.ast.JSSwitchNode;
import com.aptana.editor.js.parsing.ast.JSThisNode;
import com.aptana.editor.js.parsing.ast.JSThrowNode;
import com.aptana.editor.js.parsing.ast.JSTreeWalker;
import com.aptana.editor.js.parsing.ast.JSTrueNode;
import com.aptana.editor.js.parsing.ast.JSTryNode;
import com.aptana.editor.js.parsing.ast.JSVarNode;
import com.aptana.editor.js.parsing.ast.JSWhileNode;
import com.aptana.editor.js.parsing.ast.JSWithNode;
import com.aptana.formatter.FormatterDocument;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.AbstractFormatterNodeBuilder;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.NodeTypes;
import com.aptana.parsing.ast.IParseNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;

public class JSFormatterNodeBuilder
extends AbstractFormatterNodeBuilder {
    private FormatterDocument document;
    private boolean hasErrors;
    private Set<Integer> singleLinecommentEndOffsets;
    private Set<Integer> multiLinecommentEndOffsets;

    public IFormatterContainerNode build(IParseNode parseResult, FormatterDocument document) {
        this.document = document;
        FormatterJSRootNode rootNode = new FormatterJSRootNode((IFormatterDocument)document);
        this.start((IFormatterContainerNode)rootNode);
        JSParseRootNode jsRootNode = (JSParseRootNode)parseResult;
        this.generateCommentEndOffsets(jsRootNode.getCommentNodes());
        jsRootNode.accept((JSTreeWalker)new JSFormatterTreeWalker());
        this.checkedPop((IFormatterContainerNode)rootNode, document.getLength());
        return rootNode;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private void generateCommentEndOffsets(IParseNode[] comments) {
        this.singleLinecommentEndOffsets = new HashSet<Integer>();
        this.multiLinecommentEndOffsets = new HashSet<Integer>();
        if (comments == null) {
            return;
        }
        boolean onOffEnabled = this.document.getBoolean("js.formatter.formatter.on.off.enabled");
        LinkedHashMap<Integer, String> commentsMap = onOffEnabled ? new LinkedHashMap<Integer, String>(comments.length) : null;
        IParseNode[] iParseNodeArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            IParseNode comment = iParseNodeArray[n2];
            short commentType = comment.getNodeType();
            int end = comment.getEndingOffset();
            if (commentType == 92) {
                this.singleLinecommentEndOffsets.add(this.getNextNonWhiteCharOffset(this.document, end + 1));
            } else if (commentType == 93 || commentType == 90 || commentType == 91) {
                this.multiLinecommentEndOffsets.add(this.getNextNonWhiteCharOffset(this.document, end + 1));
            }
            if (onOffEnabled) {
                int start = comment.getStartingOffset();
                String commentStr = this.document.get(start, end + 1);
                commentsMap.put(start, commentStr);
            }
            ++n2;
        }
        if (onOffEnabled && !commentsMap.isEmpty()) {
            Pattern onPattern = Pattern.compile(Pattern.quote(this.document.getString("js.formatter.formatter.on")));
            Pattern offPattern = Pattern.compile(Pattern.quote(this.document.getString("js.formatter.formatter.off")));
            this.setOffOnRegions(FormatterUtils.resolveOnOffRegions(commentsMap, (Pattern)onPattern, (Pattern)offPattern, (int)(this.document.getLength() - 1)));
        }
    }

    private boolean hasSingleCommentBefore(int offset) {
        return this.singleLinecommentEndOffsets.contains(offset);
    }

    private boolean hasMultiLineCommentBefore(int offset) {
        return this.multiLinecommentEndOffsets.contains(offset);
    }

    private boolean hasAnyCommentBefore(int offset) {
        return this.hasSingleCommentBefore(offset) || this.hasMultiLineCommentBefore(offset);
    }

    private class JSFormatterTreeWalker
    extends JSTreeWalker {
        private JSFormatterTreeWalker() {
        }

        public void visit(JSFunctionNode node) {
            int startingOffset = node.getStartingOffset();
            int declarationEnd = startingOffset + 8;
            FormatterJSDeclarationNode declarationNode = new FormatterJSDeclarationNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, true, (IParseNode)node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(startingOffset));
            declarationNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startingOffset, (int)declarationEnd));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)declarationNode);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)declarationNode, -1);
            JSNode functionName = (JSNode)node.getName();
            if (functionName != null && functionName.getNodeType() != 0) {
                this.visitTextNode((IParseNode)functionName, true, 1);
                declarationEnd = functionName.getEnd() + 1;
            }
            JSNode body = (JSNode)node.getBody();
            IParseNode functionParameters = node.getParameters();
            List<JSNode> parameters = this.asJSNodesList(functionParameters.getChildren());
            this.pushParametersInParentheses(functionParameters.getStartingOffset(), functionParameters.getEndingOffset(), parameters, NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.DECLARATION_PARENTHESIS);
            FormatterJSFunctionBodyNode bodyNode = new FormatterJSFunctionBodyNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, FormatterJSDeclarationNode.isPartOfExpression(node.getParent()), JSFormatterNodeBuilder.this.hasAnyCommentBefore(body.getStartingOffset()));
            bodyNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)body.getStartingOffset(), (int)(body.getStartingOffset() + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)bodyNode);
            this.visitChildren(body);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)bodyNode, body.getEndingOffset());
            int end = body.getEndingOffset() + 1;
            bodyNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)body.getEndingOffset(), (int)end));
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEnd(), false, true);
            }
        }

        public void visit(JSErrorNode node) {
            JSFormatterNodeBuilder.this.hasErrors = true;
        }

        public void visit(JSFalseNode node) {
            this.visitTextNode((IParseNode)node, true, 0);
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEnd(), false, true);
            }
        }

        public void visit(JSTrueNode node) {
            this.visitTextNode((IParseNode)node, true, 0);
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEnd(), false, true);
            }
        }

        public void visit(JSEmptyNode node) {
            if (node.getLength() > 0 && node.getChildCount() == 0) {
                this.visitTextNode(node.getStartingOffset(), node.getEndingOffset() + 1, false, 0);
            }
            super.visit(node);
        }

        public void visit(JSPostUnaryOperatorNode node) {
            JSNode expression = (JSNode)node.getExpression();
            NodeTypes.TypeOperator op = NodeTypes.TypeOperator.getTypeOperator((String)node.getOperator().value.toString());
            expression.accept((JSTreeWalker)this);
            this.pushTypeOperator(op, node.getOperator().getStart(), true);
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            }
        }

        public void visit(JSPreUnaryOperatorNode node) {
            JSNode expression = (JSNode)node.getExpression();
            NodeTypes.TypeOperator op = NodeTypes.TypeOperator.getTypeOperator((String)node.getOperator().value.toString());
            this.pushTypeOperator(op, node.getOperator().getStart(), true);
            expression.accept((JSTreeWalker)this);
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            }
        }

        public void visit(JSConditionalNode node) {
            int nodeStart = node.getStartingOffset();
            FormatterJSExpressionWrapperNode conditionalWrapperNode = new FormatterJSExpressionWrapperNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (JSNode)node, JSFormatterNodeBuilder.this.hasSingleCommentBefore(nodeStart));
            conditionalWrapperNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)nodeStart, (int)nodeStart));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)conditionalWrapperNode);
            JSNode condition = (JSNode)node.getTestExpression();
            condition.accept((JSTreeWalker)this);
            this.pushTypeOperator(NodeTypes.TypeOperator.CONDITIONAL, node.getQuestionMark().getStart(), false);
            JSNode trueExpression = (JSNode)node.getTrueExpression();
            trueExpression.accept((JSTreeWalker)this);
            this.pushTypeOperator(NodeTypes.TypeOperator.CONDITIONAL_COLON, node.getColon().getStart(), false);
            JSNode falseExpression = (JSNode)node.getFalseExpression();
            falseExpression.accept((JSTreeWalker)this);
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            }
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)conditionalWrapperNode, -1);
            IFormatterContainerNode topNode = JSFormatterNodeBuilder.this.peek();
            int endingOffset = topNode.getEndOffset();
            conditionalWrapperNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)endingOffset, (int)endingOffset));
        }

        public void visit(JSIfNode node) {
            JSNode trueBlock = (JSNode)node.getTrueBlock();
            JSNode falseBlock = (JSNode)node.getFalseBlock();
            boolean isEmptyFalseBlock = falseBlock.getNodeType() == 0;
            boolean isCurlyTrueBlock = trueBlock.getNodeType() == 21;
            boolean isCurlyFalseBlock = !isEmptyFalseBlock && falseBlock.getNodeType() == 21;
            FormatterJSIfNode ifNode = new FormatterJSIfNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, isCurlyTrueBlock, (IParseNode)node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(node.getStartingOffset()));
            int ifStart = node.getStartingOffset();
            ifNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)ifStart, (int)(ifStart + 2)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)ifNode);
            this.pushNodeInParentheses('(', ')', node.getLeftParenthesis().getStart(), node.getRightParenthesis().getEnd() + 1, (JSNode)node.getCondition(), false, NodeTypes.TypeBracket.CONDITIONAL_PARENTHESIS);
            if (isCurlyTrueBlock) {
                this.pushBlockNode(trueBlock, false);
            } else {
                this.wrapInImplicitBlock(trueBlock, false);
            }
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)ifNode, trueBlock.getEndingOffset());
            if (!isEmptyFalseBlock) {
                int trueBlockEnd = trueBlock.getEndingOffset();
                int falseBlockStart = falseBlock.getStartingOffset();
                String segment = JSFormatterNodeBuilder.this.document.get(trueBlockEnd + 1, falseBlockStart);
                int elsePos = segment.toLowerCase().indexOf("else");
                int elseBlockStart = elsePos + trueBlockEnd + 1;
                int elseBlockDeclarationEnd = elseBlockStart + 4;
                boolean isElseIf = falseBlock.getNodeType() == 86;
                FormatterJSElseNode elseNode = new FormatterJSElseNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, isCurlyFalseBlock, isElseIf, isCurlyTrueBlock, JSFormatterNodeBuilder.this.hasAnyCommentBefore(elseBlockStart));
                elseNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)elseBlockStart, (int)elseBlockDeclarationEnd));
                JSFormatterNodeBuilder.this.push((IFormatterContainerNode)elseNode);
                if (isCurlyFalseBlock) {
                    this.pushBlockNode(falseBlock, false);
                } else if (isElseIf) {
                    FormatterJSElseIfNode elseIfNode = new FormatterJSElseIfNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, JSFormatterNodeBuilder.this.hasAnyCommentBefore(falseBlockStart));
                    elseIfNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)falseBlockStart, (int)falseBlockStart));
                    JSFormatterNodeBuilder.this.push((IFormatterContainerNode)elseIfNode);
                    falseBlock.accept((JSTreeWalker)this);
                    int falseBlockEnd = falseBlock.getEndingOffset() + 1;
                    JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)elseIfNode, falseBlockEnd);
                    elseIfNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)falseBlockEnd, (int)falseBlockEnd));
                } else {
                    this.wrapInImplicitBlock(falseBlock, false);
                }
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)elseNode, falseBlock.getEndingOffset() + 1);
            }
        }

        public void visit(JSDoNode node) {
            int blockEnd;
            int startingOffset = node.getStartingOffset();
            FormatterJSDeclarationNode declarationNode = new FormatterJSDeclarationNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, true, (IParseNode)node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(startingOffset));
            declarationNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startingOffset, (int)(startingOffset + 2)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)declarationNode);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)declarationNode, -1);
            JSNode body = (JSNode)node.getBody();
            boolean bodyInBrackets = body.getNodeType() == 21;
            FormatterJSBlockNode doWhileBlock = new FormatterJSBlockNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, JSFormatterNodeBuilder.this.hasAnyCommentBefore(body.getStartingOffset()));
            if (bodyInBrackets) {
                doWhileBlock.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)body.getStartingOffset(), (int)(body.getStartingOffset() + 1)));
                JSFormatterNodeBuilder.this.push((IFormatterContainerNode)doWhileBlock);
                this.visitChildren(body);
                blockEnd = body.getEndingOffset();
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)doWhileBlock, blockEnd);
                doWhileBlock.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)blockEnd, (int)(blockEnd + 1)));
            } else {
                doWhileBlock.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)body.getStartingOffset(), (int)body.getStartingOffset()));
                JSFormatterNodeBuilder.this.push((IFormatterContainerNode)doWhileBlock);
                body.accept((JSTreeWalker)this);
                blockEnd = body.getEndingOffset() + 1;
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)doWhileBlock, blockEnd);
                doWhileBlock.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)blockEnd, (int)blockEnd));
                --blockEnd;
            }
            FormatterJSNonBlockedWhileNode whileNode = new FormatterJSNonBlockedWhileNode((IFormatterDocument)JSFormatterNodeBuilder.this.document);
            int whileBeginOffset = JSFormatterNodeBuilder.locateCharacterSkippingWhitespaces((FormatterDocument)JSFormatterNodeBuilder.this.document, (int)(blockEnd + 1), (char)'w', (boolean)true);
            int conditionEnd = this.locateColonOrSemicolonInLine(node.getEndingOffset() + 1, JSFormatterNodeBuilder.this.document);
            whileNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)whileBeginOffset, (int)conditionEnd));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)whileNode);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)whileNode, -1);
        }

        public void visit(JSArrayNode node) {
            this.pushNodeInParentheses('[', ']', node.getStartingOffset(), node.getEndingOffset(), (JSNode)node, true, NodeTypes.TypeBracket.ARRAY_SQUARE);
        }

        public void visit(JSElementsNode node) {
            IParseNode[] children = node.getChildren();
            ArrayList<JSNode> jsChildren = new ArrayList<JSNode>(children.length);
            IParseNode[] iParseNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode child = iParseNodeArray[n2];
                jsChildren.add((JSNode)child);
                ++n2;
            }
            this.visitNodeLists(jsChildren, null, null, NodeTypes.TypePunctuation.COMMA);
        }

        public void visit(JSWhileNode node) {
            JSNode condition = (JSNode)node.getCondition();
            JSNode body = (JSNode)node.getBody();
            int declarationEndOffset = node.getStartingOffset() + 4;
            this.pushCommonDeclaration((JSNode)node, declarationEndOffset, null);
            int openParen = JSFormatterNodeBuilder.locateCharForward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)'(', (int)node.getLeftParenthesis().getStart());
            int closeParen = JSFormatterNodeBuilder.locateCharBackward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)')', (int)node.getRightParenthesis().getStart());
            FormatterJSParenthesesNode parenthesesNode = new FormatterJSParenthesesNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, NodeTypes.TypeBracket.LOOP_PARENTHESIS);
            parenthesesNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)openParen, (int)(openParen + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)parenthesesNode);
            condition.accept((JSTreeWalker)this);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parenthesesNode, -1);
            parenthesesNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)closeParen, (int)(closeParen + 1)));
            body.accept((JSTreeWalker)this);
        }

        public void visit(JSForNode node) {
            List<JSNode> initializers = Arrays.asList((JSNode)node.getInitializer());
            List<JSNode> conditions = Arrays.asList((JSNode)node.getCondition());
            List<JSNode> updaters = Arrays.asList((JSNode)node.getAdvance());
            JSNode body = (JSNode)node.getBody();
            int declarationEndOffset = node.getStartingOffset() + 2;
            this.pushCommonDeclaration((JSNode)node, declarationEndOffset, null);
            int openParen = JSFormatterNodeBuilder.locateCharForward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)'(', (int)node.getLeftParenthesis().getStart());
            int closeParen = JSFormatterNodeBuilder.locateCharBackward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)')', (int)node.getRightParenthesis().getStart());
            FormatterJSParenthesesNode parenthesesNode = new FormatterJSParenthesesNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, NodeTypes.TypeBracket.LOOP_PARENTHESIS);
            parenthesesNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)openParen, (int)(openParen + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)parenthesesNode);
            this.visitNodeLists(initializers, null, null, NodeTypes.TypePunctuation.COMMA);
            int semicolonOffset = JSFormatterNodeBuilder.locateCharForward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)';', (int)declarationEndOffset);
            this.pushTypePunctuation(NodeTypes.TypePunctuation.FOR_SEMICOLON, semicolonOffset);
            this.visitNodeLists(conditions, null, null, NodeTypes.TypePunctuation.COMMA);
            semicolonOffset = JSFormatterNodeBuilder.locateCharForward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)';', (int)(semicolonOffset + 1));
            this.pushTypePunctuation(NodeTypes.TypePunctuation.FOR_SEMICOLON, semicolonOffset);
            this.visitNodeLists(updaters, null, null, NodeTypes.TypePunctuation.COMMA);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parenthesesNode, -1);
            parenthesesNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)closeParen, (int)(closeParen + 1)));
            if (body.getNodeType() == 21 || body.getNodeType() == 0) {
                body.accept((JSTreeWalker)this);
            } else {
                this.wrapInImplicitBlock(body, true);
            }
        }

        public void visit(JSForInNode node) {
            JSNode expression = (JSNode)node.getExpression();
            JSNode initializer = (JSNode)node.getInitializer();
            JSNode body = (JSNode)node.getBody();
            int declarationEndOffset = node.getStartingOffset() + 2;
            this.pushCommonDeclaration((JSNode)node, declarationEndOffset, null);
            int openParen = JSFormatterNodeBuilder.locateCharForward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)'(', (int)node.getLeftParenthesis().getStart());
            int closeParen = JSFormatterNodeBuilder.locateCharBackward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)')', (int)node.getRightParenthesis().getStart());
            FormatterJSParenthesesNode parenthesesNode = new FormatterJSParenthesesNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, NodeTypes.TypeBracket.LOOP_PARENTHESIS);
            parenthesesNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)openParen, (int)(openParen + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)parenthesesNode);
            initializer.accept((JSTreeWalker)this);
            int inStart = node.getIn().getStart();
            this.visitTextNode(inStart, inStart + 2, true, 1, 1, false);
            expression.accept((JSTreeWalker)this);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parenthesesNode, closeParen);
            parenthesesNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)closeParen, (int)(closeParen + 1)));
            body.accept((JSTreeWalker)this);
        }

        public void visit(JSWithNode node) {
            JSNode expression = (JSNode)node.getExpression();
            JSNode body = (JSNode)node.getBody();
            int declarationEndOffset = node.getStartingOffset() + 3;
            this.pushCommonDeclaration((JSNode)node, declarationEndOffset, null);
            int openParen = JSFormatterNodeBuilder.locateCharForward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)'(', (int)node.getLeftParenthesis().getStart());
            int closeParen = JSFormatterNodeBuilder.locateCharBackward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)')', (int)node.getRightParenthesis().getStart());
            FormatterJSParenthesesNode parenthesesNode = new FormatterJSParenthesesNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, NodeTypes.TypeBracket.LOOP_PARENTHESIS);
            parenthesesNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)openParen, (int)(openParen + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)parenthesesNode);
            expression.accept((JSTreeWalker)this);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parenthesesNode, closeParen);
            parenthesesNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)closeParen, (int)(closeParen + 1)));
            body.accept((JSTreeWalker)this);
        }

        public void visit(JSStatementsNode node) {
            int startingOffset = node.getStartingOffset();
            FormatterJSBlockNode blockNode = new FormatterJSBlockNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, JSFormatterNodeBuilder.this.hasAnyCommentBefore(startingOffset));
            blockNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startingOffset, (int)(startingOffset + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)blockNode);
            this.visitChildren((JSNode)node);
            int endingOffset = node.getEndingOffset();
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)blockNode, endingOffset);
            blockNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)endingOffset, (int)(endingOffset + 1)));
        }

        public void visit(JSObjectNode node) {
            FormatterJSObjectNode objectNode = new FormatterJSObjectNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(node.getLeftBrace().getStart()));
            objectNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)node.getStartingOffset(), (int)(node.getStartingOffset() + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)objectNode);
            this.visitNodeLists(this.asJSNodesList(node.getChildren()), null, null, NodeTypes.TypePunctuation.COMMA);
            int end = node.getEndingOffset();
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)objectNode, end);
            objectNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)end, (int)(end + 1)));
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            }
        }

        public void visit(JSNameValuePairNode node) {
            IParseNode name = node.getName();
            FormatterJSNameValuePairNode nameValuePairNode = new FormatterJSNameValuePairNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (JSNode)node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(node.getStartingOffset()));
            nameValuePairNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)name.getStartingOffset(), (int)(name.getEndingOffset() + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)nameValuePairNode);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)nameValuePairNode, -1);
            Symbol colon = node.getColon();
            this.pushTypeOperator(NodeTypes.TypeOperator.KEY_VALUE_COLON, colon.getStart(), false);
            JSNode value = (JSNode)node.getValue();
            value.accept((JSTreeWalker)this);
        }

        public void visit(JSSwitchNode node) {
            int startingOffset = node.getStartingOffset();
            FormatterJSDeclarationNode switchNode = new FormatterJSDeclarationNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, true, (IParseNode)node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(startingOffset));
            switchNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startingOffset, (int)(node.getRightParenthesis().getEnd() + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)switchNode);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)switchNode, -1);
            int blockStart = node.getLeftBrace().getStart();
            FormatterJSSwitchNode blockNode = new FormatterJSSwitchNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, JSFormatterNodeBuilder.this.hasAnyCommentBefore(blockStart));
            blockNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)blockStart, (int)(blockStart + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)blockNode);
            this.visitChildren((JSNode)node, 1);
            int endingOffset = node.getEndingOffset();
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)blockNode, endingOffset);
            int end = endingOffset + 1;
            if (node.getSemicolonIncluded()) {
                end = this.locateColonOrSemicolonInLine(end, JSFormatterNodeBuilder.this.document);
            }
            blockNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)endingOffset, (int)end));
        }

        public void visit(JSCaseNode node) {
            this.visitCaseOrDefaultNode((JSNode)node, node.getColon().getStart());
        }

        public void visit(JSDefaultNode node) {
            this.visitCaseOrDefaultNode((JSNode)node, node.getColon().getStart());
        }

        public void visit(JSTryNode node) {
            IParseNode finallyBlock;
            this.visitCommonBlock((JSNode)node, node.getStartingOffset() + 2, node.getBody());
            IParseNode catchBlock = node.getCatchBlock();
            if (catchBlock.getNodeType() == 66) {
                this.visit((JSCatchNode)catchBlock);
            }
            if ((finallyBlock = node.getFinallyBlock()).getNodeType() == 67) {
                this.visit((JSFinallyNode)finallyBlock);
            }
        }

        public void visit(JSCatchNode node) {
            int declarationEndOffset = node.getIdentifier().getEndingOffset() + 1;
            declarationEndOffset = JSFormatterNodeBuilder.locateCharacterSkippingWhitespaces((FormatterDocument)JSFormatterNodeBuilder.this.document, (int)declarationEndOffset, (char)')', (boolean)false);
            this.visitCommonBlock((JSNode)node, declarationEndOffset, node.getBody());
        }

        public void visit(JSFinallyNode node) {
            this.visitCommonBlock((JSNode)node, node.getStartingOffset() + 6, node.getBlock());
        }

        public void visit(JSVarNode node) {
            int startingOffset = node.getStartingOffset();
            FormatterJSDeclarationNode var = new FormatterJSDeclarationNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, false, (IParseNode)node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(startingOffset));
            var.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startingOffset, (int)(startingOffset + 3)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)var);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)var, -1);
            if (node.getChildCount() > 1) {
                List<JSNode> jsChildren = this.asJSNodesList(node.getChildren());
                this.visitNodeLists(jsChildren, null, null, NodeTypes.TypePunctuation.COMMA);
            } else {
                this.visitChildren((JSNode)node);
            }
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEnd(), false, true);
            }
        }

        public void visit(JSDeclarationNode node) {
            if (node.getEqualSign() != null) {
                this.visitLeftRightExpression((JSNode)node, (JSNode)node.getIdentifier(), (JSNode)node.getValue(), node.getEqualSign().value.toString());
            } else {
                this.pushCommonDeclaration((JSNode)node, node.getEndingOffset(), null);
            }
        }

        public void visit(JSAssignmentNode node) {
            this.visitLeftRightExpression((JSNode)node, (JSNode)node.getLeftHandSide(), (JSNode)node.getRightHandSide(), node.getOperator().value.toString());
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEnd(), false, true);
            }
        }

        public void visit(JSIdentifierNode node) {
            int startingOffset = node.getStartingOffset();
            FormatterJSIdentifierNode identifierNode = new FormatterJSIdentifierNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (JSNode)node, JSFormatterNodeBuilder.this.hasSingleCommentBefore(startingOffset));
            identifierNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startingOffset, (int)(node.getEndingOffset() + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)identifierNode);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)identifierNode, -1);
        }

        public void visit(JSConstructNode node) {
            int start;
            IParseNode expression = node.getExpression();
            IParseNode argumentsNode = node.getArguments();
            List<JSNode> arguments = this.asJSNodesList(argumentsNode.getChildren());
            this.visitTextNode(start, start + 3, !JSFormatterNodeBuilder.this.hasAnyCommentBefore(start = node.getStartingOffset()), 0, 0, node.getSemicolonIncluded());
            this.visitTextNode(expression, true, 1);
            int argumentsStartOffset = argumentsNode.getStartingOffset();
            if (!arguments.isEmpty() || JSFormatterNodeBuilder.this.document.getLength() > argumentsStartOffset && JSFormatterNodeBuilder.this.document.charAt(argumentsStartOffset) == '(') {
                this.pushParametersInParentheses(argumentsNode.getStartingOffset(), argumentsNode.getEndingOffset(), arguments, NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.DECLARATION_PARENTHESIS);
            }
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            }
        }

        public void visit(JSBinaryArithmeticOperatorNode node) {
            this.visitLeftRightExpression((JSNode)node, (JSNode)node.getLeftHandSide(), (JSNode)node.getRightHandSide(), node.getOperator().value.toString());
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            }
        }

        public void visit(JSArgumentsNode node) {
            this.pushParametersInParentheses(node.getStartingOffset(), node.getEndingOffset() + 1, this.asJSNodesList(node.getChildren()), NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.DECLARATION_PARENTHESIS);
        }

        public void visit(JSBinaryBooleanOperatorNode node) {
            FormatterJSExpressionWrapperNode wrapperNode = new FormatterJSExpressionWrapperNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (JSNode)node, JSFormatterNodeBuilder.this.hasSingleCommentBefore(node.getStartingOffset()));
            int startingOffset = node.getStartingOffset();
            wrapperNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startingOffset, (int)node.getStartingOffset()));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)wrapperNode);
            this.visitLeftRightExpression((JSNode)node, (JSNode)node.getLeftHandSide(), (JSNode)node.getRightHandSide(), node.getOperator().value.toString());
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            }
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)wrapperNode, -1);
            IFormatterContainerNode topNode = JSFormatterNodeBuilder.this.peek();
            int endingOffset = topNode.getEndOffset();
            wrapperNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)endingOffset, (int)endingOffset));
        }

        public void visit(JSContinueNode node) {
            if (node.getSemicolonIncluded()) {
                FormatterJSDefaultLineNode lineNode = this.pushLineNode((JSNode)node);
                int startingOffset = node.getStartingOffset();
                this.visitTextNode(startingOffset, startingOffset + 8, true, 0, 0, false);
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)lineNode, lineNode.getEndOffset());
            } else {
                super.visit(node);
            }
        }

        public void visit(JSCommaNode node) {
            FormatterJSExpressionWrapperNode wrapperNode = new FormatterJSExpressionWrapperNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (JSNode)node, JSFormatterNodeBuilder.this.hasSingleCommentBefore(node.getStartingOffset()));
            int startingOffset = node.getStartingOffset();
            wrapperNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startingOffset, (int)node.getStartingOffset()));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)wrapperNode);
            this.visitNodeLists(this.asJSNodesList(node.getChildren()), null, null, NodeTypes.TypePunctuation.COMMA);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)wrapperNode, -1);
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            }
            int endingOffset = JSFormatterNodeBuilder.this.peek().getEndOffset();
            wrapperNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)endingOffset, (int)endingOffset));
        }

        public void visit(JSInvokeNode node) {
            JSNode functionName = (JSNode)node.getExpression();
            short nodeType = functionName.getNodeType();
            if (nodeType == 58 || nodeType == 70 || nodeType == 48) {
                FormatterJSFunctionInvocationNode fin = new FormatterJSFunctionInvocationNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (JSNode)node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(node.getStartingOffset()));
                fin.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)functionName.getStart(), (int)functionName.getStart()));
                JSFormatterNodeBuilder.this.push((IFormatterContainerNode)fin);
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)fin, -1);
                functionName.accept((JSTreeWalker)this);
            } else {
                this.pushFunctionInvocationName((JSNode)node, functionName.getStart(), functionName.getEnd() + 1);
            }
            List<JSNode> parameters = this.asJSNodesList(node.getArguments().getChildren());
            this.pushParametersInParentheses(functionName.getEnd() + 1, node.getEndingOffset(), parameters, NodeTypes.TypePunctuation.COMMA, false, NodeTypes.TypeBracket.INVOCATION_PARENTHESIS);
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            }
        }

        public void visit(JSReturnNode node) {
            if (node.getSemicolonIncluded()) {
                FormatterJSDefaultLineNode lineNode = this.pushLineNode((JSNode)node);
                int startingOffset = node.getStartingOffset();
                if (node.getChildCount() > 0 && node.getChild(0).getNodeType() != 0) {
                    this.visitTextNode(startingOffset, startingOffset + 6, true, 0, 1, false);
                    this.visitChildren((JSNode)node);
                } else {
                    this.visitTextNode(startingOffset, startingOffset + 6, true, 0, 0, false);
                }
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)lineNode, lineNode.getEndOffset());
            } else {
                super.visit(node);
            }
        }

        public void visit(JSThrowNode node) {
            if (node.getSemicolonIncluded()) {
                FormatterJSDefaultLineNode lineNode = this.pushLineNode((JSNode)node);
                int startingOffset = node.getStartingOffset();
                this.visitTextNode(startingOffset, startingOffset + 5, true, 0, 1, false);
                this.visitChildren((JSNode)node);
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)lineNode, lineNode.getEndOffset());
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            } else {
                super.visit(node);
            }
        }

        public void visit(JSBreakNode node) {
            if (node.getSemicolonIncluded()) {
                FormatterJSDefaultLineNode lineNode = this.pushLineNode((JSNode)node);
                int startingOffset = node.getStartingOffset();
                this.visitTextNode(startingOffset, startingOffset + 5, true, 0, 0, false);
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)lineNode, lineNode.getEndOffset());
            } else {
                super.visit(node);
            }
        }

        public void visit(JSGroupNode node) {
            int beginOffset = node.getLeftParenthesis().getStart();
            int endOffset = node.getRightParenthesis().getStart();
            FormatterJSGroupNode groupNode = new FormatterJSGroupNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, JSFormatterNodeBuilder.this.hasAnyCommentBefore(node.getStartingOffset()));
            groupNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)beginOffset, (int)(beginOffset + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)groupNode);
            this.visitChildren((JSNode)node);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)groupNode, endOffset);
            groupNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)endOffset, (int)(endOffset + 1)));
            if (node.getSemicolonIncluded()) {
                this.findAndPushPunctuationNode(NodeTypes.TypePunctuation.SEMICOLON, node.getEndingOffset(), false, true);
            }
        }

        public void visit(JSGetElementNode node) {
            JSNode leftHandSide = (JSNode)node.getLeftHandSide();
            FormatterJSGetElementNode getElementNode = new FormatterJSGetElementNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (JSNode)node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(node.getStartingOffset()));
            getElementNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)node.getStartingOffset(), (int)leftHandSide.getEndingOffset()));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)getElementNode);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)getElementNode, -1);
            int leftBracketOffset = node.getLeftBracket().getStart();
            int rightBracketOffset = node.getRightBracket().getStart();
            JSNode rightHandSide = (JSNode)node.getRightHandSide();
            this.pushNodeInParentheses('[', ']', leftBracketOffset, rightBracketOffset, rightHandSide, false, NodeTypes.TypeBracket.ARRAY_SQUARE);
        }

        public void visit(JSGetPropertyNode node) {
            int startingOffset = node.getStartingOffset();
            FormatterJSGetPropertyNode getElementNode = new FormatterJSGetPropertyNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (JSNode)node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(startingOffset));
            getElementNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startingOffset, (int)startingOffset));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)getElementNode);
            JSNode leftHandSide = (JSNode)node.getLeftHandSide();
            JSNode rightHandSide = (JSNode)node.getRightHandSide();
            Symbol operator = node.getOperator();
            if (leftHandSide != null) {
                leftHandSide.accept((JSTreeWalker)this);
            }
            this.pushTypePunctuation(NodeTypes.TypePunctuation.JS_DOT_PROPERTY, operator.getStart());
            if (rightHandSide != null) {
                rightHandSide.accept((JSTreeWalker)this);
            }
            int endingOffset = node.getEndingOffset() + 1;
            getElementNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)endingOffset, (int)endingOffset));
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)getElementNode, endingOffset);
        }

        public void visit(JSNumberNode node) {
            this.visitTextNode((IParseNode)node, true, 0);
        }

        public void visit(JSStringNode node) {
            this.visitTextNode((IParseNode)node, true, 0);
        }

        public void visit(JSNullNode node) {
            this.visitTextNode((IParseNode)node, true, 0);
        }

        public void visit(JSThisNode node) {
            this.visitTextNode((IParseNode)node, true, 0);
        }

        public void visit(JSRegexNode node) {
            this.visitTextNode((IParseNode)node, true, 0);
        }

        private FormatterJSDefaultLineNode pushLineNode(JSNode node) {
            FormatterJSDefaultLineNode lineNode = new FormatterJSDefaultLineNode((IFormatterDocument)JSFormatterNodeBuilder.this.document);
            lineNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)node.getStartingOffset(), (int)node.getStartingOffset()));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)lineNode);
            return lineNode;
        }

        private void pushNodeInParentheses(char openChar, char closeChar, int parenLookupStart, int parenLookupEnd, JSNode node, boolean visitOnlyChildren, NodeTypes.TypeBracket type) {
            int openParen = JSFormatterNodeBuilder.locateCharForward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)openChar, (int)parenLookupStart);
            int closeParen = JSFormatterNodeBuilder.locateCharBackward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)closeChar, (int)parenLookupEnd);
            FormatterJSParenthesesNode parenthesesNode = new FormatterJSParenthesesNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, false, JSFormatterNodeBuilder.this.hasSingleCommentBefore(openParen), JSFormatterNodeBuilder.this.hasSingleCommentBefore(closeParen), type);
            parenthesesNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)openParen, (int)(openParen + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)parenthesesNode);
            if (node != null) {
                if (visitOnlyChildren) {
                    this.visitChildren(node);
                } else {
                    node.accept((JSTreeWalker)this);
                }
            }
            if (JSFormatterNodeBuilder.this.hasAnyCommentBefore(closeParen)) {
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parenthesesNode, closeParen);
            } else {
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parenthesesNode, -1);
            }
            parenthesesNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)closeParen, (int)(closeParen + 1)));
        }

        private void visitNodeLists(List<? extends JSNode> leftNodes, List<? extends JSNode> rightNodes, NodeTypes.TypeOperator pairsOperator, NodeTypes.TypePunctuation pairsSeparator) {
            int leftSize = leftNodes.size();
            int i = 0;
            while (i < leftSize) {
                String text;
                int startIndex;
                JSNode left = leftNodes.get(i);
                JSNode right = rightNodes != null ? rightNodes.get(i) : null;
                left.accept((JSTreeWalker)this);
                if (right != null && pairsOperator != null) {
                    startIndex = left.getEnd();
                    text = JSFormatterNodeBuilder.this.document.get(startIndex, right.getStart());
                    String typeStr = pairsOperator.toString();
                    this.pushTypeOperator(pairsOperator, startIndex += text.indexOf(typeStr), false);
                    right.accept((JSTreeWalker)this);
                }
                if (i + 1 < leftSize) {
                    startIndex = left.getEnd() + 1;
                    text = JSFormatterNodeBuilder.this.document.get(startIndex, leftNodes.get(i + 1).getStart());
                    String separatorStr = pairsSeparator.toString();
                    this.pushTypePunctuation(pairsSeparator, startIndex += text.indexOf(separatorStr));
                }
                ++i;
            }
        }

        private void pushTypeOperator(NodeTypes.TypeOperator operator, int startOffset, boolean isUnary) {
            FormatterJSOperatorNode node = new FormatterJSOperatorNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, operator, isUnary, JSFormatterNodeBuilder.this.hasSingleCommentBefore(startOffset));
            node.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startOffset, (int)(startOffset + operator.toString().length())));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)node);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)node, -1);
        }

        private void pushTypePunctuation(NodeTypes.TypePunctuation punctuation, int startOffset) {
            FormatterJSPunctuationNode node = new FormatterJSPunctuationNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, punctuation, false, JSFormatterNodeBuilder.this.hasSingleCommentBefore(startOffset));
            node.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startOffset, (int)(startOffset + punctuation.toString().length())));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)node);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)node, -1);
        }

        private void pushParametersInParentheses(int declarationEndOffset, int expressionEndOffset, List<? extends JSNode> parameters, NodeTypes.TypePunctuation punctuationType, boolean lookForExtraComma, NodeTypes.TypeBracket bracketsType) {
            FormatterJSParenthesesNode parenthesesNode = null;
            int openParen = JSFormatterNodeBuilder.this.getNextNonWhiteCharOffset(JSFormatterNodeBuilder.this.document, declarationEndOffset);
            if (JSFormatterNodeBuilder.this.document.charAt(openParen) == '(') {
                parenthesesNode = new FormatterJSParenthesesNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, bracketsType);
                parenthesesNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)openParen, (int)(openParen + 1)));
            } else {
                parenthesesNode = new FormatterJSParenthesesNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, true);
                parenthesesNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)openParen, (int)openParen));
            }
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)parenthesesNode);
            if (parameters != null && parameters.size() > 0) {
                this.visitNodeLists(parameters, null, null, punctuationType);
                if (lookForExtraComma) {
                    int lastParamEnd = parameters.get(parameters.size() - 1).getEnd();
                    int nextNonWhitespace = JSFormatterNodeBuilder.this.getNextNonWhiteCharOffset(JSFormatterNodeBuilder.this.document, lastParamEnd);
                    if (JSFormatterNodeBuilder.this.document.charAt(nextNonWhitespace) == ',') {
                        this.pushTypePunctuation(punctuationType, nextNonWhitespace);
                    }
                }
            }
            int closeParenStart = expressionEndOffset;
            int closeParenEnd = expressionEndOffset;
            if (!parenthesesNode.isAsWrapper()) {
                closeParenStart = JSFormatterNodeBuilder.locateCharBackward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)')', (int)expressionEndOffset);
                closeParenEnd = closeParenStart + 1;
            }
            int popCheckOffset = -1;
            if (JSFormatterNodeBuilder.this.hasSingleCommentBefore(openParen)) {
                parenthesesNode.setHasCommentBeforeOpen(true);
            }
            if (JSFormatterNodeBuilder.this.hasSingleCommentBefore(closeParenStart)) {
                parenthesesNode.setHasCommentBeforeClose(true);
                popCheckOffset = closeParenStart;
            }
            if (JSFormatterNodeBuilder.this.hasMultiLineCommentBefore(closeParenStart)) {
                popCheckOffset = closeParenStart;
            }
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)parenthesesNode, popCheckOffset);
            parenthesesNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)closeParenStart, (int)closeParenEnd));
        }

        private void findAndPushPunctuationNode(NodeTypes.TypePunctuation type, int offsetToSearch, boolean ignoreNonWhitespace, boolean isLineTerminating) {
            char punctuationType = type.toString().charAt(0);
            int punctuationOffset = JSFormatterNodeBuilder.locateCharForward((FormatterDocument)JSFormatterNodeBuilder.this.document, (char)punctuationType, (int)offsetToSearch);
            if (punctuationOffset != offsetToSearch || JSFormatterNodeBuilder.this.document.charAt(punctuationOffset) == punctuationType) {
                String segment = JSFormatterNodeBuilder.this.document.get(offsetToSearch, punctuationOffset);
                if (!ignoreNonWhitespace && segment.trim().length() > 0) {
                    return;
                }
                if (isLineTerminating) {
                    int lineEnd = this.locateWhitespaceLineEndingOffset(punctuationOffset + 1);
                    isLineTerminating = lineEnd < 0;
                }
                FormatterJSPunctuationNode punctuationNode = new FormatterJSPunctuationNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, type, isLineTerminating, JSFormatterNodeBuilder.this.hasSingleCommentBefore(punctuationOffset));
                punctuationNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)punctuationOffset, (int)(punctuationOffset + 1)));
                JSFormatterNodeBuilder.this.push((IFormatterContainerNode)punctuationNode);
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)punctuationNode, -1);
            }
        }

        private void visitCaseOrDefaultNode(JSNode node, int colonOffset) {
            boolean hasBlockedChild = false;
            JSNode lastChild = null;
            if (node.getChildCount() > 0) {
                lastChild = (JSNode)node.getLastChild();
                while (lastChild.getNodeType() == 0 && lastChild.getSemicolonIncluded()) {
                    lastChild = (JSNode)lastChild.getPreviousSibling();
                }
                if (lastChild != null && lastChild.getNodeType() == 21) {
                    hasBlockedChild = true;
                }
            }
            FormatterJSCaseNode caseNode = new FormatterJSCaseNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, hasBlockedChild);
            caseNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)node.getStartingOffset(), (int)(colonOffset + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)caseNode);
            if (hasBlockedChild) {
                FormatterJSCaseBodyNode caseBodyNode = new FormatterJSCaseBodyNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, JSFormatterNodeBuilder.this.hasAnyCommentBefore(lastChild.getStartingOffset()));
                caseBodyNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)lastChild.getStartingOffset(), (int)(lastChild.getStartingOffset() + 1)));
                JSFormatterNodeBuilder.this.push((IFormatterContainerNode)caseBodyNode);
                if (node.getNodeType() == 83) {
                    this.visitChildren(lastChild);
                } else {
                    this.visitChildren(node);
                }
                int endingOffset = lastChild.getEndingOffset();
                JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)caseBodyNode, endingOffset);
                int end = this.locateColonOrSemicolonInLine(endingOffset + 1, JSFormatterNodeBuilder.this.document);
                caseBodyNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)endingOffset, (int)end));
            } else if (node.getNodeType() == 83) {
                this.visitChildren(node, 1);
            } else {
                this.visitChildren(node);
            }
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)caseNode, node.getEndingOffset() + 1);
        }

        private void pushBlockNode(JSNode block, boolean consumeEndingSemicolon) {
            FormatterJSBlockNode bodyNode = new FormatterJSBlockNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, JSFormatterNodeBuilder.this.hasAnyCommentBefore(block.getStartingOffset()));
            bodyNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)block.getStartingOffset(), (int)(block.getStartingOffset() + 1)));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)bodyNode);
            this.visitChildren(block);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)bodyNode, block.getEndingOffset());
            int end = block.getEndingOffset() + 1;
            if (consumeEndingSemicolon) {
                end = this.locateColonOrSemicolonInLine(end, JSFormatterNodeBuilder.this.document);
            }
            bodyNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)block.getEndingOffset(), (int)end));
        }

        private void visitCommonBlock(JSNode node, int declarationEndOffset, IParseNode body) {
            boolean hasBody;
            this.pushCommonDeclaration(node, declarationEndOffset, body);
            boolean bl = hasBody = body.getNodeType() != 0;
            if (hasBody) {
                boolean bodyInBrackets;
                FormatterJSBlockNode blockNode = new FormatterJSBlockNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, JSFormatterNodeBuilder.this.hasAnyCommentBefore(body.getStartingOffset()));
                boolean bl2 = bodyInBrackets = body.getNodeType() == 21;
                if (bodyInBrackets) {
                    blockNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)body.getStartingOffset(), (int)(body.getStartingOffset() + 1)));
                    JSFormatterNodeBuilder.this.push((IFormatterContainerNode)blockNode);
                    this.visitChildren((JSNode)body);
                    JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)blockNode, body.getEndingOffset());
                    int end = blockNode.getEndOffset() + 1;
                    blockNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)body.getEndingOffset(), (int)end));
                } else {
                    blockNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)body.getStartingOffset(), (int)body.getStartingOffset()));
                    JSFormatterNodeBuilder.this.push((IFormatterContainerNode)blockNode);
                    this.visitChildren((JSNode)body);
                    int blockEnd = this.locateColonOrSemicolonInLine(body.getEndingOffset(), JSFormatterNodeBuilder.this.document);
                    JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)blockNode, blockEnd);
                    blockNode.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)blockEnd, (int)blockEnd));
                }
            }
        }

        private void wrapInImplicitBlock(JSNode node, boolean indent) {
            FormatterJSImplicitBlockNode emptyBlock = new FormatterJSImplicitBlockNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, false, indent, 0);
            int start = node.getStartingOffset();
            int end = node.getEndingOffset() + 1;
            emptyBlock.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)start, (int)start));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)emptyBlock);
            node.accept((JSTreeWalker)this);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)emptyBlock, -1);
            emptyBlock.setEnd(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)end, (int)end));
        }

        private void pushCommonDeclaration(JSNode node, int declarationEndOffset, IParseNode body) {
            FormatterJSDeclarationNode declarationNode = new FormatterJSDeclarationNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, body != null && body.getNodeType() == 21, (IParseNode)node, JSFormatterNodeBuilder.this.hasAnyCommentBefore(node.getStartingOffset()));
            int endDeclarationOffset = declarationEndOffset + 1;
            if (body != null) {
                endDeclarationOffset = body.getNodeType() != 0 ? declarationEndOffset + 1 : body.getEndingOffset() + 1;
            }
            declarationNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)node.getStartingOffset(), (int)endDeclarationOffset));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)declarationNode);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)declarationNode, -1);
        }

        private void visitLeftRightExpression(JSNode parentNode, JSNode left, JSNode right, String operatorString) {
            int leftOffset;
            if (left != null) {
                left.accept((JSTreeWalker)this);
                leftOffset = left.getEnd();
            } else {
                leftOffset = parentNode.getStart();
            }
            int rightOffset = right != null ? right.getStart() : parentNode.getEnd();
            int operatorOffset = JSFormatterNodeBuilder.this.document.get(leftOffset, rightOffset).indexOf(operatorString) + leftOffset;
            NodeTypes.TypeOperator typeOperator = NodeTypes.TypeOperator.getTypeOperator((String)operatorString);
            this.pushTypeOperator(typeOperator, operatorOffset, false);
            if (right != null) {
                right.accept((JSTreeWalker)this);
            }
        }

        private void visitTextNode(IParseNode node, boolean consumePreviousWhitespaces, int spacesCountBefore) {
            this.visitTextNode(node.getStartingOffset(), node.getEndingOffset() + 1, consumePreviousWhitespaces, spacesCountBefore);
        }

        private void visitTextNode(int startOffset, int endOffset, boolean consumePreviousWhitespaces, int spacesCountBefore) {
            this.visitTextNode(startOffset, endOffset, consumePreviousWhitespaces, spacesCountBefore, 0, false);
        }

        private void visitTextNode(int startOffset, int endOffset, boolean consumePreviousWhitespaces, int spacesCountBefore, int spacesCountAfter, boolean isAddingBeginLine) {
            FormatterJSTextNode textNode = new FormatterJSTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, consumePreviousWhitespaces, spacesCountBefore, spacesCountAfter, isAddingBeginLine |= JSFormatterNodeBuilder.this.hasSingleCommentBefore(startOffset));
            textNode.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)startOffset, (int)endOffset));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)textNode);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)textNode, endOffset);
        }

        private void pushFunctionInvocationName(JSNode invocationNode, int nameStart, int nameEnd) {
            FormatterJSFunctionInvocationNode node = new FormatterJSFunctionInvocationNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, invocationNode, JSFormatterNodeBuilder.this.hasAnyCommentBefore(invocationNode.getStartingOffset()));
            node.setBegin(JSFormatterNodeBuilder.createTextNode((IFormatterDocument)JSFormatterNodeBuilder.this.document, (int)nameStart, (int)nameEnd));
            JSFormatterNodeBuilder.this.push((IFormatterContainerNode)node);
            JSFormatterNodeBuilder.this.checkedPop((IFormatterContainerNode)node, -1);
        }

        private int locateColonOrSemicolonInLine(int offset, FormatterDocument document) {
            int i = offset;
            int size = document.getLength();
            while (i < size) {
                char c = document.charAt(i);
                if (c == ';' || c == ',') {
                    return i + 1;
                }
                if (c == '\n' || c == '\r' || c != ' ' || c != '\t') break;
                ++i;
            }
            return offset;
        }

        private int locateWhitespaceLineEndingOffset(int start) {
            int length = JSFormatterNodeBuilder.this.document.getLength();
            int offset = start;
            while (offset < length) {
                char c = JSFormatterNodeBuilder.this.document.charAt(offset);
                if (c == '\n' || c == '\r') {
                    return offset;
                }
                if (!Character.isWhitespace(c)) {
                    return -1;
                }
                ++offset;
            }
            return -1;
        }

        private List<JSNode> asJSNodesList(IParseNode[] nodes) {
            ArrayList<JSNode> jsChildren = new ArrayList<JSNode>(nodes.length);
            IParseNode[] iParseNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNode child = iParseNodeArray[n2];
                if (child instanceof JSNode) {
                    jsChildren.add((JSNode)child);
                } else {
                    IdeLog.logError((Plugin)JSFormatterPlugin.getDefault(), (String)MessageFormat.format("Expected JSFormatter and got {0}", child.getClass().getName()), (String)"com.aptana.formatter.epl/debug");
                }
                ++n2;
            }
            return jsChildren;
        }

        private void visitChildren(JSNode node, int skip) {
            for (IParseNode child : node) {
                if (skip > 0) {
                    --skip;
                    continue;
                }
                if (!(child instanceof JSNode)) continue;
                ((JSNode)child).accept((JSTreeWalker)this);
            }
        }
    }
}

