/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.proxy;

import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;

public abstract class SocksProxySocket
extends Socket
implements StreamSocket {
    protected static final int CONNECT = 1;
    protected static final int BIND = 2;
    protected static final int NULL_TERMINATION = 0;
    protected InputStream proxyIn;
    protected OutputStream proxyOut;
    protected String providerDetail;
    protected String proxyHost;
    protected int proxyPort;
    protected String username = "";
    protected String password = "";
    protected String bindingAddress;
    protected int bindingPort = 0;
    protected String remoteHostname;

    public boolean isSecureMode() {
        return false;
    }

    public String getRemoteHost() {
        return this.remoteHostname;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHostname = remoteHost;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getBindingAddress() {
        return this.bindingAddress;
    }

    public int getBindingPort() {
        return this.bindingPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDetail() {
        return this.providerDetail;
    }

    public String toString() {
        return "SocksProxySocket[addr=" + this.getInetAddress() + ",port=" + this.getPort() + ",localport=" + this.getLocalPort() + "]";
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        super.connect(endpoint, timeout);
        this.proxyIn = this.getInputStream();
        this.proxyOut = this.getOutputStream();
    }

    public void bind(String remoteHost) throws IOException {
        this.sendRequest(2, remoteHost, 0);
        this.readResponse();
    }

    public void accept() throws IOException {
        this.readResponse();
    }

    protected abstract void sendRequest(int var1, String var2, int var3) throws IOException;

    protected abstract void readResponse() throws IOException;
}

