/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.license;

import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.license.EDTProduct;
import com.enterprisedt.util.license.License;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class LicensePropertiesBase {
    private static Logger c = Logger.getLogger("LicensePropertiesBase");
    public static final String cvsId = "@(#)$Id: LicensePropertiesBase.java,v 1.6 2009-06-24 05:17:27 bruceb Exp $";
    final SimpleDateFormat a = new SimpleDateFormat("dd MMM yyyy");
    protected String key;
    protected String owner;
    protected EDTProduct product;
    protected String productStr;
    protected boolean isTrial = true;
    protected Date expiryDate;
    protected boolean[] flags;
    static Class b;

    public boolean isTrial() {
        return this.isTrial;
    }

    public String getKey() {
        return this.key;
    }

    public String getOwner() {
        return this.owner;
    }

    public EDTProduct getProduct() {
        return this.product;
    }

    public String getProductStr() {
        return this.productStr;
    }

    public boolean[] getFlags() {
        return this.flags;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void checkLicence(EDTProduct[] expected) {
        boolean bl = false;
        for (int i2 = 0; i2 < expected.length; ++i2) {
            if (!expected[i2].equals(this.product)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            String string = "Invalid license. This license is for " + this.product != null ? this.product.toString() : "null";
            c.error(string);
            throw new RuntimeException(string);
        }
        String string = this.a.format(this.expiryDate);
        if (!this.expiryDate.after(new Date())) {
            String string2 = "The licence has expired. Expiry date: " + string;
            c.error(string2);
            throw new RuntimeException(string2);
        }
        c.info("Licence expiry date: " + string);
        c.info(this.isTrial ? "Trial licence" : "Production licence");
    }

    public String getExpiryDateStr() {
        return this.a.format(this.expiryDate);
    }

    static String a(Properties properties, String string) {
        String string2 = System.getProperty(string);
        if (string2 == null && properties != null) {
            string2 = properties.getProperty(string);
        }
        return string2;
    }

    static Properties a(String string) throws FileNotFoundException {
        return LicensePropertiesBase.a(new FileInputStream(string));
    }

    static Properties a() {
        String string = License.getOwner();
        String string2 = License.getKey();
        String string3 = License.getProduct();
        if (string == null || string2 == null || string3 == null) {
            string2 = System.getProperty("license.key");
            string3 = System.getProperty("license.product");
            string = System.getProperty("license.owner");
            if (string == null || string2 == null || string3 == null) {
                return LicensePropertiesBase.a((b == null ? (b = LicensePropertiesBase.class$("com.enterprisedt.util.license.LicensePropertiesBase")) : b).getResourceAsStream("/edtlicense.properties"));
            }
        }
        Properties properties = new Properties();
        properties.setProperty("license.owner", string);
        properties.setProperty("license.key", string2);
        properties.setProperty("license.product", string3);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static Properties a(InputStream inputStream) {
        Properties properties;
        block15: {
            if (inputStream == null) {
                c.warn("Failed to read properties file edtlicense.properties");
                return null;
            }
            properties = new Properties();
            properties.load(inputStream);
            Object var4_2 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block15;
            }
            catch (IOException iOException) {}
            break block15;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    c.error("Failed to find properties file: edtlicense.properties");
                    Object var4_3 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
                catch (IOException iOException) {
                    c.error("Could not read properties file: edtlicense.properties");
                    Object var4_4 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return properties;
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

