/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.license;

import com.enterprisedt.util.license.LicensePaddingScheme;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import xjava.security.IllegalBlockSizeException;
import xjava.security.InvalidParameterTypeException;
import xjava.security.NoSuchParameterException;
import xjava.security.Parameterized;

public abstract class LicenseCipher
implements Parameterized {
    public static final int UNINITIALIZED = 0;
    public static final int ENCRYPT = 1;
    public static final int DECRYPT = 2;
    private boolean a;
    private byte[] b;
    private int c;
    private int d;
    private int e;
    private String f;
    private String g;
    private String h;
    private String i;
    private LicensePaddingScheme j;
    private boolean k;
    private int l;

    protected LicenseCipher() {
    }

    protected LicenseCipher(boolean implBuffering, boolean implPadding, String provider) {
        if (implPadding) {
            throw new IllegalArgumentException("IJCE does not support ciphers for which implPadding == true");
        }
        this.a = implBuffering;
        this.f = provider;
    }

    protected LicenseCipher(boolean implBuffering, String provider, String algorithm) {
        this.a = implBuffering;
        this.f = provider;
        this.a(algorithm);
    }

    private void a(String string) {
        int n2 = string.indexOf(47);
        if (n2 == -1) {
            this.g = string;
        } else {
            this.g = string.substring(0, n2);
            int n3 = string.indexOf(47, n2 + 1);
            if (n3 == -1) {
                this.h = string.substring(n2 + 1);
            } else {
                this.h = string.substring(n2 + 1, n3);
                this.i = string.substring(n3 + 1);
            }
        }
    }

    protected final LicensePaddingScheme getPaddingScheme() {
        return this.j;
    }

    public final int getState() {
        return this.l;
    }

    public final String getAlgorithm() {
        return this.g;
    }

    public final String getMode() {
        return this.h == null ? "ECB" : this.h;
    }

    public final String getPadding() {
        return this.i == null ? "NONE" : this.i;
    }

    public final String getProvider() {
        return this.f;
    }

    public final boolean isPaddingBlockLicenseCipher() {
        return this.getPlaintextBlockSize() > 1 && this.getPaddingScheme() != null;
    }

    public final int outBufferSize(int inLen) {
        return this.a(inLen, false);
    }

    public final int outBufferSizeFinal(int inLen) {
        return this.a(inLen, true);
    }

    public final int inBufferSize(int outLen) {
        return this.b(outLen, false);
    }

    public final int inBufferSizeFinal(int outLen) {
        return this.b(outLen, true);
    }

    public final int blockSize() {
        int n2 = this.enginePlaintextBlockSize();
        if (n2 != this.engineCiphertextBlockSize()) {
            throw new IllegalBlockSizeException("blockSize() called when plaintext and ciphertext block sizes differ");
        }
        return n2;
    }

    public final int getInputBlockSize() {
        switch (this.getState()) {
            case 1: {
                return this.enginePlaintextBlockSize();
            }
            case 2: {
                return this.engineCiphertextBlockSize();
            }
        }
        throw new Error("cipher uninitialized");
    }

    public final int getOutputBlockSize() {
        switch (this.getState()) {
            case 1: {
                return this.engineCiphertextBlockSize();
            }
            case 2: {
                return this.enginePlaintextBlockSize();
            }
        }
        throw new Error("cipher uninitialized");
    }

    public final int getPlaintextBlockSize() {
        return this.enginePlaintextBlockSize();
    }

    public final int getCiphertextBlockSize() {
        return this.engineCiphertextBlockSize();
    }

    public final void initEncrypt(Key key) throws KeyException {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.engineInitEncrypt(key);
        this.l = 1;
        this.d = this.enginePlaintextBlockSize();
        this.e = this.engineCiphertextBlockSize();
        if (this.d < 1 || this.e < 1) {
            this.l = 0;
            throw new Error("input or output block size < 1");
        }
        this.b = !this.a && this.d > 1 ? new byte[this.d] : null;
        this.c = 0;
        if (this.j != null) {
            this.j.engineSetBlockSize(this.d);
        }
    }

    public final void initDecrypt(Key key) throws KeyException {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.engineInitDecrypt(key);
        this.l = 2;
        this.d = this.engineCiphertextBlockSize();
        this.e = this.enginePlaintextBlockSize();
        if (this.d < 1 || this.e < 1) {
            this.l = 0;
            throw new Error("input or output block size < 1");
        }
        this.b = !this.a && this.d > 1 ? new byte[this.d] : null;
        this.c = 0;
        if (this.j != null) {
            this.j.engineSetBlockSize(this.e);
        }
    }

    public final byte[] update(byte[] in) {
        return this.update(in, 0, in.length);
    }

    public final byte[] update(byte[] in, int offset, int length) {
        byte[] byArray = new byte[this.a(length, false)];
        int n2 = this.a(in, offset, length, byArray, 0, false);
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public final int update(byte[] in, int inOffset, int inLen, byte[] out) {
        return this.a(in, inOffset, inLen, out, 0, false);
    }

    public final int update(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) {
        return this.a(in, inOffset, inLen, out, outOffset, false);
    }

    public final byte[] crypt(byte[] in) throws IllegalBlockSizeException {
        return this.crypt(in, 0, in.length);
    }

    public final byte[] crypt(byte[] in, int offset, int length) throws IllegalBlockSizeException {
        byte[] byArray = new byte[this.a(length, true)];
        int n2 = this.a(in, offset, length, byArray, 0, true);
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return byArray;
    }

    public final int crypt(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws IllegalBlockSizeException {
        return this.a(in, inOffset, inLen, out, outOffset, true);
    }

    public final byte[] doFinal(byte[] in) throws IllegalBlockSizeException {
        return this.crypt(in, 0, in.length);
    }

    public final byte[] doFinal(byte[] in, int offset, int length) throws IllegalBlockSizeException {
        return this.crypt(in, offset, length);
    }

    public final int doFinal(byte[] in, int inOffset, int inLen, byte[] out) throws IllegalBlockSizeException {
        return this.crypt(in, inOffset, inLen, out, 0);
    }

    public final int doFinal(byte[] in, int inOffset, int inLen, byte[] out, int outOffset) throws IllegalBlockSizeException {
        return this.crypt(in, inOffset, inLen, out, outOffset);
    }

    private int a(int n2, boolean bl) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        if (!this.a) {
            n3 = (n2 += this.c) % this.d;
            n2 -= n3;
            if (bl && this.l == 1 && (this.j != null || n3 > 0)) {
                n2 += this.d;
            }
        }
        n3 = this.engineOutBufferSize(n2, bl);
        return n3;
    }

    private int b(int n2, boolean bl) {
        int n3;
        if (!this.a && (n3 = n2 % this.e) > 0) {
            n2 += this.e - n3;
        }
        n3 = this.engineInBufferSize(n2, bl);
        if (!this.a) {
            if (bl && this.l == 1 && this.j != null) {
                n3 -= this.d;
            }
            n3 -= this.c;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, boolean bl) {
        boolean bl2 = false;
        int n5 = n4;
        try {
            try {
                byte[] byArray3;
                if (this.l == 0) {
                    throw new IllegalStateException("cipher uninitialized");
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException("inLen < 0");
                }
                if (n2 < 0) throw new ArrayIndexOutOfBoundsException("inOffset < 0  || outOffset < 0 || (long)inOffset+inLen > in.length");
                if (n4 < 0) throw new ArrayIndexOutOfBoundsException("inOffset < 0  || outOffset < 0 || (long)inOffset+inLen > in.length");
                if ((long)n2 + (long)n3 > (long)byArray.length) {
                    throw new ArrayIndexOutOfBoundsException("inOffset < 0  || outOffset < 0 || (long)inOffset+inLen > in.length");
                }
                if (byArray2 == null) {
                    throw new NullPointerException();
                }
                if (this.b == null) {
                    if (this.k) {
                        int n6 = this.engineUpdate(byArray, n2, n3, byArray2, n4);
                        n4 += n6;
                        if (!bl) return n4 - n5;
                        if (!this.a) return n4 - n5;
                        n6 = this.engineCrypt(byArray2, n4);
                        n4 += n6;
                        return n4 - n5;
                    } else {
                        n4 += this.engineUpdate(byArray, n2, n3, byArray2, n4);
                        if (!bl) return n4 - n5;
                        if (!this.a) return n4 - n5;
                        n4 += this.engineCrypt(byArray2, n4);
                    }
                    return n4 - n5;
                }
                if (byArray == byArray2 && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)this.a(n3, bl))) {
                    byArray3 = new byte[n3];
                    System.arraycopy(byArray, n2, byArray3, 0, n3);
                    byArray = byArray3;
                    n2 = 0;
                }
                if (bl) {
                    if (this.l == 1) {
                        n4 += this.a(byArray, n2, n3, byArray2, n4, false);
                        if (this.j == null) {
                            if (this.c <= 0) return n4 - n5;
                            this.c = 0;
                            throw new IllegalBlockSizeException(this.getAlgorithm() + ": Non-padding cipher in ENCRYPT state with an incomplete final block");
                        }
                        this.j.pad(this.b, 0, this.c);
                        this.c = 0;
                        int n7 = this.engineUpdate(this.b, 0, this.d, byArray2, n4);
                        return (n4 += n7) - n5;
                    }
                    if (this.j != null) {
                        if (n3 == 0) {
                            return 0;
                        }
                        n4 += this.a(byArray, n2, n3 - 1, byArray2, n4, false);
                        if (this.c != this.d - 1) {
                            this.c = 0;
                            throw new IllegalBlockSizeException(this.getAlgorithm() + ": Cipher in DECRYPT state with an incomplete final block");
                        }
                        this.b[this.c] = byArray[n2 + n3 - 1];
                        this.c = 0;
                        byArray3 = new byte[this.a(this.d, false)];
                        int n8 = this.engineUpdate(this.b, 0, this.d, byArray3, 0);
                        int n9 = this.j.unpad(byArray3, 0, byArray3.length);
                        System.arraycopy(byArray3, 0, byArray2, n4, n9);
                        return (n4 += n9) - n5;
                    }
                }
                if (this.c > 0) {
                    if ((long)n3 + (long)this.c < (long)this.d) {
                        System.arraycopy(byArray, n2, this.b, this.c, n3);
                        this.c += n3;
                        return 0;
                    }
                    int n10 = this.d - this.c;
                    System.arraycopy(byArray, n2, this.b, this.c, n10);
                    n2 += n10;
                    n3 -= n10;
                    int n11 = this.engineUpdate(this.b, 0, this.d, byArray2, n4);
                    n4 += n11;
                }
                this.c = n3 % this.d;
                if (this.c > 0) {
                    System.arraycopy(byArray, n2 + n3 - this.c, this.b, 0, this.c);
                    n3 -= this.c;
                }
                while (n3 > 0) {
                    int n12 = this.engineUpdate(byArray, n2, this.d, byArray2, n4);
                    n4 += n12;
                    n2 += this.d;
                    n3 -= this.d;
                }
                return n4 - n5;
            }
            catch (RuntimeException runtimeException) {
                if (this.k) {
                    runtimeException.printStackTrace();
                }
                bl2 = true;
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            Object var14_26 = null;
            throw throwable;
        }
    }

    public void setParameter(String param, Object value) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        if (param == null) {
            throw new NullPointerException("param == null");
        }
        this.engineSetParameter(param, value);
    }

    public Object getParameter(String param) throws NoSuchParameterException, InvalidParameterException {
        if (param == null) {
            throw new NullPointerException("param == null");
        }
        Object object = this.engineGetParameter(param);
        return object;
    }

    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }

    public String toString() {
        return "Cipher [" + this.getProvider() + " " + this.getAlgorithm() + "/" + this.getMode() + "/" + this.getPadding() + "]";
    }

    protected void engineSetPaddingScheme(LicensePaddingScheme padding) {
        if (this.l != 0) {
            throw new IllegalStateException("Cipher is already initialized");
        }
        this.j = padding;
    }

    protected int engineBlockSize() {
        throw new Error("cipher classes must implement either engineBlockSize, or enginePlaintextBlockSize and engineCiphertextBlockSize");
    }

    protected int enginePlaintextBlockSize() {
        return this.engineBlockSize();
    }

    protected int engineCiphertextBlockSize() {
        return this.engineBlockSize();
    }

    protected int engineOutBufferSize(int inLen, boolean isFinal) {
        return inLen / this.d * this.e;
    }

    protected int engineInBufferSize(int outLen, boolean isFinal) {
        return outLen / this.e * this.d;
    }

    protected abstract void engineInitEncrypt(Key var1) throws KeyException;

    protected abstract void engineInitDecrypt(Key var1) throws KeyException;

    protected abstract int engineUpdate(byte[] var1, int var2, int var3, byte[] var4, int var5);

    protected int engineCrypt(byte[] out, int outOffset) {
        return 0;
    }

    protected void engineSetParameter(String param, Object value) throws NoSuchParameterException, InvalidParameterException, InvalidParameterTypeException {
        throw new NoSuchParameterException(this.getAlgorithm() + ": " + param);
    }

    protected Object engineGetParameter(String param) throws NoSuchParameterException, InvalidParameterException {
        throw new NoSuchParameterException(this.getAlgorithm() + ": " + param);
    }
}

