/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.cryptix.asn1.encoding.BaseCoder;
import com.enterprisedt.cryptix.asn1.encoding.CoderOperations;
import com.enterprisedt.cryptix.asn1.lang.ASNObject;
import com.enterprisedt.cryptix.asn1.lang.ASNSpecification;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.CertContext;
import com.enterprisedt.net.puretls.cert.DERUtils;
import com.enterprisedt.net.puretls.cert.X509DSAPublicKey;
import com.enterprisedt.net.puretls.cert.e;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Hashtable;

public class X509SubjectPublicKeyInfo {
    static Hashtable a = new Hashtable();

    public static PublicKey createPublicKey(byte[] spkiDER) throws IOException {
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            SSLDebug.debug(32, "SPKI encoding", spkiDER);
            CoderOperations coderOperations = BaseCoder.getInstance("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(spkiDER);
            coderOperations.init(byteArrayInputStream);
            ASNObject aSNObject = CertContext.getSpec().getComponent("SubjectPublicKeyInfo");
            ASNObject aSNObject2 = aSNObject.getComponent("SubjectPublicKeyInfo.algorithm");
            ASNObject aSNObject3 = aSNObject2.getComponent("AlgorithmIdentifier.parameters");
            aSNObject3.setValue(aSNObject3.getDefaultValue());
            aSNObject.accept(coderOperations, null);
            ASNObject aSNObject4 = aSNObject.getComponent("SubjectPublicKeyInfo.algorithm");
            ASNObject aSNObject5 = aSNObject4.getComponent("AlgorithmIdentifier.parameters");
            aSNObject4 = aSNObject4.getComponent("AlgorithmIdentifier.algorithm");
            String string = (String)aSNObject4.getValue();
            byte[] byArray = (byte[])aSNObject5.getValue();
            SSLDebug.debug(32, "SPKI params", byArray);
            aSNObject4 = aSNObject.getComponent("SubjectPublicKeyInfo.subjectPublicKey");
            byte[] byArray2 = (byte[])aSNObject4.getValue();
            if (string.equals("1.2.840.113549.1.1.1")) {
                return new e(string, byArray, byArray2);
            }
            if (string.equals("1.2.840.10040.4.1")) {
                return new X509DSAPublicKey(string, byArray, byArray2);
            }
            throw new IOException("Unrecognized OID for key" + string);
        }
    }

    public static byte[] encodePublicKey(byte[] OID, byte[] params, byte[] key) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DERUtils.encodeOID(OID, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.write(params);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray, (OutputStream)byteArrayOutputStream);
        DERUtils.encodeBitString(key, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.reset();
        DERUtils.encodeSequence(byArray2, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

