/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.net.puretls.LoadProviders;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.CertContext;
import com.enterprisedt.net.puretls.cert.WrappedObject;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.net.puretls.sslg.CertVerifyPolicyInt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class CertVerify {
    public static CertContext cctx = new CertContext();

    public static void loadRoots(String file) throws Exception {
        byte[] byArray;
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        while ((byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            cctx.addRoot(byArray);
        }
    }

    public static byte[] loadCert(String file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        byte[] byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null);
        return byArray;
    }

    public static void main(String[] args) throws Exception {
        Object object;
        int n2;
        LoadProviders.init();
        boolean bl = false;
        CertVerifyPolicyInt certVerifyPolicyInt = new CertVerifyPolicyInt();
        for (n2 = 0; n2 < args.length && args[n2].startsWith("-"); ++n2) {
            if (args[n2].equals("-debug")) {
                SSLDebug.setDebug(40);
                continue;
            }
            if (args[n2].equals("-damage")) {
                bl = true;
                continue;
            }
            if (args[n2].equals("-checkbc")) {
                certVerifyPolicyInt.requireBasicConstraints(true);
                continue;
            }
            if (args[n2].equals("-bccritical")) {
                certVerifyPolicyInt.requireBasicConstraintsCritical(true);
                continue;
            }
            if (args[n2].equals("-checkdates")) {
                certVerifyPolicyInt.checkDates(true);
                continue;
            }
            if (args[n2].equals("-checkkeyusage")) {
                certVerifyPolicyInt.requireKeyUsage(true);
                continue;
            }
            throw new InternalError("Bogus argument " + args[n2]);
        }
        CertVerify.loadRoots(args[n2++]);
        Vector<Object> vector = new Vector<Object>();
        while (n2 < args.length) {
            byte[] byArray = CertVerify.loadCert(args[n2]);
            if (bl && n2 == args.length - 1) {
                int n3 = byArray.length - 1;
                byArray[n3] = (byte)(byArray[n3] + 1);
            }
            object = new X509Cert(byArray);
            vector.addElement(object);
            ++n2;
        }
        object = X509Cert.verifyCertChain(cctx, vector, certVerifyPolicyInt);
        if (object == null) {
            System.out.println("Couldn't verify chain");
        } else if (((Vector)object).size() == 1) {
            System.out.println("IS ROOT! Didn't actually verify signature");
        } else {
            System.out.println("Verified successfully");
            for (int i2 = 0; i2 < ((Vector)object).size(); ++i2) {
                X509Cert x509Cert = (X509Cert)((Vector)object).elementAt(i2);
                System.out.println("Issuer " + x509Cert.getIssuerName().getNameString());
                System.out.println("Subject " + x509Cert.getSubjectName().getNameString());
                System.out.println("Serial " + x509Cert.getSerial());
                System.out.println("Validity " + x509Cert.getValidityNotBefore() + "-" + x509Cert.getValidityNotAfter());
            }
        }
    }
}

