/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.InvalidHostFileException;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.util.Base64;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import xjava.security.Parameterized;

public abstract class AbstractKnownHostsKeyVerification
implements HostKeyVerification {
    private static Logger a = Logger.getLogger("AbstractKnownHostsKeyVerification");
    private List b = new ArrayList();
    private String c;
    private boolean d = false;
    private boolean e = false;
    private boolean f = true;

    public AbstractKnownHostsKeyVerification(String knownhosts) throws InvalidHostFileException, IOException {
        this.parse(knownhosts);
    }

    public AbstractKnownHostsKeyVerification() {
    }

    public boolean isPortsInKnownHosts() {
        return this.f;
    }

    public void setPortsInKnownHosts(boolean portsInKnownHosts) {
        this.f = portsInKnownHosts;
    }

    public List getKnownHostEntries() {
        return this.b;
    }

    public String getKnownhosts() {
        return this.c;
    }

    public void setKnownhosts(String knownhosts) {
        this.c = knownhosts;
    }

    public void parse(InputStream in) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
        while ((string = bufferedReader.readLine()) != null) {
            string = string.trim();
            try {
                if (string.startsWith("#")) {
                    this.b.add(new CommentEntry(this, string));
                    continue;
                }
                if (string.startsWith("|1|")) {
                    this.b.add(new HashedHostEntry(this, string));
                    this.e = true;
                    continue;
                }
                this.b.add(new HostEntry(this, string));
            }
            catch (InvalidHostFileException invalidHostFileException) {
                a.warn(invalidHostFileException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String knownhosts) throws IOException {
        InputStream inputStream = null;
        try {
            if (knownhosts != null) {
                File file = new File(knownhosts);
                if (file.exists()) {
                    inputStream = new FileInputStream(file);
                    this.parse(inputStream);
                    inputStream.close();
                    this.d = file.canWrite();
                } else {
                    file.getParentFile().mkdirs();
                    if (file.createNewFile()) {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(this.toString().getBytes());
                        fileOutputStream.close();
                        this.d = true;
                    } else {
                        this.d = false;
                    }
                }
                if (!this.d) {
                    a.warn("Host file is not writeable.");
                }
                this.c = knownhosts;
            }
            Object var6_5 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public boolean isHostFileWriteable() {
        return this.d;
    }

    public abstract void onHostKeyMismatch(String var1, SshPublicKey var2, SshPublicKey var3) throws TransportProtocolException;

    public abstract boolean onUnknownHost(String var1, SshPublicKey var2) throws TransportProtocolException;

    public abstract boolean onUnknownAlgorithm(String var1, SshPublicKey var2) throws TransportProtocolException;

    public void allowHost(String host, SshPublicKey pk, boolean always) throws InvalidHostFileException {
        KnownHostsEntry knownHostsEntry;
        if (a.isDebugEnabled()) {
            a.debug("Allowing " + host + " with fingerprint " + pk.getFingerprint());
        }
        Iterator iterator = this.b.iterator();
        while (iterator.hasNext()) {
            knownHostsEntry = (KnownHostsEntry)iterator.next();
            if (!knownHostsEntry.matches(host)) continue;
            iterator.remove();
        }
        knownHostsEntry = null;
        knownHostsEntry = this.e ? new HashedHostEntry(this, host, pk) : new HostEntry(this, host, pk);
        this.b.add(knownHostsEntry);
        if (always) {
            if (this.c != null) {
                this.saveHostFile();
            } else {
                a.warn("Cannot write to known_hosts file as none supplied");
            }
        }
    }

    public void removeAllowedHost(String host) {
        Iterator iterator = this.b.iterator();
        while (iterator.hasNext()) {
            KnownHostsEntry knownHostsEntry = (KnownHostsEntry)iterator.next();
            try {
                if (!knownHostsEntry.matches(host)) continue;
                iterator.remove();
            }
            catch (InvalidHostFileException invalidHostFileException) {
                a.warn("Failed to match host: " + invalidHostFileException.getMessage());
            }
        }
    }

    public void removeAllAllowedHosts() {
        this.b.clear();
    }

    public boolean verifyHost(String host, SshPublicKey pk) throws TransportProtocolException {
        Iterator iterator = this.b.iterator();
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            KnownHostsEntry knownHostsEntry = (KnownHostsEntry)iterator.next();
            if (!knownHostsEntry.matches(host)) continue;
            a.debug("verifyHost - found matching entry for host '" + host + "'");
            bl = true;
            if (!knownHostsEntry.getPublicKey().getAlgorithmName().equals(pk.getAlgorithmName())) continue;
            a.debug("verifyHost - found matching algorithm '" + pk.getAlgorithmName() + "'");
            bl2 = true;
            if (knownHostsEntry.getPublicKey().equals(pk)) {
                return true;
            }
            this.onHostKeyMismatch(host, knownHostsEntry.getPublicKey(), pk);
            break;
        }
        if (!bl) {
            return this.onUnknownHost(host, pk);
        }
        if (!bl2) {
            return this.onUnknownAlgorithm(host, pk);
        }
        return false;
    }

    public String getPreferredKeyAlgorithm(String host) {
        Iterator iterator = this.b.iterator();
        while (iterator.hasNext()) {
            KnownHostsEntry knownHostsEntry = (KnownHostsEntry)iterator.next();
            try {
                if (!knownHostsEntry.matches(host)) continue;
                return knownHostsEntry.getPublicKey().getAlgorithmName();
            }
            catch (InvalidHostFileException invalidHostFileException) {
                a.warn("Failed to match host: " + invalidHostFileException.getMessage());
            }
        }
        return null;
    }

    public void saveHostFile() throws InvalidHostFileException {
        this.saveHostFile(this.c);
    }

    public void saveHostFile(String knownHostsFile) throws InvalidHostFileException {
        try {
            File file = new File(knownHostsFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.toString().getBytes());
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new InvalidHostFileException("Could not write to " + this.c, iOException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.b.iterator();
        while (iterator.hasNext()) {
            KnownHostsEntry knownHostsEntry = (KnownHostsEntry)iterator.next();
            stringBuffer.append(((Object)knownHostsEntry).toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    static Logger a() {
        return a;
    }

    public class HashedHostEntry
    implements KnownHostsEntry {
        private String a;
        private byte[] b;
        private byte[] c;
        private SshPublicKey d;
        private MessageDigest e;
        private final AbstractKnownHostsKeyVerification f;

        public HashedHostEntry(AbstractKnownHostsKeyVerification abstractKnownHostsKeyVerification, String line) throws InvalidHostFileException {
            this.f = abstractKnownHostsKeyVerification;
            this.b = null;
            this.c = null;
            this.e = null;
            this.e = this.a();
            StringTokenizer stringTokenizer = new StringTokenizer(line, " ");
            if (stringTokenizer.countTokens() == 0) {
                throw new InvalidHostFileException("Failed to read known_hosts line '" + line + "'");
            }
            String string = (String)stringTokenizer.nextElement();
            if (!string.startsWith("|1|")) {
                throw new InvalidHostFileException("Invalid data in known_hosts line '" + line + "'");
            }
            this.a = string.substring("|1|".length());
            int n2 = this.a.indexOf("|");
            if (n2 <= 0) {
                throw new InvalidHostFileException("Invalid data in known_hosts line '" + line + "'");
            }
            String string2 = this.a.substring(0, n2);
            String string3 = this.a.substring(n2 + 1);
            this.b = Base64.decode(string2);
            this.c = Base64.decode(string3);
            if (this.b.length != 20 || this.c.length != 20) {
                throw new InvalidHostFileException("Invalid data in known_hosts line '" + line + "'");
            }
            stringTokenizer.nextElement();
            String string4 = (String)stringTokenizer.nextElement();
            try {
                this.d = SshKeyPairFactory.decodePublicKey(Base64.decode(string4));
            }
            catch (InvalidSshKeyException invalidSshKeyException) {
                throw new InvalidHostFileException("Failed to read key for host '" + string + "': " + invalidSshKeyException.getMessage());
            }
        }

        public HashedHostEntry(AbstractKnownHostsKeyVerification abstractKnownHostsKeyVerification, String host, SshPublicKey pk) throws InvalidHostFileException {
            this.f = abstractKnownHostsKeyVerification;
            this.b = null;
            this.c = null;
            this.e = null;
            this.d = pk;
            this.e = this.a();
            this.b = new byte[this.e.getDigestLength()];
            ConfigurationLoader.getRND().nextBytes(this.b);
            this.a(this.b);
            this.e.update(host.getBytes());
            this.c = this.e.digest();
        }

        public String getHashedHostName() {
            return this.a;
        }

        public SshPublicKey getPublicKey() {
            return this.d;
        }

        public boolean matchesExact(String host) throws InvalidHostFileException {
            byte[] byArray = null;
            this.a(this.b);
            this.e.update(host.getBytes());
            byArray = this.e.digest();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                if (byArray[i2] == this.c[i2]) continue;
                return false;
            }
            return true;
        }

        public boolean matches(String host) throws InvalidHostFileException {
            boolean bl = this.matchesExact(host);
            if (!bl) {
                String string;
                StringTokenizer stringTokenizer = new StringTokenizer(host, ",");
                while (stringTokenizer.hasMoreElements() && !(bl = this.matchesExact(string = (String)stringTokenizer.nextElement()))) {
                }
                return bl;
            }
            return bl;
        }

        private void a(byte[] byArray) throws InvalidHostFileException {
            try {
                ((Parameterized)((Object)this.e)).setParameter("key", byArray);
            }
            catch (Exception exception) {
                String string = "Failed to initialise hash: " + exception.getMessage();
                AbstractKnownHostsKeyVerification.a().error(string);
                throw new InvalidHostFileException(string);
            }
        }

        private MessageDigest a() throws InvalidHostFileException {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("HMAC-SHA-1", "CryptixEDT");
                return messageDigest;
            }
            catch (Exception exception) {
                String string = "Failed to create hash algorithm: " + exception.getMessage();
                AbstractKnownHostsKeyVerification.a().error(string);
                throw new InvalidHostFileException(string);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("|1|");
            stringBuffer.append(Base64.encodeBytes(this.b, true)).append("|").append(Base64.encodeBytes(this.c, true)).append(" ").append(this.d.getAlgorithmName()).append(" ").append(Base64.encodeBytes(this.d.getEncoded(), true));
            return stringBuffer.toString();
        }
    }

    public class HostEntry
    implements KnownHostsEntry {
        private String a;
        private SshPublicKey b;
        private final AbstractKnownHostsKeyVerification c;

        public HostEntry(AbstractKnownHostsKeyVerification abstractKnownHostsKeyVerification, String line) throws InvalidHostFileException {
            this.c = abstractKnownHostsKeyVerification;
            StringTokenizer stringTokenizer = new StringTokenizer(line);
            if (stringTokenizer.countTokens() == 0) {
                throw new InvalidHostFileException("Failed to read known_hosts line '" + line + "'");
            }
            this.a = (String)stringTokenizer.nextElement();
            stringTokenizer.nextElement();
            String string = (String)stringTokenizer.nextElement();
            try {
                this.b = SshKeyPairFactory.decodePublicKey(Base64.decode(string));
            }
            catch (InvalidSshKeyException invalidSshKeyException) {
                throw new InvalidHostFileException("Failed to read key for host '" + this.a + "': " + invalidSshKeyException.getMessage());
            }
        }

        public HostEntry(AbstractKnownHostsKeyVerification abstractKnownHostsKeyVerification, String host, SshPublicKey pk) {
            this.c = abstractKnownHostsKeyVerification;
            this.a = host;
            this.b = pk;
        }

        public String getHostName() {
            return this.a;
        }

        public SshPublicKey getPublicKey() {
            return this.b;
        }

        public boolean matches(String host) throws InvalidHostFileException {
            String string;
            int n2 = host.indexOf(",");
            String string2 = string = n2 >= 0 ? host.substring(0, n2) : null;
            if (this.a.equalsIgnoreCase(host) || string != null && this.a.equalsIgnoreCase(string)) {
                return true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.a, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string3.equalsIgnoreCase(host) && (string == null || !string3.equalsIgnoreCase(string))) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.a);
            stringBuffer.append(" ").append(this.b.getAlgorithmName()).append(" ").append(Base64.encodeBytes(this.b.getEncoded(), true));
            return stringBuffer.toString();
        }
    }

    public class CommentEntry
    implements KnownHostsEntry {
        private String a;
        private final AbstractKnownHostsKeyVerification b;

        public CommentEntry(AbstractKnownHostsKeyVerification abstractKnownHostsKeyVerification, String comment) {
            this.b = abstractKnownHostsKeyVerification;
            this.a = comment;
        }

        public boolean matches(String host) throws InvalidHostFileException {
            return false;
        }

        public String toString() {
            return this.a;
        }

        public SshPublicKey getPublicKey() {
            return null;
        }
    }

    public static interface KnownHostsEntry {
        public boolean matches(String var1) throws InvalidHostFileException;

        public String toString();

        public SshPublicKey getPublicKey();
    }
}

