/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.subsystem;

import com.enterprisedt.net.j2ssh.SshThread;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.session.SessionChannelClient;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessage;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessageStore;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.util.StartStopState;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class SubsystemClient
implements Runnable {
    private static Logger a = Logger.getLogger("SubsystemClient");
    private InputStream b;
    private OutputStream c;
    private Thread d;
    private String e;
    private StartStopState f = new StartStopState(2);
    protected SubsystemMessageStore messageStore;
    protected SessionChannelClient session;

    public SubsystemClient(String name) {
        this.e = name;
        this.messageStore = new SubsystemMessageStore();
    }

    public SubsystemClient(String name, SubsystemMessageStore messageStore) {
        this.e = name;
        this.messageStore = messageStore;
    }

    public boolean isClosed() {
        return this.f.getValue() == 2;
    }

    public void setSessionChannel(SessionChannelClient session) {
        this.session = session;
        this.b = session.getInputStream();
        this.c = session.getOutputStream();
        session.setName(this.e);
    }

    public SessionChannelClient getSessionChannel() {
        return this.session;
    }

    public boolean start() throws IOException {
        this.d = new SshThread(this, this.e + " subsystem", true);
        if (this.session == null) {
            throw new IOException("No valid session is attached to the subsystem!");
        }
        if (this.session.getState().getValue() != 2) {
            throw new IOException("The session is not open!");
        }
        this.d.start();
        return this.onStart();
    }

    protected abstract boolean onStart() throws IOException;

    public String getName() {
        return this.e;
    }

    protected void sendMessage(SubsystemMessage msg) throws InvalidMessageException, IOException {
        if (a.isDebugEnabled()) {
            a.debug("Sending " + msg.getMessageName() + " subsystem message");
        }
        byte[] byArray = msg.toByteArray();
        this.c.write(ByteArrayWriter.encodeInt(byArray.length));
        this.c.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block10: {
            byte[] byArray = new byte[4];
            this.f.setValue(1);
            try {
                try {}
                catch (IOException iOException) {
                    a.fatal("Subsystem message loop failed!", iOException);
                    Object var8_7 = null;
                    this.f.setValue(2);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.f.setValue(2);
                throw throwable;
            }
            while (this.f.getValue() == 1 && this.session.getState().getValue() == 2) {
                int n2;
                byte[] byArray2;
                int n3;
                int n4 = this.b.read(byArray);
                if (n4 > 0) {
                    n3 = (int)ByteArrayReader.readInt(byArray, 0);
                    byArray2 = new byte[n3];
                    n2 = 0;
                } else {
                    if (n4 != -1) continue;
                    break;
                }
                while (n2 < n3) {
                    n4 = this.b.read(byArray2, n2, byArray2.length - n2);
                    if (n4 > 0) {
                        n2 += n4;
                        continue;
                    }
                    if (n4 != -1) continue;
                }
                this.messageStore.addMessage(byArray2);
                byArray2 = null;
            }
            Object var8_6 = null;
            this.f.setValue(2);
        }
        this.d = null;
    }

    public void stop() throws IOException {
        this.f.setValue(2);
        this.b.close();
        this.c.close();
        this.session.close();
    }
}

