/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.subsystem;

import com.enterprisedt.net.j2ssh.connection.Channel;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelData;
import com.enterprisedt.net.j2ssh.connection.SshMsgChannelExtendedData;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.io.DynamicBuffer;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessage;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessageStore;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public abstract class SubsystemChannel
extends Channel {
    private static Logger a = Logger.getLogger("SubsystemChannel");
    Integer g = null;
    String h;
    protected SubsystemMessageStore messageStore;
    DynamicBuffer i = new DynamicBuffer();
    int j = -1;

    public SubsystemChannel(String name) {
        this.h = name;
        this.messageStore = new SubsystemMessageStore();
    }

    public SubsystemChannel(String name, SubsystemMessageStore messageStore) {
        this.h = name;
        this.messageStore = messageStore;
    }

    public String getChannelType() {
        return "session";
    }

    protected void sendMessage(SubsystemMessage msg) throws InvalidMessageException, IOException {
        if (a.isDebugEnabled()) {
            a.debug("Sending " + msg.getMessageName() + " subsystem message");
        }
        byte[] byArray = this.toByteArray(msg);
        this.sendChannelData(ByteArrayWriter.encodeInt(byArray.length));
        this.sendChannelData(byArray);
    }

    protected byte[] toByteArray(SubsystemMessage msg) throws InvalidMessageException {
        return msg.toByteArray();
    }

    protected void onChannelRequest(String requestType, boolean wantReply, byte[] requestData) throws IOException {
        a.debug("Channel Request received: " + requestType);
        if (requestType.equals("exit-status")) {
            this.g = new Integer((int)ByteArrayReader.readInt(requestData, 0));
            a.debug("Exit code of " + this.g.toString() + " received");
        } else if (requestType.equals("exit-signal")) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(requestData);
            String string = byteArrayReader.readString();
            boolean bl = byteArrayReader.read() != 0;
            String string2 = byteArrayReader.readString();
            byteArrayReader.readString();
            a.debug("Exit signal " + string + " received");
            a.debug("Signal message: " + string2);
            a.debug("Core dumped: " + String.valueOf(bl));
        } else if (!requestType.equals("xon-xoff")) {
            if (requestType.equals("signal")) {
                String string = ByteArrayReader.readString(requestData, 0);
                a.debug("Signal " + string + " received");
            } else if (wantReply) {
                this.connection.sendChannelRequestFailure(this);
            }
        }
    }

    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
    }

    protected void onChannelData(SshMsgChannelData msg) throws IOException {
        this.i.getOutputStream().write(msg.getChannelData());
        byte[] byArray = new byte[4];
        while (this.i.getInputStream().available() > 4) {
            if (this.j == -1) {
                int n2 = 0;
                while ((n2 += this.i.getInputStream().read(byArray)) < 4) {
                }
                this.j = (int)ByteArrayReader.readInt(byArray, 0);
            }
            if (this.i.getInputStream().available() < this.j) break;
            byte[] byArray2 = new byte[this.j];
            this.i.getInputStream().read(byArray2);
            this.messageStore.addMessage(byArray2);
            this.j = -1;
        }
    }

    protected void onChannelEOF() throws IOException {
    }

    protected void onChannelClose() throws IOException {
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    protected void onChannelOpen() throws IOException {
    }

    public boolean startSubsystem() throws IOException {
        a.debug("Starting " + this.h + " subsystem");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(this.h);
        return this.connection.sendChannelRequest(this, "subsystem", true, byteArrayWriter.toByteArray());
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }
}

