/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.openssh;

import com.enterprisedt.net.j2ssh.openssh.KeyInfo;
import com.enterprisedt.net.j2ssh.util.SimpleASNReader;
import com.enterprisedt.net.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;

public class RSAKeyInfo
implements KeyInfo {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;
    private BigInteger g;
    private BigInteger h;

    public RSAKeyInfo(BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) {
        this.a = modulus;
        this.b = publicExponent;
        this.c = privateExponent;
        this.d = primeP;
        this.e = primeQ;
        this.f = primeExponentP;
        this.g = primeExponentQ;
        this.h = crtCoefficient;
    }

    public KeySpec getPrivateKeySpec() {
        return new RSAPrivateKeySpec(this.a, this.c);
    }

    public KeySpec getPublicKeySpec() {
        return new RSAPublicKeySpec(this.a, this.b);
    }

    public BigInteger getCrtCoefficient() {
        return this.h;
    }

    public BigInteger getModulus() {
        return this.a;
    }

    public BigInteger getPrimeExponentP() {
        return this.f;
    }

    public BigInteger getPrimeExponentQ() {
        return this.g;
    }

    public BigInteger getPrimeP() {
        return this.d;
    }

    public BigInteger getPrimeQ() {
        return this.e;
    }

    public BigInteger getPrivateExponent() {
        return this.c;
    }

    public BigInteger getPublicExponent() {
        return this.b;
    }

    public static RSAKeyInfo getRSAKeyInfo(SimpleASNReader asn) throws IOException {
        asn.assertByte(48);
        asn.getLength();
        asn.assertByte(2);
        asn.getData();
        asn.assertByte(2);
        byte[] byArray = asn.getData();
        asn.assertByte(2);
        byte[] byArray2 = asn.getData();
        asn.assertByte(2);
        byte[] byArray3 = asn.getData();
        asn.assertByte(2);
        byte[] byArray4 = asn.getData();
        asn.assertByte(2);
        byte[] byArray5 = asn.getData();
        asn.assertByte(2);
        byte[] byArray6 = asn.getData();
        asn.assertByte(2);
        byte[] byArray7 = asn.getData();
        asn.assertByte(2);
        byte[] byArray8 = asn.getData();
        return new RSAKeyInfo(new BigInteger(byArray), new BigInteger(byArray2), new BigInteger(byArray3), new BigInteger(byArray4), new BigInteger(byArray5), new BigInteger(byArray6), new BigInteger(byArray7), new BigInteger(byArray8));
    }

    public static void writeRSAKeyInfo(SimpleASNWriter asn, RSAKeyInfo keyInfo) {
        SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
        simpleASNWriter.writeByte(2);
        byte[] byArray = new byte[1];
        simpleASNWriter.writeData(byArray);
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getModulus().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getPublicExponent().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getPrivateExponent().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getPrimeP().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getPrimeQ().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getPrimeExponentP().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getPrimeExponentQ().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getCrtCoefficient().toByteArray());
        byte[] byArray2 = simpleASNWriter.toByteArray();
        asn.writeByte(48);
        asn.writeData(byArray2);
    }
}

