/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.authentication;

import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolClient;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolException;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthPKOK;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthRequest;
import com.enterprisedt.net.j2ssh.authentication.TerminatedStateException;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.Properties;

public class PublicKeyAuthenticationClient
extends SshAuthenticationClient {
    private static Logger c = Logger.getLogger(a == null ? (a = PublicKeyAuthenticationClient.class$("com.enterprisedt.net.j2ssh.authentication.PublicKeyAuthenticationClient")) : a);
    protected SshPrivateKey key;
    private String d = null;
    static Class a;
    static Class b;

    public void setKey(SshPrivateKey key) {
        this.key = key;
    }

    public void setKeyfile(String privateKeyFile) {
        this.d = privateKeyFile;
    }

    public String getKeyfile() {
        return this.d;
    }

    public void reset() {
        this.d = null;
    }

    public String getMethodName() {
        return "publickey";
    }

    public boolean acceptsKey(AuthenticationProtocolClient authentication, String username, String serviceToStart, SshPublicKey key) throws IOException {
        authentication.registerMessage(b == null ? (b = PublicKeyAuthenticationClient.class$("com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthPKOK")) : b, 60);
        c.debug("Determining if server can accept public key for authentication");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(0);
        byteArrayWriter.writeString(key.getAlgorithmName());
        byteArrayWriter.writeBinaryString(key.getEncoded());
        SshMessage sshMessage = new SshMsgUserAuthRequest(username, serviceToStart, this.getMethodName(), byteArrayWriter.toByteArray());
        authentication.sendMessage(sshMessage);
        try {
            sshMessage = authentication.readMessage(60);
            if (sshMessage instanceof SshMsgUserAuthPKOK) {
                return true;
            }
            throw new IOException("Unexpected message returned from readMessage");
        }
        catch (TerminatedStateException terminatedStateException) {
            return false;
        }
    }

    public void authenticate(AuthenticationProtocolClient authentication, String serviceToStart) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.key == null) {
            throw new AuthenticationProtocolException("You must supply a username and a key");
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        c.debug("Generating data to sign");
        SshPublicKey sshPublicKey = this.key.getPublicKey();
        c.debug("Preparing public key authentication request");
        byteArrayWriter.write(1);
        byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
        ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
        byteArrayWriter2.writeBinaryString(authentication.getSessionIdentifier());
        byteArrayWriter2.write(50);
        byteArrayWriter2.writeString(this.getUsername());
        byteArrayWriter2.writeString(serviceToStart);
        byteArrayWriter2.writeString(this.getMethodName());
        byteArrayWriter2.write(1);
        byteArrayWriter2.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter2.writeBinaryString(sshPublicKey.getEncoded());
        byteArrayWriter.writeBinaryString(this.key.generateSignature(byteArrayWriter2.toByteArray()));
        SshMsgUserAuthRequest sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), serviceToStart, this.getMethodName(), byteArrayWriter.toByteArray());
        authentication.sendMessage(sshMsgUserAuthRequest);
    }

    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        if (this.d != null) {
            properties.setProperty("PrivateKey", this.d);
        }
        return properties;
    }

    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("PrivateKey") != null) {
            this.d = properties.getProperty("PrivateKey");
        }
    }

    public boolean canAuthenticate() {
        return this.getUsername() != null && this.key != null;
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

