/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssl;

import com.enterprisedt.BaseIOException;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.RecursiveOperations;
import com.enterprisedt.net.ftp.pro.ProFTPClient;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificate;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateException;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateStore;
import com.enterprisedt.net.ftp.ssl.SSLFTPCipherSuite;
import com.enterprisedt.net.ftp.ssl.SSLFTPControlSocket;
import com.enterprisedt.net.ftp.ssl.SSLFTPException;
import com.enterprisedt.net.ftp.ssl.SSLFTPStandardValidator;
import com.enterprisedt.net.ftp.ssl.SSLFTPValidator;
import com.enterprisedt.net.ftp.ssl.b;
import com.enterprisedt.net.ftp.ssl.c;
import com.enterprisedt.net.puretls.SSLContext;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.SSLException;
import com.enterprisedt.net.puretls.SSLPrematureCloseException;
import com.enterprisedt.net.puretls.SSLSocket;
import com.enterprisedt.net.puretls.cert.CertificateVerifyException;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.StreamSocket;
import com.enterprisedt.util.proxy.StreamSocketFactory;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Vector;

public class SSLFTPClient
extends ProFTPClient
implements ProFTPClientInterface {
    public static final String AUTH_TLS = "TLS";
    public static final String AUTH_TLS_C = "TLS-C";
    public static final String AUTH_SSL = "SSL";
    public static final char PROT_CLEAR = 'C';
    public static final char PROT_PRIVATE = 'P';
    private SSLContext a;
    private SSLFTPCertificateStore b;
    private int c = 0;
    private boolean d = false;
    private static Logger e = Logger.getLogger("SSLFTPClient");
    private SSLFTPValidator f;
    private RecursiveOperations g = new RecursiveOperations();
    private boolean h = true;
    private String i = "TLS";

    public SSLFTPClient() throws FTPException {
        this.a = new SSLContext();
        this.setRemotePort(-1);
        this.setCustomValidator(new SSLFTPStandardValidator());
        this.a(new SSLFTPCertificateStore());
    }

    public SSLFTPClient(String remoteHost, int configFlags) throws UnknownHostException {
        this(remoteHost, -1, 60000, configFlags);
    }

    public SSLFTPClient(String remoteHost, int controlPort, int configFlags) throws UnknownHostException {
        this(remoteHost, controlPort, 60000, configFlags);
    }

    public SSLFTPClient(String remoteHost, int controlPort, int timeout, int configFlags) throws UnknownHostException {
        this(InetAddress.getByName(remoteHost), controlPort, timeout, configFlags);
    }

    public SSLFTPClient(InetAddress remoteAddr, int configFlags) {
        this(remoteAddr, -1, 60000, configFlags);
    }

    public SSLFTPClient(InetAddress remoteAddr, int controlPort, int configFlags) {
        this(remoteAddr, controlPort, 60000, configFlags);
    }

    public SSLFTPClient(InetAddress remoteAddr, int controlPort, int timeout, int configFlags) {
        this.a = new SSLContext();
        try {
            this.setCustomValidator(new SSLFTPStandardValidator());
            this.a(new SSLFTPCertificateStore());
            this.setRemotePort(controlPort);
            this.setRemoteAddr(remoteAddr);
            this.setTimeout(timeout);
            this.setConfigFlags(configFlags);
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            e.error(string);
            throw new RuntimeException(string);
        }
        catch (FTPException fTPException) {
            String string = fTPException.getMessage();
            e.error(string);
            throw new RuntimeException(string);
        }
    }

    private void a(SSLFTPCertificateStore sSLFTPCertificateStore) {
        this.b = sSLFTPCertificateStore;
        this.a.setRootCertificates(sSLFTPCertificateStore.b());
        this.b.a(new b(this));
    }

    public void setConfigFlags(int configFlags) throws FTPException {
        this.checkConnection(false);
        this.c = configFlags;
        if ((configFlags & 0x20) != 0) {
            this.d = true;
        }
    }

    public int getConfigFlags() {
        return this.c;
    }

    public boolean isControlSecure() {
        return this.control != null ? this.control.isSecureMode() : false;
    }

    public void connect() throws IOException, FTPException, SSLFTPCertificateException {
        this.checkConnection(false);
        if (this.remoteHost == null) {
            throw new FTPException("No host-name has been set.  Please use setRemoteHost()");
        }
        if (this.getRemotePort() < 0) {
            this.setRemotePort(!this.d ? 21 : 990);
        }
        this.a.getPolicy().handshakeOnConnect(this.d);
        this.a.getPolicy().waitOnClose(false);
        e.debug("Created " + (this.d ? "implicit" : "explicit") + " FTPS client.");
        e.debug("Connecting to " + this.getRemoteHost() + ":" + this.getRemotePort());
        StreamSocket streamSocket = StreamSocketFactory.getConnectedSocket(this.getRemoteHost(), this.controlPort, this.timeout, this.proxySettings);
        try {
            SSLSocket sSLSocket = new SSLSocket(this.a, streamSocket);
            SSLFTPControlSocket sSLFTPControlSocket = new SSLFTPControlSocket(this.proxySettings, this.a, sSLSocket, streamSocket.getInetAddress(), this.getRemotePort(), this.getTimeout(), this.d, this.c, this.f, this.controlEncoding, this.messageListener);
            this.initialize(sSLFTPControlSocket);
        }
        catch (SSLException sSLException) {
            e.debug("Caught: " + sSLException.getClass().getName());
            Throwable throwable = sSLException;
            while (throwable != null) {
                if (throwable instanceof CertificateVerifyException) {
                    e.debug("Rethrowing as SSLFTPCertificateException");
                    CertificateVerifyException certificateVerifyException = (CertificateVerifyException)throwable;
                    throw new SSLFTPCertificateException(certificateVerifyException.getMessage(), certificateVerifyException.getCertificates());
                }
                if (!(throwable instanceof SSLException)) break;
                if ((throwable = ((BaseIOException)throwable).getInnerThrowable()) == null) continue;
                e.debug("Inner throwable = " + throwable.getClass().getName());
            }
            e.debug("Caught: " + sSLException.getClass().getName());
            throw sSLException;
        }
    }

    protected void reconnect(String cwd) throws IOException, FTPException {
        try {
            this.quitImmediately();
        }
        catch (Exception exception) {
            // empty catch block
        }
        e.info("Reconnecting");
        this.connect();
        this.auth(this.i);
        this.login(this.user, this.password);
        this.setType(this.transferType);
        this.chdir(cwd);
    }

    protected int readChar(LineNumberReader in) throws IOException {
        try {
            return in.read();
        }
        catch (SSLPrematureCloseException sSLPrematureCloseException) {
            return -1;
        }
    }

    protected String readLine(LineNumberReader in) throws IOException {
        try {
            return in.readLine();
        }
        catch (SSLPrematureCloseException sSLPrematureCloseException) {
            return null;
        }
    }

    public int readChunk(BufferedInputStream in, byte[] chunk, int chunksize) throws IOException {
        try {
            return in.read(chunk, 0, chunksize);
        }
        catch (SSLPrematureCloseException sSLPrematureCloseException) {
            return -1;
        }
    }

    public Vector getCertificateChain() {
        return ((SSLFTPControlSocket)this.control).d();
    }

    public boolean getValidateServer() {
        return !this.a.getPolicy().acceptUnverifiableCertificatesP();
    }

    public void setValidateServer(boolean validate) throws FTPException {
        this.checkConnection(false);
        e.debug("Turned server validation " + (validate ? "on" : "off"));
        this.a.getPolicy().acceptUnverifiableCertificates(!validate);
    }

    public void setCustomValidator(SSLFTPValidator newValidator) throws FTPException {
        this.checkConnection(false);
        e.debug("Setting custom validator to " + newValidator.getClass().getName());
        this.f = newValidator;
        if (this.f instanceof SSLFTPStandardValidator) {
            ((SSLFTPStandardValidator)this.f).a(this.b);
        }
        c c2 = new c(this);
        this.a.setVerifier(c2);
    }

    private Vector a(Vector vector) throws SSLFTPCertificateException {
        Vector<SSLFTPCertificate> vector2 = new Vector<SSLFTPCertificate>();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            X509Cert x509Cert = (X509Cert)vector.elementAt(i2);
            vector2.add(new SSLFTPCertificate(x509Cert));
        }
        return vector2;
    }

    public SSLFTPCipherSuite[] getEnabledCipherSuites() {
        short[] sArray = this.a.getPolicy().getCipherSuites();
        SSLFTPCipherSuite[] sSLFTPCipherSuiteArray = new SSLFTPCipherSuite[sArray.length];
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            sSLFTPCipherSuiteArray[i2] = SSLFTPCipherSuite.getCipherSuite(sArray[i2]);
        }
        return sSLFTPCipherSuiteArray;
    }

    public void disableAllCipherSuites() throws FTPException {
        this.checkConnection(false);
        e.debug("Disabled all cipher-suites");
        this.a.getPolicy().setCipherSuites(new short[0]);
    }

    public void enableCipherSuite(SSLFTPCipherSuite cipherSuite) throws FTPException {
        this.checkConnection(false);
        short[] sArray = this.a.getPolicy().getCipherSuites();
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (sArray[i2] != cipherSuite.getCode()) continue;
            return;
        }
        short[] sArray2 = new short[sArray.length + 1];
        for (int i3 = 0; i3 < sArray.length; ++i3) {
            sArray2[i3] = sArray[i3];
        }
        sArray2[sArray.length] = cipherSuite.getCode();
        this.a.getPolicy().setCipherSuites(sArray2);
        try {
            e.debug("Enabled cipher-suite " + cipherSuite.getName());
        }
        catch (SSLException sSLException) {
            SSLDebug.debug(16, "No such algorithm" + cipherSuite);
        }
    }

    public void enableCipherSuites(SSLFTPCipherSuite[] cipherSuites) throws FTPException {
        int n2;
        this.checkConnection(false);
        short[] sArray = this.a.getPolicy().getCipherSuites();
        ArrayList<SSLFTPCipherSuite> arrayList = new ArrayList<SSLFTPCipherSuite>();
        for (int i2 = 0; i2 < cipherSuites.length; ++i2) {
            n2 = 0;
            int n3 = 0;
            while (i2 < sArray.length) {
                if (sArray[n3] == cipherSuites[i2].getCode()) {
                    n2 = 1;
                    try {
                        e.debug(cipherSuites[i2].getName() + " already enabled");
                    }
                    catch (SSLException sSLException) {
                        SSLDebug.debug(16, "No such algorithm" + cipherSuites[i2]);
                    }
                    break;
                }
                ++n3;
            }
            if (n2 != 0) continue;
            arrayList.add(cipherSuites[i2]);
        }
        if (arrayList.size() > 0) {
            short[] sArray2 = new short[sArray.length + arrayList.size()];
            for (n2 = 0; n2 < sArray.length; ++n2) {
                sArray2[n2] = sArray[n2];
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                SSLFTPCipherSuite sSLFTPCipherSuite = (SSLFTPCipherSuite)arrayList.get(n2);
                sArray2[sArray.length + n2] = sSLFTPCipherSuite.getCode();
                try {
                    e.debug("Enabling " + cipherSuites[n2].getName());
                    continue;
                }
                catch (SSLException sSLException) {
                    SSLDebug.debug(16, "No such algorithm" + cipherSuites[n2]);
                }
            }
            this.a.getPolicy().setCipherSuites(sArray2);
        }
    }

    public void loadClientKeyFile(InputStream inputStream, String password) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.a.loadEAYKeyFile(inputStream, password);
        e.debug("Loaded client key from input-stream.");
    }

    public void loadClientKeyFile(String path, String password) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.a.loadEAYKeyFile(path, password);
        e.debug("Loaded client key file " + path);
    }

    public void loadClientCertificate(InputStream inputStream, String password) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.a.loadEAYKeyFile(inputStream, password);
        e.debug("Loaded client key from input-stream.");
    }

    public void loadClientCertificate(String path, String password) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.a.loadEAYKeyFile(path, password);
        e.debug("Loaded client key file " + path);
    }

    public void setClientCertificate(Certificate certificate, PrivateKey privateKey) throws SSLFTPCertificateException {
        try {
            if (certificate == null) {
                throw new NullPointerException("Certificate argument is null");
            }
            if (privateKey == null) {
                throw new NullPointerException("Private key argument is null");
            }
            this.a.setClientCertPrivKey(new Certificate[]{certificate}, privateKey);
        }
        catch (Exception exception) {
            throw new SSLFTPCertificateException(exception.getMessage());
        }
    }

    public void loadRootCertificates(InputStream inputStream) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.b.importPEMFile(inputStream);
        e.debug("Loaded root certificates from InputStream");
    }

    public void loadRootCertificates(String path) throws IOException, FTPException {
        this.checkConnection(false);
        this.b.importPEMFile(path);
        e.debug("Loaded root certificates from " + path);
    }

    public SSLFTPCertificateStore getRootCertificateStore() {
        return this.b;
    }

    public void setRootCertificateStore(SSLFTPCertificateStore store) {
        this.a(store);
    }

    public void auth(String securityMechanism) throws IOException, FTPException {
        this.checkConnection(true);
        this.i = securityMechanism;
        try {
            if (this.d) {
                throw new SSLFTPException("The AUTH command cannot be used with implicit FTPS.");
            }
            if (!(securityMechanism.equals(AUTH_TLS) || securityMechanism.equals(AUTH_TLS_C) || securityMechanism.equals(AUTH_SSL))) {
                throw new FTPException("Only TLS, TLS-C, and SSL are valid arguments for the AUTH command.");
            }
            this.lastReply = this.control.sendCommand("AUTH " + securityMechanism);
            String[] stringArray = new String[]{"234", "334", "200"};
            try {
                this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
            }
            catch (FTPException fTPException) {
                String string = AUTH_SSL;
                if (securityMechanism.equals(AUTH_SSL)) {
                    string = AUTH_TLS;
                }
                e.debug("AUTH " + securityMechanism + " failed. Trying " + string + " (" + fTPException.getMessage() + ")");
                this.lastReply = this.control.sendCommand("AUTH " + string);
                this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
            }
            SSLFTPControlSocket sSLFTPControlSocket = (SSLFTPControlSocket)this.control;
            sSLFTPControlSocket.c();
            if ((this.c & 0x10) == 0) {
                this.pbsz(0);
                this.prot('P');
            }
        }
        catch (SSLFTPCertificateException sSLFTPCertificateException) {
            try {
                e.debug("Forcing disconnect");
                this.quitImmediately();
            }
            catch (Throwable throwable) {
                e.debug("Expected error during disconnect: " + throwable.getMessage());
            }
            throw sSLFTPCertificateException;
        }
    }

    public void ccc() throws FTPException, IOException {
        this.checkConnection(true);
        SSLFTPControlSocket sSLFTPControlSocket = (SSLFTPControlSocket)this.control;
        if (!sSLFTPControlSocket.e()) {
            throw new FTPException("Must issue \"AUTH\" command before issuing \"CCC\" command.");
        }
        if (this.d) {
            e.warn("\"CCC\" should only be used with explicit FTPS.");
        }
        this.lastReply = this.control.sendCommand("CCC");
        String[] stringArray = new String[]{"200"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
        sSLFTPControlSocket.shutdownSSL();
    }

    public void auth(char command) throws IOException, FTPException {
        this.checkConnection(true);
        if (!this.d) {
            throw new SSLFTPException("This version of auth() can be used with implicit FTPS only.");
        }
        this.pbsz(0);
        this.prot(command);
    }

    public void prot(char command) throws IOException, FTPException {
        this.checkConnection(true);
        SSLFTPControlSocket sSLFTPControlSocket = (SSLFTPControlSocket)this.control;
        if (!sSLFTPControlSocket.e()) {
            throw new FTPException("Must issue \"AUTH\" command or use implicit SSL before issuing \"PROT\" command.");
        }
        switch (command) {
            case 'C': 
            case 'P': {
                this.lastReply = this.control.sendCommand("PROT " + command);
                String[] stringArray = new String[]{"200"};
                this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
                sSLFTPControlSocket.c(command == 'P');
                break;
            }
            default: {
                throw new FTPException("Only 'C' and 'P' are valid arguments for the PROT command.");
            }
        }
    }

    public void pbsz(int bufferSize) throws IOException, FTPException {
        this.checkConnection(true);
        SSLFTPControlSocket sSLFTPControlSocket = (SSLFTPControlSocket)this.control;
        if (!sSLFTPControlSocket.e()) {
            throw new FTPException("Must issue \"AUTH\" command or use implicit SSL before issuing \"PBSZ\" command.");
        }
        if (bufferSize != 0) {
            throw new FTPException("The buffer-size defined by the PBSZ command must be 0.");
        }
        this.lastReply = this.control.sendCommand("PBSZ " + bufferSize);
        String[] stringArray = new String[]{"200", "235"};
        this.lastValidReply = this.control.validateReply(this.lastReply, stringArray);
    }

    public static SSLFTPCertificate getServerCertificate(String hostName) throws FTPException, IOException {
        return SSLFTPClient.getServerCertificate(hostName, 21);
    }

    public static SSLFTPCertificate getServerCertificate(String hostName, int remotePort) throws FTPException, IOException {
        return SSLFTPClient.getServerCertificate(hostName, 21, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SSLFTPCertificate getServerCertificate(String hostName, int remotePort, boolean isImplicit) throws FTPException, IOException {
        SSLFTPCertificate sSLFTPCertificate;
        SSLFTPClient sSLFTPClient = new SSLFTPClient();
        try {
            try {
                sSLFTPClient.setRemoteHost(hostName);
                sSLFTPClient.setRemotePort(remotePort);
                sSLFTPClient.setValidateServer(true);
                sSLFTPClient.setImplicitFTPS(isImplicit);
                sSLFTPClient.connect();
                sSLFTPClient.auth(AUTH_TLS);
                sSLFTPClient.quit();
                sSLFTPCertificate = null;
                Object var8_6 = null;
            }
            catch (SSLFTPCertificateException sSLFTPCertificateException) {
                Vector vector = sSLFTPCertificateException.getCertificates();
                SSLFTPCertificate sSLFTPCertificate2 = vector != null ? (vector.size() > 0 ? (SSLFTPCertificate)vector.lastElement() : null) : null;
                Object var8_7 = null;
                try {
                    sSLFTPClient.quitImmediately();
                    return sSLFTPCertificate2;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return sSLFTPCertificate2;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {}
            catch (Throwable throwable2) {
                throw throwable;
            }
            sSLFTPClient.quitImmediately();
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {
            // empty catch block
            return sSLFTPCertificate;
        }
        sSLFTPClient.quitImmediately();
        return sSLFTPCertificate;
    }

    public static String getServerSecurityMechanism(String remoteHost) throws FTPException, IOException {
        return SSLFTPClient.getServerSecurityMechanism(remoteHost, 21);
    }

    public static String getServerSecurityMechanism(String remoteHost, int remotePort) throws FTPException, IOException {
        SSLFTPClient sSLFTPClient = new SSLFTPClient();
        sSLFTPClient.setRemoteHost(remoteHost);
        sSLFTPClient.setRemotePort(remotePort);
        sSLFTPClient.connect();
        String[] stringArray = new String[]{AUTH_TLS, AUTH_SSL};
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            FTPReply fTPReply = sSLFTPClient.control.sendCommand("AUTH " + stringArray[i2]);
            if (!fTPReply.getReplyCode().equals("234") && !fTPReply.getReplyCode().equals("334") && !fTPReply.getReplyCode().equals("200")) continue;
            sSLFTPClient.control.logout();
            return stringArray[i2];
        }
        sSLFTPClient.control.logout();
        return null;
    }

    public boolean isImplicitFTPS() {
        return this.d;
    }

    public void setImplicitFTPS(boolean implicitFTPS) {
        this.d = implicitFTPS;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("FTPS").append(",").append(this.remoteHost).append(",").append(this.controlPort).append(",").append(this.getId()).append("]");
        return stringBuffer.toString();
    }

    static SSLContext a(SSLFTPClient sSLFTPClient) {
        return sSLFTPClient.a;
    }

    static Vector a(SSLFTPClient sSLFTPClient, Vector vector) throws SSLFTPCertificateException {
        return sSLFTPClient.a(vector);
    }

    static SSLFTPValidator b(SSLFTPClient sSLFTPClient) {
        return sSLFTPClient.f;
    }

    static Logger a() {
        return e;
    }

    static {
        e.info("edtFTPj - PRO version");
    }

    public static class ConfigFlags {
        public static final int DISABLE_CONTROL_SSL_CLOSURE = 1;
        public static final int DISABLE_DATA_SSL_CLOSURE = 2;
        public static final int DISABLE_SSL_CLOSURE = 3;
        public static final int DISABLE_CONTROL_WAIT_ON_CLOSE = 4;
        public static final int DISABLE_DATA_WAIT_ON_CLOSE = 8;
        public static final int DISABLE_WAIT_ON_CLOSE = 12;
        public static final int START_WITH_CLEAR_DATA_CHANNELS = 16;
        public static final int IMPLICIT_FTPS = 32;
        public static final int ALLOW_BASIC_CONSTRAINTS_IN_NON_CA = 64;
        public static final int DISABLE_SESSION_RESUMPTION = 128;
    }
}

