/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssh;

import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTypes;
import com.enterprisedt.net.ftp.RecursiveOperations;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.net.ftp.WildcardFilter;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.ssh.SCPClient;
import com.enterprisedt.net.ftp.ssh.SSHFTPPublicKey;
import com.enterprisedt.net.ftp.ssh.a;
import com.enterprisedt.net.ftp.ssh.c;
import com.enterprisedt.net.j2ssh.FileTransferProgress;
import com.enterprisedt.net.j2ssh.SftpClient;
import com.enterprisedt.net.j2ssh.SshClient;
import com.enterprisedt.net.j2ssh.sftp.FileAttributes;
import com.enterprisedt.net.j2ssh.sftp.SftpFile;
import com.enterprisedt.util.PathUtils;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SSHFTPClient
extends SCPClient
implements ProFTPClientInterface {
    private static Logger c = Logger.getLogger("SSHFTPClient");
    public static final String DEFAULT_ENCODING = "US-ASCII";
    public static final String EOL_CRLF = "\r\n";
    public static final String EOL_LF = "\n";
    private c d = new c();
    private FTPProgressMonitorEx e = null;
    private SftpClient f = null;
    private FTPTransferType g = FTPTransferType.BINARY;
    private RecursiveOperations h = new RecursiveOperations();
    private boolean i = true;
    private int j = 32648;
    private int k = SftpClient.DEFAULT_BLOCKSIZE;
    private boolean l = false;
    private long m = 0L;
    private int n = 0;
    private String o = "UTF-8";
    private String p;
    private long q = 60000L;
    private String r = null;
    private int s = -1;
    private boolean t = true;
    private boolean u = true;
    static Class b;

    public SSHFTPClient() {
        this.a(this.ssh);
        c.debug("Created SFTP client.");
    }

    public void setConfigFlags(int configFlags) throws FTPException {
        this.checkConnection(false);
        this.n = configFlags;
    }

    public int getConfigFlags() {
        return this.n;
    }

    public boolean isParallelMode() {
        return this.t;
    }

    public void setParallelMode(boolean parallelWriteMode) {
        this.t = parallelWriteMode;
        if (this.f != null) {
            this.f.setParallelMode(parallelWriteMode);
        }
    }

    public boolean checkDirReadableForChDir() {
        return this.u;
    }

    public void setCheckDirReadableForChDir(boolean checkDirReadableForChDir) {
        this.u = checkDirReadableForChDir;
        if (this.f != null) {
            this.f.setCheckDirReadableForChDir(checkDirReadableForChDir);
        }
    }

    public void setMaxTransferRate(int thresholdBytesPerSecond) {
        this.s = thresholdBytesPerSecond;
        if (this.f != null) {
            this.f.setMaxTransferRate(thresholdBytesPerSecond);
        }
    }

    public int getMaxTransferRate() {
        return this.s;
    }

    public long getServerResponseTimeout() {
        return this.q;
    }

    public void setServerResponseTimeout(long serverResponseTimeout) throws FTPException {
        this.setTimeout((int)serverResponseTimeout);
    }

    public void setControlEncoding(String controlEncoding) throws FTPException {
        this.checkConnection(false);
        this.o = controlEncoding;
    }

    public static SSHFTPPublicKey getHostPublicKey(String remoteHost) throws FTPException {
        return SSHFTPClient.getHostPublicKey(remoteHost, 22);
    }

    public static SSHFTPPublicKey getHostPublicKey(String remoteHost, int remotePort) throws FTPException {
        SSHFTPClient sSHFTPClient = new SSHFTPClient();
        sSHFTPClient.setRemoteHost(remoteHost);
        sSHFTPClient.setRemotePort(remotePort);
        sSHFTPClient.setAuthentication("", "");
        try {
            sSHFTPClient.connect();
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(b == null ? (b = SSHFTPClient.class$("com.enterprisedt.net.ftp.ssh.SSHFTPClient")) : b);
            logger.debug("Expected exception", exception);
        }
        return sSHFTPClient.getValidator().getHostPublicKey();
    }

    public void setTimeout(int millis) throws FTPException {
        this.checkConnection(false);
        this.q = millis;
        this.ssh.setSocketTimeout(millis);
    }

    public void setDetectTransferMode(boolean detectTransferMode) {
        this.i = detectTransferMode;
    }

    public boolean getDetectTransferMode() {
        return this.i;
    }

    public int getMaxPacketSize() {
        return this.j;
    }

    public void setMaxPacketSize(int maxPacketSize) throws FTPException {
        this.checkConnection(false);
        this.j = maxPacketSize;
        this.ssh.setMaxPacketSize(maxPacketSize);
    }

    public void setTransferBufferSize(int size) {
        this.k = size;
    }

    public int getTransferBufferSize() {
        return this.k;
    }

    public void setRemoteEOL(String remoteEOL) {
        this.p = remoteEOL;
        c.debug("Setting remote EOL manually");
    }

    public String getRemoteEOL() {
        return this.p;
    }

    public FTPTransferType getType() {
        return this.g;
    }

    public void setType(FTPTransferType type) {
        this.g = type;
        if (this.f != null) {
            this.f.setType(this.g);
            this.f.setRemoteEOL(this.p != null ? this.p : this.ssh.getRemoteEOLString());
        }
    }

    public String getSFTPSubsystemPath() {
        return this.r;
    }

    SftpClient a() {
        return this.f;
    }

    public void setSFTPSubsystemPath(String sftpSubsystemPath) {
        this.r = sftpSubsystemPath;
    }

    public void resumeNextDownload(long offset) throws FTPException {
        this.resume();
        if (offset < 0L) {
            throw new FTPException("Offset must be >= 0");
        }
        this.m = offset;
    }

    public void resume() throws FTPException {
        if (this.g.equals(FTPTransferType.ASCII)) {
            throw new FTPException("Resume only supported for BINARY transfers");
        }
        this.l = true;
    }

    public void cancelResume() throws IOException, FTPException {
        this.l = false;
    }

    public void cancelTransfer() {
        c.debug("cancelTransfer() called");
        this.d.c();
    }

    public boolean isTransferCancelled() {
        return this.d.isCancelled();
    }

    public void connect() throws IOException, FTPException {
        this.checkConnection(false);
        this.connectSSH();
        int n2 = 0;
        if ((this.n & ConfigFlags.DISABLE_CHMOD_AFTER_PUT) != 0) {
            n2 |= 1;
        }
        if ((this.n & ConfigFlags.DISABLE_WAIT_FOR_CHANNEL_CLOSE) != 0) {
            n2 |= 2;
        }
        if ((this.n & ConfigFlags.DISABLE_CHMOD_AFTER_CREATE_DIR) != 0) {
            n2 |= 4;
        }
        this.f = this.ssh.openSftpClient(this.r, n2);
        this.f.setType(this.g);
        this.f.setRemoteEOL(this.p != null ? this.p : this.ssh.getRemoteEOLString());
        this.f.setBlockSize(this.k);
        this.f.setControlEncoding(this.o);
        this.f.setServerResponseTimeout(this.q);
        this.f.setMaxTransferRate(this.s);
        this.f.setParallelMode(this.t);
        this.f.setCheckDirReadableForChDir(this.u);
    }

    public String getDetectedRemoteEOL() {
        return this.ssh.getRemoteEOLString();
    }

    public boolean connected() {
        return this.f == null ? false : !this.f.isClosed();
    }

    public void setProgressMonitor(FTPProgressMonitor monitor, long interval) {
        this.d.a(monitor);
        this.d.a(interval);
    }

    public void setProgressMonitor(FTPProgressMonitor monitor) {
        this.d.a(monitor);
    }

    public long getMonitorInterval() {
        return this.d.b();
    }

    public void setMonitorInterval(long interval) {
        this.d.a(interval);
    }

    public FTPProgressMonitor getProgressMonitor() {
        return this.d.a();
    }

    public FTPProgressMonitorEx getProgressMonitorEx() {
        return this.e;
    }

    public void setProgressMonitorEx(FTPProgressMonitorEx monitorEx) {
        this.e = monitorEx;
        if (this.d.a() == null) {
            this.d.a(monitorEx);
        }
    }

    public long size(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        return this.f.stat(remoteFile).getSize().longValue();
    }

    private void a(String string) throws FTPException {
        if (string == null) {
            throw new FTPException("A remote filename must be supplied for this protocol (SFTP)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String localPath, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.g;
        this.d(localPath);
        if (this.e != null) {
            this.e.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        try {
            this.f.put(localPath, remoteFile, (FileTransferProgress)this.d, false, this.l);
            Object var5_4 = null;
            this.g = fTPTransferType;
            this.l = false;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.g = fTPTransferType;
            this.l = false;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
            throw throwable;
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String localPath, String remoteFile, boolean append) throws IOException, FTPException {
        this.checkConnection(true);
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.g;
        this.d(localPath);
        if (this.e != null) {
            this.e.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        try {
            this.f.put(localPath, remoteFile, (FileTransferProgress)this.d, append, this.l);
            Object var6_5 = null;
            this.g = fTPTransferType;
            this.l = false;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.g = fTPTransferType;
            this.l = false;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
            throw throwable;
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(InputStream srcStream, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.g;
        this.d(remoteFile);
        if (this.e != null) {
            this.e.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        try {
            this.f.put(srcStream, remoteFile, (FileTransferProgress)this.d, false, this.l);
            ++this.uploadCount;
            Object var5_4 = null;
            this.g = fTPTransferType;
            this.l = false;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.g = fTPTransferType;
            this.l = false;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
            throw throwable;
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(InputStream srcStream, String remoteFile, boolean append) throws IOException, FTPException {
        this.checkConnection(true);
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.g;
        this.d(remoteFile);
        if (this.e != null) {
            this.e.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        try {
            this.f.put(srcStream, remoteFile, (FileTransferProgress)this.d, append, this.l);
            ++this.uploadCount;
            Object var6_5 = null;
            this.g = fTPTransferType;
            this.l = false;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.g = fTPTransferType;
            this.l = false;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
            throw throwable;
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(byte[] bytes, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.a(remoteFile);
        FTPTransferType fTPTransferType = this.g;
        this.d(remoteFile);
        if (this.e != null) {
            this.e.transferStarted(TransferDirection.UPLOAD, remoteFile);
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            this.f.put(byteArrayInputStream, remoteFile, (FileTransferProgress)this.d, false, this.l);
            ++this.uploadCount;
            ((InputStream)byteArrayInputStream).close();
            Object var6_5 = null;
            this.g = fTPTransferType;
            this.l = false;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.g = fTPTransferType;
            this.l = false;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
            throw throwable;
        }
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(byte[] bytes, String remoteFile, boolean append) throws IOException, FTPException {
        ByteArrayInputStream byteArrayInputStream;
        block7: {
            this.checkConnection(true);
            this.a(remoteFile);
            FTPTransferType fTPTransferType = this.g;
            this.d(remoteFile);
            if (this.e != null) {
                this.e.transferStarted(TransferDirection.UPLOAD, remoteFile);
            }
            byteArrayInputStream = null;
            try {
                byteArrayInputStream = new ByteArrayInputStream(bytes);
                this.f.put(byteArrayInputStream, remoteFile, (FileTransferProgress)this.d, append, this.l);
                ++this.uploadCount;
                Object var7_6 = null;
                this.g = fTPTransferType;
                this.l = false;
                if (this.e == null) break block7;
                this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.g = fTPTransferType;
                this.l = false;
                if (this.e != null) {
                    this.e.transferComplete(TransferDirection.UPLOAD, remoteFile);
                }
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            ((InputStream)byteArrayInputStream).close();
        }
        catch (IOException iOException) {}
        return remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String localPath, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        File file = new File(localPath);
        if (file.isDirectory()) {
            localPath = localPath + File.separator + remoteFile;
            c.debug("Setting local path to " + localPath);
        }
        FTPTransferType fTPTransferType = this.g;
        this.d(remoteFile);
        if (this.e != null) {
            this.e.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
        }
        try {
            this.f.get(remoteFile, localPath, this.d, this.l, this.m);
            ++this.downloadCount;
            Object var6_5 = null;
            this.g = fTPTransferType;
            this.l = false;
            this.m = 0L;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.g = fTPTransferType;
            this.l = false;
            this.m = 0L;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(OutputStream destStream, String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.g;
        this.d(remoteFile);
        if (this.e != null) {
            this.e.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
        }
        try {
            if (this.l && this.m != 0L) {
                c.debug("Resume marker set to: " + this.m);
            }
            this.f.get(remoteFile, destStream, this.d, this.m);
            ++this.downloadCount;
            Object var5_4 = null;
            this.g = fTPTransferType;
            this.l = false;
            this.m = 0L;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.g = fTPTransferType;
            this.l = false;
            this.m = 0L;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        FTPTransferType fTPTransferType = this.g;
        this.d(remoteFile);
        try {
            long l2 = this.size(remoteFile);
            c.debug("Size=" + l2);
            if (this.l && this.m != 0L) {
                c.debug("Resume marker set to: " + this.m);
                l2 -= this.m;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)l2);
            if (this.e != null) {
                this.e.transferStarted(TransferDirection.DOWNLOAD, remoteFile);
            }
            this.f.get(remoteFile, byteArrayOutputStream, this.d, this.m);
            ++this.downloadCount;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = null;
            byte[] byArray2 = byArray;
            Object var9_7 = null;
            this.g = fTPTransferType;
            this.l = false;
            this.m = 0L;
            if (this.e != null) {
                this.e.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            block5: {
                Object var9_8 = null;
                this.g = fTPTransferType;
                this.l = false;
                this.m = 0L;
                if (this.e == null) break block5;
                this.e.transferComplete(TransferDirection.DOWNLOAD, remoteFile);
            }
            throw throwable;
        }
    }

    public FTPFile fileDetails(String name) throws IOException, FTPException {
        String string = this.f.getAbsolutePath(name);
        FileAttributes fileAttributes = this.f.stat(string);
        SftpFile sftpFile = new SftpFile(string, fileAttributes);
        return this.a(sftpFile);
    }

    public void dirDetails(String dirname, DirectoryListCallback lister) throws IOException, FTPException, ParseException {
        this.checkConnection(true);
        this.a(dirname, lister);
    }

    public FTPFile[] dirDetails(String dirname) throws IOException, FTPException, ParseException {
        this.checkConnection(true);
        List list = this.b(dirname);
        FTPFile[] fTPFileArray = new FTPFile[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SftpFile sftpFile = (SftpFile)list.get(i2);
            fTPFileArray[i2] = this.a(sftpFile);
        }
        return fTPFileArray;
    }

    private FTPFile a(SftpFile sftpFile) {
        FileAttributes fileAttributes = sftpFile.getAttributes();
        Date date = new Date(fileAttributes.getModifiedTime().longValue() * 1000L);
        FTPFile fTPFile = new FTPFile(sftpFile.getLongname(), sftpFile.getFilename(), fileAttributes.getSize().longValue(), fileAttributes.isDirectory(), date);
        fTPFile.setOwner(fileAttributes.getUID().toString());
        fTPFile.setGroup(fileAttributes.getGID().toString());
        fTPFile.setPath(PathUtils.getDirectoryName(sftpFile.getAbsolutePath()));
        fTPFile.setPermissions(fileAttributes.getPermissionsString());
        fTPFile.setLink(fileAttributes.isLink());
        if (fileAttributes.isLink()) {
            try {
                String string = this.f.getSymbolicLinkTarget(sftpFile.getAbsolutePath());
                fTPFile.setLinkedName(string);
            }
            catch (Exception exception) {
                c.warn("Failed to get link target for '" + sftpFile.getFilename() + "'");
            }
        }
        return fTPFile;
    }

    public String[] dir() throws IOException, FTPException {
        return this.dir(".");
    }

    public String[] dir(String dirname) throws IOException, FTPException {
        return this.dir(dirname, false);
    }

    public String[] dir(String dirname, boolean full) throws IOException, FTPException {
        this.checkConnection(true);
        List list = this.b(dirname);
        String[] stringArray = new String[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SftpFile sftpFile = (SftpFile)list.get(i2);
            stringArray[i2] = full ? sftpFile.getLongname() : sftpFile.getFilename();
        }
        return stringArray;
    }

    private List b(String string) throws IOException, FTPException {
        c.debug("getFileListing('" + string + "'");
        List<SftpFile> list = new ArrayList();
        if (this.c(string)) {
            String string2 = string;
            String string3 = "";
            int n2 = -1;
            n2 = string.lastIndexOf(47);
            if (n2 > 0 && n2 < string.length()) {
                string2 = string.substring(n2 + 1);
                string3 = string.substring(0, n2);
            }
            WildcardFilter wildcardFilter = new WildcardFilter(string2);
            list = this.f.ls(string3, wildcardFilter);
        } else {
            try {
                list = this.f.ls(string, null);
            }
            catch (FTPException fTPException) {
                String string4 = this.f.getAbsolutePath(string);
                FileAttributes fileAttributes = this.f.stat(string4);
                if (!fileAttributes.isFile()) {
                    throw fTPException;
                }
                SftpFile sftpFile = new SftpFile(string4, fileAttributes);
                list.add(sftpFile);
            }
        }
        return list;
    }

    private void a(String string, DirectoryListCallback directoryListCallback) throws IOException, FTPException {
        a a2 = new a(directoryListCallback);
        if (this.c(string)) {
            String string2 = string;
            String string3 = "";
            int n2 = -1;
            n2 = string.lastIndexOf(47);
            if (n2 > 0 && n2 < string.length()) {
                string2 = string.substring(n2 + 1);
                string3 = string.substring(0, n2);
            }
            WildcardFilter wildcardFilter = new WildcardFilter(string2);
            this.f.ls(string3, wildcardFilter, a2);
        } else {
            try {
                this.f.ls(string, null, a2);
            }
            catch (Exception exception) {
                String string4 = this.f.getAbsolutePath(string);
                FileAttributes fileAttributes = this.f.stat(string4);
                SftpFile sftpFile = new SftpFile(string4, fileAttributes);
                a2.listDirectoryEntry(sftpFile);
            }
        }
    }

    private boolean c(String string) {
        for (int i2 = 0; i2 < WildcardFilter.WILDCARD_CHARS.length; ++i2) {
            if (string.indexOf(WildcardFilter.WILDCARD_CHARS[i2]) < 0) continue;
            return true;
        }
        return false;
    }

    public void delete(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        this.f.removeFile(remoteFile);
        ++this.deleteCount;
    }

    public void rename(String from, String to) throws IOException, FTPException {
        this.checkConnection(true);
        this.f.rename(from, to);
    }

    public boolean exists(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        try {
            this.f.stat(remoteFile);
            return true;
        }
        catch (FTPException fTPException) {
            if (fTPException.getReplyCode() == 2) {
                return false;
            }
            throw fTPException;
        }
    }

    public void rmdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        FileAttributes fileAttributes = this.f.stat(dir);
        if (!fileAttributes.isDirectory()) {
            throw new FTPException(dir + " is not a directory.");
        }
        List list = this.f.ls(dir, null);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SftpFile sftpFile = (SftpFile)list.get(i2);
            if (sftpFile.getFilename().equals(".") || sftpFile.getFilename().equals("..")) continue;
            throw new FTPException("Directory " + dir + " is not empty");
        }
        this.f.rm(dir);
    }

    public void mkdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.f.mkdir(dir);
    }

    public void changeMode(int permissions, String path) throws IOException, FTPException {
        this.checkConnection(true);
        this.f.chmod(permissions, path);
    }

    public void changeMode(String permissions, String path) throws IOException, FTPException {
        this.checkConnection(true);
        this.f.chmod(Integer.parseInt(permissions, 8), path);
    }

    public void changeGroup(int gid, String path) throws IOException, FTPException {
        this.checkConnection(true);
        this.f.chgrp(gid, path);
    }

    public void changeOwner(int uid, String path) throws IOException, FTPException {
        this.checkConnection(true);
        this.f.chown(uid, path);
    }

    public void setUmask(String umask) throws FTPException {
        this.checkConnection(true);
        this.f.setUmask(umask);
    }

    public String getUmask() throws FTPException {
        this.checkConnection(true);
        return this.f.getUmask();
    }

    public void chdir(String dir) throws IOException, FTPException {
        this.checkConnection(true);
        this.f.cd(dir);
    }

    public void cdup() throws IOException, FTPException {
        this.checkConnection(true);
        this.f.cd("..");
    }

    public Date modtime(String remoteFile) throws IOException, FTPException {
        this.checkConnection(true);
        return this.f.getModTime(remoteFile);
    }

    public void setModTime(String path, Date modTime) throws IOException, FTPException {
        this.checkConnection(true);
        this.f.setModTime(path, modTime);
    }

    public String pwd() throws IOException, FTPException {
        this.checkConnection(true);
        return this.f.pwd();
    }

    public void mdelete(String wildcard) throws IOException, FTPException, ParseException {
        this.h.deleteFilesCurrentDir(this, new WildcardFilter(wildcard));
    }

    public void mdelete(FileFilter filter) throws IOException, FTPException, ParseException {
        this.h.deleteFilesCurrentDir(this, filter);
    }

    public void mdelete(String remoteDir, String wildcard, boolean recurse) throws IOException, FTPException, ParseException {
        this.h.deleteFiles(this, remoteDir, new WildcardFilter(wildcard), recurse);
    }

    public void mdelete(String remoteDir, FileFilter filter, boolean recurse) throws IOException, FTPException, ParseException {
        this.h.deleteFiles(this, remoteDir, filter, recurse);
    }

    public void rmdir(String remoteDir, boolean recurse) throws IOException, FTPException, ParseException {
        if (!recurse) {
            this.rmdir(remoteDir);
        } else {
            this.h.delete(this, remoteDir);
        }
    }

    public void mput(String localDir, String wildcard) throws IOException, FTPException {
        this.h.putFilesIntoCurrentDir(this, localDir, new WildcardFilter(wildcard));
    }

    public void mput(String localDir, FileFilter filter) throws IOException, FTPException {
        this.h.putFilesIntoCurrentDir(this, localDir, filter);
    }

    public void mput(String localDir, String remoteDir, String wildcard, boolean recurse) throws FTPException, IOException {
        this.h.put(this, localDir, remoteDir, new WildcardFilter(wildcard), recurse);
    }

    public void mput(String localDir, String remoteDir, FileFilter filter, boolean recurse) throws FTPException, IOException {
        this.h.put(this, localDir, remoteDir, filter, recurse);
    }

    public void mget(String localDir, String wildcard) throws IOException, FTPException, ParseException {
        this.h.getFilesFromCurrentDir(this, localDir, new WildcardFilter(wildcard));
    }

    public void mget(String localDir, FileFilter filter) throws IOException, FTPException, ParseException {
        this.h.getFilesFromCurrentDir(this, localDir, filter);
    }

    public void mget(String localDir, String remoteDir, String wildcard, boolean recurse) throws FTPException, IOException, ParseException {
        this.h.get(this, localDir, remoteDir, new WildcardFilter(wildcard), recurse);
    }

    public void mget(String localDir, String remoteDir, FileFilter filter, boolean recurse) throws FTPException, IOException, ParseException {
        this.h.get(this, localDir, remoteDir, filter, recurse);
    }

    public int getCountBeforeSleep() {
        return this.h.getCountBeforeSleep();
    }

    public void setCountBeforeSleep(int countBeforeSleep) {
        this.h.setCountBeforeSleep(countBeforeSleep);
    }

    public boolean isSleepEnabled() {
        return this.h.isSleepEnabled();
    }

    public void setSleepEnabled(boolean sleepEnabled) {
        this.h.setSleepEnabled(sleepEnabled);
    }

    public int getSleepTime() {
        return this.h.getSleepTime();
    }

    public void setSleepTime(int sleepTime) {
        this.h.setSleepTime(sleepTime);
    }

    public void keepAlive() throws IOException, FTPException {
        c.debug("keepAlive() called - sending SSH_FXP_REALPATH");
        if (this.f != null) {
            this.f.getAbsolutePath(".");
        } else {
            c.warn("Could not send SSH_FXP_REALPATH for keepAlive()");
        }
    }

    public void quit() throws IOException, FTPException {
        this.checkConnection(true);
        this.f.quit();
        this.f = null;
        this.ssh.disconnect();
        this.ssh.close();
        this.ssh = new SshClient();
        this.a(this.ssh);
    }

    public void quitImmediately() throws IOException, FTPException {
        if (this.f != null) {
            this.f.quitImmediately();
            this.f = null;
        }
        this.ssh.disconnectImmediately();
        this.ssh.close();
        this.f = null;
        this.ssh = new SshClient();
        this.a(this.ssh);
    }

    private void a(SshClient sshClient) {
        this.ssh.setMaxPacketSize(this.j);
        this.ssh.setSocketTimeout((int)this.q);
    }

    private void d(String string) {
        if (this.i) {
            if (FileTypes.ASCII.matches(string) && this.g.equals(FTPTransferType.BINARY)) {
                this.g = FTPTransferType.ASCII;
                c.debug("Autodetect on - changed transfer type to ASCII");
            } else if (FileTypes.BINARY.matches(string) && this.g.equals(FTPTransferType.ASCII)) {
                this.g = FTPTransferType.BINARY;
                c.debug("Autodetect on - changed transfer type to binary");
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append("SFTP").append(",").append(this.getRemoteHost()).append(",").append(this.getRemotePort()).append(",").append(this.getId()).append("]");
        return stringBuffer.toString();
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static class ConfigFlags {
        public static int DISABLE_POST_CREATE_CHMOD = 1;
        public static int DISABLE_CHMOD_AFTER_PUT = 1;
        public static int DISABLE_WAIT_FOR_CHANNEL_CLOSE = 2;
        public static int DISABLE_CHMOD_AFTER_CREATE_DIR = 4;
    }
}

