/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.script;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.net.ftp.script.CommandResult;
import com.enterprisedt.net.ftp.script.ScriptCommandImpl;
import com.enterprisedt.net.ftp.script.ScriptEngine;
import com.enterprisedt.net.ftp.ssh.SCPClient;
import com.enterprisedt.net.ftp.ssh.SSHFTPClient;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;
import com.enterprisedt.net.ftp.ssl.SSLFTPStandardValidator;
import com.enterprisedt.util.StringUtils;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OpenCommand
extends ScriptCommandImpl {
    private static Logger a = Logger.getLogger("OpenCommand");
    private Map b = new HashMap();

    public OpenCommand() {
        this.setMustBeConnected(false);
        this.a();
    }

    public String helpMessage() {
        return "open - Opens the connection to the remote server. The user and password must already be set via the set command. Can also use 'connect'. If the remote host is not already set, it must be supplied here (and will override any previous setting for this connection attempt). The port number can also be optionally supplied (but the host must be provided). e.g. open edtmobile:21";
    }

    public CommandResult execute(ScriptEngine engine, ProFTPClientInterface ftp, String command, String args) throws IOException, FTPException {
        Object object;
        if (ftp != null && ftp.connected()) {
            String string = "Connection open - close before calling open";
            return new CommandResult(true, string, string);
        }
        String string = engine.getRemoteHost();
        int n2 = engine.getPort();
        if (args != null && args.length() > 0) {
            object = StringUtils.split(args, ':');
            string = object[0];
            if (((String[])object).length > 1) {
                try {
                    n2 = Integer.parseInt((String)object[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = "Could not determine port number: '" + args + "'";
                    return new CommandResult(true, string2, string2);
                }
            }
        }
        try {
            if (engine.getProtocol().equals(Protocol.SFTP)) {
                ftp = object = new SSHFTPClient();
                if (engine.getServerPublicKey() != null) {
                    ((SCPClient)object).getValidator().addKnownHost(string, engine.getServerPublicKey());
                }
                if (engine.getKnownHosts() != null) {
                    ((SCPClient)object).getValidator().loadKnownHosts(engine.getKnownHosts());
                }
                if (engine.getServerPublicKey() == null && engine.getKnownHosts() == null) {
                    ((SCPClient)object).getValidator().setHostValidationEnabled(false);
                }
                if (engine.getClientPrivateKey() != null) {
                    if (engine.getClientPrivateKeyPass() == null) {
                        String string3 = "Passphrase must be supplied for client private key";
                        return new CommandResult(true, string3, string3);
                    }
                    ((SCPClient)object).setAuthentication(engine.getClientPrivateKey(), engine.getUser(), engine.getClientPrivateKeyPass());
                } else {
                    ((SCPClient)object).setAuthentication(engine.getUser(), engine.getPassword());
                }
            } else {
                ftp = new SSLFTPClient();
                if (engine.getConfigFlags() != null) {
                    ((SSLFTPClient)ftp).setConfigFlags(this.a(engine.getConfigFlags()));
                } else {
                    ((SSLFTPClient)ftp).setConfigFlags(12);
                }
                ((FTPClient)ftp).setConnectMode(engine.getConnectMode());
                ((FTPClient)ftp).setMessageListener(engine.getMessageCollector());
                ((SSLFTPClient)ftp).setValidateServer(false);
                if (engine.getClientCertificate() != null) {
                    if (engine.getClientPassphrase() == null) {
                        object = "Password must be supplied for client certificate";
                        return new CommandResult(true, (String)object, (String)object);
                    }
                    try {
                        ((SSLFTPClient)ftp).loadClientCertificate(engine.getClientCertificate(), engine.getClientPassphrase());
                    }
                    catch (Exception exception) {
                        String string4 = "Failed to load client certificate: " + exception.getMessage();
                        return new CommandResult(true, string4, string4);
                    }
                }
                if (engine.getServerCertificate() != null) {
                    ((SSLFTPClient)ftp).setValidateServer(true);
                    try {
                        ((SSLFTPClient)ftp).getRootCertificateStore().importPEMFile(engine.getServerCertificate());
                    }
                    catch (Exception exception) {
                        String string5 = "Failed to load server/root certificate: " + exception.getMessage();
                        return new CommandResult(true, string5, string5);
                    }
                    if (engine.getIgnoreCommonName()) {
                        ((SSLFTPClient)ftp).setCustomValidator(new SSLFTPStandardValidator(false));
                    } else if (engine.getCommonName() != null) {
                        ((SSLFTPClient)ftp).setCustomValidator(new SSLFTPStandardValidator(engine.getCommonName()));
                    }
                }
                if (engine.getActiveLowPort() > 0 && engine.getActiveHighPort() > 0) {
                    ((FTPClient)ftp).setActivePortRange(engine.getActiveLowPort(), engine.getActiveHighPort());
                }
            }
            ftp.setRemoteHost(string);
            if (n2 > 0) {
                ftp.setRemotePort(n2);
            }
            ftp.setTimeout(engine.getTimeout() * 1000);
            if (engine.getProtocol().equals(Protocol.FTP)) {
                ftp.connect();
                ((FTPClient)ftp).login(engine.getUser(), engine.getPassword());
                if (engine.getAccountInfo() != null) {
                    ((FTPClient)ftp).account(engine.getAccountInfo());
                }
            } else if (engine.getProtocol().equals(Protocol.FTPS_EXPLICIT)) {
                ftp.connect();
                ((SSLFTPClient)ftp).auth("TLS");
                ((SSLFTPClient)ftp).login(engine.getUser(), engine.getPassword());
                if (engine.getAccountInfo() != null) {
                    ((SSLFTPClient)ftp).account(engine.getAccountInfo());
                }
            } else if (engine.getProtocol().equals(Protocol.FTPS_IMPLICIT)) {
                ((SSLFTPClient)ftp).setImplicitFTPS(true);
                ftp.connect();
                ((SSLFTPClient)ftp).login(engine.getUser(), engine.getPassword());
                if (engine.getAccountInfo() != null) {
                    ((SSLFTPClient)ftp).account(engine.getAccountInfo());
                }
            } else if (engine.getProtocol().equals(Protocol.SFTP)) {
                ((SSHFTPClient)ftp).connect();
            }
        }
        catch (Throwable throwable) {
            String string6 = "Failed to open connection to " + string + (n2 > 0 ? ":" + Integer.toString(n2) : "\n\r" + throwable.getMessage());
            return new CommandResult(true, string6, string6);
        }
        ftp.setType(FTPTransferType.BINARY);
        engine.setFtp((ProFTPClientInterface)ftp);
        object = "Opened connection to " + string + (n2 > 0 ? ":" + Integer.toString(n2) : "");
        return new CommandResult((String)object, (String)object);
    }

    private void a() {
        this.b.put("DISABLE_CONTROL_SSL_CLOSURE", new Integer(1));
        this.b.put("DISABLE_DATA_SSL_CLOSURE", new Integer(2));
        this.b.put("DISABLE_SSL_CLOSURE", new Integer(3));
        this.b.put("DISABLE_CONTROL_WAIT_ON_CLOSE", new Integer(4));
        this.b.put("DISABLE_DATA_WAIT_ON_CLOSE", new Integer(8));
        this.b.put("DISABLE_WAIT_ON_CLOSE", new Integer(12));
        this.b.put("START_WITH_CLEAR_DATA_CHANNELS", new Integer(16));
        this.b.put("IMPLICIT_FTPS", new Integer(32));
        this.b.put("ALLOW_BASIC_CONSTRAINTS_IN_NON_CA", new Integer(64));
        this.b.put("DISABLE_SESSION_RESUMPTION", new Integer(128));
    }

    private int a(String string) {
        String[] stringArray = StringUtils.split(string, '|');
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2].toUpperCase().trim();
            Integer n3 = (Integer)this.b.get(string2);
            if (n3 != null) {
                n2 |= n3.intValue();
                a.debug("Setting config flag = " + string2);
                continue;
            }
            a.warn("Failed to recognize config flag = " + string2);
        }
        return n2;
    }
}

