/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPClientFactory;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FileStatistics;
import com.enterprisedt.net.ftp.async.internal.ConnectionException;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.internal.EventAggregator;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class FTPConnectionPool {
    private static Logger a = Logger.getLogger("FTPConnectionPool");
    protected static int id = 0;
    protected SecureConnectionContext initialContext;
    protected Vector freeConnections = new Vector();
    protected Vector busyConnections = new Vector();
    protected FileStatistics stats = new FileStatistics();
    protected EventListener listener;
    protected int initialPoolSize = 1;
    protected int maxPoolSize = 3;
    private boolean b = false;

    public FTPConnectionPool(SecureConnectionContext initialContext) {
        this(initialContext, 1, 3);
    }

    public FTPConnectionPool(SecureConnectionContext initialContext, int initialPoolSize, int maxPoolSize) {
        this.initialContext = initialContext;
        this.maxPoolSize = maxPoolSize;
        this.initialPoolSize = initialPoolSize;
    }

    public synchronized EventListener getListener() {
        return this.listener;
    }

    public synchronized void setListener(EventListener listener) {
        this.listener = listener;
        Enumeration enumeration = this.freeConnections.elements();
        while (enumeration.hasMoreElements()) {
            FTPConnection fTPConnection = (FTPConnection)enumeration.nextElement();
            this.a(fTPConnection, listener);
        }
    }

    private void a(FTPConnection fTPConnection, EventListener eventListener) {
        fTPConnection.setListener(eventListener);
        ProFTPClientInterface proFTPClientInterface = fTPConnection.getClient();
        EventAggregator eventAggregator = new EventAggregator(eventListener);
        eventAggregator.setConnId(proFTPClientInterface.getId());
        if (proFTPClientInterface instanceof FTPClient) {
            ((FTPClient)((Object)proFTPClientInterface)).setMessageListener(eventAggregator);
        }
    }

    public synchronized void setConnectionContext(SecureConnectionContext context) {
        this.initialContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized FTPConnection createConnection() throws FTPException, IOException {
        ProFTPClientInterface proFTPClientInterface = this.createClientInstance();
        SecureConnectionContext secureConnectionContext = null;
        Object object = this.initialContext;
        synchronized (object) {
            secureConnectionContext = (SecureConnectionContext)this.initialContext.clone();
        }
        object = new FTPConnection(proFTPClientInterface, secureConnectionContext);
        proFTPClientInterface.setId(Integer.toString(++id));
        if (this.listener != null) {
            this.a((FTPConnection)object, this.listener);
        }
        a.debug("Created connection #" + proFTPClientInterface.getId());
        this.busyConnections.addElement(object);
        return object;
    }

    protected synchronized ProFTPClientInterface createClientInstance() throws FTPException {
        return FTPClientFactory.createClient(this.initialContext.getProtocol(), this.initialContext.isServerValidationEnabled());
    }

    public FileStatistics getStatistics() {
        return this.stats;
    }

    public synchronized long getLastUsedTime() {
        if (this.busyConnections.size() > 0) {
            return System.currentTimeMillis();
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < this.freeConnections.size(); ++i2) {
            FTPConnection fTPConnection = (FTPConnection)this.freeConnections.elementAt(i2);
            if (fTPConnection.getLastUsedTime() <= l2) continue;
            l2 = fTPConnection.getLastUsedTime();
        }
        return l2;
    }

    public synchronized FTPConnection getConnection() throws ConnectionException {
        if (this.b) {
            String string = "FTPConnectionPool has shut down - cannot obtain connection";
            a.error(string);
            throw new ConnectionException(string);
        }
        if (this.freeConnections.isEmpty() && this.getCurrentPoolSize() < this.maxPoolSize) {
            a.debug("No free connections - create a new connection (" + this.getCurrentPoolSize() + " conn(s) <" + this.maxPoolSize + " max)");
            return null;
        }
        long l2 = System.currentTimeMillis();
        while (!this.b) {
            try {
                a.debug("Waiting for a free connection ...");
                this.wait(1000L);
                if (this.freeConnections.isEmpty()) {
                    if (System.currentTimeMillis() - l2 <= (long)this.initialContext.getTimeout()) continue;
                    String string = "Failed to obtain free connection - timed out";
                    a.error(string);
                    throw new ConnectionException(string);
                }
                a.debug("Connection now free!");
                break;
            }
            catch (InterruptedException interruptedException) {
                String string = "Interrupted while waiting for a free connection";
                a.error(string, interruptedException);
                throw new ConnectionException(string);
            }
        }
        FTPConnection fTPConnection = (FTPConnection)this.freeConnections.elementAt(0);
        this.freeConnections.removeElementAt(0);
        this.busyConnections.addElement(fTPConnection);
        a.debug("Got a free connection: " + fTPConnection.toString() + "(" + this.freeConnections.size() + " left)");
        return fTPConnection;
    }

    public synchronized FTPConnection getFreeConnection() throws ConnectionException {
        if (this.b) {
            String string = "FTPConnectionPool has shut down - cannot obtain connection";
            a.error(string);
            throw new ConnectionException(string);
        }
        if (!this.freeConnections.isEmpty()) {
            FTPConnection fTPConnection = (FTPConnection)this.freeConnections.elementAt(0);
            this.freeConnections.removeElementAt(0);
            this.busyConnections.addElement(fTPConnection);
            return fTPConnection;
        }
        return null;
    }

    public synchronized FTPConnection[] getAllFreeConnections() {
        FTPConnection[] fTPConnectionArray = this.freeConnections.toArray(new FTPConnection[this.freeConnections.size()]);
        this.freeConnections.clear();
        return fTPConnectionArray;
    }

    public synchronized void clearConnection(FTPConnection conn) {
        this.busyConnections.removeElement(conn);
        this.freeConnections.removeElement(conn);
        if (conn.getClient().connected()) {
            try {
                conn.getClient().quitImmediately();
            }
            catch (Exception exception) {
                a.warn("Failed to shutdown connection", exception);
            }
        }
        a.debug("Cleared connection " + conn.toString());
    }

    public void markConnectionAsFresh(FTPConnection conn) {
        conn.setLastUsedTime(System.currentTimeMillis());
    }

    public synchronized void freeConnection(FTPConnection conn) {
        this.busyConnections.removeElement(conn);
        if (this.b) {
            try {
                conn.getClient().quit();
            }
            catch (Exception exception) {
                a.warn("Failed to cleanly close connection " + conn.toString(), exception);
                try {
                    conn.getClient().quitImmediately();
                }
                catch (Exception exception2) {}
            }
        } else {
            this.freeConnections.addElement(conn);
            if (this.listener != null && conn.getListener() == null) {
                this.a(conn, this.listener);
            }
        }
        if (this.freeConnections.size() + this.busyConnections.size() == 0) {
            a.warn("No connections left in pool");
            this.initialContext.setConnected(false);
        }
        this.notifyAll();
    }

    public synchronized boolean isShutdown() {
        return this.b;
    }

    public synchronized void disconnect(boolean immediate) {
        Object object;
        a.debug("disconnect() - closing free connections");
        Enumeration enumeration = this.freeConnections.elements();
        while (enumeration.hasMoreElements()) {
            object = (FTPConnection)enumeration.nextElement();
            if (!((FTPConnection)object).getClient().connected()) continue;
            try {
                ((FTPConnection)object).getClient().quit();
            }
            catch (Exception exception) {
                a.warn("Failed to cleanly close connection", exception);
            }
        }
        this.freeConnections.removeAllElements();
        if (immediate) {
            a.debug("disconnect() - closing busy connections");
            object = this.busyConnections.elements();
            while (object.hasMoreElements()) {
                FTPConnection fTPConnection = (FTPConnection)object.nextElement();
                if (!fTPConnection.getClient().connected()) continue;
                try {
                    fTPConnection.getClient().quitImmediately();
                }
                catch (Exception exception) {
                    a.warn("Failed to cleanly close connection", exception);
                }
            }
        }
        this.busyConnections.removeAllElements();
        this.initialContext.setConnected(false);
        a.debug("disconnect() completed - notifying waiting threads");
        this.notifyAll();
    }

    public synchronized boolean isConnected() {
        return this.initialContext.isConnected();
    }

    public synchronized void shutdown(boolean immediate) {
        this.b = true;
        this.disconnect(immediate);
        a.debug("FTPConnectionPool shutdown");
    }

    public synchronized SecureConnectionContext getInitialContext() {
        return this.initialContext;
    }

    public synchronized int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized int getCurrentPoolSize() {
        return this.freeConnections.size() + this.busyConnections.size();
    }

    public synchronized void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public synchronized int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public synchronized void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }
}

