/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.WildcardFilter;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.DownloadMultipleResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.MultipleTransferTask;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;
import java.io.FileFilter;

public class DownloadMultipleTask
extends MultipleTransferTask {
    private static Logger a = Logger.getLogger("DownloadMultipleTask");
    private AsyncCallback.DownloadMultiple b;
    private DownloadMultipleResult c;

    public DownloadMultipleTask(FTPTaskProcessor taskProcessor, DownloadMultipleResult result, AsyncCallback.DownloadMultiple callback) {
        super(taskProcessor, result, TaskType.o);
        this.b = callback;
        this.c = result;
    }

    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.c.getLocalDir() + "=>" + this.c.getRemoteDir() + "]";
    }

    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                this.configureMultipleUploads(conn);
                this.setupProgressMonitoring(this.c.getNotifyInterval());
                FileFilter fileFilter = this.c.getFilter();
                if (fileFilter == null && this.c.getWildcard() != null) {
                    fileFilter = new WildcardFilter(this.c.getWildcard());
                }
                String string = this.c.getRemoteDir() == null ? this.getContext().getRemoteDirectory() : this.c.getRemoteDir();
                conn.getClient().mget(this.c.getLocalDir(), string, fileFilter, this.c.isRecursive());
                this.c.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.c.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.c.notifyComplete();
        this.c.setLocalContext(this.getContext());
        if (this.b != null) {
            try {
                this.b.onDownloadMultiple(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.c, throwable);
            }
        }
        this.c.setLocalContext(null);
        try {
            if (!this.c.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.c, throwable);
        }
    }
}

