/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.DownloadByteArrayResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SingleTransferTask;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;

public class DownloadByteArrayTask
extends SingleTransferTask {
    private static Logger a = Logger.getLogger("DownloadByteArrayTask");
    private AsyncCallback.DownloadByteArray b;
    private DownloadByteArrayResult c;

    public DownloadByteArrayTask(FTPTaskProcessor taskProcessor, DownloadByteArrayResult result, AsyncCallback.DownloadByteArray callback) {
        super(taskProcessor, result, TaskType.d);
        this.b = callback;
        this.c = result;
    }

    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.result.getRemoteFileName() + "=> byteArray]";
    }

    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                this.setupProgressMonitoring(this.result.getNotifyInterval());
                byte[] byArray = conn.getClient().get(conn.convertPath(this.result.getRemoteFileName()));
                ((DownloadByteArrayResult)this.result).setResult(byArray);
                this.result.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.result.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.result.notifyComplete();
        this.result.setLocalContext(this.getContext());
        if (this.b != null) {
            try {
                this.b.onDownloadByteArray(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.result, throwable);
            }
        }
        this.result.setLocalContext(null);
        try {
            if (!this.result.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.result, throwable);
        }
    }
}

