/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.ConnectResult;
import com.enterprisedt.net.ftp.async.internal.ConnectFTPTask;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.ssl.SSLFTPClient;
import com.enterprisedt.net.ftp.ssl.SSLFTPStandardValidator;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public class ConnectFTPSETask
extends ConnectFTPTask {
    private static Logger a = Logger.getLogger("ConnectFTPSETask");

    public ConnectFTPSETask(FTPTaskProcessor taskProcessor, ConnectResult result, AsyncCallback.Connect callback) {
        super(taskProcessor, result, callback);
    }

    protected void login(FTPClientInterface ftp, SecureConnectionContext context) throws IOException, FTPException {
        block10: {
            SSLFTPClient sSLFTPClient = (SSLFTPClient)ftp;
            try {
                try {
                    sSLFTPClient.auth(this.getContext().getSecurityMechanism().toString());
                    this.a(sSLFTPClient);
                    a.info("Logged in");
                }
                catch (FTPException fTPException) {
                    if (fTPException.getReplyCode() == 530) {
                        a.debug("Login required prior to PBSZ/PROT - logging in (" + fTPException.getMessage() + ")");
                        this.a(sSLFTPClient);
                        sSLFTPClient.pbsz(0);
                        sSLFTPClient.prot('P');
                        break block10;
                    }
                    throw fTPException;
                }
            }
            catch (FTPException fTPException) {
                try {
                    sSLFTPClient.quitImmediately();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw fTPException;
            }
            catch (IOException iOException) {
                try {
                    sSLFTPClient.quitImmediately();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw iOException;
            }
        }
    }

    private void a(SSLFTPClient sSLFTPClient) throws IOException, FTPException {
        if (this.getContext().getAccountDetails() == null) {
            sSLFTPClient.login(this.getContext().getUserName(), this.getContext().getPassword());
        } else {
            sSLFTPClient.login(this.getContext().getUserName(), this.getContext().getPassword(), this.getContext().getAccountDetails());
        }
    }

    protected void preConnectConfigure(FTPClientInterface ftpClient, SecureConnectionContext context) throws IOException, FTPException {
        super.preConnectConfigure(ftpClient, context);
        SSLFTPClient sSLFTPClient = (SSLFTPClient)ftpClient;
        boolean bl = context.isServerValidationEnabled();
        sSLFTPClient.setValidateServer(bl);
        if (bl) {
            sSLFTPClient.setRootCertificateStore(context.getSSLServerValidationCertificates());
            if (context.getSSLServerCommonNames() != null) {
                sSLFTPClient.setCustomValidator(new SSLFTPStandardValidator(context.getSSLServerCommonNames()));
            }
        }
        if (context.getClientCertificatePath() != null) {
            if (context.getClientCertificatePassphrase() != null) {
                sSLFTPClient.loadClientCertificate(context.getClientCertificatePath(), context.getClientCertificatePassphrase());
                a.debug("Using client certificate validation");
            } else {
                a.warn("Client certificate passphrase not supplied - not using client validation");
            }
        } else if (context.getClientCertificate() != null) {
            if (context.getClientPrivateKey() != null) {
                sSLFTPClient.setClientCertificate(context.getClientCertificate(), context.getClientPrivateKey());
                a.debug("Using client certificate validation");
            } else {
                a.warn("Client private key not supplied - not using client validation");
            }
        }
        sSLFTPClient.enableCipherSuites(context.getEnabledCipherSuites());
        int n2 = 0;
        if (context.isDisableSessionResumption()) {
            n2 |= 0x80;
        }
        if (context.isDisableWaitOnClose()) {
            n2 |= 0xC;
        }
        if (context.isDisableSSLClosure()) {
            n2 |= 3;
        }
        if (context.isStartWithClearDataChannels()) {
            n2 |= 0x10;
        }
        if (context.isAllowBasicConstraintsNonCA()) {
            n2 |= 0x40;
        }
        sSLFTPClient.setConfigFlags(n2);
    }

    protected void postConnectConfigure(FTPClientInterface ftpClient, SecureConnectionContext context) throws IOException, FTPException {
        super.postConnectConfigure(ftpClient, context);
        SSLFTPClient sSLFTPClient = (SSLFTPClient)ftpClient;
        if (context.isUseUnencryptedCommands()) {
            sSLFTPClient.ccc();
        }
    }
}

