/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.ChangeDirectoryResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.util.debug.Logger;

public class ChangeDirectoryTask
extends Task {
    private static Logger a = Logger.getLogger("ChangeDirectoryTask");
    private AsyncCallback.ChangeDirectory b;
    private ChangeDirectoryResult c;
    private boolean d = false;

    public ChangeDirectoryTask(FTPTaskProcessor taskProcessor, ChangeDirectoryResult result, AsyncCallback.ChangeDirectory callback, boolean inCallback) {
        super(taskProcessor, TaskType.e, result);
        this.c = result;
        this.b = callback;
        this.d = inCallback;
    }

    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.c.getRemoteDirectory() + "]";
    }

    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                ProFTPClientInterface proFTPClientInterface = conn.getClient();
                String string = this.c.getDirectory();
                if ("..".equals(string)) {
                    proFTPClientInterface.cdup();
                } else {
                    proFTPClientInterface.chdir(string);
                }
                String string2 = proFTPClientInterface.pwd();
                this.c.setRemoteDirectory(string2);
                conn.getContext().setRemoteDirectory(string2);
                this.getContext().setRemoteDirectory(string2);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
                this.c.setSuccessful(true);
                a.debug("New remote directory = " + string2);
                if (!this.d) {
                    a.debug("Setting master context remotedir to " + string2);
                    this.taskProcessor.getMasterContext().setRemoteDirectory(string2);
                }
            }
        }
        catch (Throwable throwable) {
            this.c.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.c.notifyComplete();
        this.c.setLocalContext(this.getContext());
        if (this.b != null) {
            try {
                this.b.onChangeDirectory(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.c, throwable);
            }
        }
        this.c.setLocalContext(null);
        try {
            if (!this.c.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.c, throwable);
        }
    }
}

