/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.AsyncFileTransferClient;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FileStatistics;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.ChangeDirectoryResult;
import com.enterprisedt.net.ftp.async.ConnectResult;
import com.enterprisedt.net.ftp.async.CreateDirectoryResult;
import com.enterprisedt.net.ftp.async.DeleteDirectoryResult;
import com.enterprisedt.net.ftp.async.DeleteFileResult;
import com.enterprisedt.net.ftp.async.DeleteMultipleFilesResult;
import com.enterprisedt.net.ftp.async.DirectoryListCallbackResult;
import com.enterprisedt.net.ftp.async.DirectoryListResult;
import com.enterprisedt.net.ftp.async.DirectoryNameListResult;
import com.enterprisedt.net.ftp.async.DisconnectResult;
import com.enterprisedt.net.ftp.async.DownloadByteArrayResult;
import com.enterprisedt.net.ftp.async.DownloadFileResult;
import com.enterprisedt.net.ftp.async.DownloadMultipleResult;
import com.enterprisedt.net.ftp.async.DownloadStreamResult;
import com.enterprisedt.net.ftp.async.ErrorListener;
import com.enterprisedt.net.ftp.async.ExecuteCommandResult;
import com.enterprisedt.net.ftp.async.ExistsResult;
import com.enterprisedt.net.ftp.async.GetSystemTypeResult;
import com.enterprisedt.net.ftp.async.ModifiedTimeResult;
import com.enterprisedt.net.ftp.async.PermissionsResult;
import com.enterprisedt.net.ftp.async.RenameResult;
import com.enterprisedt.net.ftp.async.SizeResult;
import com.enterprisedt.net.ftp.async.UploadByteArrayResult;
import com.enterprisedt.net.ftp.async.UploadFileResult;
import com.enterprisedt.net.ftp.async.UploadMultipleResult;
import com.enterprisedt.net.ftp.async.UploadStreamResult;
import com.enterprisedt.net.ftp.async.internal.ChangeDirectoryTask;
import com.enterprisedt.net.ftp.async.internal.ConnectFTPSETask;
import com.enterprisedt.net.ftp.async.internal.ConnectFTPSITask;
import com.enterprisedt.net.ftp.async.internal.ConnectFTPTask;
import com.enterprisedt.net.ftp.async.internal.ConnectSFTPTask;
import com.enterprisedt.net.ftp.async.internal.ConnectTask;
import com.enterprisedt.net.ftp.async.internal.CreateDirectoryTask;
import com.enterprisedt.net.ftp.async.internal.DeleteDirectoryTask;
import com.enterprisedt.net.ftp.async.internal.DeleteFileTask;
import com.enterprisedt.net.ftp.async.internal.DeleteMultipleFilesTask;
import com.enterprisedt.net.ftp.async.internal.DirectoryListCallbackTask;
import com.enterprisedt.net.ftp.async.internal.DirectoryListTask;
import com.enterprisedt.net.ftp.async.internal.DirectoryNameListTask;
import com.enterprisedt.net.ftp.async.internal.DisconnectTask;
import com.enterprisedt.net.ftp.async.internal.DownloadByteArrayTask;
import com.enterprisedt.net.ftp.async.internal.DownloadFileTask;
import com.enterprisedt.net.ftp.async.internal.DownloadMultipleTask;
import com.enterprisedt.net.ftp.async.internal.DownloadStreamTask;
import com.enterprisedt.net.ftp.async.internal.ExecuteCommandTask;
import com.enterprisedt.net.ftp.async.internal.ExistsTask;
import com.enterprisedt.net.ftp.async.internal.FTPConnectionPool;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.GetModifiedTimeTask;
import com.enterprisedt.net.ftp.async.internal.GetSystemTypeTask;
import com.enterprisedt.net.ftp.async.internal.InternalConnectCallback;
import com.enterprisedt.net.ftp.async.internal.RenameTask;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.async.internal.SetModifiedTimeTask;
import com.enterprisedt.net.ftp.async.internal.SetPermissionsTask;
import com.enterprisedt.net.ftp.async.internal.SizeTask;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskCallback;
import com.enterprisedt.net.ftp.async.internal.UploadByteArrayTask;
import com.enterprisedt.net.ftp.async.internal.UploadFileTask;
import com.enterprisedt.net.ftp.async.internal.UploadMultipleTask;
import com.enterprisedt.net.ftp.async.internal.UploadStreamTask;
import com.enterprisedt.util.debug.Logger;
import java.io.FileFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class AsyncFileTransferClientImpl
implements TaskCallback {
    private static Logger a = Logger.getLogger("AsyncFileTransferClientImpl");
    private FTPConnectionPool b;
    private SecureConnectionContext c;
    private FTPTaskProcessor d;
    private HashMap e = new HashMap();
    private AsyncCallback.Disconnect f;
    private boolean g = false;

    public AsyncFileTransferClientImpl(SecureConnectionContext masterContext, int initialPoolSize, int maxPoolSize) {
        this.c = masterContext;
        this.b = new FTPConnectionPool(masterContext, initialPoolSize, maxPoolSize);
        this.d = new FTPTaskProcessor(this.b.getMaxPoolSize() + 1, this.b, masterContext);
    }

    public AsyncFileTransferClientImpl(SecureConnectionContext masterContext) {
        this.c = masterContext;
        this.b = new FTPConnectionPool(masterContext);
        this.d = new FTPTaskProcessor(this.b.getMaxPoolSize() + 1, this.b, masterContext);
    }

    public void setPersistentThreads() {
        this.g = true;
        this.d.start();
    }

    private void a(boolean bl) throws FTPException {
        if (bl && !this.isConnected()) {
            throw new FTPException("The file transfer client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!bl && this.isConnected()) {
            throw new FTPException("The file transfer client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    private void a(Protocol protocol, Protocol protocol2) throws FTPException {
        if (!protocol.equals(protocol2)) {
            throw new FTPException(protocol.toString() + " does not support this operation");
        }
    }

    public synchronized boolean isConnected() {
        return this.c.isConnected();
    }

    public SecureConnectionContext getApplicableContext() {
        return this.d.getApplicableContext();
    }

    public void setEventListener(EventListener listener) {
        this.b.setListener(listener);
    }

    public FileStatistics getStatistics() {
        return this.b.getStatistics();
    }

    public FTPReply getLastReply() {
        return this.d.getLastReply();
    }

    public void addErrorListener(ErrorListener listener) {
        this.d.addErrorListener(listener);
    }

    public void shutdown(boolean immediate) {
        this.d.shutdown(immediate);
        this.b.shutdown(immediate);
    }

    public ConnectResult connectAsync(AsyncFileTransferClient client, AsyncCallback.Connect callback, Object tag) throws FTPException {
        this.a(false);
        if (this.d.isShutdown()) {
            this.d.start();
        }
        ConnectResult connectResult = new ConnectResult();
        connectResult.setTag(tag);
        connectResult.setClient(client);
        int n2 = this.b.getInitialPoolSize();
        InternalConnectCallback internalConnectCallback = new InternalConnectCallback(this.d, n2, this.d.getApplicableContext(), callback, connectResult);
        for (int i2 = 0; i2 < n2; ++i2) {
            ConnectResult connectResult2 = new ConnectResult();
            ConnectTask connectTask = this.a(this.d.getApplicableContext(), connectResult2, internalConnectCallback);
            connectResult.addTask(connectTask);
            this.d.addTask(connectTask);
        }
        return connectResult;
    }

    private ConnectTask a(SecureConnectionContext secureConnectionContext, ConnectResult connectResult, AsyncCallback.Connect connect) {
        Protocol protocol = secureConnectionContext.getProtocol();
        ConnectTask connectTask = null;
        if (protocol.equals(Protocol.FTP)) {
            connectTask = new ConnectFTPTask(this.d, connectResult, connect);
        } else if (protocol.equals(Protocol.SFTP)) {
            connectTask = new ConnectSFTPTask(this.d, connectResult, connect);
        } else if (protocol.equals(Protocol.FTPS_EXPLICIT)) {
            connectTask = new ConnectFTPSETask(this.d, connectResult, connect);
        } else if (protocol.equals(Protocol.FTPS_IMPLICIT)) {
            connectTask = new ConnectFTPSITask(this.d, connectResult, connect);
        }
        if (connectTask != null) {
            connectTask.setContext(secureConnectionContext);
            return connectTask;
        }
        throw new RuntimeException("Unknown protocol: " + protocol.toString());
    }

    public ExecuteCommandResult executeCommandAsync(AsyncFileTransferClient client, String command, AsyncCallback.ExecuteCommand callback, Object tag) throws FTPException {
        this.a(true);
        ExecuteCommandResult executeCommandResult = new ExecuteCommandResult(command);
        executeCommandResult.setTag(tag);
        executeCommandResult.setClient(client);
        this.d.addTask(new ExecuteCommandTask(this.d, executeCommandResult, callback));
        return executeCommandResult;
    }

    public GetSystemTypeResult getSystemTypeAsync(AsyncFileTransferClient client, AsyncCallback.GetSystemType callback, Object tag) throws FTPException {
        this.a(true);
        GetSystemTypeResult getSystemTypeResult = new GetSystemTypeResult();
        getSystemTypeResult.setTag(tag);
        getSystemTypeResult.setClient(client);
        this.d.addTask(new GetSystemTypeTask(this.d, getSystemTypeResult, callback));
        return getSystemTypeResult;
    }

    public DirectoryNameListResult directoryNameListAsync(AsyncFileTransferClient client, String directoryName, boolean isLongListing, AsyncCallback.DirectoryNameList callback, Object tag) throws FTPException {
        this.a(true);
        DirectoryNameListResult directoryNameListResult = new DirectoryNameListResult(directoryName, isLongListing);
        directoryNameListResult.setTag(tag);
        directoryNameListResult.setClient(client);
        this.d.addTask(new DirectoryNameListTask(this.d, directoryNameListResult, callback));
        return directoryNameListResult;
    }

    public DirectoryListCallbackResult directoryListAsync(AsyncFileTransferClient client, String directoryName, DirectoryListCallback lister, AsyncCallback.DirectoryListCallback callback, Object tag) throws FTPException {
        this.a(true);
        DirectoryListCallbackResult directoryListCallbackResult = new DirectoryListCallbackResult(directoryName);
        directoryListCallbackResult.setTag(tag);
        directoryListCallbackResult.setClient(client);
        this.d.addTask(new DirectoryListCallbackTask(this.d, lister, directoryListCallbackResult, callback));
        return directoryListCallbackResult;
    }

    public DirectoryListResult directoryListAsync(AsyncFileTransferClient client, String directoryName, AsyncCallback.DirectoryList callback, Object tag) throws FTPException {
        this.a(true);
        DirectoryListResult directoryListResult = new DirectoryListResult(directoryName);
        directoryListResult.setTag(tag);
        directoryListResult.setClient(client);
        this.d.addTask(new DirectoryListTask(this.d, directoryListResult, callback));
        return directoryListResult;
    }

    public DownloadByteArrayResult downloadByteArrayAsync(AsyncFileTransferClient client, String remoteFileName, AsyncCallback.DownloadByteArray callback, Object tag) throws FTPException {
        this.a(true);
        DownloadByteArrayResult downloadByteArrayResult = new DownloadByteArrayResult(remoteFileName);
        downloadByteArrayResult.setTag(tag);
        downloadByteArrayResult.setClient(client);
        downloadByteArrayResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        DownloadByteArrayTask downloadByteArrayTask = new DownloadByteArrayTask(this.d, downloadByteArrayResult, callback);
        downloadByteArrayTask.setTaskCallback(this);
        this.e.put(new Integer(downloadByteArrayTask.getId()), downloadByteArrayTask);
        this.d.addTask(downloadByteArrayTask);
        return downloadByteArrayResult;
    }

    public DownloadFileResult downloadFileAsync(AsyncFileTransferClient client, String localFileName, String remoteFileName, WriteMode writeMode, AsyncCallback.DownloadFile callback, Object tag) throws FTPException {
        this.a(true);
        if (writeMode.equals(WriteMode.APPEND)) {
            throw new FTPException("Append not supported for downloads");
        }
        DownloadFileResult downloadFileResult = new DownloadFileResult(localFileName, remoteFileName, writeMode);
        downloadFileResult.setTag(tag);
        downloadFileResult.setClient(client);
        downloadFileResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        DownloadFileTask downloadFileTask = new DownloadFileTask(this.d, downloadFileResult, callback);
        downloadFileTask.setTaskCallback(this);
        this.e.put(new Integer(downloadFileTask.getId()), downloadFileTask);
        this.d.addTask(downloadFileTask);
        return downloadFileResult;
    }

    public DownloadStreamResult downloadStreamAsync(AsyncFileTransferClient client, String remoteFileName, AsyncCallback.DownloadStream callback, Object tag) throws FTPException {
        this.a(true);
        DownloadStreamResult downloadStreamResult = new DownloadStreamResult(remoteFileName);
        downloadStreamResult.setTag(tag);
        downloadStreamResult.setClient(client);
        downloadStreamResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        DownloadStreamTask downloadStreamTask = new DownloadStreamTask(this.d, downloadStreamResult, callback);
        downloadStreamTask.setTaskCallback(this);
        this.e.put(new Integer(downloadStreamTask.getId()), downloadStreamTask);
        this.d.addTask(downloadStreamTask);
        return downloadStreamResult;
    }

    public UploadFileResult uploadFileAsync(AsyncFileTransferClient client, String localFileName, String remoteFileName, WriteMode writeMode, AsyncCallback.UploadFile callback, Object tag) throws FTPException {
        this.a(true);
        UploadFileResult uploadFileResult = new UploadFileResult(localFileName, remoteFileName, writeMode);
        uploadFileResult.setTag(tag);
        uploadFileResult.setClient(client);
        uploadFileResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        UploadFileTask uploadFileTask = new UploadFileTask(this.d, uploadFileResult, callback);
        uploadFileTask.setTaskCallback(this);
        this.e.put(new Integer(uploadFileTask.getId()), uploadFileTask);
        this.d.addTask(uploadFileTask);
        return uploadFileResult;
    }

    public UploadByteArrayResult uploadByteArrayAsync(AsyncFileTransferClient client, byte[] bytes, String remoteFileName, WriteMode writeMode, AsyncCallback.UploadByteArray callback, Object tag) throws FTPException {
        this.a(true);
        if (writeMode.equals(WriteMode.RESUME)) {
            throw new FTPException("Resume not supported for byte array uploads");
        }
        UploadByteArrayResult uploadByteArrayResult = new UploadByteArrayResult(bytes, remoteFileName, writeMode);
        uploadByteArrayResult.setTag(tag);
        uploadByteArrayResult.setClient(client);
        uploadByteArrayResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        UploadByteArrayTask uploadByteArrayTask = new UploadByteArrayTask(this.d, uploadByteArrayResult, callback);
        uploadByteArrayTask.setTaskCallback(this);
        this.e.put(new Integer(uploadByteArrayTask.getId()), uploadByteArrayTask);
        this.d.addTask(uploadByteArrayTask);
        return uploadByteArrayResult;
    }

    public UploadStreamResult uploadStreamAsync(AsyncFileTransferClient client, String remoteFileName, WriteMode writeMode, AsyncCallback.UploadStream callback, Object tag) throws FTPException {
        this.a(true);
        if (writeMode.equals(WriteMode.RESUME)) {
            throw new FTPException("Resume not supported for stream uploads");
        }
        UploadStreamResult uploadStreamResult = new UploadStreamResult(remoteFileName, writeMode);
        uploadStreamResult.setTag(tag);
        uploadStreamResult.setClient(client);
        uploadStreamResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        UploadStreamTask uploadStreamTask = new UploadStreamTask(this.d, uploadStreamResult, callback);
        uploadStreamTask.setTaskCallback(this);
        this.e.put(new Integer(uploadStreamTask.getId()), uploadStreamTask);
        this.d.addTask(uploadStreamTask);
        return uploadStreamResult;
    }

    public SizeResult getSizeAsync(AsyncFileTransferClient client, String remoteFileName, AsyncCallback.Size callback, Object tag) throws FTPException {
        this.a(true);
        SizeResult sizeResult = new SizeResult(remoteFileName);
        sizeResult.setTag(tag);
        sizeResult.setClient(client);
        this.d.addTask(new SizeTask(this.d, sizeResult, callback));
        return sizeResult;
    }

    public ModifiedTimeResult getModifiedTimeAsync(AsyncFileTransferClient client, String remoteFileName, AsyncCallback.GetModifiedTime callback, Object tag) throws FTPException {
        this.a(true);
        ModifiedTimeResult modifiedTimeResult = new ModifiedTimeResult(remoteFileName);
        modifiedTimeResult.setTag(tag);
        modifiedTimeResult.setClient(client);
        this.d.addTask(new GetModifiedTimeTask(this.d, modifiedTimeResult, callback));
        return modifiedTimeResult;
    }

    public ModifiedTimeResult setModifiedTimeAsync(AsyncFileTransferClient client, String remoteFileName, Date modifiedTime, AsyncCallback.SetModifiedTime callback, Object tag) throws FTPException {
        this.a(true);
        ModifiedTimeResult modifiedTimeResult = new ModifiedTimeResult(remoteFileName);
        modifiedTimeResult.setModifiedTime(modifiedTime);
        modifiedTimeResult.setTag(tag);
        modifiedTimeResult.setClient(client);
        this.d.addTask(new SetModifiedTimeTask(this.d, modifiedTimeResult, callback));
        return modifiedTimeResult;
    }

    public PermissionsResult setPermissionsAsync(AsyncFileTransferClient client, String remotePath, int permissions, AsyncCallback.SetPermissions callback, Object tag) throws FTPException {
        this.a(true);
        this.a(this.c.getProtocol(), Protocol.SFTP);
        PermissionsResult permissionsResult = new PermissionsResult(remotePath);
        permissionsResult.setPermissions(permissions);
        permissionsResult.setTag(tag);
        permissionsResult.setClient(client);
        this.d.addTask(new SetPermissionsTask(this.d, permissionsResult, callback));
        return permissionsResult;
    }

    public ExistsResult existsAsync(AsyncFileTransferClient client, String remoteFileName, AsyncCallback.Exists callback, Object tag) throws FTPException {
        this.a(true);
        ExistsResult existsResult = new ExistsResult(remoteFileName);
        existsResult.setTag(tag);
        existsResult.setClient(client);
        this.d.addTask(new ExistsTask(this.d, existsResult, callback));
        return existsResult;
    }

    public DeleteFileResult deleteFileAsync(AsyncFileTransferClient client, String remoteFileName, AsyncCallback.DeleteFile callback, Object tag) throws FTPException {
        this.a(true);
        DeleteFileResult deleteFileResult = new DeleteFileResult(remoteFileName);
        deleteFileResult.setTag(tag);
        deleteFileResult.setClient(client);
        this.d.addTask(new DeleteFileTask(this.d, deleteFileResult, callback));
        return deleteFileResult;
    }

    public DeleteMultipleFilesResult deleteMultipleFilesAsync(AsyncFileTransferClient client, FileFilter filter, AsyncCallback.DeleteMultipleFiles callback, Object tag) throws FTPException {
        this.a(true);
        DeleteMultipleFilesResult deleteMultipleFilesResult = new DeleteMultipleFilesResult(filter);
        deleteMultipleFilesResult.setTag(tag);
        deleteMultipleFilesResult.setClient(client);
        this.d.addTask(new DeleteMultipleFilesTask(this.d, deleteMultipleFilesResult, callback));
        return deleteMultipleFilesResult;
    }

    public DeleteMultipleFilesResult deleteMultipleFilesAsync(AsyncFileTransferClient client, String wildcard, AsyncCallback.DeleteMultipleFiles callback, Object tag) throws FTPException {
        this.a(true);
        DeleteMultipleFilesResult deleteMultipleFilesResult = new DeleteMultipleFilesResult(wildcard);
        deleteMultipleFilesResult.setTag(tag);
        deleteMultipleFilesResult.setClient(client);
        this.d.addTask(new DeleteMultipleFilesTask(this.d, deleteMultipleFilesResult, callback));
        return deleteMultipleFilesResult;
    }

    public DeleteMultipleFilesResult deleteMultipleFilesAsync(AsyncFileTransferClient client, String remoteDirectory, String wildcard, boolean recursive, AsyncCallback.DeleteMultipleFiles callback, Object tag) throws FTPException {
        this.a(true);
        DeleteMultipleFilesResult deleteMultipleFilesResult = new DeleteMultipleFilesResult(remoteDirectory, wildcard, recursive);
        deleteMultipleFilesResult.setTag(tag);
        deleteMultipleFilesResult.setClient(client);
        this.d.addTask(new DeleteMultipleFilesTask(this.d, deleteMultipleFilesResult, callback));
        return deleteMultipleFilesResult;
    }

    public DeleteMultipleFilesResult deleteMultipleFilesAsync(AsyncFileTransferClient client, String remoteDirectory, FileFilter filter, boolean recursive, AsyncCallback.DeleteMultipleFiles callback, Object tag) throws FTPException {
        this.a(true);
        DeleteMultipleFilesResult deleteMultipleFilesResult = new DeleteMultipleFilesResult(remoteDirectory, filter, recursive);
        deleteMultipleFilesResult.setTag(tag);
        deleteMultipleFilesResult.setClient(client);
        this.d.addTask(new DeleteMultipleFilesTask(this.d, deleteMultipleFilesResult, callback));
        return deleteMultipleFilesResult;
    }

    public RenameResult renameAsync(AsyncFileTransferClient client, String renameFromName, String renameToName, AsyncCallback.Rename callback, Object tag) throws FTPException {
        this.a(true);
        RenameResult renameResult = new RenameResult(renameFromName, renameToName);
        renameResult.setTag(tag);
        renameResult.setClient(client);
        this.d.addTask(new RenameTask(this.d, renameResult, callback));
        return renameResult;
    }

    public ChangeDirectoryResult changeDirectoryAsync(AsyncFileTransferClient client, String directoryName, AsyncCallback.ChangeDirectory callback, Object tag) throws FTPException {
        this.a(true);
        ChangeDirectoryResult changeDirectoryResult = new ChangeDirectoryResult(directoryName);
        changeDirectoryResult.setTag(tag);
        changeDirectoryResult.setClient(client);
        this.d.addTask(new ChangeDirectoryTask(this.d, changeDirectoryResult, callback, this.d.inTaskThread()));
        return changeDirectoryResult;
    }

    public ChangeDirectoryResult changeToParentDirectoryAsync(AsyncFileTransferClient client, AsyncCallback.ChangeDirectory callback, Object tag) throws FTPException {
        this.a(true);
        ChangeDirectoryResult changeDirectoryResult = new ChangeDirectoryResult("..");
        changeDirectoryResult.setTag(tag);
        changeDirectoryResult.setClient(client);
        this.d.addTask(new ChangeDirectoryTask(this.d, changeDirectoryResult, callback, this.d.inTaskThread()));
        return changeDirectoryResult;
    }

    public CreateDirectoryResult createDirectoryAsync(AsyncFileTransferClient client, String directoryName, AsyncCallback.CreateDirectory callback, Object tag) throws FTPException {
        this.a(true);
        CreateDirectoryResult createDirectoryResult = new CreateDirectoryResult(directoryName);
        createDirectoryResult.setTag(tag);
        createDirectoryResult.setClient(client);
        this.d.addTask(new CreateDirectoryTask(this.d, createDirectoryResult, callback));
        return createDirectoryResult;
    }

    public DeleteDirectoryResult deleteDirectoryAsync(AsyncFileTransferClient client, String directoryName, AsyncCallback.DeleteDirectory callback, Object tag) throws FTPException {
        this.a(true);
        DeleteDirectoryResult deleteDirectoryResult = new DeleteDirectoryResult(directoryName);
        deleteDirectoryResult.setTag(tag);
        deleteDirectoryResult.setClient(client);
        this.d.addTask(new DeleteDirectoryTask(this.d, deleteDirectoryResult, callback));
        return deleteDirectoryResult;
    }

    public DeleteDirectoryResult deleteDirectoryAsync(AsyncFileTransferClient client, String directoryName, boolean recursive, AsyncCallback.DeleteDirectory callback, Object tag) throws FTPException {
        this.a(true);
        DeleteDirectoryResult deleteDirectoryResult = new DeleteDirectoryResult(directoryName, recursive);
        deleteDirectoryResult.setTag(tag);
        deleteDirectoryResult.setClient(client);
        this.d.addTask(new DeleteDirectoryTask(this.d, deleteDirectoryResult, callback));
        return deleteDirectoryResult;
    }

    public UploadMultipleResult uploadMultipleAsync(AsyncFileTransferClient client, String localDir, FileFilter filter, AsyncCallback.UploadMultiple callback, Object tag) throws FTPException {
        this.a(true);
        UploadMultipleResult uploadMultipleResult = new UploadMultipleResult(localDir, null, filter, false);
        uploadMultipleResult.setTag(tag);
        uploadMultipleResult.setClient(client);
        uploadMultipleResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        this.d.addTask(new UploadMultipleTask(this.d, uploadMultipleResult, callback));
        return uploadMultipleResult;
    }

    public UploadMultipleResult uploadMultipleAsync(AsyncFileTransferClient client, String localDir, String wildcard, AsyncCallback.UploadMultiple callback, Object tag) throws FTPException {
        this.a(true);
        UploadMultipleResult uploadMultipleResult = new UploadMultipleResult(localDir, null, wildcard, false);
        uploadMultipleResult.setTag(tag);
        uploadMultipleResult.setClient(client);
        uploadMultipleResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        this.d.addTask(new UploadMultipleTask(this.d, uploadMultipleResult, callback));
        return uploadMultipleResult;
    }

    public UploadMultipleResult uploadMultipleAsync(AsyncFileTransferClient client, String localDir, String remoteDir, String wildcard, boolean recursive, AsyncCallback.UploadMultiple callback, Object tag) throws FTPException {
        this.a(true);
        UploadMultipleResult uploadMultipleResult = new UploadMultipleResult(localDir, remoteDir, wildcard, recursive);
        uploadMultipleResult.setTag(tag);
        uploadMultipleResult.setClient(client);
        uploadMultipleResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        this.d.addTask(new UploadMultipleTask(this.d, uploadMultipleResult, callback));
        return uploadMultipleResult;
    }

    public UploadMultipleResult uploadMultipleAsync(AsyncFileTransferClient client, String localDir, String remoteDir, FileFilter filter, boolean recursive, AsyncCallback.UploadMultiple callback, Object tag) throws FTPException {
        this.a(true);
        UploadMultipleResult uploadMultipleResult = new UploadMultipleResult(localDir, remoteDir, filter, recursive);
        uploadMultipleResult.setTag(tag);
        uploadMultipleResult.setClient(client);
        uploadMultipleResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        this.d.addTask(new UploadMultipleTask(this.d, uploadMultipleResult, callback));
        return uploadMultipleResult;
    }

    public DownloadMultipleResult downloadMultipleAsync(AsyncFileTransferClient client, String localDir, FileFilter filter, AsyncCallback.DownloadMultiple callback, Object tag) throws FTPException {
        this.a(true);
        DownloadMultipleResult downloadMultipleResult = new DownloadMultipleResult(localDir, null, filter, false);
        downloadMultipleResult.setTag(tag);
        downloadMultipleResult.setClient(client);
        downloadMultipleResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        this.d.addTask(new DownloadMultipleTask(this.d, downloadMultipleResult, callback));
        return downloadMultipleResult;
    }

    public DownloadMultipleResult downloadMultipleAsync(AsyncFileTransferClient client, String localDir, String wildcard, AsyncCallback.DownloadMultiple callback, Object tag) throws FTPException {
        this.a(true);
        DownloadMultipleResult downloadMultipleResult = new DownloadMultipleResult(localDir, null, wildcard, false);
        downloadMultipleResult.setTag(tag);
        downloadMultipleResult.setClient(client);
        downloadMultipleResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        this.d.addTask(new DownloadMultipleTask(this.d, downloadMultipleResult, callback));
        return downloadMultipleResult;
    }

    public DownloadMultipleResult downloadMultipleAsync(AsyncFileTransferClient client, String localDir, String remoteDir, String wildcard, boolean recursive, AsyncCallback.DownloadMultiple callback, Object tag) throws FTPException {
        this.a(true);
        DownloadMultipleResult downloadMultipleResult = new DownloadMultipleResult(localDir, remoteDir, wildcard, recursive);
        downloadMultipleResult.setTag(tag);
        downloadMultipleResult.setClient(client);
        downloadMultipleResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        this.d.addTask(new DownloadMultipleTask(this.d, downloadMultipleResult, callback));
        return downloadMultipleResult;
    }

    public DownloadMultipleResult downloadMultipleAsync(AsyncFileTransferClient client, String localDir, String remoteDir, FileFilter filter, boolean recursive, AsyncCallback.DownloadMultiple callback, Object tag) throws FTPException {
        this.a(true);
        DownloadMultipleResult downloadMultipleResult = new DownloadMultipleResult(localDir, remoteDir, filter, recursive);
        downloadMultipleResult.setTag(tag);
        downloadMultipleResult.setClient(client);
        downloadMultipleResult.setNotifyInterval(this.c.getTransferNotifyInterval());
        this.d.addTask(new DownloadMultipleTask(this.d, downloadMultipleResult, callback));
        return downloadMultipleResult;
    }

    public void setDisconnectCallback(AsyncCallback.Disconnect callback) {
        this.f = callback;
        this.d.setDisconnectCallback(callback);
    }

    public AsyncCallback.Disconnect getDisconnectCallback() {
        return this.f;
    }

    public DisconnectResult disconnectAsync(AsyncFileTransferClient client, boolean immediate, AsyncCallback.Disconnect callback, Object tag) {
        DisconnectResult disconnectResult = new DisconnectResult(immediate);
        disconnectResult.setTag(tag);
        disconnectResult.setClient(client);
        if (this.isConnected()) {
            this.d.addTask(new DisconnectTask(this.d, this.g, disconnectResult, callback));
        } else {
            disconnectResult.notifyComplete();
            disconnectResult.setAlreadyDisconnected(true);
            disconnectResult.setSuccessful(true);
        }
        return disconnectResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllTransfers() {
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            a.debug("Cancelling " + this.e.size() + " transfer(s)");
            Iterator iterator = this.e.values().iterator();
            while (iterator.hasNext()) {
                Task task = (Task)iterator.next();
                a.debug("Cancelling transfer task (id=" + task.getId() + ")");
                task.cancel();
            }
            this.e.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(Task task) {
        HashMap hashMap = this.e;
        synchronized (hashMap) {
            this.e.remove(new Integer(task.getId()));
        }
    }
}

