/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;

public class FTPInputStream
extends FileTransferInputStream {
    private static Logger a = Logger.getLogger("FTPInputStream");
    private static final byte[] b = System.getProperty("line.separator").getBytes();
    private long c;
    private FTPClient d;
    private BufferedInputStream e;
    private long f = 0L;
    private boolean g = false;
    private byte[] h;
    private int i = 0;
    private int j = 0;
    private byte[] k;
    private byte[] l = new byte[FTPClient.FTP_LINE_SEPARATOR.length];
    private int m = 0;
    private ByteArrayOutputStream n;
    private long o = 0L;
    private FTPProgressMonitor p;
    private FTPProgressMonitorEx q;
    private boolean r = false;

    public FTPInputStream(FTPClient client, String remoteFile) throws IOException, FTPException {
        this(client, remoteFile, 0L);
    }

    public FTPInputStream(FTPClient client, String remoteFile, long offset) throws IOException, FTPException {
        this.d = client;
        this.remoteFile = remoteFile;
        if (offset > 0L) {
            this.d.resumeNextDownload(offset);
        }
        try {
            client.initGet(remoteFile);
            this.e = new BufferedInputStream(new DataInputStream(client.getInputStream()));
        }
        catch (IOException iOException) {
            client.validateTransferOnError(iOException);
            throw iOException;
        }
        this.c = client.getMonitorInterval();
        this.p = client.getProgressMonitor();
        this.k = new byte[client.getTransferBufferSize()];
        this.n = new ByteArrayOutputStream(client.getTransferBufferSize());
        this.g = client.getType().equals(FTPTransferType.ASCII);
    }

    public void setMonitor(FTPProgressMonitorEx monitor, long monitorInterval) {
        this.p = monitor;
        this.q = monitor;
        this.c = monitorInterval;
    }

    public int read() throws IOException {
        if (!this.r) {
            this.a();
        }
        if (this.h == null) {
            return -1;
        }
        if (this.i == this.j) {
            this.h = this.b();
            if (this.h == null) {
                return -1;
            }
        }
        return 0xFF & this.h[this.i++];
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        if (!this.r) {
            this.a();
        }
        if (this.h == null || len == 0) {
            return -1;
        }
        if (this.i == this.j) {
            this.h = this.b();
            if (this.h == null) {
                return -1;
            }
        }
        int n2 = 0;
        int n3 = len;
        while ((n2 = this.j - this.i) < n3) {
            System.arraycopy(this.h, this.i, b2, off, n2);
            n3 -= n2;
            off += n2;
            this.h = this.b();
            if (this.h != null) continue;
            return len - n3;
        }
        System.arraycopy(this.h, this.i, b2, off, n3);
        this.i += n3;
        return len;
    }

    private void a() throws IOException {
        if (this.q != null) {
            this.q.transferStarted(TransferDirection.DOWNLOAD, this.remoteFile);
        }
        this.h = this.b();
        this.r = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] b() throws IOException {
        int n2;
        block11: {
            this.i = 0;
            if (this.d.isTransferCancelled()) {
                return null;
            }
            n2 = this.d.readChunk(this.e, this.k, this.k.length);
            if (n2 < 0) {
                if (this.g && this.m > 0) {
                    this.f += (long)this.m;
                    this.j = this.m;
                    this.o += (long)this.m;
                    byte[] byArray = new byte[this.m];
                    System.arraycopy(byArray, 0, this.l, 0, this.m);
                    this.m = 0;
                    return byArray;
                }
                return null;
            }
            if (this.g) break block11;
            this.f += (long)n2;
            this.o += (long)n2;
            this.j = n2;
            byte[] byArray = this.k;
            Object var5_6 = null;
            if (this.p != null && this.o > this.c) {
                this.p.bytesTransferred(this.f);
                this.o = 0L;
            }
            return byArray;
        }
        try {
            this.n.reset();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.k[i2] == FTPClient.FTP_LINE_SEPARATOR[this.m]) {
                    this.l[this.m] = this.k[i2];
                    ++this.m;
                    if (this.m != FTPClient.FTP_LINE_SEPARATOR.length) continue;
                    this.n.write(b);
                    this.f += (long)b.length;
                    this.o += (long)b.length;
                    this.m = 0;
                    continue;
                }
                if (this.m > 0) {
                    this.n.write(this.l, 0, this.m);
                    this.f += (long)this.m;
                    this.o += (long)this.m;
                }
                this.n.write(this.k[i2]);
                ++this.f;
                ++this.o;
                this.m = 0;
            }
            byte[] byArray = this.n.toByteArray();
            this.j = byArray.length;
            byte[] byArray2 = byArray;
            Object var5_7 = null;
            if (this.p != null && this.o > this.c) {
                this.p.bytesTransferred(this.f);
                this.o = 0L;
            }
            return byArray2;
        }
        catch (Throwable throwable) {
            block12: {
                Object var5_8 = null;
                if (this.p == null || this.o <= this.c) break block12;
                this.p.bytesTransferred(this.f);
                this.o = 0L;
            }
            throw throwable;
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.d.forceResumeOff();
            this.d.closeDataSocket(this.e);
            if (this.p != null) {
                this.p.bytesTransferred(this.f);
            }
            a.debug("Transferred " + this.f + " bytes from remote host");
            try {
                this.d.validateTransfer();
            }
            catch (FTPException fTPException) {
                throw new IOException(fTPException.getMessage());
            }
            if (this.q != null) {
                this.q.transferComplete(TransferDirection.DOWNLOAD, this.remoteFile);
            }
        }
    }
}

