/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.key;

import com.enterprisedt.cryptix.util.core.ArrayUtil;
import java.security.Key;

public class RawKey
implements Key {
    private String a;
    private byte[] b;

    public RawKey(String algorithm, byte[] data) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.a = algorithm;
        this.b = (byte[])data.clone();
    }

    public RawKey(String algorithm, byte[] data, int offset, int length) {
        if (algorithm == null) {
            throw new NullPointerException("algorithm == null");
        }
        this.a = algorithm;
        this.b = new byte[length];
        System.arraycopy(data, offset, this.b, 0, length);
    }

    public int hashCode() {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.b.length; n2 += 4) {
            n3 ^= this.b[n2];
        }
        n3 <<= 8;
        for (n2 = 1; n2 < this.b.length; n2 += 4) {
            n3 ^= this.b[n2];
        }
        n3 <<= 8;
        for (n2 = 2; n2 < this.b.length; n2 += 4) {
            n3 ^= this.b[n2];
        }
        n3 <<= 8;
        for (n2 = 3; n2 < this.b.length; n2 += 4) {
            n3 ^= this.b[n2];
        }
        return n3;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof RawKey) {
            return ArrayUtil.areEqual(this.b, ((RawKey)obj).b);
        }
        return false;
    }

    public String getAlgorithm() {
        return this.a;
    }

    public String getFormat() {
        return "RAW";
    }

    public byte[] getEncoded() {
        return (byte[])this.b.clone();
    }
}

