/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.elgamal;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.elgamal.ElGamalAlgorithm;
import com.enterprisedt.cryptix.util.core.BI;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Random;
import xjava.security.interfaces.ElGamalPrivateKey;
import xjava.security.interfaces.ElGamalPublicKey;

public abstract class Any_ElGamal_PKCS1Signature
extends Signature {
    private static final boolean a = Debug.GLOBAL_DEBUG;
    private static final int b = a ? Debug.getLevel("ElGamal", "Any_ElGamal_PKCS1Signature") : 0;
    private static final BigInteger c = BigInteger.valueOf(1L);
    private BigInteger d;
    private BigInteger e;
    private BigInteger f;
    private BigInteger g;
    private int h;
    private Random i;
    private MessageDigest j;

    private static void a(String string) {
        Debug.log("Any_ElGamal_PKCS1Signature: " + string);
    }

    protected Any_ElGamal_PKCS1Signature(String mdAlgorithm) {
        super(mdAlgorithm + "/ElGamal/PKCS#1");
        try {
            this.j = MessageDigest.getInstance(mdAlgorithm, "CryptixEDT");
        }
        catch (Exception exception) {
            throw new CryptixException(this.getAlgorithm() + ": Unable to instantiate the " + mdAlgorithm + " MessageDigest\n" + exception);
        }
    }

    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        if (!(key instanceof ElGamalPrivateKey)) {
            throw new InvalidKeyException("ElGamal: signing key does not implement java.security.interfaces.ElGamalPrivateKey");
        }
        ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)key;
        BigInteger bigInteger = elGamalPrivateKey.getX();
        if (bigInteger == null) {
            throw new InvalidKeyException("ElGamal: getX() == null");
        }
        this.a(elGamalPrivateKey.getP(), elGamalPrivateKey.getG(), bigInteger, elGamalPrivateKey.getY());
        if (this.i == null) {
            this.i = new SecureRandom();
        }
    }

    protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
        if (!(key instanceof ElGamalPublicKey)) {
            throw new InvalidKeyException("ElGamal: verification key does not implement java.security.interfaces.ElGamalPublicKey");
        }
        ElGamalPublicKey elGamalPublicKey = (ElGamalPublicKey)key;
        this.a(elGamalPublicKey.getP(), elGamalPublicKey.getG(), null, elGamalPublicKey.getY());
        if (this.i == null) {
            this.i = new SecureRandom();
        }
    }

    private void a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        if (bigInteger == null) {
            throw new InvalidKeyException("ElGamal: getP() == null");
        }
        if (bigInteger2 == null) {
            throw new InvalidKeyException("ElGamal: getG() == null");
        }
        if (bigInteger4 == null) {
            throw new InvalidKeyException("ElGamal: getY() == null");
        }
        if (bigInteger.bitLength() < 256) {
            throw new InvalidKeyException("ElGamal: getP().bitLength() < 256");
        }
        if (bigInteger.compareTo(c) <= 0) {
            throw new InvalidKeyException("ElGamal: getP() < 2");
        }
        this.d = bigInteger;
        this.e = bigInteger2;
        this.f = bigInteger3;
        this.g = bigInteger4;
        this.h = (this.d.bitLength() + 7) / 8;
        this.j.reset();
    }

    protected void engineUpdate(byte b2) throws SignatureException {
        this.j.update(b2);
    }

    protected void engineUpdate(byte[] in, int offset, int length) throws SignatureException {
        this.j.update(in, offset, length);
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger = this.a();
        BigInteger[] bigIntegerArray = new BigInteger[2];
        ElGamalAlgorithm.sign(bigInteger, bigIntegerArray, this.d, this.e, this.f, this.i);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BI.toStream(bigIntegerArray[0], byteArrayOutputStream);
            BI.toStream(bigIntegerArray[1], byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new SignatureException("BI.toStream() failed");
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected boolean engineVerify(byte[] signature) throws SignatureException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3 = this.a();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(signature);
        try {
            bigInteger2 = BI.fromStream(byteArrayInputStream);
            bigInteger = BI.fromStream(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new SignatureException("BI.fromStream() failed");
        }
        return ElGamalAlgorithm.verify(bigInteger3, bigInteger2, bigInteger, this.d, this.e, this.g);
    }

    protected void engineSetParameter(String param, Object value) {
        if (param.equals("random")) {
            if (!(value instanceof Random)) {
                throw new InvalidParameterException("value must be an instance of java.util.Random");
            }
            this.i = (Random)value;
            return;
        }
        throw new InvalidParameterException(param);
    }

    protected Object engineGetParameter(String param) {
        if (param.equals("random")) {
            return this.i;
        }
        return null;
    }

    private BigInteger a() {
        byte[] byArray = this.j.digest();
        int n2 = byArray.length;
        byte[] byArray2 = new byte[this.h];
        byArray2[1] = 1;
        byte[] byArray3 = this.getAlgorithmEncoding();
        int n3 = byArray3.length;
        int n4 = this.h - 3 - n3 - n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray2[2 + i2] = -1;
        }
        System.arraycopy(byArray3, 0, byArray2, n4 + 3, n3);
        System.arraycopy(byArray, 0, byArray2, this.h - n2, n2);
        if (a && b >= 4) {
            Any_ElGamal_PKCS1Signature.a("PKCS#1 frame = " + Hex.dumpString(byArray2));
        }
        return new BigInteger(byArray2);
    }

    protected abstract byte[] getAlgorithmEncoding();
}

