/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalRootPaneUI;
import javax.swing.plaf.metal.MetalUtils;
import sun.awt.SunToolkit;
import sun.swing.SwingUtilities2;

class MetalTitlePane
extends JComponent {
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private Image systemIcon;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private MetalRootPaneUI rootPaneUI;
    private Color inactiveBackground = UIManager.getColor("inactiveCaption");
    private Color inactiveForeground = UIManager.getColor("inactiveCaptionText");
    private Color inactiveShadow = UIManager.getColor("inactiveCaptionBorder");
    private Color activeBumpsHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
    private Color activeBumpsShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
    private Color activeBackground = null;
    private Color activeForeground = null;
    private Color activeShadow = null;
    private MetalBumps activeBumps = new MetalBumps(0, 0, this.activeBumpsHighlight, this.activeBumpsShadow, MetalLookAndFeel.getPrimaryControl());
    private MetalBumps inactiveBumps = new MetalBumps(0, 0, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());

    public MetalTitlePane(JRootPane jRootPane, MetalRootPaneUI metalRootPaneUI) {
        this.rootPane = jRootPane;
        this.rootPaneUI = metalRootPaneUI;
        this.state = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
            this.updateSystemIcon();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int n = this.getWindowDecorationStyle();
        if (n == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        } else if (n == 2 || n == 3 || n == 4 || n == 5 || n == 6 || n == 7 || n == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
                break;
            }
            case 4: {
                this.activeBackground = UIManager.getColor("OptionPane.errorDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("OptionPane.warningDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.warningDialog.titlePane.shadow");
                break;
            }
            default: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
            }
        }
        this.activeBumps.setBumpColors(this.activeBumpsHighlight, this.activeBumpsShadow, this.activeBackground);
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void uninstallDefaults() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu jMenu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(jMenu);
        }
        return jMenu;
    }

    private void addMenuItems(JMenu jMenu) {
        Locale locale = this.getRootPane().getLocale();
        JMenuItem jMenuItem = jMenu.add(this.restoreAction);
        int n = MetalUtils.getInt("MetalTitlePane.restoreMnemonic", -1);
        if (n != -1) {
            jMenuItem.setMnemonic(n);
        }
        jMenuItem = jMenu.add(this.iconifyAction);
        n = MetalUtils.getInt("MetalTitlePane.iconifyMnemonic", -1);
        if (n != -1) {
            jMenuItem.setMnemonic(n);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jMenuItem = jMenu.add(this.maximizeAction);
            n = MetalUtils.getInt("MetalTitlePane.maximizeMnemonic", -1);
            if (n != -1) {
                jMenuItem.setMnemonic(n);
            }
        }
        jMenu.add(new JSeparator());
        jMenuItem = jMenu.add(this.closeAction);
        n = MetalUtils.getInt("MetalTitlePane.closeMnemonic", -1);
        if (n != -1) {
            jMenuItem.setMnemonic(n);
        }
    }

    private JButton createTitleButton() {
        JButton jButton = new JButton();
        jButton.setFocusPainted(false);
        jButton.setFocusable(false);
        jButton.setOpaque(true);
        return jButton;
    }

    private void createButtons() {
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.putClientProperty("AccessibleName", "Close");
        this.closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        if (this.getWindowDecorationStyle() == 1) {
            this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
            this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
            this.iconifyButton = this.createTitleButton();
            this.iconifyButton.setAction(this.iconifyAction);
            this.iconifyButton.setText(null);
            this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
            this.iconifyButton.setBorder(handyEmptyBorder);
            this.iconifyButton.putClientProperty("AccessibleName", "Iconify");
            this.iconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
            this.toggleButton = this.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.toggleButton.setBorder(handyEmptyBorder);
            this.toggleButton.putClientProperty("AccessibleName", "Maximize");
            this.toggleButton.setIcon(this.maximizeIcon);
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.closeButton.putClientProperty("paintActive", bl2);
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton.putClientProperty("paintActive", bl2);
            this.toggleButton.putClientProperty("paintActive", bl2);
        }
        this.getRootPane().repaint();
    }

    private void setState(int n) {
        this.setState(n, false);
    }

    private void setState(int n, boolean bl) {
        Window window = this.getWindow();
        if (window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == n && !bl) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane jRootPane = this.getRootPane();
                if ((n & 6) != 0 && (jRootPane.getBorder() == null || jRootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    jRootPane.setBorder(null);
                } else if ((n & 6) == 0) {
                    this.rootPaneUI.installBorder(jRootPane);
                }
                if (frame.isResizable()) {
                    if ((n & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = n;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        String string;
        int n4;
        MetalBumps metalBumps;
        Color color;
        Color color2;
        Color color3;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane jRootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean bl = window == null ? jRootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean bl2 = window == null ? true : window.isActive();
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        if (bl2) {
            color3 = this.activeBackground;
            color2 = this.activeForeground;
            color = this.activeShadow;
            metalBumps = this.activeBumps;
        } else {
            color3 = this.inactiveBackground;
            color2 = this.inactiveForeground;
            color = this.inactiveShadow;
            metalBumps = this.inactiveBumps;
        }
        graphics.setColor(color3);
        graphics.fillRect(0, 0, n5, n6);
        graphics.setColor(color);
        graphics.drawLine(0, n6 - 1, n5, n6 - 1);
        graphics.drawLine(0, 0, 0, 0);
        graphics.drawLine(n5 - 1, 0, n5 - 1, 0);
        int n7 = n4 = bl ? 5 : n5 - 5;
        if (this.getWindowDecorationStyle() == 1) {
            n4 += bl ? 21 : -21;
        }
        if ((string = this.getTitle()) != null) {
            FontMetrics fontMetrics = SwingUtilities2.getFontMetrics((JComponent)jRootPane, graphics);
            graphics.setColor(color2);
            n3 = (n6 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rectangle = this.iconifyButton.getBounds();
            }
            if (bl) {
                if (rectangle.x == 0) {
                    rectangle.x = window.getWidth() - window.getInsets().right - 2;
                }
                n2 = rectangle.x - n4 - 4;
                string = SwingUtilities2.clipStringIfNecessary(jRootPane, fontMetrics, string, n2);
            } else {
                n2 = n4 - rectangle.x - rectangle.width - 4;
                string = SwingUtilities2.clipStringIfNecessary(jRootPane, fontMetrics, string, n2);
                n4 -= SwingUtilities2.stringWidth(jRootPane, fontMetrics, string);
            }
            int n8 = SwingUtilities2.stringWidth(jRootPane, fontMetrics, string);
            SwingUtilities2.drawString((JComponent)jRootPane, graphics, string, n4, n3);
            n4 += bl ? n8 + 5 : -5;
        }
        if (bl) {
            n3 = n5 - this.buttonsWidth - n4 - 5;
            n = n4;
        } else {
            n3 = n4 - this.buttonsWidth - 5;
            n = this.buttonsWidth + 5;
        }
        int n9 = 3;
        n2 = this.getHeight() - 2 * n9;
        metalBumps.setBumpArea(n3, n2);
        metalBumps.paintIcon(this, graphics, n, n9);
    }

    private void updateSystemIcon() {
        Window window = this.getWindow();
        if (window == null) {
            this.systemIcon = null;
            return;
        }
        List<Image> list = window.getIconImages();
        assert (list != null);
        this.systemIcon = list.size() == 0 ? null : (list.size() == 1 ? list.get(0) : SunToolkit.getScaledIconImage(list, 16, 16));
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", MetalTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.this.close();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", MetalTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.this.iconify();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", MetalTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.this.maximize();
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("resizable".equals(string) || "state".equals(string)) {
                Frame frame = MetalTitlePane.this.getFrame();
                if (frame != null) {
                    MetalTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(string)) {
                    MetalTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(string)) {
                MetalTitlePane.this.repaint();
            } else if ("componentOrientation" == string) {
                MetalTitlePane.this.revalidate();
                MetalTitlePane.this.repaint();
            } else if ("iconImage" == string) {
                MetalTitlePane.this.updateSystemIcon();
                MetalTitlePane.this.revalidate();
                MetalTitlePane.this.repaint();
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", MetalTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MetalTitlePane.this.restore();
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (MetalTitlePane.this.systemIcon != null) {
                graphics.drawImage(MetalTitlePane.this.systemIcon, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.max(16, dimension.width), Math.max(dimension.height, 16));
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = this.computeHeight();
            return new Dimension(n, n);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        private int computeHeight() {
            FontMetrics fontMetrics = MetalTitlePane.this.rootPane.getFontMetrics(MetalTitlePane.this.getFont());
            int n = fontMetrics.getHeight();
            n += 7;
            int n2 = 0;
            if (MetalTitlePane.this.getWindowDecorationStyle() == 1) {
                n2 = 16;
            }
            int n3 = Math.max(n, n2);
            return n3;
        }

        @Override
        public void layoutContainer(Container container) {
            int n;
            int n2;
            boolean bl = MetalTitlePane.this.window == null ? MetalTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : MetalTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int n3 = MetalTitlePane.this.getWidth();
            int n4 = 3;
            if (MetalTitlePane.this.closeButton != null && MetalTitlePane.this.closeButton.getIcon() != null) {
                n2 = MetalTitlePane.this.closeButton.getIcon().getIconHeight();
                n = MetalTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                n2 = 16;
                n = 16;
            }
            int n5 = bl ? n3 : 0;
            int n6 = 5;
            int n7 = n5 = bl ? n6 : n3 - n - n6;
            if (MetalTitlePane.this.menuBar != null) {
                MetalTitlePane.this.menuBar.setBounds(n5, n4, n, n2);
            }
            n5 = bl ? n3 : 0;
            n6 = 4;
            n5 += bl ? -n6 - n : n6;
            if (MetalTitlePane.this.closeButton != null) {
                MetalTitlePane.this.closeButton.setBounds(n5, n4, n, n2);
            }
            if (!bl) {
                n5 += n;
            }
            if (MetalTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && MetalTitlePane.this.toggleButton.getParent() != null) {
                    n6 = 10;
                    MetalTitlePane.this.toggleButton.setBounds(n5 += bl ? -n6 - n : n6, n4, n, n2);
                    if (!bl) {
                        n5 += n;
                    }
                }
                if (MetalTitlePane.this.iconifyButton != null && MetalTitlePane.this.iconifyButton.getParent() != null) {
                    n6 = 2;
                    MetalTitlePane.this.iconifyButton.setBounds(n5 += bl ? -n6 - n : n6, n4, n, n2);
                    if (!bl) {
                        n5 += n;
                    }
                }
            }
            MetalTitlePane.this.buttonsWidth = bl ? n3 - n5 : n5;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            MetalTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            MetalTitlePane.this.setActive(false);
        }
    }
}

