/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.templates;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.FileUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.projects.core.Activator;
import com.pandora.projects.templates.FileTemplate;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class FileTemplatesManager {
    private static final String README_FILE_NAME = "readme.txt";
    private static final String OS_NAME = "os.name";
    private static final String OS_NAME_LINUX = "linux";
    private static final String OS_NAME_MAC = "mac";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String USER_TEMPLATES_DIRECTORY_GENERAL = "/HBuilder settings/Templates/";
    private static final String USER_TEMPLATES_DIRECTORY_MACOSX = "/Documents/HBuilder settings/Templates/";
    public static final String TEMPLATE_PATH = "/templates/file/";
    private static FileTemplatesManager fileTemplatesManager = new FileTemplatesManager();

    private FileTemplatesManager() {
        File userpath = new File(this.getUserTemplatePath(""));
        if (!userpath.exists()) {
            userpath.mkdirs();
        }
    }

    public static FileTemplatesManager getInstance() {
        return fileTemplatesManager;
    }

    public List<FileTemplate> getAllFileTemplates(String fileExtension) {
        List<FileTemplate> list = Collections.emptyList();
        if (StringUtil.isNotEmpty((String)fileExtension)) {
            try {
                list = this.getSysTemplateFileTemplates(fileExtension);
                list.addAll(this.getUserTemplateFileTemplates(fileExtension));
            }
            catch (IOException e) {
                HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
        return list;
    }

    private List<FileTemplate> getSysTemplateFileTemplates(final String fileExtension) throws IOException {
        URL url = Activator.getDefault().getBundle().getResource(TEMPLATE_PATH + fileExtension);
        File path = new File(FileLocator.toFileURL((URL)url).getFile());
        final ArrayList<FileTemplate> list = new ArrayList<FileTemplate>();
        path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile() && pathname.getName().endsWith("." + fileExtension)) {
                    String name = pathname.getName();
                    if (name.indexOf(".") >= 0) {
                        name = pathname.getName().substring(0, pathname.getName().lastIndexOf(46));
                    }
                    list.add(new FileTemplate(name, pathname.getName(), true, pathname));
                }
                return false;
            }
        });
        Collections.sort(list);
        return list;
    }

    public File getReadmeFile() throws IOException {
        URL url = Activator.getDefault().getBundle().getResource("/templates/file/readme.txt");
        return new File(FileLocator.toFileURL((URL)url).getFile());
    }

    private List<FileTemplate> getUserTemplateFileTemplates(String fileExtension) throws IOException {
        File path = new File(this.getUserTemplatePath(fileExtension));
        final ArrayList<FileTemplate> list = new ArrayList<FileTemplate>();
        path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                if (!name.equals(FileTemplatesManager.README_FILE_NAME)) {
                    if (name.indexOf(".") > 0) {
                        name = pathname.getName().substring(0, pathname.getName().lastIndexOf(46));
                    }
                    list.add(new FileTemplate(name, pathname.getName(), true, pathname));
                }
                return false;
            }
        });
        Collections.sort(list);
        return list;
    }

    public String getUserTemplatePath(String fileExtension) {
        String OS = null;
        if (Platform.isRunning()) {
            OS = Platform.getOS();
        } else {
            OS = System.getProperty(OS_NAME).toLowerCase();
            if (OS.contains(OS_NAME_MAC)) {
                OS = "macosx";
            } else if (OS.contains(OS_NAME_LINUX)) {
                OS = OS_NAME_LINUX;
            }
        }
        String userHome = System.getProperty(USER_HOME_PROPERTY);
        if (OS.equals("macosx") || OS.equals(OS_NAME_LINUX)) {
            return String.valueOf(userHome) + USER_TEMPLATES_DIRECTORY_MACOSX + fileExtension;
        }
        return String.valueOf(userHome) + USER_TEMPLATES_DIRECTORY_GENERAL + fileExtension;
    }

    public File createUserTemplatePath(String fileExtension) throws IOException {
        File systemReadme;
        File path = new File(FileTemplatesManager.getInstance().getUserTemplatePath(fileExtension));
        path.mkdirs();
        File readme = new File(path, README_FILE_NAME);
        if (!readme.exists() && (systemReadme = this.getReadmeFile()).exists()) {
            FileUtil.copyFile((File)systemReadme, (File)readme);
        }
        return path;
    }
}

