/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.projects.templates;

import java.io.File;

public class FileTemplate
implements Comparable<FileTemplate> {
    private static final String DEFAULT_TEMPLATE = "default.";
    private String name;
    private String description;
    private File file;
    private boolean isSystem;
    private boolean isDefault;

    public FileTemplate() {
    }

    public FileTemplate(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public FileTemplate(String name, String description, boolean system, File file) {
        this.description = description;
        this.isSystem = system;
        if (this.isSystem && name.startsWith(DEFAULT_TEMPLATE)) {
            this.isDefault = true;
            name = name.replace(DEFAULT_TEMPLATE, "");
        }
        this.name = name;
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public void setSystem(boolean system) {
        this.isSystem = system;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public int compareTo(FileTemplate o) {
        if (this.isDefault) {
            return -1;
        }
        if (o.isDefault) {
            return 1;
        }
        if (this.isSystem && !o.isSystem) {
            return -1;
        }
        if (!this.isSystem && o.isSystem) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }
}

