/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import com.aptana.core.util.ObjectUtil;
import com.aptana.editor.findbar.impl.FindBarDecorator;
import com.aptana.editor.findbar.impl.Messages;
import java.lang.ref.WeakReference;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditor;

public class FindBarFinder {
    private ITextEditor textEditor;
    private int incrementalOffset = -1;
    private ISourceViewer sourceViewer;
    private IRegion scope;
    private WeakReference<FindBarDecorator> findBarDecorator;

    public FindBarFinder(ITextEditor textEditor, ISourceViewer sourceViewer, FindBarDecorator findBarDecorator) {
        this.textEditor = textEditor;
        this.sourceViewer = sourceViewer;
        this.findBarDecorator = new WeakReference<FindBarDecorator>(findBarDecorator);
    }

    boolean find(boolean forward) {
        return this.find(forward, false);
    }

    boolean find(boolean forward, boolean incremental) {
        return this.find(forward, incremental, true);
    }

    boolean find(boolean forward, boolean incremental, boolean wrap) {
        return this.find(forward, incremental, wrap, false);
    }

    boolean find(boolean forward, boolean incremental, boolean wrap, boolean wrapping) {
        FindBarDecorator dec = (FindBarDecorator)this.findBarDecorator.get();
        if (dec == null) {
            return false;
        }
        IFindReplaceTarget findReplaceTarget = (IFindReplaceTarget)this.textEditor.getAdapter(IFindReplaceTarget.class);
        if (findReplaceTarget != null) {
            try {
                StyledText textWidget = this.sourceViewer.getTextWidget();
                Point selection = textWidget.getSelection();
                String originalText = dec.textFind.getText();
                String findText = dec.convertTextString(originalText);
                boolean runRegEx = dec.getConfiguration().getRegularExpression() || ObjectUtil.areNotEqual((Object)originalText, (Object)findText);
                int offset = textWidget.getCaretOffset();
                if (wrapping) {
                    offset = forward ? 0 : this.sourceViewer.getDocument().getLength() - 1;
                } else if (forward) {
                    if (incremental) {
                        if (this.incrementalOffset == -1) {
                            this.incrementalOffset = offset;
                        } else {
                            offset = this.incrementalOffset;
                        }
                    } else {
                        this.incrementalOffset = selection.x;
                    }
                } else {
                    this.incrementalOffset = selection.x;
                    if (selection.x != offset) {
                        offset = selection.x;
                    }
                }
                int newOffset = -1;
                if (findReplaceTarget instanceof IFindReplaceTargetExtension) {
                    IFindReplaceTargetExtension findReplaceTargetExtension = (IFindReplaceTargetExtension)findReplaceTarget;
                    if (findReplaceTargetExtension.getScope() != null) {
                        findReplaceTargetExtension.endSession();
                    }
                    findReplaceTargetExtension.beginSession();
                    if (dec.searchSelection.getSelection()) {
                        this.enableScope(findReplaceTargetExtension);
                    } else {
                        findReplaceTargetExtension.setScope(null);
                    }
                }
                if (findReplaceTarget instanceof IFindReplaceTargetExtension3) {
                    try {
                        newOffset = ((IFindReplaceTargetExtension3)findReplaceTarget).findAndSelect(forward ? offset : offset - 1, findText, forward, dec.getConfiguration().getCaseSensitive(), dec.getWholeWord(), runRegEx);
                    }
                    catch (PatternSyntaxException e) {
                        if (dec.statusLineManager != null) {
                            dec.statusLineManager.setMessage(true, e.getMessage(), null);
                        }
                        if (findReplaceTarget instanceof IFindReplaceTargetExtension && !dec.searchSelection.getSelection()) {
                            ((IFindReplaceTargetExtension)findReplaceTarget).endSession();
                        }
                        return false;
                    }
                } else {
                    newOffset = findReplaceTarget.findAndSelect(offset, findText, forward, dec.getConfiguration().getCaseSensitive(), dec.getWholeWord());
                }
                if (newOffset != -1) {
                    dec.textFind.setBackground(null);
                    if (!forward) {
                        selection = textWidget.getSelection();
                        this.incrementalOffset = selection.x;
                    }
                    if (dec.statusLineManager != null) {
                        if (wrapping) {
                            dec.statusLineManager.setMessage(false, Messages.FindBarDecorator_MSG_Wrapped, null);
                        } else {
                            dec.statusLineManager.setMessage(false, "", null);
                        }
                    }
                } else {
                    if (wrap && !wrapping) {
                        boolean bl = this.find(forward, incremental, wrap, true);
                        return bl;
                    }
                    dec.textFind.setBackground(dec.getfStringNotFoundColor());
                    if (dec.statusLineManager != null) {
                        dec.statusLineManager.setMessage(false, Messages.FindBarDecorator_MSG_StringNotFound, null);
                    }
                }
            }
            finally {
                if (findReplaceTarget instanceof IFindReplaceTargetExtension && !dec.searchSelection.getSelection()) {
                    ((IFindReplaceTargetExtension)findReplaceTarget).endSession();
                }
            }
        }
        return true;
    }

    public void resetIncrementalOffset() {
        this.incrementalOffset = -1;
    }

    void resetScope() {
        this.scope = null;
        IFindReplaceTarget findReplaceTarget = (IFindReplaceTarget)this.textEditor.getAdapter(IFindReplaceTarget.class);
        if (findReplaceTarget instanceof IFindReplaceTargetExtension) {
            ((IFindReplaceTargetExtension)findReplaceTarget).endSession();
        }
    }

    void enableScope(IFindReplaceTargetExtension findReplaceTargetExtension) {
        IFindReplaceTarget findReplaceTarget;
        FindBarDecorator dec = (FindBarDecorator)this.findBarDecorator.get();
        if (dec == null) {
            return;
        }
        if (findReplaceTargetExtension == null && (findReplaceTarget = (IFindReplaceTarget)this.textEditor.getAdapter(IFindReplaceTarget.class)) instanceof IFindReplaceTargetExtension) {
            findReplaceTargetExtension = (IFindReplaceTargetExtension)findReplaceTarget;
        }
        if (findReplaceTargetExtension != null && dec.searchSelection.getSelection()) {
            if (this.scope == null) {
                Point lineSelection = findReplaceTargetExtension.getLineSelection();
                this.scope = new Region(lineSelection.x, lineSelection.y);
            }
            findReplaceTargetExtension.setSelection(this.sourceViewer.getTextWidget().getCaretOffset(), 0);
            if (findReplaceTargetExtension.getScope() != null) {
                findReplaceTargetExtension.setScope(null);
            }
            findReplaceTargetExtension.setScope(this.scope);
        }
    }

    IRegion getScope() {
        return this.scope;
    }
}

