/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.editor.findbar.FindBarPlugin;
import com.aptana.editor.findbar.impl.EclipseFindSettings;
import com.aptana.editor.findbar.impl.IStartEndIgnore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Text;

public class FindBarEntriesHelper {
    static final String PREFERENCE_NAME_FIND = "FIND_BAR_DECORATOR_FIND_ENTRIES";
    static final String PREFERENCE_NAME_REPLACE = "FIND_BAR_DECORATOR_REPLACE_ENTRIES";
    private final Map<String, Set<EntriesControlHandle>> preferenceToTextAndListener = new HashMap<String, Set<EntriesControlHandle>>();
    private final EclipseFindSettings eclipseFindSettings;
    private static final Object lock = new Object();

    public FindBarEntriesHelper(EclipseFindSettings eclipseFindSettings) {
        this.eclipseFindSettings = eclipseFindSettings;
    }

    private Properties createPropertiesFromString(String asPortableString) {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(asPortableString.getBytes()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    private String createStringFromProperties(Properties properties) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            properties.store(out, "");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((Object)out).toString();
    }

    public Properties createPropertiesFromList(List<String> list) {
        Properties properties = new Properties();
        int i = 0;
        while (i < list.size()) {
            properties.put(String.valueOf(i), list.get(i));
            ++i;
        }
        return properties;
    }

    private List<String> createListFromProperties(Properties properties) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < properties.size()) {
            Object object = properties.get(String.valueOf(i));
            if (object != null) {
                list.add(object.toString());
            }
            ++i;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String entry, String preferenceName) {
        if (entry.length() == 0) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
            List<String> items = this.loadEntries(preferenceName);
            items.remove(entry);
            items.add(0, entry);
            while (items.size() > 20) {
                items.remove(items.size() - 1);
            }
            Properties props = this.createPropertiesFromList(items);
            preferenceStore.setValue(preferenceName, this.createStringFromProperties(props));
            if (preferenceName.equals(PREFERENCE_NAME_FIND)) {
                this.eclipseFindSettings.addEntry(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> loadEntries(String preferenceName) {
        Object object = lock;
        synchronized (object) {
            IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
            String current = preferenceStore.getString(preferenceName);
            if (current.trim().length() > 0) {
                Properties props = this.createPropertiesFromString(current);
                List<String> items = this.createListFromProperties(props);
                while (items.size() > 20) {
                    items.remove(items.size() - 1);
                }
                return items;
            }
            return new ArrayList<String>();
        }
    }

    private void setTextText(Text text, IStartEndIgnore modifyListener, List<String> items) {
        modifyListener.startIgnore();
        try {
            if (!text.isDisposed() && !CollectionsUtil.isEmpty(items)) {
                if (ObjectUtil.areNotEqual((Object)items.get(0), (Object)text.getText())) {
                    text.setText(items.get(0));
                }
                text.setForeground(null);
            }
        }
        finally {
            modifyListener.endIgnore();
        }
    }

    public EntriesControlHandle register(Text text, IStartEndIgnore modifyListener, final String preferenceName) {
        List<String> items = this.loadEntries(preferenceName);
        this.setTextText(text, modifyListener, items);
        Set<EntriesControlHandle> set = this.preferenceToTextAndListener.get(preferenceName);
        if (set == null) {
            set = new HashSet<EntriesControlHandle>();
            this.preferenceToTextAndListener.put(preferenceName, set);
            IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
            final Set<EntriesControlHandle> usedInternal = set;
            preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (preferenceName.equals(event.getProperty())) {
                        List<String> entries = FindBarEntriesHelper.this.loadEntries(preferenceName);
                        for (EntriesControlHandle entry : usedInternal) {
                            FindBarEntriesHelper.this.setTextText(entry.text, entry.modifyListener, entries);
                        }
                    }
                }
            });
        }
        EntriesControlHandle handle = new EntriesControlHandle(preferenceName, text, modifyListener);
        set.add(handle);
        return handle;
    }

    public void unregister(List<EntriesControlHandle> entriesControlHandles) {
        for (EntriesControlHandle entriesControlHandle : entriesControlHandles) {
            Set<EntriesControlHandle> set = this.preferenceToTextAndListener.get(entriesControlHandle.preferenceName);
            if (set == null) continue;
            set.remove(entriesControlHandle);
        }
    }

    public void updateFromEclipseFindSettings() {
        List<String> items = this.eclipseFindSettings.fFindHistory;
        IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
        Properties props = this.createPropertiesFromList(items);
        preferenceStore.setValue(PREFERENCE_NAME_FIND, this.createStringFromProperties(props));
    }

    static class EntriesControlHandle {
        final String preferenceName;
        final Text text;
        final IStartEndIgnore modifyListener;

        public EntriesControlHandle(String preferenceName, Text text, IStartEndIgnore modifyListener) {
            this.preferenceName = preferenceName;
            this.text = text;
            this.modifyListener = modifyListener;
        }
    }
}

