/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.core.util.replace.SimpleTextPatternReplacer;
import com.aptana.editor.findbar.FindBarPlugin;
import com.aptana.editor.findbar.api.IFindBarDecorator;
import com.aptana.editor.findbar.impl.CopiedFromFindReplaceDialog;
import com.aptana.editor.findbar.impl.EclipseFindSettings;
import com.aptana.editor.findbar.impl.FindBarActions;
import com.aptana.editor.findbar.impl.FindBarConfiguration;
import com.aptana.editor.findbar.impl.FindBarEntriesHelper;
import com.aptana.editor.findbar.impl.FindBarFinder;
import com.aptana.editor.findbar.impl.FindBarOption;
import com.aptana.editor.findbar.impl.FindBarVisibilityControl;
import com.aptana.editor.findbar.impl.FindHelper;
import com.aptana.editor.findbar.impl.IStartEndIgnore;
import com.aptana.editor.findbar.impl.Messages;
import com.aptana.editor.findbar.impl.ShowFindBarAction;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class FindBarDecorator
implements IFindBarDecorator,
SelectionListener {
    private static final String REGEX_WORD_BOUNDARY = "\\b";
    private static final String REGEX_LITERAL_END = "\\E";
    private static final String REGEX_LITERAL_START = "\\Q";
    private static final SimpleTextPatternReplacer NEWLINE_SANITIZER = new SimpleTextPatternReplacer();
    private static final FindBarVisibilityControl findBarVisibilityControl;
    static final EclipseFindSettings eclipseFindSettings;
    static final FindBarConfiguration findBarConfiguration;
    private static final FindBarEntriesHelper findBarEntriesHelper;
    private static final String CLOSE = "icons/close.png";
    private static final String CLOSE_ENTER = "icons/close_enter.png";
    private static final String SEARCH_BACKWARD = "icons/search_backward.png";
    private static final String OPTIONS = "icons/gear.png";
    private static final String SIGMA = "icons/sigma.png";
    private static final String CASE_SENSITIVE = "icons/casesensitive.png";
    private static final String CASE_SENSITIVE_DISABLED = "icons/casesensitive_disabled.png";
    private static final String REGEX = "icons/regex.png";
    private static final String REGEX_DISABLED = "icons/regex_disabled.png";
    private static final String WHOLE_WORD = "icons/whole_word.png";
    private static final String ICON_SEARCH_SELECTION = "icons/elcl16/segment_edit.png";
    private static final String WHOLE_WORD_DISABLED = "icons/whole_word_disabled.png";
    private ITextEditor textEditor;
    private ISourceViewer sourceViewer;
    final IEditorStatusLine statusLineManager;
    private IAction fOriginalFindBarAction;
    private List<FindBarOption> fFindBarOptions = new ArrayList<FindBarOption>();
    private Composite composite;
    private Composite findBar;
    private GridData findBarGridData;
    Text textFind;
    ToolItem findHistory;
    int lastFindHistory;
    Text textReplace;
    ToolItem replaceHistory;
    int lastReplaceHistory;
    ToolItem caseSensitive;
    ToolItem wholeWord;
    ToolItem searchBackward;
    ToolItem options;
    ToolItem regularExpression;
    ToolItem countMatches;
    ToolItem searchSelection;
    ToolItem scopeToolItem;
    private Label close;
    Button findButton;
    private Button replaceFind;
    private Button replace;
    private Button replaceAll;
    private Control[] disableWhenHidden;
    int lastCountPosition;
    int lastCountTotal;
    int lastCountOffset;
    private Sash sash;
    private GridData sashGridData;
    private GridData separatorGridData;
    private Composite editorContent;
    private List<Control> findBarTabOrder = new ArrayList<Control>(4);
    private FindBarActions findBarActions;
    int minimumFindBarHeight = 0;
    private FindBarFinder findBarFinder;
    private SearchOnTextChangedModifyListener modifyListener = new SearchOnTextChangedModifyListener();
    private final List<FindBarEntriesHelper.EntriesControlHandle> entriesControlHandles = new ArrayList<FindBarEntriesHelper.EntriesControlHandle>();
    public static final Color DISABLED_COLOR;
    FindScope findScope;
    Map<FindScope, String> scopeMap = new LinkedHashMap<FindScope, String>(4);
    FocusListener textViewerFocusListener = new FocusListener(){

        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            FindBarDecorator.this.findBarFocusLost();
        }
    };
    KeyListener textKeyListner = new KeyListener(){

        public void keyReleased(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            boolean isCKey;
            boolean isCommandCtrl = e.stateMask == SWT.MOD1;
            boolean bl = isCKey = e.character == 'A' || e.character == 'a';
            if (isCommandCtrl && isCKey) {
                ((Text)e.widget).selectAll();
            } else if (e.character == '\t') {
                if (e.stateMask == 0 || e.stateMask == 131072) {
                    e.doit = false;
                    ((Text)e.widget).traverse(e.stateMask == 0 ? 16 : 8);
                }
            } else if ((e.keyCode == 0x1000002 || e.keyCode == 0x1000001) && e.stateMask == SWT.MOD1) {
                e.doit = false;
                String preferenceName = e.widget == FindBarDecorator.this.textFind ? "FIND_BAR_DECORATOR_FIND_ENTRIES" : "FIND_BAR_DECORATOR_REPLACE_ENTRIES";
                FindBarDecorator.this.insertHistory(preferenceName, e.keyCode == 0x1000002);
            }
        }
    };
    private final UpdateFindBarActionOnPropertyChange fFindBarActionOnPropertyChange = new UpdateFindBarActionOnPropertyChange();
    private Color fStringNotFoundColor;
    private IFindReplaceTarget fFindReplaceTarget;
    private CopiedFromFindReplaceDialog fFindReplaceDialog;
    private static final int TOO_MANY;
    private Label sashSeparator;
    private FindBarOption countMatchesOption;

    static {
        NEWLINE_SANITIZER.addPattern("\\n", "\\\\n");
        NEWLINE_SANITIZER.addPattern("\\r", "\\\\r");
        findBarVisibilityControl = new FindBarVisibilityControl();
        eclipseFindSettings = new EclipseFindSettings();
        findBarConfiguration = new FindBarConfiguration(eclipseFindSettings);
        findBarEntriesHelper = new FindBarEntriesHelper(eclipseFindSettings);
        DISABLED_COLOR = UIUtils.getDisplay().getSystemColor(15);
        TOO_MANY = Integer.getInteger(String.valueOf(FindBarDecorator.class.getName()) + ".TOO_MANY", 100);
    }

    FindBarActions getFindBarActions() {
        return this.findBarActions;
    }

    public FindBarDecorator(ITextEditor textEditor) {
        this.textEditor = textEditor;
        this.statusLineManager = (IEditorStatusLine)textEditor.getAdapter(IEditorStatusLine.class);
        this.findBarActions = new FindBarActions(textEditor, this);
        this.fFindBarOptions.add(new FindBarOption("caseSensitive", CASE_SENSITIVE, CASE_SENSITIVE_DISABLED, Messages.FindBarDecorator_LABEL_CaseSensitive, this, "com.aptana.editor.findbar.caseSensitiveFindBar"){

            @Override
            public void execute(FindBarDecorator dec) {
                dec.findNextOrprevAfterChangeOption();
            }
        });
        this.fFindBarOptions.add(new FindBarOption("wholeWord", WHOLE_WORD, WHOLE_WORD_DISABLED, Messages.FindBarDecorator_LABEL_WholeWord, this, false, "com.aptana.editor.findbar.wholeWordFindBar"){

            @Override
            public void execute(FindBarDecorator dec) {
                dec.findNextOrprevAfterChangeOption();
            }
        });
        this.fFindBarOptions.add(new FindBarOption("searchSelection", ICON_SEARCH_SELECTION, null, Messages.FindBarDecorator_LABEL_SearchSelection, this, true, null){

            @Override
            public void execute(FindBarDecorator dec) {
                FindBarDecorator.this.updateSearchSelection();
            }

            @Override
            boolean isCheckable() {
                return true;
            }
        });
        this.fFindBarOptions.add(new FindBarOption("regularExpression", REGEX, REGEX_DISABLED, Messages.FindBarDecorator_LABEL_RegularExpression, this, "com.aptana.editor.findbar.regularExpressionFindBar"){

            @Override
            protected boolean canCreateItem() {
                IFindReplaceTarget findReplaceTarget = FindBarDecorator.this.getFindReplaceTarget();
                return findReplaceTarget instanceof IFindReplaceTargetExtension3;
            }

            @Override
            public ToolItem createToolItem(ToolBar optionsToolBar) {
                ToolItem item = super.createToolItem(optionsToolBar);
                if (item == null) {
                    return null;
                }
                item.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        FindBarDecorator.this.adjustEnablement();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                return item;
            }

            @Override
            public void execute(FindBarDecorator dec) {
                dec.findNextOrprevAfterChangeOption();
            }
        });
        this.countMatchesOption = new FindBarOption("countMatches", SIGMA, null, Messages.FindBarDecorator_TOOLTIP_MatchCount, this, "com.aptana.editor.findbar.matchCount"){

            @Override
            public void execute(FindBarDecorator dec) {
                FindBarDecorator.this.showCountTotal();
            }
        };
        this.fFindBarOptions.add(new FindBarOption("searchBackward", SEARCH_BACKWARD, null, Messages.FindBarDecorator_LABEL_SearchBackward, this, "com.aptana.editor.findbar.searchBackwardFindBar"){

            @Override
            public void execute(FindBarDecorator dec) {
                dec.showCountTotal();
            }
        });
        FindBarOption opt = new FindBarOption("options", OPTIONS, null, Messages.FindBarDecorator_LABEL_ShowOptions, this, null){

            @Override
            public void execute(FindBarDecorator dec) {
                FindBarDecorator.this.showOptions(true);
            }
        };
        opt.createMenuItem = false;
        this.fFindBarOptions.add(opt);
        this.scopeMap.put(FindScope.CURRENT_FILE, "icons/elcl16/search_current_file.gif");
        this.scopeMap.put(FindScope.OPEN_FILES, "icons/elcl16/search_open_files.gif");
        this.scopeMap.put(FindScope.ENCLOSING_PROJECT, "icons/elcl16/search_project.gif");
        this.scopeMap.put(FindScope.WORKSPACE, "icons/elcl16/search_workspace.gif");
        this.resetHistoryCounters();
    }

    @Override
    public Composite createFindBarComposite(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        this.editorContent = new Composite(this.composite, 0);
        this.editorContent.setLayout((Layout)new FillLayout());
        this.editorContent.setLayoutData((Object)this.createdDefaultGridData(4, 4, true, true));
        return this.editorContent;
    }

    @Override
    public void createFindBar(ISourceViewer sourceViewer) {
        this.sourceViewer = sourceViewer;
        this.findBarFinder = new FindBarFinder(this.textEditor, sourceViewer, this);
        this.sashSeparator = new Label(this.composite, 258);
        this.separatorGridData = GridDataFactory.fillDefaults().grab(true, false).exclude(true).create();
        this.sashSeparator.setLayoutData((Object)this.separatorGridData);
        this.sash = new Sash(this.composite, 65792);
        this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Rectangle rect = FindBarDecorator.this.sash.getParent().getClientArea();
                event.y = Math.min(Math.max(event.y, FindBarDecorator.this.minimumFindBarHeight), rect.height - FindBarDecorator.this.minimumFindBarHeight);
                if (event.detail != 1) {
                    FindBarDecorator.this.sash.setBounds(event.x, event.y, event.width, event.height);
                    FindBarDecorator.this.layout();
                }
            }
        });
        this.composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                FindBarDecorator.this.findBar.getParent().layout(new Control[]{FindBarDecorator.this.findBar});
            }
        });
        this.sashGridData = this.createdDefaultGridData(4, 1, true, false);
        this.sashGridData.heightHint = 3;
        this.sashGridData.exclude = true;
        this.sash.setLayoutData((Object)this.sashGridData);
        this.findBar = new Composite(this.composite, 0);
        this.findBarGridData = this.createdDefaultGridData(4, 1, true, false);
        this.findBarGridData.exclude = true;
        this.findBar.setLayoutData((Object)this.findBarGridData);
        this.textFind = this.createText("FIND_BAR_DECORATOR_FIND_ENTRIES");
        this.textFind.setText(Messages.FindBarDecorator_Find_initial_text);
        this.textFind.setEnabled(false);
        this.textFind.setForeground(DISABLED_COLOR);
        this.textFind.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindBarDecorator.this.findButton.setEnabled(!FindBarDecorator.this.isTextFindEmpty());
                if (FindBarDecorator.this.countMatches.getSelection()) {
                    findBarConfiguration.toggle(((FindBarDecorator)FindBarDecorator.this).countMatchesOption.preferencesKey);
                    FindBarDecorator.this.countMatches.setText("");
                    FindBarDecorator.this.countMatches.getParent().getParent().layout(new Control[]{FindBarDecorator.this.countMatches.getParent()});
                }
            }
        });
        this.textFind.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 8) {
                    if (FindBarDecorator.this.replaceAll.isEnabled()) {
                        FindBarDecorator.this.replaceAll.setFocus();
                    } else {
                        FindBarDecorator.this.textReplace.setFocus();
                    }
                    e.doit = false;
                }
            }
        });
        this.findBarTabOrder.add((Control)this.textFind);
        ToolBar findToolbar = new ToolBar(this.findBar, 0x800000);
        findToolbar.setLayoutData((Object)this.createdDefaultGridData(16384, 1, false, false));
        this.findHistory = this.createHistoryToolItem(findToolbar, "FIND_BAR_DECORATOR_FIND_ENTRIES");
        this.textReplace = this.createText("FIND_BAR_DECORATOR_REPLACE_ENTRIES");
        this.textReplace.setText(Messages.FindBarDecorator_Replace_initial_text);
        this.textReplace.setForeground(DISABLED_COLOR);
        this.findBarTabOrder.add((Control)this.textReplace);
        ToolBar replaceToolbar = new ToolBar(this.findBar, 0x800000);
        replaceToolbar.setLayoutData((Object)this.createdDefaultGridData(16384, 1, false, false));
        this.replaceHistory = this.createHistoryToolItem(replaceToolbar, "FIND_BAR_DECORATOR_REPLACE_ENTRIES");
        Composite searchComposite = new Composite(this.findBar, 0);
        searchComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        searchComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 1).grab(false, true).create());
        this.findBarTabOrder.add((Control)searchComposite);
        Composite findButtonComposite = new Composite(searchComposite, 0);
        findButtonComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing("macosx".equals(Platform.getOS()) ? 0 : 5, 0).numColumns(4).create());
        findButtonComposite.setLayoutData((Object)GridDataFactory.fillDefaults().indent(0, "macosx".equals(Platform.getOS()) ? -4 : 0).create());
        this.findButton = this.createButton(findButtonComposite, null, true);
        this.findButton.setText(Messages.FindBarDecorator_LABEL_Find);
        this.replaceFind = this.createButton(findButtonComposite, null, true);
        this.replaceFind.setText(Messages.FindBarDecorator_LABEL_ReplaceFind);
        this.replace = this.createButton(findButtonComposite, null, true);
        this.replace.setText(Messages.FindBarDecorator_LABEL_Replace);
        this.replaceAll = this.createButton(findButtonComposite, null, true);
        this.replaceAll.setText(Messages.FindBarDecorator_LABEL_ReplaceAll);
        ToolBar optionsToolBar = new ToolBar(searchComposite, 0x820000);
        optionsToolBar.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 1).indent("macosx".equals(Platform.getOS()) ? 5 : 0, 0).create());
        for (FindBarOption option : this.fFindBarOptions) {
            option.createToolItem(optionsToolBar);
        }
        new ToolItem(optionsToolBar, 2);
        this.scopeToolItem = this.createScopeToolItem(optionsToolBar);
        this.countMatchesOption.createToolItem(optionsToolBar);
        searchComposite.setTabList(new Control[]{findButtonComposite});
        this.findBarTabOrder.add((Control)this.textFind);
        this.findBarTabOrder.add((Control)this.textReplace);
        this.close = this.createLabel(this.findBar, CLOSE, true, CLOSE_ENTER);
        this.close.setToolTipText(Messages.FindBarDecorator_TOOLTIP_HideFindBar);
        this.close.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 1).create());
        this.disableWhenHidden = new Control[]{this.textFind, this.textReplace, optionsToolBar, this.close, this.findButton, this.replaceFind, this.replace, this.replaceAll};
        GridLayout findBarLayout = GridLayoutFactory.swtDefaults().margins(2, 0).spacing(4, 0).numColumns(6).create();
        findBarLayout.marginBottom = 2;
        this.findBar.setLayout((Layout)findBarLayout);
        this.findBar.setTabList(this.findBarTabOrder.toArray(new Control[this.findBarTabOrder.size()]));
        this.minimumFindBarHeight = this.findBar.computeSize((int)-1, (int)-1).y + findBarLayout.marginBottom;
        findBarVisibilityControl.register(this);
    }

    private void findBarFocusLost() {
        this.searchSelection.setSelection(false);
        this.updateSearchSelection();
    }

    private ToolItem createScopeToolItem(ToolBar parent) {
        this.findScope = FindScope.CURRENT_FILE;
        ToolItem toolItem = new ToolItem(parent, 4);
        toolItem.setText(Messages.FindBarDecorator_LABEL_Scope);
        toolItem.setToolTipText(MessageFormat.format(Messages.FindBarDecorator_TOOLTIP_Scope_menu_item, this.findScope.toString()));
        toolItem.setImage(FindBarPlugin.getImage("icons/elcl16/search_current_file.gif"));
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){
            Menu menu = null;

            public void widgetSelected(SelectionEvent e) {
                ToolItem toolItem = (ToolItem)e.widget;
                ToolBar toolbar = toolItem.getParent();
                Rectangle bounds = toolItem.getBounds();
                Point point = toolbar.toDisplay(new Point(bounds.x, bounds.y + bounds.height));
                if (this.menu == null) {
                    this.menu = new Menu((Decorations)UIUtils.getActiveShell(), toolbar.getStyle() & 0x6000000 | 8);
                    HashMap<String, List<TriggerSequence>> commandToBindings = FindBarDecorator.this.findBarActions.getCommandToBindings();
                    for (final FindScope scope : FindBarDecorator.this.scopeMap.keySet()) {
                        String commandId = "";
                        String trigger = "";
                        switch (scope) {
                            case CURRENT_FILE: {
                                commandId = "org.eclipse.ui.edit.findbar.searchInCurrentFile";
                                break;
                            }
                            case OPEN_FILES: {
                                commandId = "org.eclipse.ui.edit.findbar.searchInOpenFiles";
                                break;
                            }
                            case ENCLOSING_PROJECT: {
                                commandId = "org.eclipse.ui.edit.findbar.searchInEnclosingProject";
                                break;
                            }
                            case WORKSPACE: {
                                commandId = "org.eclipse.ui.edit.findbar.searchInWorkspace";
                            }
                        }
                        List triggers = (List)commandToBindings.get(commandId);
                        if (!CollectionsUtil.isEmpty((Collection)triggers)) {
                            trigger = ((TriggerSequence)triggers.get(0)).toString();
                        }
                        MenuItem menuItem = new MenuItem(this.menu, 0);
                        menuItem.setText(StringUtil.isEmpty((String)trigger) ? scope.toString() : MessageFormat.format(Messages.FindBarDecorator_LABEL_Scope_Shortcut, scope.toString(), trigger));
                        menuItem.setImage(FindBarPlugin.getImage(FindBarDecorator.this.scopeMap.get((Object)scope)));
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                FindBarDecorator.this.updateSearchScope(scope);
                            }
                        });
                    }
                }
                this.menu.setLocation(point.x, point.y);
                this.menu.setVisible(true);
            }
        });
        return toolItem;
    }

    void updateSearchScope(FindScope scope) {
        Control[] controls;
        this.findScope = scope;
        this.scopeToolItem.setImage(FindBarPlugin.getImage(this.scopeMap.get((Object)this.findScope)));
        this.scopeToolItem.setToolTipText(MessageFormat.format(Messages.FindBarDecorator_TOOLTIP_Scope_menu_item, this.findScope.toString()));
        boolean isCurrentFile = this.findScope == FindScope.CURRENT_FILE;
        Control[] controlArray = controls = new Control[]{this.textReplace, this.replace, this.replaceAll, this.replaceFind};
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(isCurrentFile);
            ++n2;
        }
        this.textReplace.setBackground(isCurrentFile ? null : UIUtils.getDisplay().getSystemColor(22));
        this.replaceHistory.setEnabled(isCurrentFile);
        this.searchSelection.setEnabled(isCurrentFile);
        this.countMatches.setEnabled(isCurrentFile);
    }

    private GridData createdDefaultGridData(int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace) {
        GridData gridData = new GridData(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace);
        return gridData;
    }

    private GridData createdDefaultGridData() {
        return this.createdDefaultGridData(16384, 0x1000000, false, false);
    }

    private Button createButton(Composite parent, String image, boolean enabled) {
        GridData layoutData = this.createdDefaultGridData();
        Button button = new Button(parent, 8);
        button.setEnabled(enabled);
        if (image != null) {
            button.setImage(FindBarPlugin.getImage(image));
        }
        button.addSelectionListener((SelectionListener)this);
        button.setLayoutData((Object)layoutData);
        this.setDefaultFocusListener(button);
        return button;
    }

    private ToolItem createHistoryToolItem(ToolBar toolbar, final String preferenceName) {
        ToolItem historyToolItem = new ToolItem(toolbar, 4);
        historyToolItem.setImage(FindBarPlugin.getImage("icons/elcl16/search_history.png"));
        historyToolItem.setToolTipText(Messages.FindBarDecorator_TOOLTIP_History);
        historyToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){
            Menu menu = null;

            public void widgetSelected(SelectionEvent e) {
                ToolItem toolItem = (ToolItem)e.widget;
                this.menu = FindBarDecorator.this.createHistoryMenu(toolItem, preferenceName, this.menu);
            }
        });
        return historyToolItem;
    }

    private Menu createHistoryMenu(ToolItem toolItem, final String preferenceName, Menu menu) {
        ToolBar toolbar = toolItem.getParent();
        Rectangle bounds = toolItem.getBounds();
        Point point = toolbar.toDisplay(new Point(bounds.x, bounds.y + bounds.height));
        List<String> loadEntries = findBarEntriesHelper.loadEntries(preferenceName);
        if (menu != null && !menu.isDisposed()) {
            menu.dispose();
        }
        menu = new Menu((Decorations)UIUtils.getActiveShell(), toolbar.getStyle() & 0x6000000 | 8);
        if (!CollectionsUtil.isEmpty(loadEntries)) {
            int i = 0;
            for (final String item : loadEntries) {
                final MenuItem menuItem = new MenuItem(menu, 0);
                menuItem.setData((Object)i);
                menuItem.setText(StringUtil.truncate((String)NEWLINE_SANITIZER.searchAndReplace(item), (int)30));
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ("FIND_BAR_DECORATOR_REPLACE_ENTRIES".equals(preferenceName)) {
                            FindBarDecorator.this.lastReplaceHistory = (Integer)menuItem.getData();
                        } else {
                            FindBarDecorator.this.lastFindHistory = (Integer)menuItem.getData();
                        }
                        FindBarDecorator.this.updateTextAfterHistorySelection(item, preferenceName);
                    }
                });
                ++i;
            }
        } else {
            MenuItem menuItem = new MenuItem(menu, 0);
            menuItem.setText(Messages.FindBarDecorator_LABEL_No_History);
        }
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
        return menu;
    }

    private void insertHistory(String preferenceName, boolean isNext) {
        List<String> loadEntries = findBarEntriesHelper.loadEntries(preferenceName);
        boolean isReplace = "FIND_BAR_DECORATOR_REPLACE_ENTRIES".equals(preferenceName);
        int currentIndex = isReplace ? this.lastReplaceHistory : this.lastFindHistory;
        if ((currentIndex += isNext ? -1 : 1) >= loadEntries.size()) {
            currentIndex = 0;
        } else if (currentIndex < 0) {
            currentIndex = loadEntries.size() - 1;
        }
        String text = loadEntries.get(currentIndex);
        this.updateTextAfterHistorySelection(text, preferenceName);
        if (isReplace) {
            this.lastReplaceHistory = currentIndex;
        } else {
            this.lastFindHistory = currentIndex;
        }
    }

    private void updateTextAfterHistorySelection(String text, String preferenceName) {
        Text textBox = "FIND_BAR_DECORATOR_REPLACE_ENTRIES".equals(preferenceName) ? this.textReplace : this.textFind;
        textBox.setForeground(null);
        textBox.setText(text);
        textBox.setSelection(0, text.length());
    }

    private Label createLabel(Composite parent, String image, boolean enabled, String imageEntered) {
        GridData layoutData = this.createdDefaultGridData();
        final Label label = new Label(parent, 0x1000000);
        label.setEnabled(enabled);
        final Image imageRegular = FindBarPlugin.getImage(image);
        label.setImage(imageRegular);
        final Image imageMouseOver = FindBarPlugin.getImage(imageEntered);
        label.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                label.setImage(imageRegular);
            }

            public void mouseEnter(MouseEvent e) {
                label.setImage(imageMouseOver);
            }
        });
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FindBarDecorator.this.handleWidgetSelected(label);
            }
        });
        label.setLayoutData((Object)layoutData);
        return label;
    }

    private void setDefaultFocusListener(Button button) {
        button.addFocusListener(this.findBarActions.createFocusListener(button));
    }

    private Text createText(String preferenceName) {
        Text text = null;
        text = PlatformUtil.isMac() ? new Text(this.findBar, 2048) : new Text(this.findBar, 2818);
        text.setLayoutData((Object)this.createdDefaultGridData(4, 4, true, true));
        this.entriesControlHandles.add(findBarEntriesHelper.register(text, this.modifyListener, preferenceName));
        text.addFocusListener(this.findBarActions.createFocusListener(text));
        text.addKeyListener(this.textKeyListner);
        return text;
    }

    @Override
    public void setVisible(boolean visible) {
        String selectedFindText = null;
        if (visible) {
            ITextSelection textSelection;
            String text;
            ISelection selection;
            Control focusControl = Display.getCurrent().getFocusControl();
            boolean wasExcluded = this.findBarGridData.exclude;
            if ((wasExcluded || focusControl instanceof StyledText) && (selection = this.sourceViewer.getSelectionProvider().getSelection()) instanceof ITextSelection && !StringUtil.isEmpty((String)(text = (textSelection = (ITextSelection)selection).getText()))) {
                selectedFindText = text;
            }
        }
        if (visible && this.isVisible() && selectedFindText == null) {
            visible = false;
        }
        findBarVisibilityControl.setVisible(visible, this, selectedFindText);
        if (visible) {
            this.textFind.setFocus();
            String text = this.textFind.getText();
            if (!StringUtil.isEmpty((String)text)) {
                this.textFind.setSelection(0, text.length());
            }
        }
    }

    @Override
    public boolean isVisible() {
        return !this.findBarGridData.exclude;
    }

    @Override
    public void installActions() {
        IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
        preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fFindBarActionOnPropertyChange);
        this.fOriginalFindBarAction = this.textEditor.getAction(ITextEditorActionConstants.FIND);
        this.updateFindBarAction();
    }

    private void updateFindBarAction() {
        IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
        boolean useCustomFindBar = preferenceStore.getBoolean("com.aptana.editor.findbar.useCustomFindBar");
        if (useCustomFindBar) {
            this.textEditor.setAction(ITextEditorActionConstants.FIND, (IAction)new ShowFindBarAction(this.textEditor));
        } else {
            this.textEditor.setAction(ITextEditorActionConstants.FIND, this.fOriginalFindBarAction);
        }
    }

    public Color getfStringNotFoundColor() {
        if (this.fStringNotFoundColor == null) {
            this.fStringNotFoundColor = new Color((Device)Display.getCurrent(), 255, 204, 102);
        }
        return this.fStringNotFoundColor;
    }

    @Override
    public void dispose() {
        findBarVisibilityControl.unregister(this);
        IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
        preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fFindBarActionOnPropertyChange);
        this.fOriginalFindBarAction = null;
        if (this.fStringNotFoundColor != null) {
            this.fStringNotFoundColor.dispose();
            this.fStringNotFoundColor = null;
        }
        for (FindBarOption opt : this.fFindBarOptions) {
            opt.dispose();
        }
        this.fFindBarOptions.clear();
        findBarEntriesHelper.unregister(this.entriesControlHandles);
        this.entriesControlHandles.clear();
        if (this.sourceViewer.getTextWidget() != null && !this.sourceViewer.getTextWidget().isDisposed()) {
            this.sourceViewer.getTextWidget().removeFocusListener(this.textViewerFocusListener);
        }
        if (this.findBarActions != null) {
            this.findBarActions.dispose();
            this.findBarActions = null;
        }
        this.fFindReplaceTarget = null;
        this.findBarFinder = null;
        this.textEditor = null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        this.handleWidgetSelected(source);
    }

    public void handleWidgetSelected(Object source) {
        if (source == this.close) {
            this.setVisible(false);
        } else if (source == this.findButton) {
            this.findNextOrPrev();
        } else if (source == this.replaceFind || source == this.replace) {
            this.replace(source == this.replaceFind);
        } else if (source == this.replaceAll) {
            this.replaceAll();
        } else {
            FindBarPlugin.log(new RuntimeException("Unhandled selection for widget: " + source));
        }
    }

    private void findNextOrprevAfterChangeOption() {
        if (this.isTextFindValid()) {
            this.setFindText(this.textFind.getText());
            this.findBarFinder.find(!this.getConfiguration().getSearchBackward(), true);
            this.showCountTotal();
        }
    }

    private boolean isTextFindValid() {
        return !DISABLED_COLOR.equals((Object)this.textFind.getForeground()) && !this.isTextFindEmpty();
    }

    private boolean isTextFindEmpty() {
        String findText = this.textFind.getText();
        return findText == null || findText.length() == 0;
    }

    private IFindReplaceTarget getFindReplaceTarget() {
        if (this.fFindReplaceTarget == null) {
            this.fFindReplaceTarget = (IFindReplaceTarget)this.textEditor.getAdapter(IFindReplaceTarget.class);
        }
        return this.fFindReplaceTarget;
    }

    private CopiedFromFindReplaceDialog getFindReplaceDialog() {
        if (this.fFindReplaceDialog == null) {
            this.fFindReplaceDialog = new CopiedFromFindReplaceDialog(this.getFindReplaceTarget(), this.statusLineManager);
        }
        return this.fFindReplaceDialog;
    }

    private void replace(boolean newFind) {
        ISelectionProvider selectionProvider = this.textEditor.getSelectionProvider();
        ISelection selection = selectionProvider.getSelection();
        if (!(selection instanceof ITextSelection)) {
            FindBarPlugin.log((Throwable)((Object)new AssertionError((Object)("Expected text editor selection to be an ITextSelection. Was: " + selection))));
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        String comboText = this.textFind.getText();
        if (comboText.length() == 0) {
            return;
        }
        this.setFindText(comboText);
        this.setFindTextOnReplace(this.getReplaceText());
        selectionProvider.setSelection((ISelection)new TextSelection(this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput()), textSelection.getOffset(), 0));
        if (!this.findBarFinder.find(true, false, false)) {
            return;
        }
        try {
            this.getFindReplaceDialog().replaceSelection(this.getReplaceText(), this.getConfiguration().getRegularExpression());
            this.showCountTotal();
        }
        catch (Exception e1) {
            this.statusLineManager.setMessage(true, MessageFormat.format(Messages.FindBarDecorator_ReplaceError, e1.getMessage()), null);
            FindBarPlugin.log(e1);
            return;
        }
        if (newFind) {
            if (this.getConfiguration().getSearchBackward()) {
                this.findBarFinder.find(false);
            } else {
                this.findBarFinder.find(true);
            }
        } else {
            this.statusLineManager.setMessage(false, "", null);
        }
    }

    private void replaceAll() {
        this.setFindText(this.textFind.getText());
        this.setFindTextOnReplace(this.getReplaceText());
        try {
            int replaced = this.getFindReplaceDialog().replaceAll(this.textFind.getText(), this.getReplaceText(), true, this.getConfiguration().getCaseSensitive(), this.getWholeWord(), this.getConfiguration().getRegularExpression());
            this.showCountTotal();
            this.statusLineManager.setMessage(false, String.format(Messages.FindBarDecorator_MSG_Replaced, replaced), null);
        }
        catch (PatternSyntaxException e1) {
            this.statusLineManager.setMessage(true, e1.getMessage(), null);
        }
    }

    boolean isFindTextActive() {
        return this.isVisible() && this.textFind.getDisplay().getFocusControl() == this.textFind;
    }

    boolean isReplaceTextActive() {
        return this.isVisible() && this.textReplace.getDisplay().getFocusControl() == this.textReplace;
    }

    private void adjustEnablement() {
        String text = this.textFind.getText();
        boolean isTextFindValue = this.isTextFindValid();
        this.findButton.setEnabled(isTextFindValue);
        this.replace.setEnabled(isTextFindValue);
        this.replaceFind.setEnabled(isTextFindValue);
        this.replaceAll.setEnabled(isTextFindValue);
        this.wholeWord.setEnabled(!"".equals(text) && !this.getConfiguration().getRegularExpression() && this.isWord(text));
    }

    void hideFindBar(boolean updateFocus) {
        if (!this.findBarGridData.exclude) {
            this.sashGridData.exclude = true;
            this.separatorGridData.exclude = true;
            this.findBarGridData.exclude = true;
            this.composite.layout();
            this.findBarFinder.resetIncrementalOffset();
            this.findBarFinder.resetScope();
            this.removeComboSearchOnTextChangeListener();
            if (this.statusLineManager != null) {
                this.statusLineManager.setMessage(false, "", null);
            }
        }
        if (updateFocus) {
            this.textEditor.setFocus();
        }
        if (this.disableWhenHidden != null) {
            Control[] controlArray = this.disableWhenHidden;
            int n = this.disableWhenHidden.length;
            int n2 = 0;
            while (n2 < n) {
                Control w = controlArray[n2];
                w.setEnabled(false);
                ++n2;
            }
        }
        this.sourceViewer.getTextWidget().removeFocusListener(this.textViewerFocusListener);
    }

    public void addComboSearchOnTextChangeListener() {
        this.textFind.addKeyListener((KeyListener)this.modifyListener);
        this.textFind.addModifyListener((ModifyListener)this.modifyListener);
    }

    public void removeComboSearchOnTextChangeListener() {
        this.textFind.removeKeyListener((KeyListener)this.modifyListener);
        this.textFind.removeModifyListener((ModifyListener)this.modifyListener);
    }

    void showFindBar(boolean updateFocus) {
        if (this.disableWhenHidden != null) {
            Control[] controlArray = this.disableWhenHidden;
            int n = this.disableWhenHidden.length;
            int n2 = 0;
            while (n2 < n) {
                Control w = controlArray[n2];
                if (w != null && !w.isDisposed()) {
                    w.setEnabled(true);
                }
                ++n2;
            }
        }
        boolean wasExcluded = this.findBarGridData.exclude;
        if (this.findBarGridData.exclude) {
            this.separatorGridData.exclude = false;
            this.sashGridData.exclude = false;
            this.findBarGridData.exclude = false;
            this.findBarGridData.heightHint = 60;
            this.composite.layout();
        }
        if (wasExcluded) {
            this.textFind.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FindBarDecorator.this.addComboSearchOnTextChangeListener();
                }
            });
        }
        this.adjustEnablement();
        if (!this.textFind.isFocusControl()) {
            this.textFind.setFocus();
            this.findBarFinder.resetIncrementalOffset();
        }
        this.sourceViewer.getTextWidget().addFocusListener(this.textViewerFocusListener);
    }

    void findPrevious() {
        if (this.findScope == FindScope.CURRENT_FILE && this.isTextFindValid()) {
            this.setFindText(this.textFind.getText());
            this.incrementCountPosition(false);
            this.findBarFinder.find(false);
            this.updateLastCountPosition();
        }
    }

    void findNext() {
        if (this.findScope == FindScope.CURRENT_FILE && this.isTextFindValid()) {
            this.setFindText(this.textFind.getText());
            this.incrementCountPosition(true);
            this.findBarFinder.find(true);
            this.updateLastCountPosition();
        }
    }

    void findNextOrPrev() {
        if (this.findScope == FindScope.CURRENT_FILE && this.isTextFindValid()) {
            if (this.getConfiguration().getSearchBackward()) {
                this.findPrevious();
            } else {
                this.findNext();
            }
        } else {
            this.searchInScope();
        }
    }

    boolean getWholeWord() {
        return this.wholeWord.getEnabled() && this.getConfiguration().getWholeWord() && !this.getConfiguration().getRegularExpression();
    }

    void setFindText(String findText) {
        this.setFindText(findText, this.textFind, "FIND_BAR_DECORATOR_FIND_ENTRIES");
    }

    private void setFindTextOnReplace(String findText) {
        this.setFindText(findText, this.textReplace, "FIND_BAR_DECORATOR_REPLACE_ENTRIES");
    }

    private void setFindText(String findText, Text text, String preferenceName) {
        findBarEntriesHelper.addEntry(findText, preferenceName);
        this.resetHistoryCounters();
    }

    private void resetHistoryCounters() {
        this.lastFindHistory = -1;
        this.lastReplaceHistory = -1;
    }

    void showCountTotal() {
        if (!this.countMatches.getSelection()) {
            this.countMatches.setText("");
            return;
        }
        this.lastCountOffset = this.sourceViewer.getTextWidget().getCaretOffset();
        int currentCount = 0;
        int total = 0;
        if (this.isTextFindValid()) {
            String text = this.sourceViewer.getDocument().get();
            Pattern pattern = this.createFindPattern();
            IRegion scope = this.findBarFinder.getScope();
            if (scope != null) {
                text = text.substring(scope.getOffset(), scope.getOffset() + scope.getLength());
            } else {
                scope = new Region(0, text.length());
            }
            Matcher matcher = pattern.matcher(text);
            if (matcher.find(0)) {
                total = 1;
                FindBarConfiguration configuration = this.getConfiguration();
                if (!configuration.getSearchBackward() && this.lastCountOffset > matcher.start() + scope.getOffset() || configuration.getSearchBackward() && this.lastCountOffset >= matcher.start() + scope.getOffset()) {
                    currentCount = total;
                }
                while (matcher.find()) {
                    ++total;
                    if (!configuration.getSearchBackward() && this.lastCountOffset > matcher.start() + scope.getOffset() || configuration.getSearchBackward() && this.lastCountOffset >= matcher.start() + scope.getOffset()) {
                        currentCount = total;
                    }
                    if (TOO_MANY != -1 && total > TOO_MANY) break;
                }
            }
            if (currentCount > total) {
                currentCount -= total;
            }
        }
        if (TOO_MANY != -1 && total > TOO_MANY) {
            this.countMatches.setText("> " + TOO_MANY);
            this.lastCountPosition = -1;
        } else {
            this.countMatches.setText(MessageFormat.format(Messages.FindBarDecorator_LABEL_Count_Match, String.valueOf(currentCount), String.valueOf(total)));
            this.lastCountPosition = currentCount;
        }
        this.lastCountTotal = total;
        this.findBar.layout(true, true);
    }

    Pattern createFindPattern() {
        String originalPattern = this.textFind.getText();
        String convertedPattern = this.convertTextString(originalPattern);
        boolean isRegEx = this.getConfiguration().getRegularExpression() || ObjectUtil.areNotEqual((Object)originalPattern, (Object)convertedPattern);
        boolean patternStringIsAWord = this.isWord(convertedPattern);
        int flags = 0;
        if (!this.getConfiguration().getCaseSensitive()) {
            flags |= 2;
        }
        if (!isRegEx) {
            convertedPattern = Pattern.quote(convertedPattern);
        }
        if (patternStringIsAWord && this.getWholeWord()) {
            convertedPattern = REGEX_WORD_BOUNDARY + convertedPattern + REGEX_WORD_BOUNDARY;
        }
        return Pattern.compile(convertedPattern, flags);
    }

    void incrementCountPosition(boolean isForward) {
        if (this.countMatches.getSelection()) {
            if (this.lastCountOffset == this.sourceViewer.getTextWidget().getCaretOffset()) {
                if (TOO_MANY != -1 && this.lastCountTotal > TOO_MANY) {
                    return;
                }
                if (isForward) {
                    ++this.lastCountPosition;
                    if (this.lastCountPosition > this.lastCountTotal) {
                        this.lastCountPosition = 1;
                    }
                } else {
                    --this.lastCountPosition;
                    if (this.lastCountPosition < 1) {
                        this.lastCountPosition = this.lastCountTotal;
                    }
                }
                this.countMatches.setText(MessageFormat.format(Messages.FindBarDecorator_LABEL_Count_Match, String.valueOf(this.lastCountPosition), String.valueOf(this.lastCountTotal)));
            } else {
                this.showCountTotal();
            }
            this.countMatches.getParent().getParent().layout(new Control[]{this.countMatches.getParent()});
        }
    }

    private void updateLastCountPosition() {
        if (this.countMatches.getSelection()) {
            this.lastCountOffset = this.sourceViewer.getTextWidget().getCaretOffset();
        }
    }

    void updateSearchSelection() {
        this.findBarFinder.resetScope();
        if (this.searchSelection.getSelection()) {
            if (!this.textReplace.isFocusControl()) {
                this.textFind.setFocus();
            }
            this.findBarFinder.enableScope(null);
        }
        if (this.countMatches.getSelection()) {
            this.showCountTotal();
        }
    }

    void showOptions(boolean useMousePos) {
        Point location;
        Menu menu = new Menu((Decorations)UIUtils.getActiveShell(), 8);
        for (FindBarOption option : this.fFindBarOptions) {
            option.createMenuItem(menu);
        }
        if (useMousePos) {
            Display current = UIUtils.getDisplay();
            location = current.getCursorLocation();
        } else {
            Rectangle bounds = this.options.getBounds();
            location = this.options.getParent().toDisplay(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        }
        menu.setLocation(location);
        menu.setVisible(true);
    }

    void searchInScope() {
        String searchText = this.textFind.getText();
        if (searchText.length() >= 0) {
            String convertedText = this.convertTextString(searchText);
            boolean isWholeWord = this.getConfiguration().getWholeWord();
            boolean isRegEx = this.getConfiguration().getRegularExpression() || ObjectUtil.areNotEqual((Object)searchText, (Object)convertedText);
            boolean isCaseSensitive = this.getConfiguration().getCaseSensitive();
            if (isWholeWord && !isRegEx && this.isWord(convertedText)) {
                isRegEx = true;
                convertedText = REGEX_WORD_BOUNDARY + convertedText + REGEX_WORD_BOUNDARY;
            }
            IStatusLineManager statusLineManager = (IStatusLineManager)this.textEditor.getAdapter(IStatusLineManager.class);
            switch (this.findScope) {
                case OPEN_FILES: {
                    FindHelper.findInOpenDocuments(convertedText, isCaseSensitive, isWholeWord, isRegEx, statusLineManager);
                    break;
                }
                case ENCLOSING_PROJECT: {
                    FindHelper.findInEnclosingProject(convertedText, isCaseSensitive, isWholeWord, isRegEx, statusLineManager);
                    break;
                }
                case WORKSPACE: {
                    FindHelper.findInWorkspace(convertedText, isCaseSensitive, isWholeWord, isRegEx, statusLineManager);
                }
            }
        }
    }

    String convertTextString(String textString) {
        if (!this.getConfiguration().getRegularExpression()) {
            StringBuilder sb = new StringBuilder();
            int startIndex = 0;
            Matcher matcher = StringUtil.LINE_SPLITTER.matcher(textString);
            while (matcher.find()) {
                sb.append(REGEX_LITERAL_START);
                sb.append(textString.substring(startIndex, matcher.start()));
                sb.append(REGEX_LITERAL_END);
                sb.append(StringUtil.REGEX_NEWLINE_GROUP);
                startIndex = matcher.end();
            }
            if (startIndex == 0) {
                sb.append(textString);
            } else if (startIndex < textString.length()) {
                sb.append(REGEX_LITERAL_START);
                sb.append(textString.substring(startIndex));
                sb.append(REGEX_LITERAL_END);
            }
            return sb.toString();
        }
        return textString;
    }

    void showFindReplaceDialog() {
        this.textFind.setFocus();
        IWorkbenchPartSite site = this.textEditor.getSite();
        ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
        Command findReplacecommand = commandService.getCommand(ActionFactory.FIND.create(site.getWorkbenchWindow()).getActionDefinitionId());
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        if (handlerService != null) {
            try {
                handlerService.executeCommand(new ParameterizedCommand(findReplacecommand, null), null);
            }
            catch (ExecutionException executionException) {
            }
            catch (NotDefinedException notDefinedException) {
            }
            catch (NotEnabledException notEnabledException) {
            }
            catch (NotHandledException notHandledException) {}
        }
    }

    boolean isWord(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void updateFromEclipseFindSettings() {
        eclipseFindSettings.readConfiguration();
        findBarConfiguration.updateFromEclipseFindSettings();
        findBarEntriesHelper.updateFromEclipseFindSettings();
    }

    public FindBarConfiguration getConfiguration() {
        return findBarConfiguration;
    }

    void layout() {
        Rectangle clientRect = this.composite.getClientArea();
        Rectangle hSashBounds = this.sash.getBounds();
        Rectangle separatorBounds = this.sashSeparator.getBounds();
        this.editorContent.setBounds(0, 0, clientRect.width, hSashBounds.y - separatorBounds.height);
        this.sashSeparator.setBounds(0, hSashBounds.y - separatorBounds.height, clientRect.width, separatorBounds.height);
        this.findBar.setBounds(0, hSashBounds.y + hSashBounds.height, clientRect.width, clientRect.height - (hSashBounds.y + hSashBounds.height));
        this.findBarGridData.heightHint = clientRect.height - (hSashBounds.y + hSashBounds.height);
    }

    String getLineDelimiter(IDocument document) {
        InstanceScope scope = EclipseUtil.instanceScope();
        IEclipsePreferences node = scope.getNode("org.eclipse.core.runtime");
        String separator = node.get("line.separator", "");
        if (StringUtil.isEmpty((String)separator)) {
            separator = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        }
        return separator;
    }

    String getReplaceText() {
        return this.textReplace == null || this.textReplace.isDisposed() || DISABLED_COLOR.equals((Object)this.textReplace.getForeground()) ? "" : this.textReplace.getText();
    }

    void inputNewline(Text text) {
        StringBuilder sb = new StringBuilder(text.getText());
        Point selection = text.getSelection();
        String delimiter = Text.DELIMITER;
        sb.replace(selection.x, selection.y, delimiter);
        text.setText(sb.toString());
        text.setSelection(selection.x + delimiter.length());
    }

    @Override
    public void activateContexts(String[] contextIds) {
        this.findBarActions.activateContexts(contextIds);
    }

    static enum FindScope {
        CURRENT_FILE(Messages.FindBarDecorator_LABEL_Scope_Current_File),
        OPEN_FILES(Messages.FindBarDecorator_LABEL_Scope_Open_Files),
        ENCLOSING_PROJECT(Messages.FindBarDecorator_LABEL_Scope_Enclosing_Project),
        WORKSPACE(Messages.FindBarDecorator_LABEL_Scope_Workspace);

        private String name;

        private FindScope(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private final class SearchOnTextChangedModifyListener
    implements ModifyListener,
    KeyListener,
    IStartEndIgnore {
        private String lastText = "";
        private int ignore;
        private boolean searchOnModifyText;

        private SearchOnTextChangedModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            FindBarDecorator.this.adjustEnablement();
            if (this.ignore > 0 || !this.searchOnModifyText) {
                return;
            }
            IPreferenceStore preferenceStore = FindBarPlugin.getDefault().getPreferenceStore();
            if (!preferenceStore.getBoolean("com.aptana.editor.findbar.incrementalSearchOnFindBar")) {
                return;
            }
            FindBarDecorator.this.textFind.setBackground(null);
            boolean wrap = true;
            String text = FindBarDecorator.this.textFind.getText();
            if (this.lastText.startsWith(text)) {
                wrap = false;
            }
            this.lastText = text;
            if ("".equals(text)) {
                ISelectionProvider selectionProvider = FindBarDecorator.this.textEditor.getSelectionProvider();
                ISelection selection = selectionProvider.getSelection();
                if (selection instanceof TextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    selectionProvider.setSelection((ISelection)new TextSelection(textSelection.getOffset(), 0));
                }
            } else {
                FindBarDecorator.this.findBarFinder.find(true, true, wrap);
            }
            FindBarDecorator.this.showCountTotal();
        }

        @Override
        public void startIgnore() {
            ++this.ignore;
        }

        @Override
        public void endIgnore() {
            Assert.isTrue((this.ignore > 0 ? 1 : 0) != 0);
            --this.ignore;
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000005: 
                case 0x1000006: {
                    this.searchOnModifyText = false;
                    break;
                }
                default: {
                    this.searchOnModifyText = true;
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            this.searchOnModifyText = false;
        }
    }

    private final class UpdateFindBarActionOnPropertyChange
    implements IPropertyChangeListener {
        private UpdateFindBarActionOnPropertyChange() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("com.aptana.editor.findbar.useCustomFindBar")) {
                FindBarDecorator.this.updateFindBarAction();
            }
        }
    }
}

