/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.findbar.FindBarPlugin;
import com.aptana.editor.findbar.impl.FindBarConfiguration;
import com.aptana.editor.findbar.impl.FindBarDecorator;
import com.aptana.editor.findbar.impl.Messages;
import com.aptana.ui.keybinding.KeyBindingHelper;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.ITextEditor;

public class FindBarActions {
    public static final String HIDE_FIND_BAR_COMMAND_ID = "org.eclipse.ui.edit.findbar.hide";
    public static final String FIND_PREVIOUS_COMMAND_ID = "org.eclipse.ui.edit.findbar.findPrevious";
    public static final String FIND_NEXT_COMMAND_ID = "org.eclipse.ui.edit.findbar.findNext";
    public static final String FIND_NEXT_OR_PREV_COMMAND_ID = "org.eclipse.ui.edit.findbar.findNextOrPrev";
    public static final String INPUT_NEWLINE_COMMAND_ID = "org.eclipse.ui.edit.findbar.inputNewline";
    public static final String FOCUS_REPLACE_COMMAND_ID = "org.eclipse.ui.edit.findbar.focusReplace";
    public static final String FOCUS_FIND_COMMAND_ID = "org.eclipse.ui.edit.findbar.focusFind";
    public static final String FOCUS_FIND_OR_OPEN_ECLIPSE_SEARCH_COMMAND_ID = "org.eclipse.ui.edit.findbar.focusFindOrOpenEclipseSearch";
    public static final String TOGGLE_CASE_MATCHING_COMMAND_ID = "org.eclipse.ui.edit.findbar.toggleCaseMatching";
    public static final String TOGGLE_REGEXP_MATCHING_COMMAND_ID = "org.eclipse.ui.edit.findbar.toggleRegexpMatching";
    public static final String TOGGLE_SEARCH_BACKWARD_COMMAND_ID = "org.eclipse.ui.edit.findbar.toggleSearchBackward";
    public static final String TOGGLE_COUNT_MATCHES_COMMAND_ID = "org.eclipse.ui.edit.findbar.toggleMatchCount";
    public static final String TOGGLE_WORD_MATCHING_COMMAND_ID = "org.eclipse.ui.edit.findbar.toggleWordMatching";
    public static final String TOGGLE_SEARCH_SELECTION_COMMAND_ID = "org.eclipse.ui.edit.findbar.toggleSearchSelection";
    public static final String SEARCH_IN_OPEN_FILES_COMMAND_ID = "org.eclipse.ui.edit.findbar.searchInOpenFiles";
    public static final String SEARCH_IN_CURRENT_FILE_COMMAND_ID = "org.eclipse.ui.edit.findbar.searchInCurrentFile";
    public static final String SEARCH_IN_ENCLOSING_PROJECT_COMMAND_ID = "org.eclipse.ui.edit.findbar.searchInEnclosingProject";
    public static final String SEARCH_IN_WORKSPACE_COMMAND_ID = "org.eclipse.ui.edit.findbar.searchInWorkspace";
    public static final String SHOW_OPTIONS_COMMAND_ID = "org.eclipse.ui.edit.findbar.showOptions";
    private boolean fActivated;
    private IContextActivation findBarContextActivation;
    private final Map<String, AbstractHandler> fCommandToHandler = new HashMap<String, AbstractHandler>();
    private final List<IHandlerActivation> fHandlerActivations = new ArrayList<IHandlerActivation>();
    private final IBindingManagerListener fClearCommandToBindingOnChangesListener = new IBindingManagerListener(){

        public void bindingManagerChanged(BindingManagerEvent event) {
            if (event.isActiveBindingsChanged()) {
                FindBarActions.this.fCommandToBinding = null;
            }
        }
    };
    private HashMap<String, List<TriggerSequence>> fCommandToBinding;
    private ITextEditor textEditor;
    private WeakReference<FindBarDecorator> findBarDecorator;
    private List<String> editorContextIds = new ArrayList<String>();
    private List<IContextActivation> editorContextActivations = new ArrayList<IContextActivation>();

    public FindBarActions(ITextEditor textEditor, FindBarDecorator findBarDecorator) {
        this.textEditor = textEditor;
        this.findBarDecorator = new WeakReference<FindBarDecorator>(findBarDecorator);
        this.fCommandToHandler.put(HIDE_FIND_BAR_COMMAND_ID, new HideFindBarHandler());
        this.fCommandToHandler.put(FIND_PREVIOUS_COMMAND_ID, new FindPreviousHandler());
        this.fCommandToHandler.put(FIND_NEXT_COMMAND_ID, new FindNextHandler());
        this.fCommandToHandler.put(FIND_NEXT_OR_PREV_COMMAND_ID, new FindNextOrPrevHandler());
        this.fCommandToHandler.put(INPUT_NEWLINE_COMMAND_ID, new InputNewlineInFindBarHandler());
        this.fCommandToHandler.put(FOCUS_FIND_COMMAND_ID, new FocusFindFindBarHandler());
        this.fCommandToHandler.put(FOCUS_FIND_OR_OPEN_ECLIPSE_SEARCH_COMMAND_ID, new FocusFindOrOpenEclipseSearchFindBarHandler());
        this.fCommandToHandler.put(FOCUS_REPLACE_COMMAND_ID, new FocusReplaceFindBarHandler());
        this.fCommandToHandler.put(TOGGLE_CASE_MATCHING_COMMAND_ID, new ToggleCaseFindBarHandler());
        this.fCommandToHandler.put(TOGGLE_WORD_MATCHING_COMMAND_ID, new ToggleWordFindBarHandler());
        this.fCommandToHandler.put(TOGGLE_REGEXP_MATCHING_COMMAND_ID, new ToggleRegexpFindBarHandler());
        this.fCommandToHandler.put(TOGGLE_SEARCH_BACKWARD_COMMAND_ID, new ToggleSearchBackwardFindBarHandler());
        this.fCommandToHandler.put(TOGGLE_COUNT_MATCHES_COMMAND_ID, new ToggleMatchCountFindBarHandler());
        this.fCommandToHandler.put(TOGGLE_SEARCH_SELECTION_COMMAND_ID, new ToggleSearchSelectionFindBarHandler());
        this.fCommandToHandler.put(SEARCH_IN_OPEN_FILES_COMMAND_ID, new ChangeScopeHandler(FindBarDecorator.FindScope.OPEN_FILES));
        this.fCommandToHandler.put(SEARCH_IN_CURRENT_FILE_COMMAND_ID, new ChangeScopeHandler(FindBarDecorator.FindScope.CURRENT_FILE));
        this.fCommandToHandler.put(SEARCH_IN_ENCLOSING_PROJECT_COMMAND_ID, new ChangeScopeHandler(FindBarDecorator.FindScope.ENCLOSING_PROJECT));
        this.fCommandToHandler.put(SEARCH_IN_WORKSPACE_COMMAND_ID, new ChangeScopeHandler(FindBarDecorator.FindScope.WORKSPACE));
        this.fCommandToHandler.put(SHOW_OPTIONS_COMMAND_ID, new ShowOptionsFindBarHandler());
        this.fCommandToHandler.put("org.eclipse.ui.edit.undo", null);
        this.fCommandToHandler.put("org.eclipse.ui.edit.redo", null);
        this.fCommandToHandler.put("org.eclipse.ui.file.closePart", null);
        this.fCommandToHandler.put("org.eclipse.ui.file.close", null);
        this.fCommandToHandler.put("org.eclipse.ui.file.closeAll", null);
        this.fCommandToHandler.put("org.eclipse.ui.file.save", null);
        this.fCommandToHandler.put("org.eclipse.ui.file.saveAll", null);
        this.fCommandToHandler.put("org.eclipse.ui.navigate.openResource", null);
        this.fCommandToHandler.put("org.eclipse.ui.views.showView", null);
        this.fCommandToHandler.put("org.eclipse.ui.navigate.backwardHistory", null);
        this.fCommandToHandler.put("org.eclipse.ui.navigate.forwardHistory", null);
        this.fCommandToHandler.put("org.eclipse.ui.window.switchToEditor", null);
        this.fCommandToHandler.put("org.eclipse.ui.window.nextEditor", null);
        this.fCommandToHandler.put("org.eclipse.ui.window.previousEditor", null);
        this.fCommandToHandler.put("org.eclipse.ui.window.nextView", null);
        this.fCommandToHandler.put("org.eclipse.ui.window.previousView", null);
        this.fCommandToHandler.put("org.eclipse.ui.window.nextPerspective", null);
        this.fCommandToHandler.put("org.eclipse.ui.window.previousPerspective", null);
        this.fCommandToHandler.put("org.eclipse.ui.part.nextPage", null);
        this.fCommandToHandler.put("org.eclipse.ui.part.previousPage", null);
        this.fCommandToHandler.put("org.eclipse.ui.window.showKeyAssist", null);
        this.fCommandToHandler.put("org.eclipse.debug.ui.commands.RunLast", null);
        this.fCommandToHandler.put("org.eclipse.debug.ui.commands.DebugLast", null);
        this.fCommandToHandler.put("org.eclipse.debug.ui.commands.Terminate", null);
        this.fCommandToHandler.put("org.python.pydev.editor.actions.pyShowOutline", null);
        this.fCommandToHandler.put("org.python.pydev.editor.actions.pyShowBrowser", null);
        this.fCommandToHandler.put("com.python.pydev.analysis.actions.pyGlobalsBrowserWorkbench", null);
        this.fCommandToHandler.put("org.python.pydev.debug.ui.actions.runEditorBasedOnNatureTypeAction", null);
        this.fCommandToHandler.put("org.python.pydev.debug.ui.actions.runEditorAsCustomUnitTestAction", null);
        this.fCommandToHandler.put("org.python.pydev.debug.ui.actions.relaunchLastAction", null);
        this.fCommandToHandler.put("org.python.pydev.debug.ui.actions.terminateAllLaunchesAction", null);
        this.fCommandToHandler.put("com.aptana.editor.NextEditorCommand", null);
        this.fCommandToHandler.put("com.aptana.editor.PreviousEditorCommand", null);
        this.fCommandToHandler.put("com.aptana.editor.js.quick_outline", null);
        this.fCommandToHandler.put("com.aptana.editor.php.openType.command", null);
        this.fCommandToHandler.put("org.eclipse.jdt.ui.navigate.open.type", null);
    }

    private void setFindBarContextActive(boolean activate) {
        this.fActivated = activate;
        IWorkbenchPartSite site = this.textEditor.getSite();
        IContextService contextService = (IContextService)site.getService(IContextService.class);
        IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
        IBindingService service = (IBindingService)site.getService(IBindingService.class);
        if (activate) {
            for (Map.Entry<String, AbstractHandler> entry : this.fCommandToHandler.entrySet()) {
                AbstractHandler handler = entry.getValue();
                if (handler == null) continue;
                this.fHandlerActivations.add(handlerService.activateHandler(entry.getKey(), (IHandler)handler));
            }
            service.setKeyFilterEnabled(false);
            service.addBindingManagerListener(this.fClearCommandToBindingOnChangesListener);
            this.findBarContextActivation = contextService.activateContext("org.eclipse.ui.textEditorScope.findbar");
            contextService.deactivateContexts(this.editorContextActivations);
        } else {
            this.fCommandToBinding = null;
            service.setKeyFilterEnabled(true);
            if (this.findBarContextActivation != null) {
                service.removeBindingManagerListener(this.fClearCommandToBindingOnChangesListener);
                handlerService.deactivateHandlers(this.fHandlerActivations);
                this.fHandlerActivations.clear();
                contextService.deactivateContext(this.findBarContextActivation);
                this.findBarContextActivation = null;
            }
            this.activateContexts(this.editorContextIds.toArray(new String[this.editorContextIds.size()]));
        }
    }

    public void activateContexts(String[] contextIds) {
        IContextService contextService;
        if (this.textEditor != null && (contextService = (IContextService)this.textEditor.getSite().getService(IContextService.class)) != null) {
            this.editorContextActivations.clear();
            this.editorContextIds.clear();
            String[] stringArray = contextIds;
            int n = contextIds.length;
            int n2 = 0;
            while (n2 < n) {
                String contextId = stringArray[n2];
                this.editorContextIds.add(contextId);
                this.editorContextActivations.add(contextService.activateContext(contextId));
                ++n2;
            }
        }
    }

    public void updateCommandToBinding() {
        this.fCommandToBinding = this.getCommandToBindings();
        FindBarDecorator dec = (FindBarDecorator)this.findBarDecorator.get();
        if (dec != null) {
            ArrayList<String> triggers;
            List<TriggerSequence> newlineTriggers;
            this.updateTooltip(TOGGLE_WORD_MATCHING_COMMAND_ID, Messages.FindBarDecorator_LABEL_WholeWord, dec.wholeWord);
            this.updateTooltip(TOGGLE_CASE_MATCHING_COMMAND_ID, Messages.FindBarDecorator_LABEL_CaseSensitive, dec.caseSensitive);
            if (dec.regularExpression != null) {
                this.updateTooltip(TOGGLE_REGEXP_MATCHING_COMMAND_ID, Messages.FindBarDecorator_LABEL_RegularExpression, dec.regularExpression);
            }
            this.updateTooltip(TOGGLE_SEARCH_BACKWARD_COMMAND_ID, Messages.FindBarDecorator_LABEL_SearchBackward, dec.searchBackward);
            this.updateTooltip(TOGGLE_COUNT_MATCHES_COMMAND_ID, Messages.FindBarDecorator_TOOLTIP_ShowMatchCount, dec.countMatches);
            this.updateTooltip(TOGGLE_SEARCH_SELECTION_COMMAND_ID, Messages.FindBarDecorator_LABEL_SearchSelection, dec.searchSelection);
            this.updateTooltip(SHOW_OPTIONS_COMMAND_ID, Messages.FindBarDecorator_LABEL_ShowOptions, dec.options);
            String prevHistoryKey = KeySequence.getInstance((KeyStroke)KeyStroke.getInstance((int)SWT.MOD1, (int)0x1000001)).toString();
            String nextHistoryKey = KeySequence.getInstance((KeyStroke)KeyStroke.getInstance((int)SWT.MOD1, (int)0x1000002)).toString();
            List<TriggerSequence> bindings = this.fCommandToBinding.get(FOCUS_REPLACE_COMMAND_ID);
            if (!CollectionsUtil.isEmpty(bindings)) {
                newlineTriggers = this.fCommandToBinding.get(INPUT_NEWLINE_COMMAND_ID);
                triggers = new ArrayList<String>(newlineTriggers.size() + 1);
                triggers.add(bindings.get(0).toString());
                for (TriggerSequence sequence : newlineTriggers) {
                    triggers.add(sequence.toString());
                }
                if (triggers.size() < 3) {
                    triggers.add("");
                }
                triggers.add(prevHistoryKey);
                triggers.add(nextHistoryKey);
                dec.textReplace.setToolTipText(MessageFormat.format(Messages.FindBarActions_TOOLTIP_FocusReplaceCombo, triggers.toArray(new Object[triggers.size()])));
            }
            if (!CollectionsUtil.isEmpty(bindings = this.fCommandToBinding.get(FOCUS_FIND_COMMAND_ID))) {
                newlineTriggers = this.fCommandToBinding.get(INPUT_NEWLINE_COMMAND_ID);
                triggers = new ArrayList(newlineTriggers.size() + 1);
                triggers.add(bindings.get(0).toString());
                for (TriggerSequence sequence : newlineTriggers) {
                    triggers.add(sequence.toString());
                }
                if (triggers.size() < 3) {
                    triggers.add("");
                }
                triggers.add(prevHistoryKey);
                triggers.add(nextHistoryKey);
                dec.textFind.setToolTipText(MessageFormat.format(Messages.FindBarActions_TOOLTIP_FocusFindCombo, triggers.toArray(new Object[triggers.size()])));
            }
        }
    }

    private void updateTooltip(String commandId, String tooltip, ToolItem item) {
        List<TriggerSequence> bindings = this.fCommandToBinding.get(commandId);
        if (bindings != null && bindings.size() > 0) {
            item.setToolTipText(MessageFormat.format("{0} ({1})", tooltip, bindings.get(0)));
        } else {
            item.setToolTipText(tooltip);
        }
    }

    public HashMap<String, List<TriggerSequence>> getCommandToBindings() {
        HashMap<String, List<TriggerSequence>> commandToBinding = new HashMap<String, List<TriggerSequence>>();
        IWorkbenchPartSite site = this.textEditor.getSite();
        IBindingService service = (IBindingService)site.getService(IBindingService.class);
        Binding[] bindings = service.getBindings();
        int i = 0;
        while (i < bindings.length) {
            String id;
            Binding binding = bindings[i];
            ParameterizedCommand command = binding.getParameterizedCommand();
            if (command != null && this.fCommandToHandler.containsKey(id = command.getId())) {
                List<TriggerSequence> list = commandToBinding.get(id);
                if (list == null) {
                    list = new ArrayList<TriggerSequence>();
                    commandToBinding.put(id, list);
                }
                list.add(binding.getTriggerSequence());
            }
            ++i;
        }
        return commandToBinding;
    }

    public boolean isActivated() {
        return this.fActivated;
    }

    public FocusListener createFocusListener(Button button) {
        return new FindBarControlFocusListener((Control)button);
    }

    public FocusListener createFocusListener(Text text) {
        final WeakReference<Text> weakText = new WeakReference<Text>(text);
        return new FindBarControlFocusListener((Control)text){

            @Override
            public void focusGained(FocusEvent e) {
                Text text = (Text)weakText.get();
                if (text != null) {
                    text.setBackground(null);
                    if (FindBarDecorator.DISABLED_COLOR.equals((Object)text.getForeground())) {
                        text.setText("");
                        text.setForeground(null);
                    }
                }
                super.focusGained(e);
            }
        };
    }

    public void dispose() {
        if (this.editorContextActivations != null) {
            this.editorContextActivations.clear();
        }
        this.textEditor = null;
    }

    private class ChangeScopeHandler
    extends AbstractHandler {
        FindBarDecorator.FindScope scope;

        ChangeScopeHandler(FindBarDecorator.FindScope scope) {
            this.scope = scope;
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                dec.updateSearchScope(this.scope);
            }
            return null;
        }
    }

    private class FindBarControlFocusListener
    implements FocusListener,
    Listener {
        private Control control;
        private boolean listening = false;
        private Display display;
        private boolean firstActivation = true;

        public FindBarControlFocusListener(Control control) {
            this.control = control;
        }

        public void focusLost(FocusEvent e) {
            if (!this.listening) {
                return;
            }
            this.listening = false;
            FindBarActions.this.setFindBarContextActive(false);
            this.display.removeFilter(1, (Listener)this);
            this.display.removeFilter(31, (Listener)this);
        }

        public void focusGained(FocusEvent e) {
            if (this.listening) {
                return;
            }
            if (this.firstActivation) {
                this.firstActivation = false;
                FindBarActions.this.updateCommandToBinding();
            }
            this.listening = true;
            this.display = PlatformUI.getWorkbench().getDisplay();
            this.display.addFilter(1, (Listener)this);
            this.display.addFilter(31, (Listener)this);
            FindBarActions.this.setFindBarContextActive(true);
        }

        public void handleEvent(Event event) {
            if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
                return;
            }
            if (event.widget != this.control) {
                return;
            }
            boolean consumed = this.processEvent(event.keyCode, event.stateMask);
            if (consumed) {
                this.consumeEvent(event);
            }
        }

        private void consumeEvent(Event event) {
            switch (event.type) {
                case 1: {
                    event.doit = false;
                    break;
                }
                case 31: {
                    event.detail = 0;
                    event.doit = true;
                }
            }
            event.type = 0;
        }

        private boolean processEvent(int keyCode, int stateMask) {
            HashMap commandToBinding;
            boolean consumed = false;
            if (FindBarActions.this.fCommandToBinding == null) {
                FindBarActions.this.updateCommandToBinding();
            }
            if ((commandToBinding = FindBarActions.this.fCommandToBinding) != null) {
                for (Map.Entry entry : commandToBinding.entrySet()) {
                    List value = (List)entry.getValue();
                    for (TriggerSequence seq : value) {
                        KeySequence keySequence;
                        if (!(seq instanceof KeySequence) || !KeyBindingHelper.matchesKeybinding((int)keyCode, (int)stateMask, (TriggerSequence)(keySequence = (KeySequence)seq))) continue;
                        consumed = true;
                        IHandlerService handlerService = (IHandlerService)FindBarActions.this.textEditor.getSite().getService(IHandlerService.class);
                        try {
                            handlerService.executeCommand((String)entry.getKey(), null);
                        }
                        catch (NotHandledException notHandledException) {
                            continue;
                        }
                        catch (NotEnabledException notEnabledException) {
                            continue;
                        }
                        catch (Exception e1) {
                            FindBarPlugin.log(e1);
                        }
                        return consumed;
                    }
                }
            }
            return consumed;
        }
    }

    private class FindNextHandler
    extends AbstractHandler {
        private FindNextHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                dec.findNext();
            }
            return null;
        }
    }

    private class FindNextOrPrevHandler
    extends AbstractHandler {
        private FindNextOrPrevHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null && dec.findButton.isEnabled()) {
                dec.findNextOrPrev();
            }
            return null;
        }
    }

    private class FindPreviousHandler
    extends AbstractHandler {
        private FindPreviousHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                dec.findPrevious();
            }
            return null;
        }
    }

    private class FocusFindFindBarHandler
    extends AbstractHandler {
        private FocusFindFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                dec.textFind.setFocus();
                dec.textFind.setSelection(new Point(0, dec.textFind.getText().length()));
            }
            return null;
        }
    }

    private class FocusFindOrOpenEclipseSearchFindBarHandler
    extends AbstractHandler {
        private FocusFindOrOpenEclipseSearchFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                IEclipsePreferences preferenceStore = EclipseUtil.instanceScope().getNode("com.aptana.editor.findbar");
                boolean openEclipseFindBar = preferenceStore.getBoolean("com.aptana.editor.findbar.ctrlFTwiceOpensEclipseFindBar", false);
                if (openEclipseFindBar) {
                    dec.showFindReplaceDialog();
                } else {
                    dec.findNextOrPrev();
                }
            }
            return null;
        }
    }

    private class FocusReplaceFindBarHandler
    extends AbstractHandler {
        private FocusReplaceFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                dec.textReplace.setFocus();
                dec.textReplace.setSelection(new Point(0, dec.textReplace.getText().length()));
            }
            return null;
        }
    }

    private class HideFindBarHandler
    extends AbstractHandler {
        private HideFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                dec.setVisible(false);
            }
            return null;
        }
    }

    private class InputNewlineInFindBarHandler
    extends AbstractHandler {
        private InputNewlineInFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec.isFindTextActive()) {
                dec.inputNewline(dec.textFind);
            } else if (dec.isReplaceTextActive()) {
                dec.inputNewline(dec.textReplace);
            }
            return null;
        }
    }

    private class ShowOptionsFindBarHandler
    extends AbstractHandler {
        private ShowOptionsFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                dec.showOptions(false);
            }
            return null;
        }
    }

    private class ToggleCaseFindBarHandler
    extends AbstractHandler {
        private ToggleCaseFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                FindBarConfiguration conf;
                conf.setCaseSensitive(!(conf = dec.getConfiguration()).getCaseSensitive());
            }
            return null;
        }
    }

    private class ToggleMatchCountFindBarHandler
    extends AbstractHandler {
        private ToggleMatchCountFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                FindBarConfiguration conf;
                conf.setMatchCount(!(conf = dec.getConfiguration()).getMatchCount());
                dec.showCountTotal();
            }
            return null;
        }
    }

    private class ToggleRegexpFindBarHandler
    extends AbstractHandler {
        private ToggleRegexpFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                FindBarConfiguration conf;
                conf.setRegularExpression(!(conf = dec.getConfiguration()).getRegularExpression());
            }
            return null;
        }
    }

    private class ToggleSearchBackwardFindBarHandler
    extends AbstractHandler {
        private ToggleSearchBackwardFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                FindBarConfiguration conf;
                conf.setSearchBackward(!(conf = dec.getConfiguration()).getSearchBackward());
            }
            return null;
        }
    }

    private class ToggleSearchSelectionFindBarHandler
    extends AbstractHandler {
        private ToggleSearchSelectionFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                dec.searchSelection.setSelection(!dec.searchSelection.getSelection());
                dec.updateSearchSelection();
            }
            return null;
        }
    }

    private class ToggleWordFindBarHandler
    extends AbstractHandler {
        private ToggleWordFindBarHandler() {
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            FindBarDecorator dec = (FindBarDecorator)FindBarActions.this.findBarDecorator.get();
            if (dec != null) {
                FindBarConfiguration conf;
                conf.setWholeWord(!(conf = dec.getConfiguration()).getWholeWord());
            }
            return null;
        }
    }
}

