/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.quicksearch.ui.internal.quicksearch;

import com.pandora.core.index.QuickSearchIndexResult;
import com.pandora.core.utils.ProjectUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class IndexElement
extends QuickAccessElement {
    private QuickSearchIndexResult quickSearchIndexResult;
    private IProject project;
    private String separator = " - ";

    public IndexElement(QuickAccessProvider provider, QuickSearchIndexResult quickSearchIndexResult) {
        super(provider);
        this.quickSearchIndexResult = quickSearchIndexResult;
        this.project = ProjectUtils.getCurrentProject();
    }

    public String getLabel() {
        return this.quickSearchIndexResult.getName();
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.createFromImage((Image)this.quickSearchIndexResult.getImage());
    }

    public String getId() {
        return String.valueOf(this.quickSearchIndexResult.hashCode());
    }

    public void execute() {
        IFile file = this.project.getFile(this.quickSearchIndexResult.getPath());
        if (file == null || !file.exists()) {
            return;
        }
        try {
            AbstractTextEditor editor;
            ISelection selection;
            IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            int start = 0;
            if (editorPart instanceof AbstractTextEditor && (selection = (editor = (AbstractTextEditor)editorPart).getSelectionProvider().getSelection()) != null && selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                start = textSelection.getOffset() + textSelection.getLength();
            }
            editorPart.setFocus();
            ITextSelection selection2 = this.quickSearchIndexResult.getSelection(editorPart);
            if (selection2 != null) {
                if (editorPart instanceof AbstractTextEditor) {
                    AbstractTextEditor editor2 = (AbstractTextEditor)editorPart;
                    editor2.getSelectionProvider().setSelection((ISelection)selection2);
                }
            } else {
                IFindReplaceTarget target = (IFindReplaceTarget)editorPart.getAdapter(IFindReplaceTarget.class);
                if (target != null && target.canPerformFind()) {
                    String name = this.quickSearchIndexResult.getName();
                    if (QuickSearchIndexResult.FileType.CSS_FILE == this.quickSearchIndexResult.getFileType()) {
                        if (QuickSearchIndexResult.ResultType.ID == this.quickSearchIndexResult.getType()) {
                            name = "#" + name;
                        } else if (QuickSearchIndexResult.ResultType.CLASS == this.quickSearchIndexResult.getType()) {
                            name = "\\." + name;
                        }
                    }
                    if (target instanceof IFindReplaceTargetExtension3) {
                        IFindReplaceTargetExtension3 exts = (IFindReplaceTargetExtension3)target;
                        int i = exts.findAndSelect(start, name, true, true, false, true);
                        if (i == -1) {
                            start = 0;
                            i = exts.findAndSelect(start, name, true, true, false, true);
                        }
                    } else {
                        int i = target.findAndSelect(start, name, true, true, true);
                        if (i == -1) {
                            start = 0;
                            i = target.findAndSelect(start, name, true, true, true);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSortLabel() {
        return String.valueOf(this.quickSearchIndexResult.getType().getName()) + this.quickSearchIndexResult.getName() + this.separator + this.project.getName() + "/" + this.quickSearchIndexResult.getPath();
    }
}

