/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.quicksearch.ui.internal.quicksearch;

import com.pandora.quicksearch.ui.internal.quicksearch.FileElement;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

public class FileProvider
extends QuickAccessProvider {
    private Map<String, QuickAccessElement> idToElement;
    private QuickAccessProvider provider;

    public String getId() {
        return "com.pandora.quicksearch.ui.fileprovider";
    }

    public String getName() {
        return "\u6587\u4ef6";
    }

    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_NODE");
    }

    public QuickAccessElement[] getElements() {
        this.provider = this;
        if (this.idToElement == null) {
            this.idToElement = new HashMap<String, QuickAccessElement>();
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            try {
                CollectingResourceVisitor visitor = new CollectingResourceVisitor();
                ws.getRoot().accept((IResourceProxyVisitor)visitor, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.values().size()]);
    }

    public QuickAccessElement getElementForId(String id) {
        this.getElements();
        return this.idToElement.get(id);
    }

    private class CollectingResourceVisitor
    implements IResourceProxyVisitor {
        private CollectingResourceVisitor() {
        }

        public boolean visit(IResourceProxy proxy) {
            IResource resource = proxy.requestResource();
            if (resource == null) {
                return false;
            }
            if (1 == resource.getType()) {
                IFile iFile = (IFile)resource;
                String fname = iFile.getName();
                if (fname.charAt(0) == '.') {
                    return false;
                }
                FileElement fElement = new FileElement(iFile, FileProvider.this.provider);
                FileProvider.this.idToElement.put(iFile.getFullPath().toOSString(), fElement);
            }
            return true;
        }
    }
}

