/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.quicksearch.ui;

import com.pandora.core.index.QuickSearchType;
import com.pandora.quicksearch.ui.QuickSearchUtil;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class QuickSearchItem
extends ContributionItem {
    private ToolItem menuToolItem;
    private Menu fMenu;
    private static Rectangle rectangle = null;

    public void fill(final ToolBar toolBar, int index) {
        super.fill(toolBar, index);
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        if (this.menuToolItem != null) {
            this.menuToolItem.dispose();
        }
        this.fMenu = new Menu((Decorations)toolBar.getShell(), 8);
        this.menuToolItem = new ToolItem(toolBar, 4);
        this.menuToolItem.setImage(QuickSearchUtil.DEFAULT_TYPE_IMAGE);
        this.menuToolItem.setToolTipText("\u6ce8\uff1a\u9ed8\u8ba4\u641c\u7d22\u662f\u5f53\u524d\u7f16\u8f91\u5668\u5355\u8bcd\uff0c\u8f93\u5165\u201c@\u201d\u53f7\u540e\u641c\u7d22\u76f8\u5173\u53d8\u91cf\uff0c\u8f93\u5165\u201c:\u201d\u53f7\u540e\u662f\u8f6c\u5230\u884c\uff0c\u8f93\u5165\u201c/\u201d\u53f7\u540e\u641c\u7d22\u6587\u4ef6\uff0c\u8f93\u5165\u201c!\u201d\u53f7\u540e\u641c\u7d22\u529f\u80fd\uff0c\u8f93\u5165\u201c?\u201d\u53f7\u540e\u641c\u7d22\u95ee\u7b54");
        this.menuToolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                QuickSearchItem.this.showMenu(toolBar, QuickSearchItem.this.fMenu, QuickSearchItem.this.menuToolItem);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void showMenu(ToolBar toolBar, Menu menu, ToolItem menuToolItem) {
        QuickSearchUtil.closeQuickSearchDialog();
        if (rectangle == null && menuToolItem != null && !menuToolItem.isDisposed()) {
            rectangle = menuToolItem.getBounds();
        }
        if (menu.getItemCount() == 0) {
            MenuItem defalut = new MenuItem(menu, 64);
            defalut.setText("\u67e5\u627e\u4e0b\u4e00\u4e2a\uff08\u9ed8\u8ba4\uff09(&N)");
            defalut.addSelectionListener((SelectionListener)new Selection(QuickSearchType.DEFAULT));
            MenuItem indexItem = new MenuItem(menu, 64);
            indexItem.setText("\u67e5\u627e\u53d8\u91cf(&V)");
            indexItem.addSelectionListener((SelectionListener)new Selection(QuickSearchType.INDEX));
            MenuItem gotoLineItem = new MenuItem(menu, 64);
            gotoLineItem.setText("\u8f6c\u5230\u884c(&G)");
            gotoLineItem.addSelectionListener((SelectionListener)new Selection(QuickSearchType.GOTO_LINE));
            MenuItem fileItem = new MenuItem(menu, 64);
            fileItem.setText("\u67e5\u627e\u6587\u4ef6(&F)");
            fileItem.addSelectionListener((SelectionListener)new Selection(QuickSearchType.FILE));
            MenuItem abilityItem = new MenuItem(menu, 64);
            abilityItem.setText("\u67e5\u627e\u529f\u80fd(&A)");
            abilityItem.addSelectionListener((SelectionListener)new Selection(QuickSearchType.ABILITY));
            MenuItem askItem = new MenuItem(menu, 64);
            askItem.setText("\u641c\u7d22\u95ee\u7b54(&Q)");
            askItem.addSelectionListener((SelectionListener)new Selection(QuickSearchType.ASK));
        }
        Point pt = new Point(QuickSearchItem.rectangle.x, QuickSearchItem.rectangle.y + QuickSearchItem.rectangle.height);
        pt = toolBar.toDisplay(pt);
        menu.setLocation(pt.x, pt.y);
        menu.setVisible(true);
    }

    public QuickSearchItem(String id) {
        super(id);
    }

    public QuickSearchItem() {
    }

    private class Selection
    implements SelectionListener {
        public QuickSearchType type;

        public Selection(QuickSearchType type) {
            this.type = type;
        }

        public void widgetSelected(SelectionEvent e) {
            QuickSearchUtil.setSearchType(this.type, true);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

