/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.quicksearch.ui;

import com.pandora.core.log.HBLog;
import com.pandora.core.search.IQuickSearch;
import com.pandora.core.utils.EclipseUtil;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.SearchUtil;
import com.pandora.quicksearch.ui.QuickSearchUtil;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class QuickSearchActivator
extends AbstractUIPlugin
implements IQuickSearch {
    public static final String PLUGIN_ID = "com.pandora.quicksearch.ui";
    private static QuickSearchActivator plugin;
    private long lastTime = 0L;
    public static final String QUICKSEARCH_DOUBLE_KEY = "QUICKSEARCH_DOUBLE_KEY";
    private static boolean isChanged;
    private static boolean value;

    static {
        isChanged = true;
        value = true;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        SearchUtil.setQuickSearch((IQuickSearch)this);
        this.getWorkbench().getDisplay().addFilter(2, new Listener(){

            public void handleEvent(Event event) {
                if (!QuickSearchActivator.this.getQuickSearchDoubleKeyValue()) {
                    return;
                }
                int mod = SWT.MOD1;
                if (PlatformUtil.isMac()) {
                    mod = SWT.MOD4;
                }
                if (event.keyCode == mod) {
                    long currentTime = System.currentTimeMillis();
                    long pTime = currentTime - QuickSearchActivator.this.lastTime;
                    if (pTime > 0L && pTime < 300L) {
                        QuickSearchUtil.setFocus(true);
                        QuickSearchActivator.this.lastTime = 0L;
                    } else {
                        QuickSearchActivator.this.lastTime = currentTime;
                    }
                } else {
                    QuickSearchActivator.this.lastTime = 0L;
                }
            }
        });
        this.getWorkbench().getDisplay().addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                if (!QuickSearchActivator.this.getQuickSearchDoubleKeyValue()) {
                    return;
                }
                int mod = SWT.MOD1;
                if (PlatformUtil.isMac()) {
                    mod = SWT.MOD4;
                }
                if (event.keyCode != mod) {
                    QuickSearchActivator.this.lastTime = 0L;
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static QuickSearchActivator getDefault() {
        return plugin;
    }

    public void storeQuickSearchDoubleKeyValue(boolean b) {
        if (this.getQuickSearchDoubleKeyValue() == b) {
            return;
        }
        isChanged = true;
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(PLUGIN_ID);
        prefs.put(QUICKSEARCH_DOUBLE_KEY, String.valueOf(b));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            HBLog.logError((Plugin)QuickSearchActivator.getDefault(), (Throwable)e);
        }
        QuickSearchUtil.setMessage(b);
    }

    public boolean getQuickSearchDoubleKeyValue() {
        if (!isChanged) {
            return value;
        }
        isChanged = false;
        String v = QuickSearchActivator.getDefault().getPreferenceStore().getString(QUICKSEARCH_DOUBLE_KEY);
        value = !"false".equals(v);
        return value;
    }
}

