/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.erb.html;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.erb.ERBEditorPlugin;
import com.aptana.editor.erb.html.Messages;
import com.aptana.editor.html.contentassist.index.HTMLFileIndexingParticipant;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.index.core.AbstractFileIndexingParticipant;
import com.aptana.index.core.BuildContextType;
import com.aptana.index.core.Index;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ruby.internal.core.index.RubyFileIndexingParticipant;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;

public class RHTMLFileIndexingParticipant
extends AbstractFileIndexingParticipant {
    public void index(BuildContext context, Index index, IProgressMonitor monitor) throws CoreException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                sub.subTask(this.getIndexingMessage(index, context.getURI()));
                this.indexSource(context, index, (IProgressMonitor)sub.newChild(100));
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)ERBEditorPlugin.getDefault(), (Throwable)e);
                sub.done();
            }
        }
        finally {
            sub.done();
        }
    }

    private void indexSource(BuildContext context, Index index, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            String fileContents = context.getContents();
            if (fileContents == null || fileContents.trim().length() <= 0) {
                return;
            }
            try {
                HTMLParseState parseState = new HTMLParseState(fileContents);
                parseState.setProgressMonitor((IProgressMonitor)sub.newChild(20));
                if (context.isNeedSleep()) {
                    parseState.setNeedSleep(true);
                }
                IParseRootNode parseNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.html.erb", (IParseState)parseState).getRootNode();
                HTMLFileIndexingParticipant part = new HTMLFileIndexingParticipant();
                part.walkAST(context, index, (IParseNode)parseNode, (IProgressMonitor)sub.newChild(30));
                String rubyContents = RHTMLFileIndexingParticipant.replaceNonRubyCodeWithWhitespace(fileContents);
                sub.worked(5);
                RubyFileIndexingParticipant rfip = new RubyFileIndexingParticipant();
                rfip.indexSource(index, context, rubyContents, (IProgressMonitor)sub.newChild(45));
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)ERBEditorPlugin.getDefault(), (String)MessageFormat.format(Messages.RHTMLFileIndexingParticipant_ERR_Indexing, context.getName()), (Throwable)e);
            }
        }
        finally {
            sub.done();
        }
    }

    public static String replaceNonRubyCodeWithWhitespace(String source) {
        List<String> code = RHTMLFileIndexingParticipant.getRubyCodeChunks(source);
        if (code == null || code.size() == 0) {
            return RHTMLFileIndexingParticipant.fillWithWhitespace(source);
        }
        StringBuilder buffer = new StringBuilder();
        int endOfLastFragment = 0;
        boolean dontIncludeSemicolon = false;
        for (String codeFragment : code) {
            int beginningOfCurrentFragment = source.indexOf(codeFragment, endOfLastFragment);
            if (codeFragment.length() > 0 && codeFragment.charAt(0) == '#') {
                codeFragment = RHTMLFileIndexingParticipant.fillWithWhitespace(codeFragment);
                dontIncludeSemicolon = true;
            }
            String portion = source.substring(endOfLastFragment, beginningOfCurrentFragment);
            int j = 0;
            while (j < portion.length()) {
                char chr = portion.charAt(j);
                if (Character.isWhitespace(chr)) {
                    buffer.append(chr);
                } else if (j != 0 && chr == '>' && portion.charAt(j - 1) == '%') {
                    if (dontIncludeSemicolon) {
                        buffer.append(' ');
                        dontIncludeSemicolon = false;
                    } else {
                        buffer.append(';');
                    }
                } else {
                    buffer.append(' ');
                }
                ++j;
            }
            buffer.append(codeFragment);
            endOfLastFragment = beginningOfCurrentFragment + codeFragment.length();
        }
        return buffer.toString();
    }

    private static String fillWithWhitespace(String source) {
        StringBuilder buffer = new StringBuilder();
        int j = 0;
        while (j < source.length()) {
            char chr = source.charAt(j);
            if (Character.isWhitespace(chr)) {
                buffer.append(chr);
            } else {
                buffer.append(' ');
            }
            ++j;
        }
        return buffer.toString();
    }

    private static List<String> getRubyCodeChunks(String stringContents) {
        ArrayList<String> code = new ArrayList<String>();
        String[] pieces = stringContents.split("(<%%)|(%%>)|(<%=)|(<%)|(\\-?%>)");
        int i = 0;
        while (i < pieces.length) {
            if (i % 2 == 1) {
                code.add(pieces[i]);
            }
            ++i;
        }
        return code;
    }

    public boolean isEnableType(BuildContextType contextType) {
        return false;
    }
}

