/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.internal.core.index;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.Index;
import com.aptana.ruby.core.IRubyMethod;
import com.aptana.ruby.core.ISourceElementRequestor;
import java.net.URI;
import java.util.Stack;

class RubySourceIndexer
implements ISourceElementRequestor {
    private static final String NAMESPACE_DELIMETER = "::";
    protected static final String VERSION_KEY = "index_version";
    protected static final int CURRENT_VERSION = 5;
    private Stack<ISourceElementRequestor.TypeInfo> typeStack = new Stack();
    private Index index;
    private URI documentPath;

    RubySourceIndexer(Index index, URI documentPath) {
        this.index = index;
        this.documentPath = documentPath;
    }

    private void addIndex(String category, String word) {
        this.index.addEntry(category, word, this.documentPath);
    }

    @Override
    public void exitType(int endOffset) {
        this.typeStack.pop();
    }

    @Override
    public void exitScript(int endOffset) {
        this.typeStack.clear();
    }

    @Override
    public void exitMethod(int endOffset) {
    }

    @Override
    public void exitField(int endOffset) {
    }

    @Override
    public void exitConstructor(int endOffset) {
    }

    @Override
    public void enterType(ISourceElementRequestor.TypeInfo type) {
        String simpleName = this.getSimpleName(type.name);
        String[] enclosingTypes = this.getEnclosingTypeNames(type.name);
        this.addClassDeclaration(type.isModule, simpleName, enclosingTypes, type.superclass, type.modules, type.secondary);
        this.typeStack.push(type);
    }

    private void addClassDeclaration(boolean isModule, String simpleName, String[] enclosingTypes, String superclass, String[] modules, boolean secondary) {
        String indexKey = this.createTypeDeclarationKey(isModule, simpleName, enclosingTypes, secondary);
        this.addIndex("typeDecl", indexKey);
        if (superclass != null && !"Object".equals(superclass)) {
            this.addTypeReference(superclass);
        }
        if (!isModule && superclass != null && !"Object".equals(superclass)) {
            this.addIndex("superRef", this.createSuperTypeReferenceKey(simpleName, enclosingTypes, 'C', superclass, 'C'));
        }
        if (modules != null) {
            String[] stringArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                String module = stringArray[n2];
                this.addTypeReference(module);
                this.addIncludedModuleReference(simpleName, enclosingTypes, module);
                ++n2;
            }
        }
    }

    private String createTypeDeclarationKey(boolean isModule, String typeName, String[] enclosingTypeNames, boolean secondary) {
        StringBuilder builder = new StringBuilder();
        builder.append(typeName);
        builder.append('/');
        if (enclosingTypeNames != null && enclosingTypeNames.length > 0) {
            String[] stringArray = enclosingTypeNames;
            int n = enclosingTypeNames.length;
            int n2 = 0;
            while (n2 < n) {
                String enclosingName = stringArray[n2];
                builder.append(enclosingName);
                builder.append(NAMESPACE_DELIMETER);
                ++n2;
            }
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append('/');
        builder.append(isModule ? (char)'M' : 'C');
        if (secondary) {
            builder.append('/');
            builder.append('S');
        }
        return builder.toString();
    }

    private String[] getEnclosingTypeNames(String typeName) {
        String[] parts = typeName.split(NAMESPACE_DELIMETER);
        String[] names = new String[this.typeStack.size() + parts.length - 1];
        int i = 0;
        for (ISourceElementRequestor.TypeInfo info : this.typeStack) {
            names[i++] = info.name;
        }
        int j = 0;
        while (j < parts.length - 1) {
            names[i++] = parts[j];
            ++j;
        }
        return names;
    }

    @Override
    public void enterScript() {
    }

    @Override
    public void enterConstructor(ISourceElementRequestor.MethodInfo constructor) {
        this.addIndex("constructorDecl", this.createMethodDefKey("initialize", this.getSimpleName(constructor.name), new String[]{this.getNamespace(constructor.name)}, IRubyMethod.Visibility.PUBLIC, true, constructor.parameterNames.length));
    }

    @Override
    public void enterField(ISourceElementRequestor.FieldInfo field) {
        if (field == null || field.name == null || field.name.length() == 0) {
            return;
        }
        if (field.name.startsWith("@@")) {
            this.addIndex("fieldDecl", this.createdNamespacedFieldKey(field.name));
            return;
        }
        if (field.name.length() > 0 && field.name.charAt(0) == '@') {
            this.addIndex("fieldDecl", this.createdNamespacedFieldKey(field.name));
            return;
        }
        if (field.name.length() > 0 && field.name.charAt(0) == '$') {
            this.addIndex("globalDecl", field.name);
            return;
        }
        if (Character.isUpperCase(field.name.charAt(0))) {
            this.addIndex("constantDecl", this.createdNamespacedFieldKey(field.name));
            return;
        }
        this.addIndex("localDecl", field.name);
    }

    private String createdNamespacedFieldKey(String name) {
        String simpleName = "Object";
        String[] enclosingTypes = ArrayUtil.NO_STRINGS;
        if (!this.typeStack.isEmpty()) {
            ISourceElementRequestor.TypeInfo info = this.typeStack.pop();
            simpleName = this.getSimpleName(info.name);
            enclosingTypes = this.getEnclosingTypeNames(info.name);
            this.typeStack.push(info);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(name);
        builder.append('/');
        builder.append(simpleName);
        builder.append('/');
        if (enclosingTypes != null && enclosingTypes.length > 0) {
            String[] stringArray = enclosingTypes;
            int n = enclosingTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String enclosingName = stringArray[n2];
                builder.append(enclosingName);
                builder.append(NAMESPACE_DELIMETER);
                ++n2;
            }
            builder.delete(builder.length() - 2, builder.length());
        }
        return builder.toString();
    }

    @Override
    public void enterMethod(ISourceElementRequestor.MethodInfo method) {
        String simpleName = "Object";
        String[] enclosingTypes = ArrayUtil.NO_STRINGS;
        if (!this.typeStack.isEmpty()) {
            ISourceElementRequestor.TypeInfo info = this.typeStack.pop();
            simpleName = this.getSimpleName(info.name);
            enclosingTypes = this.getEnclosingTypeNames(info.name);
            this.typeStack.push(info);
        }
        this.addIndex("methodDecl", this.createMethodDefKey(method.name, simpleName, enclosingTypes, method.visibility, method.isClassLevel, method.parameterNames.length));
    }

    @Override
    public void acceptYield(String name) {
    }

    @Override
    public void acceptTypeReference(String name, int startOffset, int endOffset) {
        this.addTypeReference(name);
    }

    private void addTypeReference(String name) {
        this.addIndex("ref", this.getSimpleName(name));
    }

    private String lastSegment(String name, String delimeter) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(delimeter);
        if (index != -1) {
            return name.substring(index + delimeter.length());
        }
        return name;
    }

    @Override
    public void acceptModuleFunction(String function) {
    }

    @Override
    public void acceptMixin(String moduleName) {
        this.addIndex("ref", this.getSimpleName(moduleName));
        if (this.typeStack != null && !this.typeStack.isEmpty()) {
            ISourceElementRequestor.TypeInfo info = this.typeStack.pop();
            String[] enclosingTypes = this.getEnclosingTypeNames(info.name);
            this.typeStack.push(info);
            this.addIncludedModuleReference(this.getSimpleName(info.name), enclosingTypes, moduleName);
        }
    }

    private void addIncludedModuleReference(String simpleName, String[] enclosingTypes, String moduleName) {
        this.addIndex("superRef", this.createSuperTypeReferenceKey(simpleName, enclosingTypes, 'C', moduleName, 'M'));
    }

    private String createSuperTypeReferenceKey(String typeName, String[] enclosingTypeNames, char classOrModule, String superTypeName, char superClassOrModule) {
        if (superTypeName == null) {
            superTypeName = "Object";
        }
        String superSimpleName = this.lastSegment(superTypeName, NAMESPACE_DELIMETER);
        char[] superQualification = null;
        if (!superTypeName.equals(superSimpleName)) {
            int length = superTypeName.length() - superSimpleName.length() - 1;
            superQualification = new char[length - 1];
            System.arraycopy(superTypeName.toCharArray(), 0, superQualification, 0, length - 1);
        }
        String superTypeSourceName = this.lastSegment(superSimpleName, NAMESPACE_DELIMETER);
        if (superSimpleName != null && !superSimpleName.equals(superTypeSourceName)) {
            int start = superQualification == null ? 0 : superQualification.length + 1;
            int prefixLength = superSimpleName.length() - superTypeSourceName.length();
            char[] mangledQualification = new char[start + prefixLength];
            if (superQualification != null) {
                System.arraycopy(superQualification, 0, mangledQualification, 0, start - 1);
                mangledQualification[start - 1] = 46;
            }
            System.arraycopy(superSimpleName.toCharArray(), 0, mangledQualification, start, prefixLength);
            superQualification = mangledQualification;
            superSimpleName = superTypeSourceName;
        }
        String simpleName = this.lastSegment(typeName, NAMESPACE_DELIMETER);
        String enclosingTypeName = StringUtil.join((String)NAMESPACE_DELIMETER, (String[])enclosingTypeNames);
        StringBuilder builder = new StringBuilder();
        builder.append(superSimpleName);
        builder.append('/');
        if (superQualification != null) {
            builder.append(superQualification);
        }
        builder.append('/');
        builder.append(simpleName);
        builder.append('/');
        builder.append(enclosingTypeName);
        builder.append('/');
        builder.append(superClassOrModule);
        builder.append(classOrModule);
        return builder.toString();
    }

    private String getNamespace(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(NAMESPACE_DELIMETER);
        if (index != -1) {
            return name.substring(0, index);
        }
        return "";
    }

    private String getSimpleName(String name) {
        return this.lastSegment(name, NAMESPACE_DELIMETER);
    }

    @Override
    public void acceptMethodVisibilityChange(String methodName, IRubyMethod.Visibility visibility) {
    }

    @Override
    public void acceptMethodReference(String name, int argCount, int offset) {
        this.addIndex("methodRef", this.createMethodRefKey(name, argCount));
    }

    private String createMethodRefKey(String name, int argCount) {
        return String.valueOf(name) + '/' + String.valueOf(argCount);
    }

    private String createMethodDefKey(String methodName, String definingTypeSimpleName, String[] definingTypeNamespace, IRubyMethod.Visibility visibility, boolean isSingleton, int argCount) {
        StringBuilder builder = new StringBuilder();
        builder.append(methodName);
        builder.append('/');
        builder.append(definingTypeSimpleName);
        builder.append('/');
        if (definingTypeNamespace != null && definingTypeNamespace.length > 0) {
            String[] stringArray = definingTypeNamespace;
            int n = definingTypeNamespace.length;
            int n2 = 0;
            while (n2 < n) {
                String enclosingName = stringArray[n2];
                builder.append(enclosingName);
                builder.append(NAMESPACE_DELIMETER);
                ++n2;
            }
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append('/');
        builder.append(this.getVisibilityChar(visibility));
        builder.append('/');
        builder.append(isSingleton ? (char)'S' : 'I');
        builder.append('/');
        builder.append(String.valueOf(argCount));
        return builder.toString();
    }

    private char getVisibilityChar(IRubyMethod.Visibility visibility) {
        switch (visibility) {
            case PRIVATE: {
                return 'V';
            }
            case PROTECTED: {
                return 'R';
            }
            case PUBLIC: {
                return 'P';
            }
        }
        return 'X';
    }

    @Override
    public void acceptImport(String value, int startOffset, int endOffset) {
        this.addIndex("ruby.require", value);
    }

    @Override
    public void acceptFieldReference(String name, int offset) {
        this.addIndex("ref", name);
    }

    @Override
    public void acceptConstructorReference(String name, int argCount, int offset) {
        String simpleTypeName = this.getSimpleName(name);
        this.addIndex("ref", simpleTypeName);
        this.addIndex("constructorRef", this.createMethodRefKey(simpleTypeName, argCount));
    }

    @Override
    public void enterBlock(int startOffset, int endOffset) {
    }

    @Override
    public void exitBlock(int endOffset) {
    }
}

