/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.core.codeassist;

import com.aptana.ruby.core.ast.OffsetNodeLocator;
import com.aptana.ruby.core.codeassist.ResolutionTarget;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.Parser;
import org.jrubyparser.ast.Node;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;

public class ResolveContext {
    private URI uri;
    private String source;
    private int offset;
    private List<ResolutionTarget> resolved;
    private Node root;
    private Node atOffset;

    public ResolveContext(URI uri, String source, int offset) {
        this.uri = uri;
        this.source = source;
        this.offset = offset;
    }

    public synchronized Node getAST() throws SyntaxException {
        if (this.root == null) {
            Parser parser = new Parser();
            BufferedReader reader = new BufferedReader(new StringReader(this.source));
            try {
                this.root = parser.parse(this.getFileName(), (Reader)reader, new ParserConfiguration(0, CompatVersion.BOTH));
            }
            catch (Throwable throwable) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
        return this.root;
    }

    public synchronized Node getSelectedNode() throws SyntaxException {
        if (this.atOffset == null) {
            try {
                this.atOffset = new OffsetNodeLocator().find(this.getAST(), this.offset);
            }
            catch (SyntaxException syntaxException) {}
        }
        return this.atOffset;
    }

    public URI getURI() {
        return this.uri;
    }

    private String getFileName() {
        return this.uri.getPath();
    }

    public List<ResolutionTarget> getResolved() {
        if (this.resolved == null || this.resolved.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.resolved);
    }

    public synchronized void addResolved(Collection<ResolutionTarget> targets) {
        if (this.resolved == null) {
            this.resolved = new ArrayList<ResolutionTarget>(targets);
        } else {
            this.resolved.addAll(targets);
        }
    }
}

