/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.coffee.parsing.ast;

import com.aptana.editor.coffee.parsing.ast.CoffeeArrNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeCallNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeLiteralNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeNode;
import com.aptana.parsing.ast.IParseNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class CoffeeValueNode
extends CoffeeNode {
    private String tag;

    public CoffeeValueNode(CoffeeNode objAssignable) {
        this(objAssignable, null, null);
    }

    public CoffeeValueNode(CoffeeCallNode invocation, CoffeeNode accessor) {
        this(invocation, accessor, null);
    }

    public CoffeeValueNode(CoffeeNode coffeeLiteralNode, CoffeeNode coffeeAccessNode, String tag) {
        super((short)7);
        this.addChild((IParseNode)coffeeLiteralNode);
        if (coffeeAccessNode != null) {
            this.addChild((IParseNode)coffeeAccessNode);
        }
        this.tag = tag;
    }

    public CoffeeValueNode push(CoffeeNode accessor) {
        this.addChild((IParseNode)accessor);
        return this;
    }

    @Override
    public String getText() {
        IParseNode child = this.getChild(0);
        if (child instanceof CoffeeLiteralNode) {
            return MessageFormat.format("Value \"{0}\"", this.getChild(0).getText());
        }
        return "Value";
    }

    @Override
    public CoffeeNode unwrap() {
        if (this.hasProperties()) {
            return this;
        }
        return this.base();
    }

    CoffeeNode base() {
        return (CoffeeNode)this.getChild(0);
    }

    public boolean hasProperties() {
        return this.getChildCount() > 1;
    }

    public boolean isArray() {
        return this.getChildCount() == 1 && this.base() instanceof CoffeeArrNode;
    }

    @Override
    public boolean isComplex() {
        return this.hasProperties() || this.base().isComplex();
    }

    @Override
    public boolean isAssignable() {
        return this.hasProperties() || this.base().isAssignable();
    }

    public List<CoffeeNode> properties() {
        ArrayList<CoffeeNode> props = new ArrayList<CoffeeNode>();
        int i = 1;
        while (i < this.getChildCount()) {
            props.add((CoffeeNode)this.getChild(i));
            ++i;
        }
        return props;
    }
}

