/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.coffee.parsing.ast;

import com.aptana.editor.coffee.parsing.ast.CoffeeCallNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeCodeNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeInNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeParensNode;
import com.aptana.parsing.ast.IParseNode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoffeeOpNode
extends CoffeeNode {
    private static final Map<String, String> CONVERSIONS = new HashMap<String, String>();
    private static final Map<String, String> INVERSIONS;
    private String operator;
    private boolean postOp;
    private CoffeeNode first;
    private CoffeeNode second;
    private boolean invert;

    static {
        CONVERSIONS.put("==", "===");
        CONVERSIONS.put("!=", "!==");
        CONVERSIONS.put("of", "in");
        INVERSIONS = new HashMap<String, String>();
        INVERSIONS.put("!==", "===");
        INVERSIONS.put("===", "!==");
    }

    public CoffeeOpNode(String operator, CoffeeNode expression) {
        this(operator, expression, null, false);
    }

    public CoffeeOpNode(String operator, CoffeeNode left, CoffeeNode right) {
        this(operator, left, right, false);
    }

    public CoffeeOpNode(String operator, CoffeeNode left, CoffeeNode right, boolean postOp) {
        super((short)32);
        this.first = left;
        this.second = right;
        this.addChild((IParseNode)left);
        if (right != null) {
            this.addChild((IParseNode)right);
        }
        this.postOp = postOp;
        this.operator = operator;
        if (CONVERSIONS.containsKey(operator)) {
            this.operator = CONVERSIONS.get(operator);
        }
    }

    public static CoffeeNode create(String operator, CoffeeNode first, CoffeeNode second) {
        if ("in".equals(operator)) {
            return new CoffeeInNode(first, second);
        }
        if ("do".equals(operator)) {
            List<Object> params = new ArrayList();
            if (first instanceof CoffeeCodeNode) {
                params = ((CoffeeCodeNode)first).params();
            }
            CoffeeCallNode call = new CoffeeCallNode(first, params, false);
            call.isDo = true;
            return call;
        }
        if ("new".equals(operator)) {
            if (first instanceof CoffeeCallNode && !((CoffeeCallNode)first).isDo) {
                return ((CoffeeCallNode)first).newInstance();
            }
            if (first instanceof CoffeeCodeNode && ((CoffeeCodeNode)first).bound || first instanceof CoffeeCallNode && ((CoffeeCallNode)first).isDo) {
                first = new CoffeeParensNode(first);
            }
        }
        return new CoffeeOpNode(operator, first, second);
    }

    @Override
    public CoffeeOpNode invert() {
        boolean allInvertable = false;
        CoffeeOpNode curr = null;
        if (this.isChainable() && this.first.isChainable()) {
            allInvertable = true;
            curr = this;
            while (curr != null && curr.operator != null) {
                allInvertable = allInvertable && INVERSIONS.containsKey(curr.operator);
                curr = curr.first instanceof CoffeeOpNode ? (CoffeeOpNode)curr.first : null;
            }
            if (!allInvertable) {
                return (CoffeeOpNode)new CoffeeParensNode(this).invert();
            }
            curr = this;
            while (curr != null && curr.operator != null) {
                curr.invert = !curr.invert;
                curr.operator = INVERSIONS.get(curr.operator);
                curr = curr.first instanceof CoffeeOpNode ? (CoffeeOpNode)curr.first : null;
            }
            return this;
        }
        if (INVERSIONS.containsKey(this.operator)) {
            this.operator = INVERSIONS.get(this.operator);
            if (this.first.unwrap() instanceof CoffeeOpNode) {
                this.first.invert();
            }
            return this;
        }
        if (this.second != null) {
            return (CoffeeOpNode)new CoffeeParensNode(this).invert();
        }
        if ("!".equals(this.operator) && this.first.unwrap() instanceof CoffeeOpNode && ("!".equals(((CoffeeOpNode)this.first.unwrap()).operator) || "in".equals(((CoffeeOpNode)this.first.unwrap()).operator) || "instanceof".equals(((CoffeeOpNode)this.first.unwrap()).operator))) {
            return (CoffeeOpNode)this.first.unwrap();
        }
        return new CoffeeOpNode("!", this);
    }

    @Override
    public String getText() {
        return MessageFormat.format("Op {0}", this.operator);
    }

    private boolean isUnary() {
        return this.getChildCount() == 1;
    }

    @Override
    protected boolean isComplex() {
        return !this.isUnary() || !"+".equals(this.operator) && !"-".equals(this.operator) || this.first.isComplex();
    }

    @Override
    protected boolean isChainable() {
        return "<".equals(this.operator) || ">".equals(this.operator) || ">=".equals(this.operator) || "<=".equals(this.operator) || "===".equals(this.operator) || "!==".equals(this.operator);
    }
}

