/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.coffee.parsing.ast;

import com.aptana.editor.coffee.parsing.ast.CoffeeBlockNode;
import com.aptana.editor.coffee.parsing.ast.CoffeeNode;
import com.aptana.parsing.ast.IParseNode;

public class CoffeeIfNode
extends CoffeeNode {
    private boolean statement;
    private boolean isChain;
    private CoffeeBlockNode elseBody;

    public CoffeeIfNode(CoffeeNode condition, CoffeeNode body, String type) {
        this(condition, body, type, false);
    }

    public CoffeeIfNode(CoffeeNode condition, CoffeeNode body, String type, boolean statement) {
        super((short)6);
        if ("unless".equals(type)) {
            condition = condition.invert();
        }
        this.addChild((IParseNode)condition);
        if (body != null) {
            this.addChild((IParseNode)body);
        }
        this.statement = statement;
        this.isChain = false;
    }

    private CoffeeIfNode elseBodyNode() {
        return (CoffeeIfNode)(this.elseBody != null ? this.elseBody.unwrap() : null);
    }

    public CoffeeIfNode addElse(CoffeeNode elseBody) {
        if (this.isChain) {
            this.elseBodyNode().addElse(elseBody);
        } else {
            this.isChain = elseBody instanceof CoffeeIfNode;
            this.elseBody = this.ensureBlock(elseBody);
            this.addChild((IParseNode)this.elseBody);
        }
        return this;
    }

    private CoffeeBlockNode ensureBlock(CoffeeNode node) {
        if (node instanceof CoffeeBlockNode) {
            return (CoffeeBlockNode)node;
        }
        return new CoffeeBlockNode(node);
    }

    @Override
    public String getText() {
        return "If";
    }
}

