/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.core.util.StringUtil;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.model.TriggerType;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

class SnippetNode
extends BaseNode<Property> {
    private static final Image SNIPPET_ICON = ScriptingUIPlugin.getImage("icons/snippet.png");
    private SnippetElement snippet;

    SnippetNode(SnippetElement snippet) {
        this.snippet = snippet;
    }

    @Override
    public Image getImage() {
        return SNIPPET_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return this.snippet.getDisplayName();
    }

    static enum Property implements IPropertyInformation<SnippetNode>
    {
        NAME(Messages.SnippetNode_Snippet_Name){

            @Override
            public Object getPropertyValue(SnippetNode node) {
                return node.snippet.getDisplayName();
            }
        }
        ,
        PATH(Messages.SnippetNode_Snippet_Path){

            @Override
            public Object getPropertyValue(SnippetNode node) {
                return node.snippet.getPath();
            }
        }
        ,
        SCOPE(Messages.SnippetNode_Snippet_Scope){

            @Override
            public Object getPropertyValue(SnippetNode node) {
                String scope = node.snippet.getScope();
                return scope != null && scope.length() > 0 ? scope : "all";
            }
        }
        ,
        TRIGGERS(Messages.SnippetNode_Snippet_Triggers){

            @Override
            public Object getPropertyValue(SnippetNode node) {
                return StringUtil.join((String)", ", (String[])node.snippet.getTriggerTypeValues(TriggerType.PREFIX));
            }
        }
        ,
        EXPANSION(Messages.SnippetNode_Snippet_Expansion){

            @Override
            public Object getPropertyValue(SnippetNode node) {
                return node.snippet.getDisplayName();
            }
        }
        ,
        CATEGORY(Messages.SnippetNode_Category){

            @Override
            public Object getPropertyValue(SnippetNode node) {
                return node.snippet.getCategory();
            }
        }
        ,
        ICON_PATH(Messages.SnippetNode_Icon_Path){

            @Override
            public Object getPropertyValue(SnippetNode node) {
                return node.snippet.getIconPath();
            }
        }
        ,
        TAGS(Messages.SnippetNode_Tags){

            @Override
            public Object getPropertyValue(SnippetNode node) {
                return StringUtil.join((String)", ", (Collection)node.snippet.getTags());
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

