/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.ui.views;

import com.aptana.scripting.model.ProjectSampleElement;
import com.aptana.scripting.ui.ScriptingUIPlugin;
import com.aptana.scripting.ui.views.BaseNode;
import com.aptana.scripting.ui.views.IPropertyInformation;
import com.aptana.scripting.ui.views.Messages;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

class ProjectSampleNode
extends BaseNode<Property> {
    private static final Image PROJECT_SAMPLE_ICON = ScriptingUIPlugin.getImage("icons/sample.png");
    private ProjectSampleElement projectSample;

    ProjectSampleNode(ProjectSampleElement projectSample) {
        this.projectSample = projectSample;
    }

    @Override
    public Image getImage() {
        return PROJECT_SAMPLE_ICON;
    }

    @Override
    protected Set<Property> getPropertyInfoSet() {
        return EnumSet.allOf(Property.class);
    }

    @Override
    public String getLabel() {
        return this.projectSample.getDisplayName();
    }

    static enum Property implements IPropertyInformation<ProjectSampleNode>
    {
        NAME(Messages.ProjectSampleNode_Project_Sample_Name){

            @Override
            public Object getPropertyValue(ProjectSampleNode node) {
                return node.projectSample.getDisplayName();
            }
        }
        ,
        PATH(Messages.ProjectSampleNode_Project_Sample_Path){

            @Override
            public Object getPropertyValue(ProjectSampleNode node) {
                return node.projectSample.getPath();
            }
        }
        ,
        SCOPE(Messages.ProjectSampleNode_Project_Sample_Scope){

            @Override
            public Object getPropertyValue(ProjectSampleNode node) {
                String scope = node.projectSample.getScope();
                return scope != null && scope.length() > 0 ? scope : Messages.ProjectSampleNode_All_SCOPES;
            }
        }
        ,
        CATEGORY(Messages.ProjectSampleNode_Project_Sample_Category){

            @Override
            public Object getPropertyValue(ProjectSampleNode node) {
                return node.projectSample.getCategory();
            }
        }
        ,
        LOCATION(Messages.ProjectSampleNode_Project_Sample_Location){

            @Override
            public Object getPropertyValue(ProjectSampleNode node) {
                return node.projectSample.getLocation();
            }
        }
        ,
        DESCRIPTION(Messages.ProjectSampleNode_Project_Sample_Description){

            @Override
            public Object getPropertyValue(ProjectSampleNode node) {
                return node.projectSample.getDescription();
            }
        }
        ,
        ICON(Messages.ProjectSampleNode_Project_Sample_Icon_Path){

            @Override
            public Object getPropertyValue(ProjectSampleNode node) {
                return node.projectSample.getIcon();
            }
        };

        private String header;

        private Property(String header) {
            this.header = header;
        }

        @Override
        public String getHeader() {
            return this.header;
        }
    }
}

